import { loadRestJsonErrorCode, parseJsonBody as parseBody, parseJsonErrorBody as parseErrorBody } from "@aws-sdk/core";
import { HttpRequest as __HttpRequest } from "@smithy/protocol-http";
import { _json, collectBody, decorateServiceException as __decorateServiceException, expectInt32 as __expectInt32, expectLong as __expectLong, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectString as __expectString, limitedParseDouble as __limitedParseDouble, parseEpochTimestamp as __parseEpochTimestamp, take, withBaseException, } from "@smithy/smithy-client";
import { ECRServiceException as __BaseException } from "../models/ECRServiceException";
import { EmptyUploadException, ImageAlreadyExistsException, ImageDigestDoesNotMatchException, ImageNotFoundException, ImageTagAlreadyExistsException, InvalidLayerException, InvalidLayerPartException, InvalidParameterException, InvalidTagParameterException, KmsException, LayerAlreadyExistsException, LayerInaccessibleException, LayerPartTooSmallException, LayersNotFoundException, LifecyclePolicyNotFoundException, LifecyclePolicyPreviewInProgressException, LifecyclePolicyPreviewNotFoundException, LimitExceededException, PullThroughCacheRuleAlreadyExistsException, PullThroughCacheRuleNotFoundException, ReferencedImagesNotFoundException, RegistryPolicyNotFoundException, RepositoryAlreadyExistsException, RepositoryNotEmptyException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, ScanNotFoundException, SecretNotFoundException, ServerException, TemplateAlreadyExistsException, TemplateNotFoundException, TooManyTagsException, UnableToAccessSecretException, UnableToDecryptSecretValueException, UnableToGetUpstreamImageException, UnableToGetUpstreamLayerException, UnsupportedImageTypeException, UnsupportedUpstreamRegistryException, UploadNotFoundException, ValidationException, } from "../models/models_0";
export const se_BatchCheckLayerAvailabilityCommand = async (input, context) => {
    const headers = sharedHeaders("BatchCheckLayerAvailability");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchDeleteImageCommand = async (input, context) => {
    const headers = sharedHeaders("BatchDeleteImage");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetImageCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetImage");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetRepositoryScanningConfigurationCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetRepositoryScanningConfiguration");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CompleteLayerUploadCommand = async (input, context) => {
    const headers = sharedHeaders("CompleteLayerUpload");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreatePullThroughCacheRuleCommand = async (input, context) => {
    const headers = sharedHeaders("CreatePullThroughCacheRule");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateRepositoryCommand = async (input, context) => {
    const headers = sharedHeaders("CreateRepository");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateRepositoryCreationTemplateCommand = async (input, context) => {
    const headers = sharedHeaders("CreateRepositoryCreationTemplate");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteLifecyclePolicyCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteLifecyclePolicy");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeletePullThroughCacheRuleCommand = async (input, context) => {
    const headers = sharedHeaders("DeletePullThroughCacheRule");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRegistryPolicyCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteRegistryPolicy");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRepositoryCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteRepository");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRepositoryCreationTemplateCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteRepositoryCreationTemplate");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRepositoryPolicyCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteRepositoryPolicy");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImageReplicationStatusCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeImageReplicationStatus");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImagesCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeImages");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImageScanFindingsCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeImageScanFindings");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribePullThroughCacheRulesCommand = async (input, context) => {
    const headers = sharedHeaders("DescribePullThroughCacheRules");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeRegistryCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeRegistry");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeRepositoriesCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeRepositories");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeRepositoryCreationTemplatesCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeRepositoryCreationTemplates");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetAccountSettingCommand = async (input, context) => {
    const headers = sharedHeaders("GetAccountSetting");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetAuthorizationTokenCommand = async (input, context) => {
    const headers = sharedHeaders("GetAuthorizationToken");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetDownloadUrlForLayerCommand = async (input, context) => {
    const headers = sharedHeaders("GetDownloadUrlForLayer");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetLifecyclePolicyCommand = async (input, context) => {
    const headers = sharedHeaders("GetLifecyclePolicy");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetLifecyclePolicyPreviewCommand = async (input, context) => {
    const headers = sharedHeaders("GetLifecyclePolicyPreview");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetRegistryPolicyCommand = async (input, context) => {
    const headers = sharedHeaders("GetRegistryPolicy");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetRegistryScanningConfigurationCommand = async (input, context) => {
    const headers = sharedHeaders("GetRegistryScanningConfiguration");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetRepositoryPolicyCommand = async (input, context) => {
    const headers = sharedHeaders("GetRepositoryPolicy");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_InitiateLayerUploadCommand = async (input, context) => {
    const headers = sharedHeaders("InitiateLayerUpload");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListImagesCommand = async (input, context) => {
    const headers = sharedHeaders("ListImages");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListTagsForResourceCommand = async (input, context) => {
    const headers = sharedHeaders("ListTagsForResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutAccountSettingCommand = async (input, context) => {
    const headers = sharedHeaders("PutAccountSetting");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutImageCommand = async (input, context) => {
    const headers = sharedHeaders("PutImage");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutImageScanningConfigurationCommand = async (input, context) => {
    const headers = sharedHeaders("PutImageScanningConfiguration");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutImageTagMutabilityCommand = async (input, context) => {
    const headers = sharedHeaders("PutImageTagMutability");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutLifecyclePolicyCommand = async (input, context) => {
    const headers = sharedHeaders("PutLifecyclePolicy");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutRegistryPolicyCommand = async (input, context) => {
    const headers = sharedHeaders("PutRegistryPolicy");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutRegistryScanningConfigurationCommand = async (input, context) => {
    const headers = sharedHeaders("PutRegistryScanningConfiguration");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutReplicationConfigurationCommand = async (input, context) => {
    const headers = sharedHeaders("PutReplicationConfiguration");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SetRepositoryPolicyCommand = async (input, context) => {
    const headers = sharedHeaders("SetRepositoryPolicy");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartImageScanCommand = async (input, context) => {
    const headers = sharedHeaders("StartImageScan");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartLifecyclePolicyPreviewCommand = async (input, context) => {
    const headers = sharedHeaders("StartLifecyclePolicyPreview");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_TagResourceCommand = async (input, context) => {
    const headers = sharedHeaders("TagResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UntagResourceCommand = async (input, context) => {
    const headers = sharedHeaders("UntagResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdatePullThroughCacheRuleCommand = async (input, context) => {
    const headers = sharedHeaders("UpdatePullThroughCacheRule");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateRepositoryCreationTemplateCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateRepositoryCreationTemplate");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UploadLayerPartCommand = async (input, context) => {
    const headers = sharedHeaders("UploadLayerPart");
    let body;
    body = JSON.stringify(se_UploadLayerPartRequest(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ValidatePullThroughCacheRuleCommand = async (input, context) => {
    const headers = sharedHeaders("ValidatePullThroughCacheRule");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const de_BatchCheckLayerAvailabilityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_BatchDeleteImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_BatchGetImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_BatchGetRepositoryScanningConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CompleteLayerUploadCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreatePullThroughCacheRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreatePullThroughCacheRuleResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateRepositoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateRepositoryResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateRepositoryCreationTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateRepositoryCreationTemplateResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteLifecyclePolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteLifecyclePolicyResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeletePullThroughCacheRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeletePullThroughCacheRuleResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteRegistryPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteRepositoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteRepositoryResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteRepositoryCreationTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteRepositoryCreationTemplateResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteRepositoryPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImageReplicationStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImagesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeImagesResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImageScanFindingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeImageScanFindingsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribePullThroughCacheRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribePullThroughCacheRulesResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeRegistryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeRepositoriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeRepositoriesResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeRepositoryCreationTemplatesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeRepositoryCreationTemplatesResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetAccountSettingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetAuthorizationTokenCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetAuthorizationTokenResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetDownloadUrlForLayerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetLifecyclePolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetLifecyclePolicyResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetLifecyclePolicyPreviewCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetLifecyclePolicyPreviewResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetRegistryPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetRegistryScanningConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetRepositoryPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_InitiateLayerUploadCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListImagesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutAccountSettingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutImageScanningConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutImageTagMutabilityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutLifecyclePolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutRegistryPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutRegistryScanningConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutReplicationConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SetRepositoryPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartImageScanCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartLifecyclePolicyPreviewCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdatePullThroughCacheRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdatePullThroughCacheRuleResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateRepositoryCreationTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateRepositoryCreationTemplateResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UploadLayerPartCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ValidatePullThroughCacheRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidParameterException":
        case "com.amazonaws.ecr#InvalidParameterException":
            throw await de_InvalidParameterExceptionRes(parsedOutput, context);
        case "RepositoryNotFoundException":
        case "com.amazonaws.ecr#RepositoryNotFoundException":
            throw await de_RepositoryNotFoundExceptionRes(parsedOutput, context);
        case "ServerException":
        case "com.amazonaws.ecr#ServerException":
            throw await de_ServerExceptionRes(parsedOutput, context);
        case "LimitExceededException":
        case "com.amazonaws.ecr#LimitExceededException":
            throw await de_LimitExceededExceptionRes(parsedOutput, context);
        case "UnableToGetUpstreamImageException":
        case "com.amazonaws.ecr#UnableToGetUpstreamImageException":
            throw await de_UnableToGetUpstreamImageExceptionRes(parsedOutput, context);
        case "ValidationException":
        case "com.amazonaws.ecr#ValidationException":
            throw await de_ValidationExceptionRes(parsedOutput, context);
        case "EmptyUploadException":
        case "com.amazonaws.ecr#EmptyUploadException":
            throw await de_EmptyUploadExceptionRes(parsedOutput, context);
        case "InvalidLayerException":
        case "com.amazonaws.ecr#InvalidLayerException":
            throw await de_InvalidLayerExceptionRes(parsedOutput, context);
        case "KmsException":
        case "com.amazonaws.ecr#KmsException":
            throw await de_KmsExceptionRes(parsedOutput, context);
        case "LayerAlreadyExistsException":
        case "com.amazonaws.ecr#LayerAlreadyExistsException":
            throw await de_LayerAlreadyExistsExceptionRes(parsedOutput, context);
        case "LayerPartTooSmallException":
        case "com.amazonaws.ecr#LayerPartTooSmallException":
            throw await de_LayerPartTooSmallExceptionRes(parsedOutput, context);
        case "UploadNotFoundException":
        case "com.amazonaws.ecr#UploadNotFoundException":
            throw await de_UploadNotFoundExceptionRes(parsedOutput, context);
        case "PullThroughCacheRuleAlreadyExistsException":
        case "com.amazonaws.ecr#PullThroughCacheRuleAlreadyExistsException":
            throw await de_PullThroughCacheRuleAlreadyExistsExceptionRes(parsedOutput, context);
        case "SecretNotFoundException":
        case "com.amazonaws.ecr#SecretNotFoundException":
            throw await de_SecretNotFoundExceptionRes(parsedOutput, context);
        case "UnableToAccessSecretException":
        case "com.amazonaws.ecr#UnableToAccessSecretException":
            throw await de_UnableToAccessSecretExceptionRes(parsedOutput, context);
        case "UnableToDecryptSecretValueException":
        case "com.amazonaws.ecr#UnableToDecryptSecretValueException":
            throw await de_UnableToDecryptSecretValueExceptionRes(parsedOutput, context);
        case "UnsupportedUpstreamRegistryException":
        case "com.amazonaws.ecr#UnsupportedUpstreamRegistryException":
            throw await de_UnsupportedUpstreamRegistryExceptionRes(parsedOutput, context);
        case "InvalidTagParameterException":
        case "com.amazonaws.ecr#InvalidTagParameterException":
            throw await de_InvalidTagParameterExceptionRes(parsedOutput, context);
        case "RepositoryAlreadyExistsException":
        case "com.amazonaws.ecr#RepositoryAlreadyExistsException":
            throw await de_RepositoryAlreadyExistsExceptionRes(parsedOutput, context);
        case "TooManyTagsException":
        case "com.amazonaws.ecr#TooManyTagsException":
            throw await de_TooManyTagsExceptionRes(parsedOutput, context);
        case "TemplateAlreadyExistsException":
        case "com.amazonaws.ecr#TemplateAlreadyExistsException":
            throw await de_TemplateAlreadyExistsExceptionRes(parsedOutput, context);
        case "LifecyclePolicyNotFoundException":
        case "com.amazonaws.ecr#LifecyclePolicyNotFoundException":
            throw await de_LifecyclePolicyNotFoundExceptionRes(parsedOutput, context);
        case "PullThroughCacheRuleNotFoundException":
        case "com.amazonaws.ecr#PullThroughCacheRuleNotFoundException":
            throw await de_PullThroughCacheRuleNotFoundExceptionRes(parsedOutput, context);
        case "RegistryPolicyNotFoundException":
        case "com.amazonaws.ecr#RegistryPolicyNotFoundException":
            throw await de_RegistryPolicyNotFoundExceptionRes(parsedOutput, context);
        case "RepositoryNotEmptyException":
        case "com.amazonaws.ecr#RepositoryNotEmptyException":
            throw await de_RepositoryNotEmptyExceptionRes(parsedOutput, context);
        case "TemplateNotFoundException":
        case "com.amazonaws.ecr#TemplateNotFoundException":
            throw await de_TemplateNotFoundExceptionRes(parsedOutput, context);
        case "RepositoryPolicyNotFoundException":
        case "com.amazonaws.ecr#RepositoryPolicyNotFoundException":
            throw await de_RepositoryPolicyNotFoundExceptionRes(parsedOutput, context);
        case "ImageNotFoundException":
        case "com.amazonaws.ecr#ImageNotFoundException":
            throw await de_ImageNotFoundExceptionRes(parsedOutput, context);
        case "ScanNotFoundException":
        case "com.amazonaws.ecr#ScanNotFoundException":
            throw await de_ScanNotFoundExceptionRes(parsedOutput, context);
        case "LayerInaccessibleException":
        case "com.amazonaws.ecr#LayerInaccessibleException":
            throw await de_LayerInaccessibleExceptionRes(parsedOutput, context);
        case "LayersNotFoundException":
        case "com.amazonaws.ecr#LayersNotFoundException":
            throw await de_LayersNotFoundExceptionRes(parsedOutput, context);
        case "UnableToGetUpstreamLayerException":
        case "com.amazonaws.ecr#UnableToGetUpstreamLayerException":
            throw await de_UnableToGetUpstreamLayerExceptionRes(parsedOutput, context);
        case "LifecyclePolicyPreviewNotFoundException":
        case "com.amazonaws.ecr#LifecyclePolicyPreviewNotFoundException":
            throw await de_LifecyclePolicyPreviewNotFoundExceptionRes(parsedOutput, context);
        case "ImageAlreadyExistsException":
        case "com.amazonaws.ecr#ImageAlreadyExistsException":
            throw await de_ImageAlreadyExistsExceptionRes(parsedOutput, context);
        case "ImageDigestDoesNotMatchException":
        case "com.amazonaws.ecr#ImageDigestDoesNotMatchException":
            throw await de_ImageDigestDoesNotMatchExceptionRes(parsedOutput, context);
        case "ImageTagAlreadyExistsException":
        case "com.amazonaws.ecr#ImageTagAlreadyExistsException":
            throw await de_ImageTagAlreadyExistsExceptionRes(parsedOutput, context);
        case "ReferencedImagesNotFoundException":
        case "com.amazonaws.ecr#ReferencedImagesNotFoundException":
            throw await de_ReferencedImagesNotFoundExceptionRes(parsedOutput, context);
        case "UnsupportedImageTypeException":
        case "com.amazonaws.ecr#UnsupportedImageTypeException":
            throw await de_UnsupportedImageTypeExceptionRes(parsedOutput, context);
        case "LifecyclePolicyPreviewInProgressException":
        case "com.amazonaws.ecr#LifecyclePolicyPreviewInProgressException":
            throw await de_LifecyclePolicyPreviewInProgressExceptionRes(parsedOutput, context);
        case "InvalidLayerPartException":
        case "com.amazonaws.ecr#InvalidLayerPartException":
            throw await de_InvalidLayerPartExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_EmptyUploadExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new EmptyUploadException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ImageAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ImageAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ImageDigestDoesNotMatchExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ImageDigestDoesNotMatchException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ImageNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ImageNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ImageTagAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ImageTagAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidLayerExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidLayerException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidLayerPartExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidLayerPartException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidParameterExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidParameterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTagParameterExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTagParameterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_KmsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new KmsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LayerAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LayerAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LayerInaccessibleExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LayerInaccessibleException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LayerPartTooSmallExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LayerPartTooSmallException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LayersNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LayersNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LifecyclePolicyNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LifecyclePolicyNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LifecyclePolicyPreviewInProgressExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LifecyclePolicyPreviewInProgressException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LifecyclePolicyPreviewNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LifecyclePolicyPreviewNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PullThroughCacheRuleAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PullThroughCacheRuleAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PullThroughCacheRuleNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PullThroughCacheRuleNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReferencedImagesNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ReferencedImagesNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RegistryPolicyNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RegistryPolicyNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryNotEmptyExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryNotEmptyException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryPolicyNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryPolicyNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ScanNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ScanNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SecretNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new SecretNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ServerExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ServerException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TemplateAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TemplateAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TemplateNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TemplateNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TooManyTagsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TooManyTagsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_UnableToAccessSecretExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new UnableToAccessSecretException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_UnableToDecryptSecretValueExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new UnableToDecryptSecretValueException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_UnableToGetUpstreamImageExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new UnableToGetUpstreamImageException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_UnableToGetUpstreamLayerExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new UnableToGetUpstreamLayerException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_UnsupportedImageTypeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new UnsupportedImageTypeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_UnsupportedUpstreamRegistryExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new UnsupportedUpstreamRegistryException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_UploadNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new UploadNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ValidationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ValidationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const se_UploadLayerPartRequest = (input, context) => {
    return take(input, {
        layerPartBlob: context.base64Encoder,
        partFirstByte: [],
        partLastByte: [],
        registryId: [],
        repositoryName: [],
        uploadId: [],
    });
};
const de_AuthorizationData = (output, context) => {
    return take(output, {
        authorizationToken: __expectString,
        expiresAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        proxyEndpoint: __expectString,
    });
};
const de_AuthorizationDataList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AuthorizationData(entry, context);
    });
    return retVal;
};
const de_AwsEcrContainerImageDetails = (output, context) => {
    return take(output, {
        architecture: __expectString,
        author: __expectString,
        imageHash: __expectString,
        imageTags: _json,
        inUseCount: __expectLong,
        lastInUseAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        platform: __expectString,
        pushedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        registry: __expectString,
        repositoryName: __expectString,
    });
};
const de_CreatePullThroughCacheRuleResponse = (output, context) => {
    return take(output, {
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        credentialArn: __expectString,
        customRoleArn: __expectString,
        ecrRepositoryPrefix: __expectString,
        registryId: __expectString,
        upstreamRegistry: __expectString,
        upstreamRegistryUrl: __expectString,
        upstreamRepositoryPrefix: __expectString,
    });
};
const de_CreateRepositoryCreationTemplateResponse = (output, context) => {
    return take(output, {
        registryId: __expectString,
        repositoryCreationTemplate: (_) => de_RepositoryCreationTemplate(_, context),
    });
};
const de_CreateRepositoryResponse = (output, context) => {
    return take(output, {
        repository: (_) => de_Repository(_, context),
    });
};
const de_CvssScore = (output, context) => {
    return take(output, {
        baseScore: __limitedParseDouble,
        scoringVector: __expectString,
        source: __expectString,
        version: __expectString,
    });
};
const de_CvssScoreDetails = (output, context) => {
    return take(output, {
        adjustments: _json,
        score: __limitedParseDouble,
        scoreSource: __expectString,
        scoringVector: __expectString,
        version: __expectString,
    });
};
const de_CvssScoreList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CvssScore(entry, context);
    });
    return retVal;
};
const de_DeleteLifecyclePolicyResponse = (output, context) => {
    return take(output, {
        lastEvaluatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lifecyclePolicyText: __expectString,
        registryId: __expectString,
        repositoryName: __expectString,
    });
};
const de_DeletePullThroughCacheRuleResponse = (output, context) => {
    return take(output, {
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        credentialArn: __expectString,
        customRoleArn: __expectString,
        ecrRepositoryPrefix: __expectString,
        registryId: __expectString,
        upstreamRegistryUrl: __expectString,
        upstreamRepositoryPrefix: __expectString,
    });
};
const de_DeleteRepositoryCreationTemplateResponse = (output, context) => {
    return take(output, {
        registryId: __expectString,
        repositoryCreationTemplate: (_) => de_RepositoryCreationTemplate(_, context),
    });
};
const de_DeleteRepositoryResponse = (output, context) => {
    return take(output, {
        repository: (_) => de_Repository(_, context),
    });
};
const de_DescribeImageScanFindingsResponse = (output, context) => {
    return take(output, {
        imageId: _json,
        imageScanFindings: (_) => de_ImageScanFindings(_, context),
        imageScanStatus: _json,
        nextToken: __expectString,
        registryId: __expectString,
        repositoryName: __expectString,
    });
};
const de_DescribeImagesResponse = (output, context) => {
    return take(output, {
        imageDetails: (_) => de_ImageDetailList(_, context),
        nextToken: __expectString,
    });
};
const de_DescribePullThroughCacheRulesResponse = (output, context) => {
    return take(output, {
        nextToken: __expectString,
        pullThroughCacheRules: (_) => de_PullThroughCacheRuleList(_, context),
    });
};
const de_DescribeRepositoriesResponse = (output, context) => {
    return take(output, {
        nextToken: __expectString,
        repositories: (_) => de_RepositoryList(_, context),
    });
};
const de_DescribeRepositoryCreationTemplatesResponse = (output, context) => {
    return take(output, {
        nextToken: __expectString,
        registryId: __expectString,
        repositoryCreationTemplates: (_) => de_RepositoryCreationTemplateList(_, context),
    });
};
const de_EnhancedImageScanFinding = (output, context) => {
    return take(output, {
        awsAccountId: __expectString,
        description: __expectString,
        exploitAvailable: __expectString,
        findingArn: __expectString,
        firstObservedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        fixAvailable: __expectString,
        lastObservedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        packageVulnerabilityDetails: (_) => de_PackageVulnerabilityDetails(_, context),
        remediation: _json,
        resources: (_) => de_ResourceList(_, context),
        score: __limitedParseDouble,
        scoreDetails: (_) => de_ScoreDetails(_, context),
        severity: __expectString,
        status: __expectString,
        title: __expectString,
        type: __expectString,
        updatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_EnhancedImageScanFindingList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_EnhancedImageScanFinding(entry, context);
    });
    return retVal;
};
const de_GetAuthorizationTokenResponse = (output, context) => {
    return take(output, {
        authorizationData: (_) => de_AuthorizationDataList(_, context),
    });
};
const de_GetLifecyclePolicyPreviewResponse = (output, context) => {
    return take(output, {
        lifecyclePolicyText: __expectString,
        nextToken: __expectString,
        previewResults: (_) => de_LifecyclePolicyPreviewResultList(_, context),
        registryId: __expectString,
        repositoryName: __expectString,
        status: __expectString,
        summary: _json,
    });
};
const de_GetLifecyclePolicyResponse = (output, context) => {
    return take(output, {
        lastEvaluatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lifecyclePolicyText: __expectString,
        registryId: __expectString,
        repositoryName: __expectString,
    });
};
const de_ImageDetail = (output, context) => {
    return take(output, {
        artifactMediaType: __expectString,
        imageDigest: __expectString,
        imageManifestMediaType: __expectString,
        imagePushedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        imageScanFindingsSummary: (_) => de_ImageScanFindingsSummary(_, context),
        imageScanStatus: _json,
        imageSizeInBytes: __expectLong,
        imageTags: _json,
        lastRecordedPullTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        registryId: __expectString,
        repositoryName: __expectString,
    });
};
const de_ImageDetailList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ImageDetail(entry, context);
    });
    return retVal;
};
const de_ImageScanFindings = (output, context) => {
    return take(output, {
        enhancedFindings: (_) => de_EnhancedImageScanFindingList(_, context),
        findingSeverityCounts: _json,
        findings: _json,
        imageScanCompletedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        vulnerabilitySourceUpdatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_ImageScanFindingsSummary = (output, context) => {
    return take(output, {
        findingSeverityCounts: _json,
        imageScanCompletedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        vulnerabilitySourceUpdatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_LifecyclePolicyPreviewResult = (output, context) => {
    return take(output, {
        action: _json,
        appliedRulePriority: __expectInt32,
        imageDigest: __expectString,
        imagePushedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        imageTags: _json,
    });
};
const de_LifecyclePolicyPreviewResultList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_LifecyclePolicyPreviewResult(entry, context);
    });
    return retVal;
};
const de_PackageVulnerabilityDetails = (output, context) => {
    return take(output, {
        cvss: (_) => de_CvssScoreList(_, context),
        referenceUrls: _json,
        relatedVulnerabilities: _json,
        source: __expectString,
        sourceUrl: __expectString,
        vendorCreatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        vendorSeverity: __expectString,
        vendorUpdatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        vulnerabilityId: __expectString,
        vulnerablePackages: _json,
    });
};
const de_PullThroughCacheRule = (output, context) => {
    return take(output, {
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        credentialArn: __expectString,
        customRoleArn: __expectString,
        ecrRepositoryPrefix: __expectString,
        registryId: __expectString,
        updatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        upstreamRegistry: __expectString,
        upstreamRegistryUrl: __expectString,
        upstreamRepositoryPrefix: __expectString,
    });
};
const de_PullThroughCacheRuleList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PullThroughCacheRule(entry, context);
    });
    return retVal;
};
const de_Repository = (output, context) => {
    return take(output, {
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        encryptionConfiguration: _json,
        imageScanningConfiguration: _json,
        imageTagMutability: __expectString,
        registryId: __expectString,
        repositoryArn: __expectString,
        repositoryName: __expectString,
        repositoryUri: __expectString,
    });
};
const de_RepositoryCreationTemplate = (output, context) => {
    return take(output, {
        appliedFor: _json,
        createdAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        customRoleArn: __expectString,
        description: __expectString,
        encryptionConfiguration: _json,
        imageTagMutability: __expectString,
        lifecyclePolicy: __expectString,
        prefix: __expectString,
        repositoryPolicy: __expectString,
        resourceTags: _json,
        updatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_RepositoryCreationTemplateList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RepositoryCreationTemplate(entry, context);
    });
    return retVal;
};
const de_RepositoryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Repository(entry, context);
    });
    return retVal;
};
const de_Resource = (output, context) => {
    return take(output, {
        details: (_) => de_ResourceDetails(_, context),
        id: __expectString,
        tags: _json,
        type: __expectString,
    });
};
const de_ResourceDetails = (output, context) => {
    return take(output, {
        awsEcrContainerImage: (_) => de_AwsEcrContainerImageDetails(_, context),
    });
};
const de_ResourceList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Resource(entry, context);
    });
    return retVal;
};
const de_ScoreDetails = (output, context) => {
    return take(output, {
        cvss: (_) => de_CvssScoreDetails(_, context),
    });
};
const de_UpdatePullThroughCacheRuleResponse = (output, context) => {
    return take(output, {
        credentialArn: __expectString,
        customRoleArn: __expectString,
        ecrRepositoryPrefix: __expectString,
        registryId: __expectString,
        updatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        upstreamRepositoryPrefix: __expectString,
    });
};
const de_UpdateRepositoryCreationTemplateResponse = (output, context) => {
    return take(output, {
        registryId: __expectString,
        repositoryCreationTemplate: (_) => de_RepositoryCreationTemplate(_, context),
    });
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const throwDefaultError = withBaseException(__BaseException);
const buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers,
    };
    if (resolvedHostname !== undefined) {
        contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
        contents.body = body;
    }
    return new __HttpRequest(contents);
};
function sharedHeaders(operation) {
    return {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": `AmazonEC2ContainerRegistry_V20150921.${operation}`,
    };
}
