import { ECRServiceException as __BaseException } from "./ECRServiceException";
export const LayerFailureCode = {
    InvalidLayerDigest: "InvalidLayerDigest",
    MissingLayerDigest: "MissingLayerDigest",
};
export const LayerAvailability = {
    AVAILABLE: "AVAILABLE",
    UNAVAILABLE: "UNAVAILABLE",
};
export class InvalidParameterException extends __BaseException {
    name = "InvalidParameterException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidParameterException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidParameterException.prototype);
    }
}
export class RepositoryNotFoundException extends __BaseException {
    name = "RepositoryNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryNotFoundException.prototype);
    }
}
export class ServerException extends __BaseException {
    name = "ServerException";
    $fault = "server";
    constructor(opts) {
        super({
            name: "ServerException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, ServerException.prototype);
    }
}
export const ImageFailureCode = {
    ImageNotFound: "ImageNotFound",
    ImageReferencedByManifestList: "ImageReferencedByManifestList",
    ImageTagDoesNotMatchDigest: "ImageTagDoesNotMatchDigest",
    InvalidImageDigest: "InvalidImageDigest",
    InvalidImageTag: "InvalidImageTag",
    KmsError: "KmsError",
    MissingDigestAndTag: "MissingDigestAndTag",
    UpstreamAccessDenied: "UpstreamAccessDenied",
    UpstreamTooManyRequests: "UpstreamTooManyRequests",
    UpstreamUnavailable: "UpstreamUnavailable",
};
export class LimitExceededException extends __BaseException {
    name = "LimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LimitExceededException.prototype);
    }
}
export class UnableToGetUpstreamImageException extends __BaseException {
    name = "UnableToGetUpstreamImageException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "UnableToGetUpstreamImageException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UnableToGetUpstreamImageException.prototype);
    }
}
export const ScanningConfigurationFailureCode = {
    REPOSITORY_NOT_FOUND: "REPOSITORY_NOT_FOUND",
};
export const ScanningRepositoryFilterType = {
    WILDCARD: "WILDCARD",
};
export const ScanFrequency = {
    CONTINUOUS_SCAN: "CONTINUOUS_SCAN",
    MANUAL: "MANUAL",
    SCAN_ON_PUSH: "SCAN_ON_PUSH",
};
export class ValidationException extends __BaseException {
    name = "ValidationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ValidationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ValidationException.prototype);
    }
}
export class EmptyUploadException extends __BaseException {
    name = "EmptyUploadException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "EmptyUploadException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, EmptyUploadException.prototype);
    }
}
export class InvalidLayerException extends __BaseException {
    name = "InvalidLayerException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidLayerException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidLayerException.prototype);
    }
}
export class KmsException extends __BaseException {
    name = "KmsException";
    $fault = "client";
    kmsError;
    constructor(opts) {
        super({
            name: "KmsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, KmsException.prototype);
        this.kmsError = opts.kmsError;
    }
}
export class LayerAlreadyExistsException extends __BaseException {
    name = "LayerAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LayerAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LayerAlreadyExistsException.prototype);
    }
}
export class LayerPartTooSmallException extends __BaseException {
    name = "LayerPartTooSmallException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LayerPartTooSmallException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LayerPartTooSmallException.prototype);
    }
}
export class UploadNotFoundException extends __BaseException {
    name = "UploadNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "UploadNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UploadNotFoundException.prototype);
    }
}
export const UpstreamRegistry = {
    AzureContainerRegistry: "azure-container-registry",
    DockerHub: "docker-hub",
    Ecr: "ecr",
    EcrPublic: "ecr-public",
    GitHubContainerRegistry: "github-container-registry",
    GitLabContainerRegistry: "gitlab-container-registry",
    K8s: "k8s",
    Quay: "quay",
};
export class PullThroughCacheRuleAlreadyExistsException extends __BaseException {
    name = "PullThroughCacheRuleAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "PullThroughCacheRuleAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PullThroughCacheRuleAlreadyExistsException.prototype);
    }
}
export class SecretNotFoundException extends __BaseException {
    name = "SecretNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SecretNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SecretNotFoundException.prototype);
    }
}
export class UnableToAccessSecretException extends __BaseException {
    name = "UnableToAccessSecretException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "UnableToAccessSecretException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UnableToAccessSecretException.prototype);
    }
}
export class UnableToDecryptSecretValueException extends __BaseException {
    name = "UnableToDecryptSecretValueException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "UnableToDecryptSecretValueException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UnableToDecryptSecretValueException.prototype);
    }
}
export class UnsupportedUpstreamRegistryException extends __BaseException {
    name = "UnsupportedUpstreamRegistryException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "UnsupportedUpstreamRegistryException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UnsupportedUpstreamRegistryException.prototype);
    }
}
export const EncryptionType = {
    AES256: "AES256",
    KMS: "KMS",
    KMS_DSSE: "KMS_DSSE",
};
export const ImageTagMutability = {
    IMMUTABLE: "IMMUTABLE",
    MUTABLE: "MUTABLE",
};
export class InvalidTagParameterException extends __BaseException {
    name = "InvalidTagParameterException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTagParameterException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTagParameterException.prototype);
    }
}
export class RepositoryAlreadyExistsException extends __BaseException {
    name = "RepositoryAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryAlreadyExistsException.prototype);
    }
}
export class TooManyTagsException extends __BaseException {
    name = "TooManyTagsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TooManyTagsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyTagsException.prototype);
    }
}
export const RCTAppliedFor = {
    PULL_THROUGH_CACHE: "PULL_THROUGH_CACHE",
    REPLICATION: "REPLICATION",
};
export class TemplateAlreadyExistsException extends __BaseException {
    name = "TemplateAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TemplateAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TemplateAlreadyExistsException.prototype);
    }
}
export class LifecyclePolicyNotFoundException extends __BaseException {
    name = "LifecyclePolicyNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LifecyclePolicyNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LifecyclePolicyNotFoundException.prototype);
    }
}
export class PullThroughCacheRuleNotFoundException extends __BaseException {
    name = "PullThroughCacheRuleNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "PullThroughCacheRuleNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PullThroughCacheRuleNotFoundException.prototype);
    }
}
export class RegistryPolicyNotFoundException extends __BaseException {
    name = "RegistryPolicyNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RegistryPolicyNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RegistryPolicyNotFoundException.prototype);
    }
}
export class RepositoryNotEmptyException extends __BaseException {
    name = "RepositoryNotEmptyException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryNotEmptyException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryNotEmptyException.prototype);
    }
}
export class TemplateNotFoundException extends __BaseException {
    name = "TemplateNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TemplateNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TemplateNotFoundException.prototype);
    }
}
export class RepositoryPolicyNotFoundException extends __BaseException {
    name = "RepositoryPolicyNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryPolicyNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryPolicyNotFoundException.prototype);
    }
}
export const ReplicationStatus = {
    COMPLETE: "COMPLETE",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
};
export class ImageNotFoundException extends __BaseException {
    name = "ImageNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ImageNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ImageNotFoundException.prototype);
    }
}
export const TagStatus = {
    ANY: "ANY",
    TAGGED: "TAGGED",
    UNTAGGED: "UNTAGGED",
};
export const FindingSeverity = {
    CRITICAL: "CRITICAL",
    HIGH: "HIGH",
    INFORMATIONAL: "INFORMATIONAL",
    LOW: "LOW",
    MEDIUM: "MEDIUM",
    UNDEFINED: "UNDEFINED",
};
export const ScanStatus = {
    ACTIVE: "ACTIVE",
    COMPLETE: "COMPLETE",
    FAILED: "FAILED",
    FINDINGS_UNAVAILABLE: "FINDINGS_UNAVAILABLE",
    IN_PROGRESS: "IN_PROGRESS",
    LIMIT_EXCEEDED: "LIMIT_EXCEEDED",
    PENDING: "PENDING",
    SCAN_ELIGIBILITY_EXPIRED: "SCAN_ELIGIBILITY_EXPIRED",
    UNSUPPORTED_IMAGE: "UNSUPPORTED_IMAGE",
};
export class ScanNotFoundException extends __BaseException {
    name = "ScanNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ScanNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ScanNotFoundException.prototype);
    }
}
export const RepositoryFilterType = {
    PREFIX_MATCH: "PREFIX_MATCH",
};
export class LayerInaccessibleException extends __BaseException {
    name = "LayerInaccessibleException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LayerInaccessibleException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LayerInaccessibleException.prototype);
    }
}
export class LayersNotFoundException extends __BaseException {
    name = "LayersNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LayersNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LayersNotFoundException.prototype);
    }
}
export class UnableToGetUpstreamLayerException extends __BaseException {
    name = "UnableToGetUpstreamLayerException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "UnableToGetUpstreamLayerException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UnableToGetUpstreamLayerException.prototype);
    }
}
export const ImageActionType = {
    EXPIRE: "EXPIRE",
};
export const LifecyclePolicyPreviewStatus = {
    COMPLETE: "COMPLETE",
    EXPIRED: "EXPIRED",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
};
export class LifecyclePolicyPreviewNotFoundException extends __BaseException {
    name = "LifecyclePolicyPreviewNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LifecyclePolicyPreviewNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LifecyclePolicyPreviewNotFoundException.prototype);
    }
}
export const ScanType = {
    BASIC: "BASIC",
    ENHANCED: "ENHANCED",
};
export class ImageAlreadyExistsException extends __BaseException {
    name = "ImageAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ImageAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ImageAlreadyExistsException.prototype);
    }
}
export class ImageDigestDoesNotMatchException extends __BaseException {
    name = "ImageDigestDoesNotMatchException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ImageDigestDoesNotMatchException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ImageDigestDoesNotMatchException.prototype);
    }
}
export class ImageTagAlreadyExistsException extends __BaseException {
    name = "ImageTagAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ImageTagAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ImageTagAlreadyExistsException.prototype);
    }
}
export class ReferencedImagesNotFoundException extends __BaseException {
    name = "ReferencedImagesNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReferencedImagesNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReferencedImagesNotFoundException.prototype);
    }
}
export class UnsupportedImageTypeException extends __BaseException {
    name = "UnsupportedImageTypeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "UnsupportedImageTypeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UnsupportedImageTypeException.prototype);
    }
}
export class LifecyclePolicyPreviewInProgressException extends __BaseException {
    name = "LifecyclePolicyPreviewInProgressException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LifecyclePolicyPreviewInProgressException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LifecyclePolicyPreviewInProgressException.prototype);
    }
}
export class InvalidLayerPartException extends __BaseException {
    name = "InvalidLayerPartException";
    $fault = "client";
    registryId;
    repositoryName;
    uploadId;
    lastValidByteReceived;
    constructor(opts) {
        super({
            name: "InvalidLayerPartException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidLayerPartException.prototype);
        this.registryId = opts.registryId;
        this.repositoryName = opts.repositoryName;
        this.uploadId = opts.uploadId;
        this.lastValidByteReceived = opts.lastValidByteReceived;
    }
}
