import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_UploadLayerPartCommand, se_UploadLayerPartCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class UploadLayerPartCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerRegistry_V20150921", "UploadLayerPart", {})
    .n("ECRClient", "UploadLayerPartCommand")
    .f(void 0, void 0)
    .ser(se_UploadLayerPartCommand)
    .de(de_UploadLayerPartCommand)
    .build() {
}
