import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_StartLifecyclePolicyPreviewCommand, se_StartLifecyclePolicyPreviewCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class StartLifecyclePolicyPreviewCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerRegistry_V20150921", "StartLifecyclePolicyPreview", {})
    .n("ECRClient", "StartLifecyclePolicyPreviewCommand")
    .f(void 0, void 0)
    .ser(se_StartLifecyclePolicyPreviewCommand)
    .de(de_StartLifecyclePolicyPreviewCommand)
    .build() {
}
