import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_InitiateLayerUploadCommand, se_InitiateLayerUploadCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class InitiateLayerUploadCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerRegistry_V20150921", "InitiateLayerUpload", {})
    .n("ECRClient", "InitiateLayerUploadCommand")
    .f(void 0, void 0)
    .ser(se_InitiateLayerUploadCommand)
    .de(de_InitiateLayerUploadCommand)
    .build() {
}
