import {
  AccountAttribute,
  AccountAttributeName,
  Address,
  AddressAttribute,
  AddressAttributeName,
  AddressTransfer,
  BundleTask,
  ByoipCidr,
  CapacityReservationFleetState,
  ClientVpnAuthorizationRuleStatus,
  InstanceEventWindowState,
  Tag,
  TagSpecification,
  TransitGatewayPeeringAttachment,
  TransitGatewayVpcAttachment,
  UnsuccessfulItem,
  VerifiedAccessInstance,
  VerifiedAccessTrustProvider,
  VpcAttachment,
  VpcPeeringConnection,
} from "./models_0";
import {
  CapacityReservation,
  CapacityReservationTenancy,
  CarrierGateway,
  ClientVpnEndpointStatus,
  ClientVpnRouteStatus,
  CoipCidr,
  CoipPool,
  Ec2InstanceConnectEndpoint,
  FleetCapacityReservation,
  FleetCapacityReservationTenancy,
  FleetInstanceMatchCriteria,
  GatewayType,
  Ipam,
  IpamExternalResourceVerificationToken,
  IpamPool,
  IpamResourceDiscovery,
  IpamScope,
  LaunchTemplate,
} from "./models_1";
import {
  GroupIdentifier,
  LocalGatewayRoute,
  LocalGatewayRouteTable,
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation,
  LocalGatewayRouteTableVpcAssociation,
  LocalGatewayVirtualInterface,
  LocalGatewayVirtualInterfaceGroup,
  ManagedPrefixList,
  RouteServer,
  RouteServerEndpoint,
  RouteServerPeer,
  SubnetCidrReservation,
  TransitGateway,
  TransitGatewayConnect,
  TransitGatewayConnectPeer,
  TransitGatewayMulticastDomain,
  TransitGatewayPolicyTable,
  TransitGatewayPrefixListReference,
  TransitGatewayRoute,
  TransitGatewayRouteTable,
  TransitGatewayRouteTableAnnouncement,
  VerifiedAccessEndpoint,
  VerifiedAccessGroup,
  VpcBlockPublicAccessExclusion,
  VpcEndpoint,
} from "./models_2";
export interface CreateVpcEndpointResult {
  VpcEndpoint?: VpcEndpoint | undefined;
  ClientToken?: string | undefined;
}
export interface CreateVpcEndpointConnectionNotificationRequest {
  DryRun?: boolean | undefined;
  ServiceId?: string | undefined;
  VpcEndpointId?: string | undefined;
  ConnectionNotificationArn: string | undefined;
  ConnectionEvents: string[] | undefined;
  ClientToken?: string | undefined;
}
export declare const ConnectionNotificationState: {
  readonly Disabled: "Disabled";
  readonly Enabled: "Enabled";
};
export type ConnectionNotificationState =
  (typeof ConnectionNotificationState)[keyof typeof ConnectionNotificationState];
export declare const ConnectionNotificationType: {
  readonly Topic: "Topic";
};
export type ConnectionNotificationType =
  (typeof ConnectionNotificationType)[keyof typeof ConnectionNotificationType];
export interface ConnectionNotification {
  ConnectionNotificationId?: string | undefined;
  ServiceId?: string | undefined;
  VpcEndpointId?: string | undefined;
  ConnectionNotificationType?: ConnectionNotificationType | undefined;
  ConnectionNotificationArn?: string | undefined;
  ConnectionEvents?: string[] | undefined;
  ConnectionNotificationState?: ConnectionNotificationState | undefined;
  ServiceRegion?: string | undefined;
}
export interface CreateVpcEndpointConnectionNotificationResult {
  ConnectionNotification?: ConnectionNotification | undefined;
  ClientToken?: string | undefined;
}
export interface CreateVpcEndpointServiceConfigurationRequest {
  DryRun?: boolean | undefined;
  AcceptanceRequired?: boolean | undefined;
  PrivateDnsName?: string | undefined;
  NetworkLoadBalancerArns?: string[] | undefined;
  GatewayLoadBalancerArns?: string[] | undefined;
  SupportedIpAddressTypes?: string[] | undefined;
  SupportedRegions?: string[] | undefined;
  ClientToken?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export declare const PayerResponsibility: {
  readonly ServiceOwner: "ServiceOwner";
};
export type PayerResponsibility =
  (typeof PayerResponsibility)[keyof typeof PayerResponsibility];
export declare const DnsNameState: {
  readonly Failed: "failed";
  readonly PendingVerification: "pendingVerification";
  readonly Verified: "verified";
};
export type DnsNameState = (typeof DnsNameState)[keyof typeof DnsNameState];
export interface PrivateDnsNameConfiguration {
  State?: DnsNameState | undefined;
  Type?: string | undefined;
  Value?: string | undefined;
  Name?: string | undefined;
}
export declare const ServiceState: {
  readonly Available: "Available";
  readonly Deleted: "Deleted";
  readonly Deleting: "Deleting";
  readonly Failed: "Failed";
  readonly Pending: "Pending";
};
export type ServiceState = (typeof ServiceState)[keyof typeof ServiceState];
export declare const ServiceType: {
  readonly Gateway: "Gateway";
  readonly GatewayLoadBalancer: "GatewayLoadBalancer";
  readonly Interface: "Interface";
};
export type ServiceType = (typeof ServiceType)[keyof typeof ServiceType];
export interface ServiceTypeDetail {
  ServiceType?: ServiceType | undefined;
}
export declare const ServiceConnectivityType: {
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
};
export type ServiceConnectivityType =
  (typeof ServiceConnectivityType)[keyof typeof ServiceConnectivityType];
export interface SupportedRegionDetail {
  Region?: string | undefined;
  ServiceState?: string | undefined;
}
export interface ServiceConfiguration {
  ServiceType?: ServiceTypeDetail[] | undefined;
  ServiceId?: string | undefined;
  ServiceName?: string | undefined;
  ServiceState?: ServiceState | undefined;
  AvailabilityZones?: string[] | undefined;
  AcceptanceRequired?: boolean | undefined;
  ManagesVpcEndpoints?: boolean | undefined;
  NetworkLoadBalancerArns?: string[] | undefined;
  GatewayLoadBalancerArns?: string[] | undefined;
  SupportedIpAddressTypes?: ServiceConnectivityType[] | undefined;
  BaseEndpointDnsNames?: string[] | undefined;
  PrivateDnsName?: string | undefined;
  PrivateDnsNameConfiguration?: PrivateDnsNameConfiguration | undefined;
  PayerResponsibility?: PayerResponsibility | undefined;
  Tags?: Tag[] | undefined;
  SupportedRegions?: SupportedRegionDetail[] | undefined;
  RemoteAccessEnabled?: boolean | undefined;
}
export interface CreateVpcEndpointServiceConfigurationResult {
  ServiceConfiguration?: ServiceConfiguration | undefined;
  ClientToken?: string | undefined;
}
export interface CreateVpcPeeringConnectionRequest {
  PeerRegion?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  VpcId: string | undefined;
  PeerVpcId?: string | undefined;
  PeerOwnerId?: string | undefined;
}
export interface CreateVpcPeeringConnectionResult {
  VpcPeeringConnection?: VpcPeeringConnection | undefined;
}
export declare const TunnelInsideIpVersion: {
  readonly ipv4: "ipv4";
  readonly ipv6: "ipv6";
};
export type TunnelInsideIpVersion =
  (typeof TunnelInsideIpVersion)[keyof typeof TunnelInsideIpVersion];
export interface IKEVersionsRequestListValue {
  Value?: string | undefined;
}
export interface CloudWatchLogOptionsSpecification {
  LogEnabled?: boolean | undefined;
  LogGroupArn?: string | undefined;
  LogOutputFormat?: string | undefined;
}
export interface VpnTunnelLogOptionsSpecification {
  CloudWatchLogOptions?: CloudWatchLogOptionsSpecification | undefined;
}
export interface Phase1DHGroupNumbersRequestListValue {
  Value?: number | undefined;
}
export interface Phase1EncryptionAlgorithmsRequestListValue {
  Value?: string | undefined;
}
export interface Phase1IntegrityAlgorithmsRequestListValue {
  Value?: string | undefined;
}
export interface Phase2DHGroupNumbersRequestListValue {
  Value?: number | undefined;
}
export interface Phase2EncryptionAlgorithmsRequestListValue {
  Value?: string | undefined;
}
export interface Phase2IntegrityAlgorithmsRequestListValue {
  Value?: string | undefined;
}
export interface VpnTunnelOptionsSpecification {
  TunnelInsideCidr?: string | undefined;
  TunnelInsideIpv6Cidr?: string | undefined;
  PreSharedKey?: string | undefined;
  Phase1LifetimeSeconds?: number | undefined;
  Phase2LifetimeSeconds?: number | undefined;
  RekeyMarginTimeSeconds?: number | undefined;
  RekeyFuzzPercentage?: number | undefined;
  ReplayWindowSize?: number | undefined;
  DPDTimeoutSeconds?: number | undefined;
  DPDTimeoutAction?: string | undefined;
  Phase1EncryptionAlgorithms?:
    | Phase1EncryptionAlgorithmsRequestListValue[]
    | undefined;
  Phase2EncryptionAlgorithms?:
    | Phase2EncryptionAlgorithmsRequestListValue[]
    | undefined;
  Phase1IntegrityAlgorithms?:
    | Phase1IntegrityAlgorithmsRequestListValue[]
    | undefined;
  Phase2IntegrityAlgorithms?:
    | Phase2IntegrityAlgorithmsRequestListValue[]
    | undefined;
  Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[] | undefined;
  Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[] | undefined;
  IKEVersions?: IKEVersionsRequestListValue[] | undefined;
  StartupAction?: string | undefined;
  LogOptions?: VpnTunnelLogOptionsSpecification | undefined;
  EnableTunnelLifecycleControl?: boolean | undefined;
}
export interface VpnConnectionOptionsSpecification {
  EnableAcceleration?: boolean | undefined;
  TunnelInsideIpVersion?: TunnelInsideIpVersion | undefined;
  TunnelOptions?: VpnTunnelOptionsSpecification[] | undefined;
  LocalIpv4NetworkCidr?: string | undefined;
  RemoteIpv4NetworkCidr?: string | undefined;
  LocalIpv6NetworkCidr?: string | undefined;
  RemoteIpv6NetworkCidr?: string | undefined;
  OutsideIpAddressType?: string | undefined;
  TransportTransitGatewayAttachmentId?: string | undefined;
  StaticRoutesOnly?: boolean | undefined;
}
export interface CreateVpnConnectionRequest {
  CustomerGatewayId: string | undefined;
  Type: string | undefined;
  VpnGatewayId?: string | undefined;
  TransitGatewayId?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  PreSharedKeyStorage?: string | undefined;
  DryRun?: boolean | undefined;
  Options?: VpnConnectionOptionsSpecification | undefined;
}
export declare const GatewayAssociationState: {
  readonly associated: "associated";
  readonly associating: "associating";
  readonly disassociating: "disassociating";
  readonly not_associated: "not-associated";
};
export type GatewayAssociationState =
  (typeof GatewayAssociationState)[keyof typeof GatewayAssociationState];
export interface IKEVersionsListValue {
  Value?: string | undefined;
}
export interface CloudWatchLogOptions {
  LogEnabled?: boolean | undefined;
  LogGroupArn?: string | undefined;
  LogOutputFormat?: string | undefined;
}
export interface VpnTunnelLogOptions {
  CloudWatchLogOptions?: CloudWatchLogOptions | undefined;
}
export interface Phase1DHGroupNumbersListValue {
  Value?: number | undefined;
}
export interface Phase1EncryptionAlgorithmsListValue {
  Value?: string | undefined;
}
export interface Phase1IntegrityAlgorithmsListValue {
  Value?: string | undefined;
}
export interface Phase2DHGroupNumbersListValue {
  Value?: number | undefined;
}
export interface Phase2EncryptionAlgorithmsListValue {
  Value?: string | undefined;
}
export interface Phase2IntegrityAlgorithmsListValue {
  Value?: string | undefined;
}
export interface TunnelOption {
  OutsideIpAddress?: string | undefined;
  TunnelInsideCidr?: string | undefined;
  TunnelInsideIpv6Cidr?: string | undefined;
  PreSharedKey?: string | undefined;
  Phase1LifetimeSeconds?: number | undefined;
  Phase2LifetimeSeconds?: number | undefined;
  RekeyMarginTimeSeconds?: number | undefined;
  RekeyFuzzPercentage?: number | undefined;
  ReplayWindowSize?: number | undefined;
  DpdTimeoutSeconds?: number | undefined;
  DpdTimeoutAction?: string | undefined;
  Phase1EncryptionAlgorithms?:
    | Phase1EncryptionAlgorithmsListValue[]
    | undefined;
  Phase2EncryptionAlgorithms?:
    | Phase2EncryptionAlgorithmsListValue[]
    | undefined;
  Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsListValue[] | undefined;
  Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsListValue[] | undefined;
  Phase1DHGroupNumbers?: Phase1DHGroupNumbersListValue[] | undefined;
  Phase2DHGroupNumbers?: Phase2DHGroupNumbersListValue[] | undefined;
  IkeVersions?: IKEVersionsListValue[] | undefined;
  StartupAction?: string | undefined;
  LogOptions?: VpnTunnelLogOptions | undefined;
  EnableTunnelLifecycleControl?: boolean | undefined;
}
export interface VpnConnectionOptions {
  EnableAcceleration?: boolean | undefined;
  StaticRoutesOnly?: boolean | undefined;
  LocalIpv4NetworkCidr?: string | undefined;
  RemoteIpv4NetworkCidr?: string | undefined;
  LocalIpv6NetworkCidr?: string | undefined;
  RemoteIpv6NetworkCidr?: string | undefined;
  OutsideIpAddressType?: string | undefined;
  TransportTransitGatewayAttachmentId?: string | undefined;
  TunnelInsideIpVersion?: TunnelInsideIpVersion | undefined;
  TunnelOptions?: TunnelOption[] | undefined;
}
export declare const VpnStaticRouteSource: {
  readonly Static: "Static";
};
export type VpnStaticRouteSource =
  (typeof VpnStaticRouteSource)[keyof typeof VpnStaticRouteSource];
export declare const VpnState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type VpnState = (typeof VpnState)[keyof typeof VpnState];
export interface VpnStaticRoute {
  DestinationCidrBlock?: string | undefined;
  Source?: VpnStaticRouteSource | undefined;
  State?: VpnState | undefined;
}
export declare const TelemetryStatus: {
  readonly DOWN: "DOWN";
  readonly UP: "UP";
};
export type TelemetryStatus =
  (typeof TelemetryStatus)[keyof typeof TelemetryStatus];
export interface VgwTelemetry {
  AcceptedRouteCount?: number | undefined;
  LastStatusChange?: Date | undefined;
  OutsideIpAddress?: string | undefined;
  Status?: TelemetryStatus | undefined;
  StatusMessage?: string | undefined;
  CertificateArn?: string | undefined;
}
export interface VpnConnection {
  Category?: string | undefined;
  TransitGatewayId?: string | undefined;
  CoreNetworkArn?: string | undefined;
  CoreNetworkAttachmentArn?: string | undefined;
  GatewayAssociationState?: GatewayAssociationState | undefined;
  Options?: VpnConnectionOptions | undefined;
  Routes?: VpnStaticRoute[] | undefined;
  Tags?: Tag[] | undefined;
  VgwTelemetry?: VgwTelemetry[] | undefined;
  PreSharedKeyArn?: string | undefined;
  VpnConnectionId?: string | undefined;
  State?: VpnState | undefined;
  CustomerGatewayConfiguration?: string | undefined;
  Type?: GatewayType | undefined;
  CustomerGatewayId?: string | undefined;
  VpnGatewayId?: string | undefined;
}
export interface CreateVpnConnectionResult {
  VpnConnection?: VpnConnection | undefined;
}
export interface CreateVpnConnectionRouteRequest {
  DestinationCidrBlock: string | undefined;
  VpnConnectionId: string | undefined;
}
export interface CreateVpnGatewayRequest {
  AvailabilityZone?: string | undefined;
  Type: GatewayType | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  AmazonSideAsn?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface VpnGateway {
  AmazonSideAsn?: number | undefined;
  Tags?: Tag[] | undefined;
  VpnGatewayId?: string | undefined;
  State?: VpnState | undefined;
  Type?: GatewayType | undefined;
  AvailabilityZone?: string | undefined;
  VpcAttachments?: VpcAttachment[] | undefined;
}
export interface CreateVpnGatewayResult {
  VpnGateway?: VpnGateway | undefined;
}
export interface DeleteCarrierGatewayRequest {
  CarrierGatewayId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteCarrierGatewayResult {
  CarrierGateway?: CarrierGateway | undefined;
}
export interface DeleteClientVpnEndpointRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteClientVpnEndpointResult {
  Status?: ClientVpnEndpointStatus | undefined;
}
export interface DeleteClientVpnRouteRequest {
  ClientVpnEndpointId: string | undefined;
  TargetVpcSubnetId?: string | undefined;
  DestinationCidrBlock: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteClientVpnRouteResult {
  Status?: ClientVpnRouteStatus | undefined;
}
export interface DeleteCoipCidrRequest {
  Cidr: string | undefined;
  CoipPoolId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteCoipCidrResult {
  CoipCidr?: CoipCidr | undefined;
}
export interface DeleteCoipPoolRequest {
  CoipPoolId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteCoipPoolResult {
  CoipPool?: CoipPool | undefined;
}
export interface DeleteCustomerGatewayRequest {
  CustomerGatewayId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteDhcpOptionsRequest {
  DhcpOptionsId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteEgressOnlyInternetGatewayRequest {
  DryRun?: boolean | undefined;
  EgressOnlyInternetGatewayId: string | undefined;
}
export interface DeleteEgressOnlyInternetGatewayResult {
  ReturnCode?: boolean | undefined;
}
export interface DeleteFleetsRequest {
  DryRun?: boolean | undefined;
  FleetIds: string[] | undefined;
  TerminateInstances: boolean | undefined;
}
export declare const FleetStateCode: {
  readonly ACTIVE: "active";
  readonly DELETED: "deleted";
  readonly DELETED_RUNNING: "deleted_running";
  readonly DELETED_TERMINATING_INSTANCES: "deleted_terminating";
  readonly FAILED: "failed";
  readonly MODIFYING: "modifying";
  readonly SUBMITTED: "submitted";
};
export type FleetStateCode =
  (typeof FleetStateCode)[keyof typeof FleetStateCode];
export interface DeleteFleetSuccessItem {
  CurrentFleetState?: FleetStateCode | undefined;
  PreviousFleetState?: FleetStateCode | undefined;
  FleetId?: string | undefined;
}
export declare const DeleteFleetErrorCode: {
  readonly FLEET_ID_DOES_NOT_EXIST: "fleetIdDoesNotExist";
  readonly FLEET_ID_MALFORMED: "fleetIdMalformed";
  readonly FLEET_NOT_IN_DELETABLE_STATE: "fleetNotInDeletableState";
  readonly UNEXPECTED_ERROR: "unexpectedError";
};
export type DeleteFleetErrorCode =
  (typeof DeleteFleetErrorCode)[keyof typeof DeleteFleetErrorCode];
export interface DeleteFleetError {
  Code?: DeleteFleetErrorCode | undefined;
  Message?: string | undefined;
}
export interface DeleteFleetErrorItem {
  Error?: DeleteFleetError | undefined;
  FleetId?: string | undefined;
}
export interface DeleteFleetsResult {
  SuccessfulFleetDeletions?: DeleteFleetSuccessItem[] | undefined;
  UnsuccessfulFleetDeletions?: DeleteFleetErrorItem[] | undefined;
}
export interface DeleteFlowLogsRequest {
  DryRun?: boolean | undefined;
  FlowLogIds: string[] | undefined;
}
export interface DeleteFlowLogsResult {
  Unsuccessful?: UnsuccessfulItem[] | undefined;
}
export interface DeleteFpgaImageRequest {
  DryRun?: boolean | undefined;
  FpgaImageId: string | undefined;
}
export interface DeleteFpgaImageResult {
  Return?: boolean | undefined;
}
export interface DeleteInstanceConnectEndpointRequest {
  DryRun?: boolean | undefined;
  InstanceConnectEndpointId: string | undefined;
}
export interface DeleteInstanceConnectEndpointResult {
  InstanceConnectEndpoint?: Ec2InstanceConnectEndpoint | undefined;
}
export interface DeleteInstanceEventWindowRequest {
  DryRun?: boolean | undefined;
  ForceDelete?: boolean | undefined;
  InstanceEventWindowId: string | undefined;
}
export interface InstanceEventWindowStateChange {
  InstanceEventWindowId?: string | undefined;
  State?: InstanceEventWindowState | undefined;
}
export interface DeleteInstanceEventWindowResult {
  InstanceEventWindowState?: InstanceEventWindowStateChange | undefined;
}
export interface DeleteInternetGatewayRequest {
  DryRun?: boolean | undefined;
  InternetGatewayId: string | undefined;
}
export interface DeleteIpamRequest {
  DryRun?: boolean | undefined;
  IpamId: string | undefined;
  Cascade?: boolean | undefined;
}
export interface DeleteIpamResult {
  Ipam?: Ipam | undefined;
}
export interface DeleteIpamExternalResourceVerificationTokenRequest {
  DryRun?: boolean | undefined;
  IpamExternalResourceVerificationTokenId: string | undefined;
}
export interface DeleteIpamExternalResourceVerificationTokenResult {
  IpamExternalResourceVerificationToken?:
    | IpamExternalResourceVerificationToken
    | undefined;
}
export interface DeleteIpamPoolRequest {
  DryRun?: boolean | undefined;
  IpamPoolId: string | undefined;
  Cascade?: boolean | undefined;
}
export interface DeleteIpamPoolResult {
  IpamPool?: IpamPool | undefined;
}
export interface DeleteIpamResourceDiscoveryRequest {
  DryRun?: boolean | undefined;
  IpamResourceDiscoveryId: string | undefined;
}
export interface DeleteIpamResourceDiscoveryResult {
  IpamResourceDiscovery?: IpamResourceDiscovery | undefined;
}
export interface DeleteIpamScopeRequest {
  DryRun?: boolean | undefined;
  IpamScopeId: string | undefined;
}
export interface DeleteIpamScopeResult {
  IpamScope?: IpamScope | undefined;
}
export interface DeleteKeyPairRequest {
  KeyName?: string | undefined;
  KeyPairId?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteKeyPairResult {
  Return?: boolean | undefined;
  KeyPairId?: string | undefined;
}
export interface DeleteLaunchTemplateRequest {
  DryRun?: boolean | undefined;
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
}
export interface DeleteLaunchTemplateResult {
  LaunchTemplate?: LaunchTemplate | undefined;
}
export interface DeleteLaunchTemplateVersionsRequest {
  DryRun?: boolean | undefined;
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  Versions: string[] | undefined;
}
export interface DeleteLaunchTemplateVersionsResponseSuccessItem {
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  VersionNumber?: number | undefined;
}
export declare const LaunchTemplateErrorCode: {
  readonly LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST: "launchTemplateIdDoesNotExist";
  readonly LAUNCH_TEMPLATE_ID_MALFORMED: "launchTemplateIdMalformed";
  readonly LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST: "launchTemplateNameDoesNotExist";
  readonly LAUNCH_TEMPLATE_NAME_MALFORMED: "launchTemplateNameMalformed";
  readonly LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST: "launchTemplateVersionDoesNotExist";
  readonly UNEXPECTED_ERROR: "unexpectedError";
};
export type LaunchTemplateErrorCode =
  (typeof LaunchTemplateErrorCode)[keyof typeof LaunchTemplateErrorCode];
export interface ResponseError {
  Code?: LaunchTemplateErrorCode | undefined;
  Message?: string | undefined;
}
export interface DeleteLaunchTemplateVersionsResponseErrorItem {
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  VersionNumber?: number | undefined;
  ResponseError?: ResponseError | undefined;
}
export interface DeleteLaunchTemplateVersionsResult {
  SuccessfullyDeletedLaunchTemplateVersions?:
    | DeleteLaunchTemplateVersionsResponseSuccessItem[]
    | undefined;
  UnsuccessfullyDeletedLaunchTemplateVersions?:
    | DeleteLaunchTemplateVersionsResponseErrorItem[]
    | undefined;
}
export interface DeleteLocalGatewayRouteRequest {
  DestinationCidrBlock?: string | undefined;
  LocalGatewayRouteTableId: string | undefined;
  DryRun?: boolean | undefined;
  DestinationPrefixListId?: string | undefined;
}
export interface DeleteLocalGatewayRouteResult {
  Route?: LocalGatewayRoute | undefined;
}
export interface DeleteLocalGatewayRouteTableRequest {
  LocalGatewayRouteTableId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteLocalGatewayRouteTableResult {
  LocalGatewayRouteTable?: LocalGatewayRouteTable | undefined;
}
export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult {
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation?:
    | LocalGatewayRouteTableVirtualInterfaceGroupAssociation
    | undefined;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationRequest {
  LocalGatewayRouteTableVpcAssociationId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationResult {
  LocalGatewayRouteTableVpcAssociation?:
    | LocalGatewayRouteTableVpcAssociation
    | undefined;
}
export interface DeleteLocalGatewayVirtualInterfaceRequest {
  LocalGatewayVirtualInterfaceId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteLocalGatewayVirtualInterfaceResult {
  LocalGatewayVirtualInterface?: LocalGatewayVirtualInterface | undefined;
}
export interface DeleteLocalGatewayVirtualInterfaceGroupRequest {
  LocalGatewayVirtualInterfaceGroupId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteLocalGatewayVirtualInterfaceGroupResult {
  LocalGatewayVirtualInterfaceGroup?:
    | LocalGatewayVirtualInterfaceGroup
    | undefined;
}
export interface DeleteManagedPrefixListRequest {
  DryRun?: boolean | undefined;
  PrefixListId: string | undefined;
}
export interface DeleteManagedPrefixListResult {
  PrefixList?: ManagedPrefixList | undefined;
}
export interface DeleteNatGatewayRequest {
  DryRun?: boolean | undefined;
  NatGatewayId: string | undefined;
}
export interface DeleteNatGatewayResult {
  NatGatewayId?: string | undefined;
}
export interface DeleteNetworkAclRequest {
  DryRun?: boolean | undefined;
  NetworkAclId: string | undefined;
}
export interface DeleteNetworkAclEntryRequest {
  DryRun?: boolean | undefined;
  NetworkAclId: string | undefined;
  RuleNumber: number | undefined;
  Egress: boolean | undefined;
}
export interface DeleteNetworkInsightsAccessScopeRequest {
  DryRun?: boolean | undefined;
  NetworkInsightsAccessScopeId: string | undefined;
}
export interface DeleteNetworkInsightsAccessScopeResult {
  NetworkInsightsAccessScopeId?: string | undefined;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisRequest {
  NetworkInsightsAccessScopeAnalysisId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisResult {
  NetworkInsightsAccessScopeAnalysisId?: string | undefined;
}
export interface DeleteNetworkInsightsAnalysisRequest {
  DryRun?: boolean | undefined;
  NetworkInsightsAnalysisId: string | undefined;
}
export interface DeleteNetworkInsightsAnalysisResult {
  NetworkInsightsAnalysisId?: string | undefined;
}
export interface DeleteNetworkInsightsPathRequest {
  DryRun?: boolean | undefined;
  NetworkInsightsPathId: string | undefined;
}
export interface DeleteNetworkInsightsPathResult {
  NetworkInsightsPathId?: string | undefined;
}
export interface DeleteNetworkInterfaceRequest {
  DryRun?: boolean | undefined;
  NetworkInterfaceId: string | undefined;
}
export interface DeleteNetworkInterfacePermissionRequest {
  NetworkInterfacePermissionId: string | undefined;
  Force?: boolean | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteNetworkInterfacePermissionResult {
  Return?: boolean | undefined;
}
export interface DeletePlacementGroupRequest {
  DryRun?: boolean | undefined;
  GroupName: string | undefined;
}
export interface DeletePublicIpv4PoolRequest {
  DryRun?: boolean | undefined;
  PoolId: string | undefined;
  NetworkBorderGroup?: string | undefined;
}
export interface DeletePublicIpv4PoolResult {
  ReturnValue?: boolean | undefined;
}
export interface DeleteQueuedReservedInstancesRequest {
  DryRun?: boolean | undefined;
  ReservedInstancesIds: string[] | undefined;
}
export declare const DeleteQueuedReservedInstancesErrorCode: {
  readonly RESERVED_INSTANCES_ID_INVALID: "reserved-instances-id-invalid";
  readonly RESERVED_INSTANCES_NOT_IN_QUEUED_STATE: "reserved-instances-not-in-queued-state";
  readonly UNEXPECTED_ERROR: "unexpected-error";
};
export type DeleteQueuedReservedInstancesErrorCode =
  (typeof DeleteQueuedReservedInstancesErrorCode)[keyof typeof DeleteQueuedReservedInstancesErrorCode];
export interface DeleteQueuedReservedInstancesError {
  Code?: DeleteQueuedReservedInstancesErrorCode | undefined;
  Message?: string | undefined;
}
export interface FailedQueuedPurchaseDeletion {
  Error?: DeleteQueuedReservedInstancesError | undefined;
  ReservedInstancesId?: string | undefined;
}
export interface SuccessfulQueuedPurchaseDeletion {
  ReservedInstancesId?: string | undefined;
}
export interface DeleteQueuedReservedInstancesResult {
  SuccessfulQueuedPurchaseDeletions?:
    | SuccessfulQueuedPurchaseDeletion[]
    | undefined;
  FailedQueuedPurchaseDeletions?: FailedQueuedPurchaseDeletion[] | undefined;
}
export interface DeleteRouteRequest {
  DestinationPrefixListId?: string | undefined;
  DryRun?: boolean | undefined;
  RouteTableId: string | undefined;
  DestinationCidrBlock?: string | undefined;
  DestinationIpv6CidrBlock?: string | undefined;
}
export interface DeleteRouteServerRequest {
  RouteServerId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteRouteServerResult {
  RouteServer?: RouteServer | undefined;
}
export interface DeleteRouteServerEndpointRequest {
  RouteServerEndpointId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteRouteServerEndpointResult {
  RouteServerEndpoint?: RouteServerEndpoint | undefined;
}
export interface DeleteRouteServerPeerRequest {
  RouteServerPeerId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteRouteServerPeerResult {
  RouteServerPeer?: RouteServerPeer | undefined;
}
export interface DeleteRouteTableRequest {
  DryRun?: boolean | undefined;
  RouteTableId: string | undefined;
}
export interface DeleteSecurityGroupRequest {
  GroupId?: string | undefined;
  GroupName?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteSecurityGroupResult {
  Return?: boolean | undefined;
  GroupId?: string | undefined;
}
export interface DeleteSnapshotRequest {
  SnapshotId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteSpotDatafeedSubscriptionRequest {
  DryRun?: boolean | undefined;
}
export interface DeleteSubnetRequest {
  SubnetId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteSubnetCidrReservationRequest {
  SubnetCidrReservationId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteSubnetCidrReservationResult {
  DeletedSubnetCidrReservation?: SubnetCidrReservation | undefined;
}
export interface DeleteTagsRequest {
  DryRun?: boolean | undefined;
  Resources: string[] | undefined;
  Tags?: Tag[] | undefined;
}
export interface DeleteTrafficMirrorFilterRequest {
  TrafficMirrorFilterId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTrafficMirrorFilterResult {
  TrafficMirrorFilterId?: string | undefined;
}
export interface DeleteTrafficMirrorFilterRuleRequest {
  TrafficMirrorFilterRuleId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTrafficMirrorFilterRuleResult {
  TrafficMirrorFilterRuleId?: string | undefined;
}
export interface DeleteTrafficMirrorSessionRequest {
  TrafficMirrorSessionId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTrafficMirrorSessionResult {
  TrafficMirrorSessionId?: string | undefined;
}
export interface DeleteTrafficMirrorTargetRequest {
  TrafficMirrorTargetId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTrafficMirrorTargetResult {
  TrafficMirrorTargetId?: string | undefined;
}
export interface DeleteTransitGatewayRequest {
  TransitGatewayId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayResult {
  TransitGateway?: TransitGateway | undefined;
}
export interface DeleteTransitGatewayConnectRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayConnectResult {
  TransitGatewayConnect?: TransitGatewayConnect | undefined;
}
export interface DeleteTransitGatewayConnectPeerRequest {
  TransitGatewayConnectPeerId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayConnectPeerResult {
  TransitGatewayConnectPeer?: TransitGatewayConnectPeer | undefined;
}
export interface DeleteTransitGatewayMulticastDomainRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayMulticastDomainResult {
  TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain | undefined;
}
export interface DeleteTransitGatewayPeeringAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayPeeringAttachmentResult {
  TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment | undefined;
}
export interface DeleteTransitGatewayPolicyTableRequest {
  TransitGatewayPolicyTableId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayPolicyTableResult {
  TransitGatewayPolicyTable?: TransitGatewayPolicyTable | undefined;
}
export interface DeleteTransitGatewayPrefixListReferenceRequest {
  TransitGatewayRouteTableId: string | undefined;
  PrefixListId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayPrefixListReferenceResult {
  TransitGatewayPrefixListReference?:
    | TransitGatewayPrefixListReference
    | undefined;
}
export interface DeleteTransitGatewayRouteRequest {
  TransitGatewayRouteTableId: string | undefined;
  DestinationCidrBlock: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayRouteResult {
  Route?: TransitGatewayRoute | undefined;
}
export interface DeleteTransitGatewayRouteTableRequest {
  TransitGatewayRouteTableId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayRouteTableResult {
  TransitGatewayRouteTable?: TransitGatewayRouteTable | undefined;
}
export interface DeleteTransitGatewayRouteTableAnnouncementRequest {
  TransitGatewayRouteTableAnnouncementId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayRouteTableAnnouncementResult {
  TransitGatewayRouteTableAnnouncement?:
    | TransitGatewayRouteTableAnnouncement
    | undefined;
}
export interface DeleteTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment | undefined;
}
export interface DeleteVerifiedAccessEndpointRequest {
  VerifiedAccessEndpointId: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteVerifiedAccessEndpointResult {
  VerifiedAccessEndpoint?: VerifiedAccessEndpoint | undefined;
}
export interface DeleteVerifiedAccessGroupRequest {
  VerifiedAccessGroupId: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteVerifiedAccessGroupResult {
  VerifiedAccessGroup?: VerifiedAccessGroup | undefined;
}
export interface DeleteVerifiedAccessInstanceRequest {
  VerifiedAccessInstanceId: string | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
}
export interface DeleteVerifiedAccessInstanceResult {
  VerifiedAccessInstance?: VerifiedAccessInstance | undefined;
}
export interface DeleteVerifiedAccessTrustProviderRequest {
  VerifiedAccessTrustProviderId: string | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
}
export interface DeleteVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider | undefined;
}
export interface DeleteVolumeRequest {
  VolumeId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteVpcRequest {
  VpcId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteVpcBlockPublicAccessExclusionRequest {
  DryRun?: boolean | undefined;
  ExclusionId: string | undefined;
}
export interface DeleteVpcBlockPublicAccessExclusionResult {
  VpcBlockPublicAccessExclusion?: VpcBlockPublicAccessExclusion | undefined;
}
export interface DeleteVpcEndpointConnectionNotificationsRequest {
  DryRun?: boolean | undefined;
  ConnectionNotificationIds: string[] | undefined;
}
export interface DeleteVpcEndpointConnectionNotificationsResult {
  Unsuccessful?: UnsuccessfulItem[] | undefined;
}
export interface DeleteVpcEndpointsRequest {
  DryRun?: boolean | undefined;
  VpcEndpointIds: string[] | undefined;
}
export interface DeleteVpcEndpointsResult {
  Unsuccessful?: UnsuccessfulItem[] | undefined;
}
export interface DeleteVpcEndpointServiceConfigurationsRequest {
  DryRun?: boolean | undefined;
  ServiceIds: string[] | undefined;
}
export interface DeleteVpcEndpointServiceConfigurationsResult {
  Unsuccessful?: UnsuccessfulItem[] | undefined;
}
export interface DeleteVpcPeeringConnectionRequest {
  DryRun?: boolean | undefined;
  VpcPeeringConnectionId: string | undefined;
}
export interface DeleteVpcPeeringConnectionResult {
  Return?: boolean | undefined;
}
export interface DeleteVpnConnectionRequest {
  VpnConnectionId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeleteVpnConnectionRouteRequest {
  DestinationCidrBlock: string | undefined;
  VpnConnectionId: string | undefined;
}
export interface DeleteVpnGatewayRequest {
  VpnGatewayId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeprovisionByoipCidrRequest {
  Cidr: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DeprovisionByoipCidrResult {
  ByoipCidr?: ByoipCidr | undefined;
}
export interface DeprovisionIpamByoasnRequest {
  DryRun?: boolean | undefined;
  IpamId: string | undefined;
  Asn: string | undefined;
}
export declare const AsnState: {
  readonly deprovisioned: "deprovisioned";
  readonly failed_deprovision: "failed-deprovision";
  readonly failed_provision: "failed-provision";
  readonly pending_deprovision: "pending-deprovision";
  readonly pending_provision: "pending-provision";
  readonly provisioned: "provisioned";
};
export type AsnState = (typeof AsnState)[keyof typeof AsnState];
export interface Byoasn {
  Asn?: string | undefined;
  IpamId?: string | undefined;
  StatusMessage?: string | undefined;
  State?: AsnState | undefined;
}
export interface DeprovisionIpamByoasnResult {
  Byoasn?: Byoasn | undefined;
}
export interface DeprovisionIpamPoolCidrRequest {
  DryRun?: boolean | undefined;
  IpamPoolId: string | undefined;
  Cidr?: string | undefined;
}
export declare const IpamPoolCidrFailureCode: {
  readonly cidr_not_available: "cidr-not-available";
  readonly limit_exceeded: "limit-exceeded";
};
export type IpamPoolCidrFailureCode =
  (typeof IpamPoolCidrFailureCode)[keyof typeof IpamPoolCidrFailureCode];
export interface IpamPoolCidrFailureReason {
  Code?: IpamPoolCidrFailureCode | undefined;
  Message?: string | undefined;
}
export declare const IpamPoolCidrState: {
  readonly deprovisioned: "deprovisioned";
  readonly failed_deprovision: "failed-deprovision";
  readonly failed_import: "failed-import";
  readonly failed_provision: "failed-provision";
  readonly pending_deprovision: "pending-deprovision";
  readonly pending_import: "pending-import";
  readonly pending_provision: "pending-provision";
  readonly provisioned: "provisioned";
};
export type IpamPoolCidrState =
  (typeof IpamPoolCidrState)[keyof typeof IpamPoolCidrState];
export interface IpamPoolCidr {
  Cidr?: string | undefined;
  State?: IpamPoolCidrState | undefined;
  FailureReason?: IpamPoolCidrFailureReason | undefined;
  IpamPoolCidrId?: string | undefined;
  NetmaskLength?: number | undefined;
}
export interface DeprovisionIpamPoolCidrResult {
  IpamPoolCidr?: IpamPoolCidr | undefined;
}
export interface DeprovisionPublicIpv4PoolCidrRequest {
  DryRun?: boolean | undefined;
  PoolId: string | undefined;
  Cidr: string | undefined;
}
export interface DeprovisionPublicIpv4PoolCidrResult {
  PoolId?: string | undefined;
  DeprovisionedAddresses?: string[] | undefined;
}
export interface DeregisterImageRequest {
  ImageId: string | undefined;
  DeleteAssociatedSnapshots?: boolean | undefined;
  DryRun?: boolean | undefined;
}
export declare const SnapshotReturnCodes: {
  readonly ERROR_CODE_CLIENT_ERROR: "client-error";
  readonly ERROR_CODE_INTERNAL_ERROR: "internal-error";
  readonly ERROR_MISSING_PERMISSIONS: "missing-permissions";
  readonly SUCCESS: "success";
  readonly WARN_SKIPPED: "skipped";
};
export type SnapshotReturnCodes =
  (typeof SnapshotReturnCodes)[keyof typeof SnapshotReturnCodes];
export interface DeleteSnapshotReturnCode {
  SnapshotId?: string | undefined;
  ReturnCode?: SnapshotReturnCodes | undefined;
}
export interface DeregisterImageResult {
  Return?: boolean | undefined;
  DeleteSnapshotResults?: DeleteSnapshotReturnCode[] | undefined;
}
export interface DeregisterInstanceTagAttributeRequest {
  IncludeAllTagsOfInstance?: boolean | undefined;
  InstanceTagKeys?: string[] | undefined;
}
export interface DeregisterInstanceEventNotificationAttributesRequest {
  DryRun?: boolean | undefined;
  InstanceTagAttribute: DeregisterInstanceTagAttributeRequest | undefined;
}
export interface InstanceTagNotificationAttribute {
  InstanceTagKeys?: string[] | undefined;
  IncludeAllTagsOfInstance?: boolean | undefined;
}
export interface DeregisterInstanceEventNotificationAttributesResult {
  InstanceTagAttribute?: InstanceTagNotificationAttribute | undefined;
}
export interface DeregisterTransitGatewayMulticastGroupMembersRequest {
  TransitGatewayMulticastDomainId?: string | undefined;
  GroupIpAddress?: string | undefined;
  NetworkInterfaceIds?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayMulticastDeregisteredGroupMembers {
  TransitGatewayMulticastDomainId?: string | undefined;
  DeregisteredNetworkInterfaceIds?: string[] | undefined;
  GroupIpAddress?: string | undefined;
}
export interface DeregisterTransitGatewayMulticastGroupMembersResult {
  DeregisteredMulticastGroupMembers?:
    | TransitGatewayMulticastDeregisteredGroupMembers
    | undefined;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesRequest {
  TransitGatewayMulticastDomainId?: string | undefined;
  GroupIpAddress?: string | undefined;
  NetworkInterfaceIds?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayMulticastDeregisteredGroupSources {
  TransitGatewayMulticastDomainId?: string | undefined;
  DeregisteredNetworkInterfaceIds?: string[] | undefined;
  GroupIpAddress?: string | undefined;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesResult {
  DeregisteredMulticastGroupSources?:
    | TransitGatewayMulticastDeregisteredGroupSources
    | undefined;
}
export interface DescribeAccountAttributesRequest {
  DryRun?: boolean | undefined;
  AttributeNames?: AccountAttributeName[] | undefined;
}
export interface DescribeAccountAttributesResult {
  AccountAttributes?: AccountAttribute[] | undefined;
}
export interface Filter {
  Name?: string | undefined;
  Values?: string[] | undefined;
}
export interface DescribeAddressesRequest {
  PublicIps?: string[] | undefined;
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
  AllocationIds?: string[] | undefined;
}
export interface DescribeAddressesResult {
  Addresses?: Address[] | undefined;
}
export interface DescribeAddressesAttributeRequest {
  AllocationIds?: string[] | undefined;
  Attribute?: AddressAttributeName | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeAddressesAttributeResult {
  Addresses?: AddressAttribute[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeAddressTransfersRequest {
  AllocationIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeAddressTransfersResult {
  AddressTransfers?: AddressTransfer[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeAggregateIdFormatRequest {
  DryRun?: boolean | undefined;
}
export interface IdFormat {
  Deadline?: Date | undefined;
  Resource?: string | undefined;
  UseLongIds?: boolean | undefined;
}
export interface DescribeAggregateIdFormatResult {
  UseLongIdsAggregated?: boolean | undefined;
  Statuses?: IdFormat[] | undefined;
}
export interface DescribeAvailabilityZonesRequest {
  ZoneNames?: string[] | undefined;
  ZoneIds?: string[] | undefined;
  AllAvailabilityZones?: boolean | undefined;
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
}
export interface AvailabilityZoneMessage {
  Message?: string | undefined;
}
export declare const AvailabilityZoneOptInStatus: {
  readonly not_opted_in: "not-opted-in";
  readonly opt_in_not_required: "opt-in-not-required";
  readonly opted_in: "opted-in";
};
export type AvailabilityZoneOptInStatus =
  (typeof AvailabilityZoneOptInStatus)[keyof typeof AvailabilityZoneOptInStatus];
export declare const AvailabilityZoneState: {
  readonly available: "available";
  readonly constrained: "constrained";
  readonly impaired: "impaired";
  readonly information: "information";
  readonly unavailable: "unavailable";
};
export type AvailabilityZoneState =
  (typeof AvailabilityZoneState)[keyof typeof AvailabilityZoneState];
export interface AvailabilityZone {
  OptInStatus?: AvailabilityZoneOptInStatus | undefined;
  Messages?: AvailabilityZoneMessage[] | undefined;
  RegionName?: string | undefined;
  ZoneName?: string | undefined;
  ZoneId?: string | undefined;
  GroupName?: string | undefined;
  NetworkBorderGroup?: string | undefined;
  ZoneType?: string | undefined;
  ParentZoneName?: string | undefined;
  ParentZoneId?: string | undefined;
  GroupLongName?: string | undefined;
  State?: AvailabilityZoneState | undefined;
}
export interface DescribeAvailabilityZonesResult {
  AvailabilityZones?: AvailabilityZone[] | undefined;
}
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsRequest {
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const MetricType: {
  readonly aggregate_latency: "aggregate-latency";
};
export type MetricType = (typeof MetricType)[keyof typeof MetricType];
export declare const PeriodType: {
  readonly fifteen_minutes: "fifteen-minutes";
  readonly five_minutes: "five-minutes";
  readonly one_day: "one-day";
  readonly one_hour: "one-hour";
  readonly one_week: "one-week";
  readonly three_hours: "three-hours";
};
export type PeriodType = (typeof PeriodType)[keyof typeof PeriodType];
export declare const StatisticType: {
  readonly p50: "p50";
};
export type StatisticType = (typeof StatisticType)[keyof typeof StatisticType];
export interface Subscription {
  Source?: string | undefined;
  Destination?: string | undefined;
  Metric?: MetricType | undefined;
  Statistic?: StatisticType | undefined;
  Period?: PeriodType | undefined;
}
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsResult {
  NextToken?: string | undefined;
  Subscriptions?: Subscription[] | undefined;
}
export interface DescribeBundleTasksRequest {
  BundleIds?: string[] | undefined;
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
}
export interface DescribeBundleTasksResult {
  BundleTasks?: BundleTask[] | undefined;
}
export interface DescribeByoipCidrsRequest {
  DryRun?: boolean | undefined;
  MaxResults: number | undefined;
  NextToken?: string | undefined;
}
export interface DescribeByoipCidrsResult {
  ByoipCidrs?: ByoipCidr[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeCapacityBlockExtensionHistoryRequest {
  CapacityReservationIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const CapacityBlockExtensionStatus: {
  readonly PAYMENT_FAILED: "payment-failed";
  readonly PAYMENT_PENDING: "payment-pending";
  readonly PAYMENT_SUCCEEDED: "payment-succeeded";
};
export type CapacityBlockExtensionStatus =
  (typeof CapacityBlockExtensionStatus)[keyof typeof CapacityBlockExtensionStatus];
export interface CapacityBlockExtension {
  CapacityReservationId?: string | undefined;
  InstanceType?: string | undefined;
  InstanceCount?: number | undefined;
  AvailabilityZone?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  CapacityBlockExtensionOfferingId?: string | undefined;
  CapacityBlockExtensionDurationHours?: number | undefined;
  CapacityBlockExtensionStatus?: CapacityBlockExtensionStatus | undefined;
  CapacityBlockExtensionPurchaseDate?: Date | undefined;
  CapacityBlockExtensionStartDate?: Date | undefined;
  CapacityBlockExtensionEndDate?: Date | undefined;
  UpfrontFee?: string | undefined;
  CurrencyCode?: string | undefined;
}
export interface DescribeCapacityBlockExtensionHistoryResult {
  CapacityBlockExtensions?: CapacityBlockExtension[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeCapacityBlockExtensionOfferingsRequest {
  DryRun?: boolean | undefined;
  CapacityBlockExtensionDurationHours: number | undefined;
  CapacityReservationId: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface CapacityBlockExtensionOffering {
  CapacityBlockExtensionOfferingId?: string | undefined;
  InstanceType?: string | undefined;
  InstanceCount?: number | undefined;
  AvailabilityZone?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  StartDate?: Date | undefined;
  CapacityBlockExtensionStartDate?: Date | undefined;
  CapacityBlockExtensionEndDate?: Date | undefined;
  CapacityBlockExtensionDurationHours?: number | undefined;
  UpfrontFee?: string | undefined;
  CurrencyCode?: string | undefined;
  Tenancy?: CapacityReservationTenancy | undefined;
}
export interface DescribeCapacityBlockExtensionOfferingsResult {
  CapacityBlockExtensionOfferings?:
    | CapacityBlockExtensionOffering[]
    | undefined;
  NextToken?: string | undefined;
}
export interface DescribeCapacityBlockOfferingsRequest {
  DryRun?: boolean | undefined;
  InstanceType?: string | undefined;
  InstanceCount?: number | undefined;
  StartDateRange?: Date | undefined;
  EndDateRange?: Date | undefined;
  CapacityDurationHours: number | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface CapacityBlockOffering {
  CapacityBlockOfferingId?: string | undefined;
  InstanceType?: string | undefined;
  AvailabilityZone?: string | undefined;
  InstanceCount?: number | undefined;
  StartDate?: Date | undefined;
  EndDate?: Date | undefined;
  CapacityBlockDurationHours?: number | undefined;
  UpfrontFee?: string | undefined;
  CurrencyCode?: string | undefined;
  Tenancy?: CapacityReservationTenancy | undefined;
  CapacityBlockDurationMinutes?: number | undefined;
}
export interface DescribeCapacityBlockOfferingsResult {
  CapacityBlockOfferings?: CapacityBlockOffering[] | undefined;
  NextToken?: string | undefined;
}
export declare const CallerRole: {
  readonly odcr_owner: "odcr-owner";
  readonly unused_reservation_billing_owner: "unused-reservation-billing-owner";
};
export type CallerRole = (typeof CallerRole)[keyof typeof CallerRole];
export interface DescribeCapacityReservationBillingRequestsRequest {
  CapacityReservationIds?: string[] | undefined;
  Role: CallerRole | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export interface CapacityReservationInfo {
  InstanceType?: string | undefined;
  AvailabilityZone?: string | undefined;
  Tenancy?: CapacityReservationTenancy | undefined;
  AvailabilityZoneId?: string | undefined;
}
export declare const CapacityReservationBillingRequestStatus: {
  readonly accepted: "accepted";
  readonly cancelled: "cancelled";
  readonly expired: "expired";
  readonly pending: "pending";
  readonly rejected: "rejected";
  readonly revoked: "revoked";
};
export type CapacityReservationBillingRequestStatus =
  (typeof CapacityReservationBillingRequestStatus)[keyof typeof CapacityReservationBillingRequestStatus];
export interface CapacityReservationBillingRequest {
  CapacityReservationId?: string | undefined;
  RequestedBy?: string | undefined;
  UnusedReservationBillingOwnerId?: string | undefined;
  LastUpdateTime?: Date | undefined;
  Status?: CapacityReservationBillingRequestStatus | undefined;
  StatusMessage?: string | undefined;
  CapacityReservationInfo?: CapacityReservationInfo | undefined;
}
export interface DescribeCapacityReservationBillingRequestsResult {
  NextToken?: string | undefined;
  CapacityReservationBillingRequests?:
    | CapacityReservationBillingRequest[]
    | undefined;
}
export interface DescribeCapacityReservationFleetsRequest {
  CapacityReservationFleetIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export interface CapacityReservationFleet {
  CapacityReservationFleetId?: string | undefined;
  CapacityReservationFleetArn?: string | undefined;
  State?: CapacityReservationFleetState | undefined;
  TotalTargetCapacity?: number | undefined;
  TotalFulfilledCapacity?: number | undefined;
  Tenancy?: FleetCapacityReservationTenancy | undefined;
  EndDate?: Date | undefined;
  CreateTime?: Date | undefined;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria | undefined;
  AllocationStrategy?: string | undefined;
  InstanceTypeSpecifications?: FleetCapacityReservation[] | undefined;
  Tags?: Tag[] | undefined;
}
export interface DescribeCapacityReservationFleetsResult {
  CapacityReservationFleets?: CapacityReservationFleet[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeCapacityReservationsRequest {
  CapacityReservationIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeCapacityReservationsResult {
  NextToken?: string | undefined;
  CapacityReservations?: CapacityReservation[] | undefined;
}
export interface DescribeCarrierGatewaysRequest {
  CarrierGatewayIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface DescribeCarrierGatewaysResult {
  CarrierGateways?: CarrierGateway[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeClassicLinkInstancesRequest {
  DryRun?: boolean | undefined;
  InstanceIds?: string[] | undefined;
  Filters?: Filter[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ClassicLinkInstance {
  Groups?: GroupIdentifier[] | undefined;
  InstanceId?: string | undefined;
  Tags?: Tag[] | undefined;
  VpcId?: string | undefined;
}
export interface DescribeClassicLinkInstancesResult {
  Instances?: ClassicLinkInstance[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeClientVpnAuthorizationRulesRequest {
  ClientVpnEndpointId: string | undefined;
  DryRun?: boolean | undefined;
  NextToken?: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
}
export interface AuthorizationRule {
  ClientVpnEndpointId?: string | undefined;
  Description?: string | undefined;
  GroupId?: string | undefined;
  AccessAll?: boolean | undefined;
  DestinationCidr?: string | undefined;
  Status?: ClientVpnAuthorizationRuleStatus | undefined;
}
export interface DescribeClientVpnAuthorizationRulesResult {
  AuthorizationRules?: AuthorizationRule[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeClientVpnConnectionsRequest {
  ClientVpnEndpointId: string | undefined;
  Filters?: Filter[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
}
export declare const ClientVpnConnectionStatusCode: {
  readonly active: "active";
  readonly failed_to_terminate: "failed-to-terminate";
  readonly terminated: "terminated";
  readonly terminating: "terminating";
};
export type ClientVpnConnectionStatusCode =
  (typeof ClientVpnConnectionStatusCode)[keyof typeof ClientVpnConnectionStatusCode];
export declare const VpnTunnelOptionsSpecificationFilterSensitiveLog: (
  obj: VpnTunnelOptionsSpecification
) => any;
export declare const VpnConnectionOptionsSpecificationFilterSensitiveLog: (
  obj: VpnConnectionOptionsSpecification
) => any;
export declare const CreateVpnConnectionRequestFilterSensitiveLog: (
  obj: CreateVpnConnectionRequest
) => any;
export declare const TunnelOptionFilterSensitiveLog: (obj: TunnelOption) => any;
export declare const VpnConnectionOptionsFilterSensitiveLog: (
  obj: VpnConnectionOptions
) => any;
export declare const VpnConnectionFilterSensitiveLog: (
  obj: VpnConnection
) => any;
export declare const CreateVpnConnectionResultFilterSensitiveLog: (
  obj: CreateVpnConnectionResult
) => any;
export declare const DeleteVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: DeleteVerifiedAccessTrustProviderResult
) => any;
export declare const DescribeBundleTasksResultFilterSensitiveLog: (
  obj: DescribeBundleTasksResult
) => any;
