import {
  AcceleratorCount,
  AcceleratorCountRequest,
  AcceleratorManufacturer,
  AcceleratorName,
  AcceleratorTotalMemoryMiB,
  AcceleratorTotalMemoryMiBRequest,
  AcceleratorType,
  AddIpamOperatingRegion,
  AddressFamily,
  AllocationType,
  AttachmentStatus,
  CapacityReservationFleetState,
  InstanceEventWindow,
  ResourceType,
  SubnetIpv6CidrBlockAssociation,
  Tag,
  TagSpecification,
  UnsuccessfulItem,
  VpcCidrBlockAssociation,
  VpcIpv6CidrBlockAssociation,
  WeekDay,
} from "./models_0";
export interface CopyFpgaImageRequest {
  DryRun?: boolean | undefined;
  SourceFpgaImageId: string | undefined;
  Description?: string | undefined;
  Name?: string | undefined;
  SourceRegion: string | undefined;
  ClientToken?: string | undefined;
}
export interface CopyFpgaImageResult {
  FpgaImageId?: string | undefined;
}
export interface CopyImageRequest {
  ClientToken?: string | undefined;
  Description?: string | undefined;
  Encrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  Name: string | undefined;
  SourceImageId: string | undefined;
  SourceRegion: string | undefined;
  DestinationOutpostArn?: string | undefined;
  CopyImageTags?: boolean | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  SnapshotCopyCompletionDurationMinutes?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface CopyImageResult {
  ImageId?: string | undefined;
}
export interface CopySnapshotRequest {
  Description?: string | undefined;
  DestinationOutpostArn?: string | undefined;
  DestinationRegion?: string | undefined;
  Encrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  PresignedUrl?: string | undefined;
  SourceRegion: string | undefined;
  SourceSnapshotId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  CompletionDurationMinutes?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface CopySnapshotResult {
  Tags?: Tag[] | undefined;
  SnapshotId?: string | undefined;
}
export declare const CapacityReservationDeliveryPreference: {
  readonly FIXED: "fixed";
  readonly INCREMENTAL: "incremental";
};
export type CapacityReservationDeliveryPreference =
  (typeof CapacityReservationDeliveryPreference)[keyof typeof CapacityReservationDeliveryPreference];
export declare const EndDateType: {
  readonly limited: "limited";
  readonly unlimited: "unlimited";
};
export type EndDateType = (typeof EndDateType)[keyof typeof EndDateType];
export declare const InstanceMatchCriteria: {
  readonly open: "open";
  readonly targeted: "targeted";
};
export type InstanceMatchCriteria =
  (typeof InstanceMatchCriteria)[keyof typeof InstanceMatchCriteria];
export declare const CapacityReservationInstancePlatform: {
  readonly LINUX_UNIX: "Linux/UNIX";
  readonly LINUX_WITH_SQL_SERVER_ENTERPRISE: "Linux with SQL Server Enterprise";
  readonly LINUX_WITH_SQL_SERVER_STANDARD: "Linux with SQL Server Standard";
  readonly LINUX_WITH_SQL_SERVER_WEB: "Linux with SQL Server Web";
  readonly RED_HAT_ENTERPRISE_LINUX: "Red Hat Enterprise Linux";
  readonly RHEL_WITH_HA: "RHEL with HA";
  readonly RHEL_WITH_HA_AND_SQL_SERVER_ENTERPRISE: "RHEL with HA and SQL Server Enterprise";
  readonly RHEL_WITH_HA_AND_SQL_SERVER_STANDARD: "RHEL with HA and SQL Server Standard";
  readonly RHEL_WITH_SQL_SERVER_ENTERPRISE: "RHEL with SQL Server Enterprise";
  readonly RHEL_WITH_SQL_SERVER_STANDARD: "RHEL with SQL Server Standard";
  readonly RHEL_WITH_SQL_SERVER_WEB: "RHEL with SQL Server Web";
  readonly SUSE_LINUX: "SUSE Linux";
  readonly UBUNTU_PRO_LINUX: "Ubuntu Pro";
  readonly WINDOWS: "Windows";
  readonly WINDOWS_WITH_SQL_SERVER: "Windows with SQL Server";
  readonly WINDOWS_WITH_SQL_SERVER_ENTERPRISE: "Windows with SQL Server Enterprise";
  readonly WINDOWS_WITH_SQL_SERVER_STANDARD: "Windows with SQL Server Standard";
  readonly WINDOWS_WITH_SQL_SERVER_WEB: "Windows with SQL Server Web";
};
export type CapacityReservationInstancePlatform =
  (typeof CapacityReservationInstancePlatform)[keyof typeof CapacityReservationInstancePlatform];
export declare const CapacityReservationTenancy: {
  readonly dedicated: "dedicated";
  readonly default: "default";
};
export type CapacityReservationTenancy =
  (typeof CapacityReservationTenancy)[keyof typeof CapacityReservationTenancy];
export interface CreateCapacityReservationRequest {
  ClientToken?: string | undefined;
  InstanceType: string | undefined;
  InstancePlatform: CapacityReservationInstancePlatform | undefined;
  AvailabilityZone?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  Tenancy?: CapacityReservationTenancy | undefined;
  InstanceCount: number | undefined;
  EbsOptimized?: boolean | undefined;
  EphemeralStorage?: boolean | undefined;
  EndDate?: Date | undefined;
  EndDateType?: EndDateType | undefined;
  InstanceMatchCriteria?: InstanceMatchCriteria | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  OutpostArn?: string | undefined;
  PlacementGroupArn?: string | undefined;
  StartDate?: Date | undefined;
  CommitmentDuration?: number | undefined;
  DeliveryPreference?: CapacityReservationDeliveryPreference | undefined;
}
export interface CapacityAllocation {
  AllocationType?: AllocationType | undefined;
  Count?: number | undefined;
}
export interface CapacityReservationCommitmentInfo {
  CommittedInstanceCount?: number | undefined;
  CommitmentEndDate?: Date | undefined;
}
export declare const CapacityReservationType: {
  readonly CAPACITY_BLOCK: "capacity-block";
  readonly DEFAULT: "default";
};
export type CapacityReservationType =
  (typeof CapacityReservationType)[keyof typeof CapacityReservationType];
export declare const CapacityReservationState: {
  readonly active: "active";
  readonly assessing: "assessing";
  readonly cancelled: "cancelled";
  readonly delayed: "delayed";
  readonly expired: "expired";
  readonly failed: "failed";
  readonly payment_failed: "payment-failed";
  readonly payment_pending: "payment-pending";
  readonly pending: "pending";
  readonly scheduled: "scheduled";
  readonly unsupported: "unsupported";
};
export type CapacityReservationState =
  (typeof CapacityReservationState)[keyof typeof CapacityReservationState];
export interface CapacityReservation {
  CapacityReservationId?: string | undefined;
  OwnerId?: string | undefined;
  CapacityReservationArn?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  InstanceType?: string | undefined;
  InstancePlatform?: CapacityReservationInstancePlatform | undefined;
  AvailabilityZone?: string | undefined;
  Tenancy?: CapacityReservationTenancy | undefined;
  TotalInstanceCount?: number | undefined;
  AvailableInstanceCount?: number | undefined;
  EbsOptimized?: boolean | undefined;
  EphemeralStorage?: boolean | undefined;
  State?: CapacityReservationState | undefined;
  StartDate?: Date | undefined;
  EndDate?: Date | undefined;
  EndDateType?: EndDateType | undefined;
  InstanceMatchCriteria?: InstanceMatchCriteria | undefined;
  CreateDate?: Date | undefined;
  Tags?: Tag[] | undefined;
  OutpostArn?: string | undefined;
  CapacityReservationFleetId?: string | undefined;
  PlacementGroupArn?: string | undefined;
  CapacityAllocations?: CapacityAllocation[] | undefined;
  ReservationType?: CapacityReservationType | undefined;
  UnusedReservationBillingOwnerId?: string | undefined;
  CommitmentInfo?: CapacityReservationCommitmentInfo | undefined;
  DeliveryPreference?: CapacityReservationDeliveryPreference | undefined;
}
export interface CreateCapacityReservationResult {
  CapacityReservation?: CapacityReservation | undefined;
}
export interface CreateCapacityReservationBySplittingRequest {
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  SourceCapacityReservationId: string | undefined;
  InstanceCount: number | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface CreateCapacityReservationBySplittingResult {
  SourceCapacityReservation?: CapacityReservation | undefined;
  DestinationCapacityReservation?: CapacityReservation | undefined;
  InstanceCount?: number | undefined;
}
export declare const FleetInstanceMatchCriteria: {
  readonly open: "open";
};
export type FleetInstanceMatchCriteria =
  (typeof FleetInstanceMatchCriteria)[keyof typeof FleetInstanceMatchCriteria];
export declare const _InstanceType: {
  readonly a1_2xlarge: "a1.2xlarge";
  readonly a1_4xlarge: "a1.4xlarge";
  readonly a1_large: "a1.large";
  readonly a1_medium: "a1.medium";
  readonly a1_metal: "a1.metal";
  readonly a1_xlarge: "a1.xlarge";
  readonly c1_medium: "c1.medium";
  readonly c1_xlarge: "c1.xlarge";
  readonly c3_2xlarge: "c3.2xlarge";
  readonly c3_4xlarge: "c3.4xlarge";
  readonly c3_8xlarge: "c3.8xlarge";
  readonly c3_large: "c3.large";
  readonly c3_xlarge: "c3.xlarge";
  readonly c4_2xlarge: "c4.2xlarge";
  readonly c4_4xlarge: "c4.4xlarge";
  readonly c4_8xlarge: "c4.8xlarge";
  readonly c4_large: "c4.large";
  readonly c4_xlarge: "c4.xlarge";
  readonly c5_12xlarge: "c5.12xlarge";
  readonly c5_18xlarge: "c5.18xlarge";
  readonly c5_24xlarge: "c5.24xlarge";
  readonly c5_2xlarge: "c5.2xlarge";
  readonly c5_4xlarge: "c5.4xlarge";
  readonly c5_9xlarge: "c5.9xlarge";
  readonly c5_large: "c5.large";
  readonly c5_metal: "c5.metal";
  readonly c5_xlarge: "c5.xlarge";
  readonly c5a_12xlarge: "c5a.12xlarge";
  readonly c5a_16xlarge: "c5a.16xlarge";
  readonly c5a_24xlarge: "c5a.24xlarge";
  readonly c5a_2xlarge: "c5a.2xlarge";
  readonly c5a_4xlarge: "c5a.4xlarge";
  readonly c5a_8xlarge: "c5a.8xlarge";
  readonly c5a_large: "c5a.large";
  readonly c5a_xlarge: "c5a.xlarge";
  readonly c5ad_12xlarge: "c5ad.12xlarge";
  readonly c5ad_16xlarge: "c5ad.16xlarge";
  readonly c5ad_24xlarge: "c5ad.24xlarge";
  readonly c5ad_2xlarge: "c5ad.2xlarge";
  readonly c5ad_4xlarge: "c5ad.4xlarge";
  readonly c5ad_8xlarge: "c5ad.8xlarge";
  readonly c5ad_large: "c5ad.large";
  readonly c5ad_xlarge: "c5ad.xlarge";
  readonly c5d_12xlarge: "c5d.12xlarge";
  readonly c5d_18xlarge: "c5d.18xlarge";
  readonly c5d_24xlarge: "c5d.24xlarge";
  readonly c5d_2xlarge: "c5d.2xlarge";
  readonly c5d_4xlarge: "c5d.4xlarge";
  readonly c5d_9xlarge: "c5d.9xlarge";
  readonly c5d_large: "c5d.large";
  readonly c5d_metal: "c5d.metal";
  readonly c5d_xlarge: "c5d.xlarge";
  readonly c5n_18xlarge: "c5n.18xlarge";
  readonly c5n_2xlarge: "c5n.2xlarge";
  readonly c5n_4xlarge: "c5n.4xlarge";
  readonly c5n_9xlarge: "c5n.9xlarge";
  readonly c5n_large: "c5n.large";
  readonly c5n_metal: "c5n.metal";
  readonly c5n_xlarge: "c5n.xlarge";
  readonly c6a_12xlarge: "c6a.12xlarge";
  readonly c6a_16xlarge: "c6a.16xlarge";
  readonly c6a_24xlarge: "c6a.24xlarge";
  readonly c6a_2xlarge: "c6a.2xlarge";
  readonly c6a_32xlarge: "c6a.32xlarge";
  readonly c6a_48xlarge: "c6a.48xlarge";
  readonly c6a_4xlarge: "c6a.4xlarge";
  readonly c6a_8xlarge: "c6a.8xlarge";
  readonly c6a_large: "c6a.large";
  readonly c6a_metal: "c6a.metal";
  readonly c6a_xlarge: "c6a.xlarge";
  readonly c6g_12xlarge: "c6g.12xlarge";
  readonly c6g_16xlarge: "c6g.16xlarge";
  readonly c6g_2xlarge: "c6g.2xlarge";
  readonly c6g_4xlarge: "c6g.4xlarge";
  readonly c6g_8xlarge: "c6g.8xlarge";
  readonly c6g_large: "c6g.large";
  readonly c6g_medium: "c6g.medium";
  readonly c6g_metal: "c6g.metal";
  readonly c6g_xlarge: "c6g.xlarge";
  readonly c6gd_12xlarge: "c6gd.12xlarge";
  readonly c6gd_16xlarge: "c6gd.16xlarge";
  readonly c6gd_2xlarge: "c6gd.2xlarge";
  readonly c6gd_4xlarge: "c6gd.4xlarge";
  readonly c6gd_8xlarge: "c6gd.8xlarge";
  readonly c6gd_large: "c6gd.large";
  readonly c6gd_medium: "c6gd.medium";
  readonly c6gd_metal: "c6gd.metal";
  readonly c6gd_xlarge: "c6gd.xlarge";
  readonly c6gn_12xlarge: "c6gn.12xlarge";
  readonly c6gn_16xlarge: "c6gn.16xlarge";
  readonly c6gn_2xlarge: "c6gn.2xlarge";
  readonly c6gn_4xlarge: "c6gn.4xlarge";
  readonly c6gn_8xlarge: "c6gn.8xlarge";
  readonly c6gn_large: "c6gn.large";
  readonly c6gn_medium: "c6gn.medium";
  readonly c6gn_xlarge: "c6gn.xlarge";
  readonly c6i_12xlarge: "c6i.12xlarge";
  readonly c6i_16xlarge: "c6i.16xlarge";
  readonly c6i_24xlarge: "c6i.24xlarge";
  readonly c6i_2xlarge: "c6i.2xlarge";
  readonly c6i_32xlarge: "c6i.32xlarge";
  readonly c6i_4xlarge: "c6i.4xlarge";
  readonly c6i_8xlarge: "c6i.8xlarge";
  readonly c6i_large: "c6i.large";
  readonly c6i_metal: "c6i.metal";
  readonly c6i_xlarge: "c6i.xlarge";
  readonly c6id_12xlarge: "c6id.12xlarge";
  readonly c6id_16xlarge: "c6id.16xlarge";
  readonly c6id_24xlarge: "c6id.24xlarge";
  readonly c6id_2xlarge: "c6id.2xlarge";
  readonly c6id_32xlarge: "c6id.32xlarge";
  readonly c6id_4xlarge: "c6id.4xlarge";
  readonly c6id_8xlarge: "c6id.8xlarge";
  readonly c6id_large: "c6id.large";
  readonly c6id_metal: "c6id.metal";
  readonly c6id_xlarge: "c6id.xlarge";
  readonly c6in_12xlarge: "c6in.12xlarge";
  readonly c6in_16xlarge: "c6in.16xlarge";
  readonly c6in_24xlarge: "c6in.24xlarge";
  readonly c6in_2xlarge: "c6in.2xlarge";
  readonly c6in_32xlarge: "c6in.32xlarge";
  readonly c6in_4xlarge: "c6in.4xlarge";
  readonly c6in_8xlarge: "c6in.8xlarge";
  readonly c6in_large: "c6in.large";
  readonly c6in_metal: "c6in.metal";
  readonly c6in_xlarge: "c6in.xlarge";
  readonly c7a_12xlarge: "c7a.12xlarge";
  readonly c7a_16xlarge: "c7a.16xlarge";
  readonly c7a_24xlarge: "c7a.24xlarge";
  readonly c7a_2xlarge: "c7a.2xlarge";
  readonly c7a_32xlarge: "c7a.32xlarge";
  readonly c7a_48xlarge: "c7a.48xlarge";
  readonly c7a_4xlarge: "c7a.4xlarge";
  readonly c7a_8xlarge: "c7a.8xlarge";
  readonly c7a_large: "c7a.large";
  readonly c7a_medium: "c7a.medium";
  readonly c7a_metal_48xl: "c7a.metal-48xl";
  readonly c7a_xlarge: "c7a.xlarge";
  readonly c7g_12xlarge: "c7g.12xlarge";
  readonly c7g_16xlarge: "c7g.16xlarge";
  readonly c7g_2xlarge: "c7g.2xlarge";
  readonly c7g_4xlarge: "c7g.4xlarge";
  readonly c7g_8xlarge: "c7g.8xlarge";
  readonly c7g_large: "c7g.large";
  readonly c7g_medium: "c7g.medium";
  readonly c7g_metal: "c7g.metal";
  readonly c7g_xlarge: "c7g.xlarge";
  readonly c7gd_12xlarge: "c7gd.12xlarge";
  readonly c7gd_16xlarge: "c7gd.16xlarge";
  readonly c7gd_2xlarge: "c7gd.2xlarge";
  readonly c7gd_4xlarge: "c7gd.4xlarge";
  readonly c7gd_8xlarge: "c7gd.8xlarge";
  readonly c7gd_large: "c7gd.large";
  readonly c7gd_medium: "c7gd.medium";
  readonly c7gd_metal: "c7gd.metal";
  readonly c7gd_xlarge: "c7gd.xlarge";
  readonly c7gn_12xlarge: "c7gn.12xlarge";
  readonly c7gn_16xlarge: "c7gn.16xlarge";
  readonly c7gn_2xlarge: "c7gn.2xlarge";
  readonly c7gn_4xlarge: "c7gn.4xlarge";
  readonly c7gn_8xlarge: "c7gn.8xlarge";
  readonly c7gn_large: "c7gn.large";
  readonly c7gn_medium: "c7gn.medium";
  readonly c7gn_metal: "c7gn.metal";
  readonly c7gn_xlarge: "c7gn.xlarge";
  readonly c7i_12xlarge: "c7i.12xlarge";
  readonly c7i_16xlarge: "c7i.16xlarge";
  readonly c7i_24xlarge: "c7i.24xlarge";
  readonly c7i_2xlarge: "c7i.2xlarge";
  readonly c7i_48xlarge: "c7i.48xlarge";
  readonly c7i_4xlarge: "c7i.4xlarge";
  readonly c7i_8xlarge: "c7i.8xlarge";
  readonly c7i_flex_12xlarge: "c7i-flex.12xlarge";
  readonly c7i_flex_16xlarge: "c7i-flex.16xlarge";
  readonly c7i_flex_2xlarge: "c7i-flex.2xlarge";
  readonly c7i_flex_4xlarge: "c7i-flex.4xlarge";
  readonly c7i_flex_8xlarge: "c7i-flex.8xlarge";
  readonly c7i_flex_large: "c7i-flex.large";
  readonly c7i_flex_xlarge: "c7i-flex.xlarge";
  readonly c7i_large: "c7i.large";
  readonly c7i_metal_24xl: "c7i.metal-24xl";
  readonly c7i_metal_48xl: "c7i.metal-48xl";
  readonly c7i_xlarge: "c7i.xlarge";
  readonly c8g_12xlarge: "c8g.12xlarge";
  readonly c8g_16xlarge: "c8g.16xlarge";
  readonly c8g_24xlarge: "c8g.24xlarge";
  readonly c8g_2xlarge: "c8g.2xlarge";
  readonly c8g_48xlarge: "c8g.48xlarge";
  readonly c8g_4xlarge: "c8g.4xlarge";
  readonly c8g_8xlarge: "c8g.8xlarge";
  readonly c8g_large: "c8g.large";
  readonly c8g_medium: "c8g.medium";
  readonly c8g_metal_24xl: "c8g.metal-24xl";
  readonly c8g_metal_48xl: "c8g.metal-48xl";
  readonly c8g_xlarge: "c8g.xlarge";
  readonly c8gd_12xlarge: "c8gd.12xlarge";
  readonly c8gd_16xlarge: "c8gd.16xlarge";
  readonly c8gd_24xlarge: "c8gd.24xlarge";
  readonly c8gd_2xlarge: "c8gd.2xlarge";
  readonly c8gd_48xlarge: "c8gd.48xlarge";
  readonly c8gd_4xlarge: "c8gd.4xlarge";
  readonly c8gd_8xlarge: "c8gd.8xlarge";
  readonly c8gd_large: "c8gd.large";
  readonly c8gd_medium: "c8gd.medium";
  readonly c8gd_metal_24xl: "c8gd.metal-24xl";
  readonly c8gd_metal_48xl: "c8gd.metal-48xl";
  readonly c8gd_xlarge: "c8gd.xlarge";
  readonly cc1_4xlarge: "cc1.4xlarge";
  readonly cc2_8xlarge: "cc2.8xlarge";
  readonly cg1_4xlarge: "cg1.4xlarge";
  readonly cr1_8xlarge: "cr1.8xlarge";
  readonly d2_2xlarge: "d2.2xlarge";
  readonly d2_4xlarge: "d2.4xlarge";
  readonly d2_8xlarge: "d2.8xlarge";
  readonly d2_xlarge: "d2.xlarge";
  readonly d3_2xlarge: "d3.2xlarge";
  readonly d3_4xlarge: "d3.4xlarge";
  readonly d3_8xlarge: "d3.8xlarge";
  readonly d3_xlarge: "d3.xlarge";
  readonly d3en_12xlarge: "d3en.12xlarge";
  readonly d3en_2xlarge: "d3en.2xlarge";
  readonly d3en_4xlarge: "d3en.4xlarge";
  readonly d3en_6xlarge: "d3en.6xlarge";
  readonly d3en_8xlarge: "d3en.8xlarge";
  readonly d3en_xlarge: "d3en.xlarge";
  readonly dl1_24xlarge: "dl1.24xlarge";
  readonly dl2q_24xlarge: "dl2q.24xlarge";
  readonly f1_16xlarge: "f1.16xlarge";
  readonly f1_2xlarge: "f1.2xlarge";
  readonly f1_4xlarge: "f1.4xlarge";
  readonly f2_12xlarge: "f2.12xlarge";
  readonly f2_48xlarge: "f2.48xlarge";
  readonly g2_2xlarge: "g2.2xlarge";
  readonly g2_8xlarge: "g2.8xlarge";
  readonly g3_16xlarge: "g3.16xlarge";
  readonly g3_4xlarge: "g3.4xlarge";
  readonly g3_8xlarge: "g3.8xlarge";
  readonly g3s_xlarge: "g3s.xlarge";
  readonly g4ad_16xlarge: "g4ad.16xlarge";
  readonly g4ad_2xlarge: "g4ad.2xlarge";
  readonly g4ad_4xlarge: "g4ad.4xlarge";
  readonly g4ad_8xlarge: "g4ad.8xlarge";
  readonly g4ad_xlarge: "g4ad.xlarge";
  readonly g4dn_12xlarge: "g4dn.12xlarge";
  readonly g4dn_16xlarge: "g4dn.16xlarge";
  readonly g4dn_2xlarge: "g4dn.2xlarge";
  readonly g4dn_4xlarge: "g4dn.4xlarge";
  readonly g4dn_8xlarge: "g4dn.8xlarge";
  readonly g4dn_metal: "g4dn.metal";
  readonly g4dn_xlarge: "g4dn.xlarge";
  readonly g5_12xlarge: "g5.12xlarge";
  readonly g5_16xlarge: "g5.16xlarge";
  readonly g5_24xlarge: "g5.24xlarge";
  readonly g5_2xlarge: "g5.2xlarge";
  readonly g5_48xlarge: "g5.48xlarge";
  readonly g5_4xlarge: "g5.4xlarge";
  readonly g5_8xlarge: "g5.8xlarge";
  readonly g5_xlarge: "g5.xlarge";
  readonly g5g_16xlarge: "g5g.16xlarge";
  readonly g5g_2xlarge: "g5g.2xlarge";
  readonly g5g_4xlarge: "g5g.4xlarge";
  readonly g5g_8xlarge: "g5g.8xlarge";
  readonly g5g_metal: "g5g.metal";
  readonly g5g_xlarge: "g5g.xlarge";
  readonly g6_12xlarge: "g6.12xlarge";
  readonly g6_16xlarge: "g6.16xlarge";
  readonly g6_24xlarge: "g6.24xlarge";
  readonly g6_2xlarge: "g6.2xlarge";
  readonly g6_48xlarge: "g6.48xlarge";
  readonly g6_4xlarge: "g6.4xlarge";
  readonly g6_8xlarge: "g6.8xlarge";
  readonly g6_xlarge: "g6.xlarge";
  readonly g6e_12xlarge: "g6e.12xlarge";
  readonly g6e_16xlarge: "g6e.16xlarge";
  readonly g6e_24xlarge: "g6e.24xlarge";
  readonly g6e_2xlarge: "g6e.2xlarge";
  readonly g6e_48xlarge: "g6e.48xlarge";
  readonly g6e_4xlarge: "g6e.4xlarge";
  readonly g6e_8xlarge: "g6e.8xlarge";
  readonly g6e_xlarge: "g6e.xlarge";
  readonly gr6_4xlarge: "gr6.4xlarge";
  readonly gr6_8xlarge: "gr6.8xlarge";
  readonly h1_16xlarge: "h1.16xlarge";
  readonly h1_2xlarge: "h1.2xlarge";
  readonly h1_4xlarge: "h1.4xlarge";
  readonly h1_8xlarge: "h1.8xlarge";
  readonly hi1_4xlarge: "hi1.4xlarge";
  readonly hpc6a_48xlarge: "hpc6a.48xlarge";
  readonly hpc6id_32xlarge: "hpc6id.32xlarge";
  readonly hpc7a_12xlarge: "hpc7a.12xlarge";
  readonly hpc7a_24xlarge: "hpc7a.24xlarge";
  readonly hpc7a_48xlarge: "hpc7a.48xlarge";
  readonly hpc7a_96xlarge: "hpc7a.96xlarge";
  readonly hpc7g_16xlarge: "hpc7g.16xlarge";
  readonly hpc7g_4xlarge: "hpc7g.4xlarge";
  readonly hpc7g_8xlarge: "hpc7g.8xlarge";
  readonly hs1_8xlarge: "hs1.8xlarge";
  readonly i2_2xlarge: "i2.2xlarge";
  readonly i2_4xlarge: "i2.4xlarge";
  readonly i2_8xlarge: "i2.8xlarge";
  readonly i2_xlarge: "i2.xlarge";
  readonly i3_16xlarge: "i3.16xlarge";
  readonly i3_2xlarge: "i3.2xlarge";
  readonly i3_4xlarge: "i3.4xlarge";
  readonly i3_8xlarge: "i3.8xlarge";
  readonly i3_large: "i3.large";
  readonly i3_metal: "i3.metal";
  readonly i3_xlarge: "i3.xlarge";
  readonly i3en_12xlarge: "i3en.12xlarge";
  readonly i3en_24xlarge: "i3en.24xlarge";
  readonly i3en_2xlarge: "i3en.2xlarge";
  readonly i3en_3xlarge: "i3en.3xlarge";
  readonly i3en_6xlarge: "i3en.6xlarge";
  readonly i3en_large: "i3en.large";
  readonly i3en_metal: "i3en.metal";
  readonly i3en_xlarge: "i3en.xlarge";
  readonly i4g_16xlarge: "i4g.16xlarge";
  readonly i4g_2xlarge: "i4g.2xlarge";
  readonly i4g_4xlarge: "i4g.4xlarge";
  readonly i4g_8xlarge: "i4g.8xlarge";
  readonly i4g_large: "i4g.large";
  readonly i4g_xlarge: "i4g.xlarge";
  readonly i4i_12xlarge: "i4i.12xlarge";
  readonly i4i_16xlarge: "i4i.16xlarge";
  readonly i4i_24xlarge: "i4i.24xlarge";
  readonly i4i_2xlarge: "i4i.2xlarge";
  readonly i4i_32xlarge: "i4i.32xlarge";
  readonly i4i_4xlarge: "i4i.4xlarge";
  readonly i4i_8xlarge: "i4i.8xlarge";
  readonly i4i_large: "i4i.large";
  readonly i4i_metal: "i4i.metal";
  readonly i4i_xlarge: "i4i.xlarge";
  readonly i7i_12xlarge: "i7i.12xlarge";
  readonly i7i_16xlarge: "i7i.16xlarge";
  readonly i7i_24xlarge: "i7i.24xlarge";
  readonly i7i_2xlarge: "i7i.2xlarge";
  readonly i7i_48xlarge: "i7i.48xlarge";
  readonly i7i_4xlarge: "i7i.4xlarge";
  readonly i7i_8xlarge: "i7i.8xlarge";
  readonly i7i_large: "i7i.large";
  readonly i7i_metal_24xl: "i7i.metal-24xl";
  readonly i7i_metal_48xl: "i7i.metal-48xl";
  readonly i7i_xlarge: "i7i.xlarge";
  readonly i7ie_12xlarge: "i7ie.12xlarge";
  readonly i7ie_18xlarge: "i7ie.18xlarge";
  readonly i7ie_24xlarge: "i7ie.24xlarge";
  readonly i7ie_2xlarge: "i7ie.2xlarge";
  readonly i7ie_3xlarge: "i7ie.3xlarge";
  readonly i7ie_48xlarge: "i7ie.48xlarge";
  readonly i7ie_6xlarge: "i7ie.6xlarge";
  readonly i7ie_large: "i7ie.large";
  readonly i7ie_metal_24xl: "i7ie.metal-24xl";
  readonly i7ie_metal_48xl: "i7ie.metal-48xl";
  readonly i7ie_xlarge: "i7ie.xlarge";
  readonly i8g_12xlarge: "i8g.12xlarge";
  readonly i8g_16xlarge: "i8g.16xlarge";
  readonly i8g_24xlarge: "i8g.24xlarge";
  readonly i8g_2xlarge: "i8g.2xlarge";
  readonly i8g_48xlarge: "i8g.48xlarge";
  readonly i8g_4xlarge: "i8g.4xlarge";
  readonly i8g_8xlarge: "i8g.8xlarge";
  readonly i8g_large: "i8g.large";
  readonly i8g_metal_24xl: "i8g.metal-24xl";
  readonly i8g_xlarge: "i8g.xlarge";
  readonly im4gn_16xlarge: "im4gn.16xlarge";
  readonly im4gn_2xlarge: "im4gn.2xlarge";
  readonly im4gn_4xlarge: "im4gn.4xlarge";
  readonly im4gn_8xlarge: "im4gn.8xlarge";
  readonly im4gn_large: "im4gn.large";
  readonly im4gn_xlarge: "im4gn.xlarge";
  readonly inf1_24xlarge: "inf1.24xlarge";
  readonly inf1_2xlarge: "inf1.2xlarge";
  readonly inf1_6xlarge: "inf1.6xlarge";
  readonly inf1_xlarge: "inf1.xlarge";
  readonly inf2_24xlarge: "inf2.24xlarge";
  readonly inf2_48xlarge: "inf2.48xlarge";
  readonly inf2_8xlarge: "inf2.8xlarge";
  readonly inf2_xlarge: "inf2.xlarge";
  readonly is4gen_2xlarge: "is4gen.2xlarge";
  readonly is4gen_4xlarge: "is4gen.4xlarge";
  readonly is4gen_8xlarge: "is4gen.8xlarge";
  readonly is4gen_large: "is4gen.large";
  readonly is4gen_medium: "is4gen.medium";
  readonly is4gen_xlarge: "is4gen.xlarge";
  readonly m1_large: "m1.large";
  readonly m1_medium: "m1.medium";
  readonly m1_small: "m1.small";
  readonly m1_xlarge: "m1.xlarge";
  readonly m2_2xlarge: "m2.2xlarge";
  readonly m2_4xlarge: "m2.4xlarge";
  readonly m2_xlarge: "m2.xlarge";
  readonly m3_2xlarge: "m3.2xlarge";
  readonly m3_large: "m3.large";
  readonly m3_medium: "m3.medium";
  readonly m3_xlarge: "m3.xlarge";
  readonly m4_10xlarge: "m4.10xlarge";
  readonly m4_16xlarge: "m4.16xlarge";
  readonly m4_2xlarge: "m4.2xlarge";
  readonly m4_4xlarge: "m4.4xlarge";
  readonly m4_large: "m4.large";
  readonly m4_xlarge: "m4.xlarge";
  readonly m5_12xlarge: "m5.12xlarge";
  readonly m5_16xlarge: "m5.16xlarge";
  readonly m5_24xlarge: "m5.24xlarge";
  readonly m5_2xlarge: "m5.2xlarge";
  readonly m5_4xlarge: "m5.4xlarge";
  readonly m5_8xlarge: "m5.8xlarge";
  readonly m5_large: "m5.large";
  readonly m5_metal: "m5.metal";
  readonly m5_xlarge: "m5.xlarge";
  readonly m5a_12xlarge: "m5a.12xlarge";
  readonly m5a_16xlarge: "m5a.16xlarge";
  readonly m5a_24xlarge: "m5a.24xlarge";
  readonly m5a_2xlarge: "m5a.2xlarge";
  readonly m5a_4xlarge: "m5a.4xlarge";
  readonly m5a_8xlarge: "m5a.8xlarge";
  readonly m5a_large: "m5a.large";
  readonly m5a_xlarge: "m5a.xlarge";
  readonly m5ad_12xlarge: "m5ad.12xlarge";
  readonly m5ad_16xlarge: "m5ad.16xlarge";
  readonly m5ad_24xlarge: "m5ad.24xlarge";
  readonly m5ad_2xlarge: "m5ad.2xlarge";
  readonly m5ad_4xlarge: "m5ad.4xlarge";
  readonly m5ad_8xlarge: "m5ad.8xlarge";
  readonly m5ad_large: "m5ad.large";
  readonly m5ad_xlarge: "m5ad.xlarge";
  readonly m5d_12xlarge: "m5d.12xlarge";
  readonly m5d_16xlarge: "m5d.16xlarge";
  readonly m5d_24xlarge: "m5d.24xlarge";
  readonly m5d_2xlarge: "m5d.2xlarge";
  readonly m5d_4xlarge: "m5d.4xlarge";
  readonly m5d_8xlarge: "m5d.8xlarge";
  readonly m5d_large: "m5d.large";
  readonly m5d_metal: "m5d.metal";
  readonly m5d_xlarge: "m5d.xlarge";
  readonly m5dn_12xlarge: "m5dn.12xlarge";
  readonly m5dn_16xlarge: "m5dn.16xlarge";
  readonly m5dn_24xlarge: "m5dn.24xlarge";
  readonly m5dn_2xlarge: "m5dn.2xlarge";
  readonly m5dn_4xlarge: "m5dn.4xlarge";
  readonly m5dn_8xlarge: "m5dn.8xlarge";
  readonly m5dn_large: "m5dn.large";
  readonly m5dn_metal: "m5dn.metal";
  readonly m5dn_xlarge: "m5dn.xlarge";
  readonly m5n_12xlarge: "m5n.12xlarge";
  readonly m5n_16xlarge: "m5n.16xlarge";
  readonly m5n_24xlarge: "m5n.24xlarge";
  readonly m5n_2xlarge: "m5n.2xlarge";
  readonly m5n_4xlarge: "m5n.4xlarge";
  readonly m5n_8xlarge: "m5n.8xlarge";
  readonly m5n_large: "m5n.large";
  readonly m5n_metal: "m5n.metal";
  readonly m5n_xlarge: "m5n.xlarge";
  readonly m5zn_12xlarge: "m5zn.12xlarge";
  readonly m5zn_2xlarge: "m5zn.2xlarge";
  readonly m5zn_3xlarge: "m5zn.3xlarge";
  readonly m5zn_6xlarge: "m5zn.6xlarge";
  readonly m5zn_large: "m5zn.large";
  readonly m5zn_metal: "m5zn.metal";
  readonly m5zn_xlarge: "m5zn.xlarge";
  readonly m6a_12xlarge: "m6a.12xlarge";
  readonly m6a_16xlarge: "m6a.16xlarge";
  readonly m6a_24xlarge: "m6a.24xlarge";
  readonly m6a_2xlarge: "m6a.2xlarge";
  readonly m6a_32xlarge: "m6a.32xlarge";
  readonly m6a_48xlarge: "m6a.48xlarge";
  readonly m6a_4xlarge: "m6a.4xlarge";
  readonly m6a_8xlarge: "m6a.8xlarge";
  readonly m6a_large: "m6a.large";
  readonly m6a_metal: "m6a.metal";
  readonly m6a_xlarge: "m6a.xlarge";
  readonly m6g_12xlarge: "m6g.12xlarge";
  readonly m6g_16xlarge: "m6g.16xlarge";
  readonly m6g_2xlarge: "m6g.2xlarge";
  readonly m6g_4xlarge: "m6g.4xlarge";
  readonly m6g_8xlarge: "m6g.8xlarge";
  readonly m6g_large: "m6g.large";
  readonly m6g_medium: "m6g.medium";
  readonly m6g_metal: "m6g.metal";
  readonly m6g_xlarge: "m6g.xlarge";
  readonly m6gd_12xlarge: "m6gd.12xlarge";
  readonly m6gd_16xlarge: "m6gd.16xlarge";
  readonly m6gd_2xlarge: "m6gd.2xlarge";
  readonly m6gd_4xlarge: "m6gd.4xlarge";
  readonly m6gd_8xlarge: "m6gd.8xlarge";
  readonly m6gd_large: "m6gd.large";
  readonly m6gd_medium: "m6gd.medium";
  readonly m6gd_metal: "m6gd.metal";
  readonly m6gd_xlarge: "m6gd.xlarge";
  readonly m6i_12xlarge: "m6i.12xlarge";
  readonly m6i_16xlarge: "m6i.16xlarge";
  readonly m6i_24xlarge: "m6i.24xlarge";
  readonly m6i_2xlarge: "m6i.2xlarge";
  readonly m6i_32xlarge: "m6i.32xlarge";
  readonly m6i_4xlarge: "m6i.4xlarge";
  readonly m6i_8xlarge: "m6i.8xlarge";
  readonly m6i_large: "m6i.large";
  readonly m6i_metal: "m6i.metal";
  readonly m6i_xlarge: "m6i.xlarge";
  readonly m6id_12xlarge: "m6id.12xlarge";
  readonly m6id_16xlarge: "m6id.16xlarge";
  readonly m6id_24xlarge: "m6id.24xlarge";
  readonly m6id_2xlarge: "m6id.2xlarge";
  readonly m6id_32xlarge: "m6id.32xlarge";
  readonly m6id_4xlarge: "m6id.4xlarge";
  readonly m6id_8xlarge: "m6id.8xlarge";
  readonly m6id_large: "m6id.large";
  readonly m6id_metal: "m6id.metal";
  readonly m6id_xlarge: "m6id.xlarge";
  readonly m6idn_12xlarge: "m6idn.12xlarge";
  readonly m6idn_16xlarge: "m6idn.16xlarge";
  readonly m6idn_24xlarge: "m6idn.24xlarge";
  readonly m6idn_2xlarge: "m6idn.2xlarge";
  readonly m6idn_32xlarge: "m6idn.32xlarge";
  readonly m6idn_4xlarge: "m6idn.4xlarge";
  readonly m6idn_8xlarge: "m6idn.8xlarge";
  readonly m6idn_large: "m6idn.large";
  readonly m6idn_metal: "m6idn.metal";
  readonly m6idn_xlarge: "m6idn.xlarge";
  readonly m6in_12xlarge: "m6in.12xlarge";
  readonly m6in_16xlarge: "m6in.16xlarge";
  readonly m6in_24xlarge: "m6in.24xlarge";
  readonly m6in_2xlarge: "m6in.2xlarge";
  readonly m6in_32xlarge: "m6in.32xlarge";
  readonly m6in_4xlarge: "m6in.4xlarge";
  readonly m6in_8xlarge: "m6in.8xlarge";
  readonly m6in_large: "m6in.large";
  readonly m6in_metal: "m6in.metal";
  readonly m6in_xlarge: "m6in.xlarge";
  readonly m7a_12xlarge: "m7a.12xlarge";
  readonly m7a_16xlarge: "m7a.16xlarge";
  readonly m7a_24xlarge: "m7a.24xlarge";
  readonly m7a_2xlarge: "m7a.2xlarge";
  readonly m7a_32xlarge: "m7a.32xlarge";
  readonly m7a_48xlarge: "m7a.48xlarge";
  readonly m7a_4xlarge: "m7a.4xlarge";
  readonly m7a_8xlarge: "m7a.8xlarge";
  readonly m7a_large: "m7a.large";
  readonly m7a_medium: "m7a.medium";
  readonly m7a_metal_48xl: "m7a.metal-48xl";
  readonly m7a_xlarge: "m7a.xlarge";
  readonly m7g_12xlarge: "m7g.12xlarge";
  readonly m7g_16xlarge: "m7g.16xlarge";
  readonly m7g_2xlarge: "m7g.2xlarge";
  readonly m7g_4xlarge: "m7g.4xlarge";
  readonly m7g_8xlarge: "m7g.8xlarge";
  readonly m7g_large: "m7g.large";
  readonly m7g_medium: "m7g.medium";
  readonly m7g_metal: "m7g.metal";
  readonly m7g_xlarge: "m7g.xlarge";
  readonly m7gd_12xlarge: "m7gd.12xlarge";
  readonly m7gd_16xlarge: "m7gd.16xlarge";
  readonly m7gd_2xlarge: "m7gd.2xlarge";
  readonly m7gd_4xlarge: "m7gd.4xlarge";
  readonly m7gd_8xlarge: "m7gd.8xlarge";
  readonly m7gd_large: "m7gd.large";
  readonly m7gd_medium: "m7gd.medium";
  readonly m7gd_metal: "m7gd.metal";
  readonly m7gd_xlarge: "m7gd.xlarge";
  readonly m7i_12xlarge: "m7i.12xlarge";
  readonly m7i_16xlarge: "m7i.16xlarge";
  readonly m7i_24xlarge: "m7i.24xlarge";
  readonly m7i_2xlarge: "m7i.2xlarge";
  readonly m7i_48xlarge: "m7i.48xlarge";
  readonly m7i_4xlarge: "m7i.4xlarge";
  readonly m7i_8xlarge: "m7i.8xlarge";
  readonly m7i_flex_12xlarge: "m7i-flex.12xlarge";
  readonly m7i_flex_16xlarge: "m7i-flex.16xlarge";
  readonly m7i_flex_2xlarge: "m7i-flex.2xlarge";
  readonly m7i_flex_4xlarge: "m7i-flex.4xlarge";
  readonly m7i_flex_8xlarge: "m7i-flex.8xlarge";
  readonly m7i_flex_large: "m7i-flex.large";
  readonly m7i_flex_xlarge: "m7i-flex.xlarge";
  readonly m7i_large: "m7i.large";
  readonly m7i_metal_24xl: "m7i.metal-24xl";
  readonly m7i_metal_48xl: "m7i.metal-48xl";
  readonly m7i_xlarge: "m7i.xlarge";
  readonly m8g_12xlarge: "m8g.12xlarge";
  readonly m8g_16xlarge: "m8g.16xlarge";
  readonly m8g_24xlarge: "m8g.24xlarge";
  readonly m8g_2xlarge: "m8g.2xlarge";
  readonly m8g_48xlarge: "m8g.48xlarge";
  readonly m8g_4xlarge: "m8g.4xlarge";
  readonly m8g_8xlarge: "m8g.8xlarge";
  readonly m8g_large: "m8g.large";
  readonly m8g_medium: "m8g.medium";
  readonly m8g_metal_24xl: "m8g.metal-24xl";
  readonly m8g_metal_48xl: "m8g.metal-48xl";
  readonly m8g_xlarge: "m8g.xlarge";
  readonly m8gd_12xlarge: "m8gd.12xlarge";
  readonly m8gd_16xlarge: "m8gd.16xlarge";
  readonly m8gd_24xlarge: "m8gd.24xlarge";
  readonly m8gd_2xlarge: "m8gd.2xlarge";
  readonly m8gd_48xlarge: "m8gd.48xlarge";
  readonly m8gd_4xlarge: "m8gd.4xlarge";
  readonly m8gd_8xlarge: "m8gd.8xlarge";
  readonly m8gd_large: "m8gd.large";
  readonly m8gd_medium: "m8gd.medium";
  readonly m8gd_metal_24xl: "m8gd.metal-24xl";
  readonly m8gd_metal_48xl: "m8gd.metal-48xl";
  readonly m8gd_xlarge: "m8gd.xlarge";
  readonly mac1_metal: "mac1.metal";
  readonly mac2_m1ultra_metal: "mac2-m1ultra.metal";
  readonly mac2_m2_metal: "mac2-m2.metal";
  readonly mac2_m2pro_metal: "mac2-m2pro.metal";
  readonly mac2_metal: "mac2.metal";
  readonly p2_16xlarge: "p2.16xlarge";
  readonly p2_8xlarge: "p2.8xlarge";
  readonly p2_xlarge: "p2.xlarge";
  readonly p3_16xlarge: "p3.16xlarge";
  readonly p3_2xlarge: "p3.2xlarge";
  readonly p3_8xlarge: "p3.8xlarge";
  readonly p3dn_24xlarge: "p3dn.24xlarge";
  readonly p4d_24xlarge: "p4d.24xlarge";
  readonly p4de_24xlarge: "p4de.24xlarge";
  readonly p5_48xlarge: "p5.48xlarge";
  readonly p5e_48xlarge: "p5e.48xlarge";
  readonly p5en_48xlarge: "p5en.48xlarge";
  readonly p6_b200_48xlarge: "p6-b200.48xlarge";
  readonly r3_2xlarge: "r3.2xlarge";
  readonly r3_4xlarge: "r3.4xlarge";
  readonly r3_8xlarge: "r3.8xlarge";
  readonly r3_large: "r3.large";
  readonly r3_xlarge: "r3.xlarge";
  readonly r4_16xlarge: "r4.16xlarge";
  readonly r4_2xlarge: "r4.2xlarge";
  readonly r4_4xlarge: "r4.4xlarge";
  readonly r4_8xlarge: "r4.8xlarge";
  readonly r4_large: "r4.large";
  readonly r4_xlarge: "r4.xlarge";
  readonly r5_12xlarge: "r5.12xlarge";
  readonly r5_16xlarge: "r5.16xlarge";
  readonly r5_24xlarge: "r5.24xlarge";
  readonly r5_2xlarge: "r5.2xlarge";
  readonly r5_4xlarge: "r5.4xlarge";
  readonly r5_8xlarge: "r5.8xlarge";
  readonly r5_large: "r5.large";
  readonly r5_metal: "r5.metal";
  readonly r5_xlarge: "r5.xlarge";
  readonly r5a_12xlarge: "r5a.12xlarge";
  readonly r5a_16xlarge: "r5a.16xlarge";
  readonly r5a_24xlarge: "r5a.24xlarge";
  readonly r5a_2xlarge: "r5a.2xlarge";
  readonly r5a_4xlarge: "r5a.4xlarge";
  readonly r5a_8xlarge: "r5a.8xlarge";
  readonly r5a_large: "r5a.large";
  readonly r5a_xlarge: "r5a.xlarge";
  readonly r5ad_12xlarge: "r5ad.12xlarge";
  readonly r5ad_16xlarge: "r5ad.16xlarge";
  readonly r5ad_24xlarge: "r5ad.24xlarge";
  readonly r5ad_2xlarge: "r5ad.2xlarge";
  readonly r5ad_4xlarge: "r5ad.4xlarge";
  readonly r5ad_8xlarge: "r5ad.8xlarge";
  readonly r5ad_large: "r5ad.large";
  readonly r5ad_xlarge: "r5ad.xlarge";
  readonly r5b_12xlarge: "r5b.12xlarge";
  readonly r5b_16xlarge: "r5b.16xlarge";
  readonly r5b_24xlarge: "r5b.24xlarge";
  readonly r5b_2xlarge: "r5b.2xlarge";
  readonly r5b_4xlarge: "r5b.4xlarge";
  readonly r5b_8xlarge: "r5b.8xlarge";
  readonly r5b_large: "r5b.large";
  readonly r5b_metal: "r5b.metal";
  readonly r5b_xlarge: "r5b.xlarge";
  readonly r5d_12xlarge: "r5d.12xlarge";
  readonly r5d_16xlarge: "r5d.16xlarge";
  readonly r5d_24xlarge: "r5d.24xlarge";
  readonly r5d_2xlarge: "r5d.2xlarge";
  readonly r5d_4xlarge: "r5d.4xlarge";
  readonly r5d_8xlarge: "r5d.8xlarge";
  readonly r5d_large: "r5d.large";
  readonly r5d_metal: "r5d.metal";
  readonly r5d_xlarge: "r5d.xlarge";
  readonly r5dn_12xlarge: "r5dn.12xlarge";
  readonly r5dn_16xlarge: "r5dn.16xlarge";
  readonly r5dn_24xlarge: "r5dn.24xlarge";
  readonly r5dn_2xlarge: "r5dn.2xlarge";
  readonly r5dn_4xlarge: "r5dn.4xlarge";
  readonly r5dn_8xlarge: "r5dn.8xlarge";
  readonly r5dn_large: "r5dn.large";
  readonly r5dn_metal: "r5dn.metal";
  readonly r5dn_xlarge: "r5dn.xlarge";
  readonly r5n_12xlarge: "r5n.12xlarge";
  readonly r5n_16xlarge: "r5n.16xlarge";
  readonly r5n_24xlarge: "r5n.24xlarge";
  readonly r5n_2xlarge: "r5n.2xlarge";
  readonly r5n_4xlarge: "r5n.4xlarge";
  readonly r5n_8xlarge: "r5n.8xlarge";
  readonly r5n_large: "r5n.large";
  readonly r5n_metal: "r5n.metal";
  readonly r5n_xlarge: "r5n.xlarge";
  readonly r6a_12xlarge: "r6a.12xlarge";
  readonly r6a_16xlarge: "r6a.16xlarge";
  readonly r6a_24xlarge: "r6a.24xlarge";
  readonly r6a_2xlarge: "r6a.2xlarge";
  readonly r6a_32xlarge: "r6a.32xlarge";
  readonly r6a_48xlarge: "r6a.48xlarge";
  readonly r6a_4xlarge: "r6a.4xlarge";
  readonly r6a_8xlarge: "r6a.8xlarge";
  readonly r6a_large: "r6a.large";
  readonly r6a_metal: "r6a.metal";
  readonly r6a_xlarge: "r6a.xlarge";
  readonly r6g_12xlarge: "r6g.12xlarge";
  readonly r6g_16xlarge: "r6g.16xlarge";
  readonly r6g_2xlarge: "r6g.2xlarge";
  readonly r6g_4xlarge: "r6g.4xlarge";
  readonly r6g_8xlarge: "r6g.8xlarge";
  readonly r6g_large: "r6g.large";
  readonly r6g_medium: "r6g.medium";
  readonly r6g_metal: "r6g.metal";
  readonly r6g_xlarge: "r6g.xlarge";
  readonly r6gd_12xlarge: "r6gd.12xlarge";
  readonly r6gd_16xlarge: "r6gd.16xlarge";
  readonly r6gd_2xlarge: "r6gd.2xlarge";
  readonly r6gd_4xlarge: "r6gd.4xlarge";
  readonly r6gd_8xlarge: "r6gd.8xlarge";
  readonly r6gd_large: "r6gd.large";
  readonly r6gd_medium: "r6gd.medium";
  readonly r6gd_metal: "r6gd.metal";
  readonly r6gd_xlarge: "r6gd.xlarge";
  readonly r6i_12xlarge: "r6i.12xlarge";
  readonly r6i_16xlarge: "r6i.16xlarge";
  readonly r6i_24xlarge: "r6i.24xlarge";
  readonly r6i_2xlarge: "r6i.2xlarge";
  readonly r6i_32xlarge: "r6i.32xlarge";
  readonly r6i_4xlarge: "r6i.4xlarge";
  readonly r6i_8xlarge: "r6i.8xlarge";
  readonly r6i_large: "r6i.large";
  readonly r6i_metal: "r6i.metal";
  readonly r6i_xlarge: "r6i.xlarge";
  readonly r6id_12xlarge: "r6id.12xlarge";
  readonly r6id_16xlarge: "r6id.16xlarge";
  readonly r6id_24xlarge: "r6id.24xlarge";
  readonly r6id_2xlarge: "r6id.2xlarge";
  readonly r6id_32xlarge: "r6id.32xlarge";
  readonly r6id_4xlarge: "r6id.4xlarge";
  readonly r6id_8xlarge: "r6id.8xlarge";
  readonly r6id_large: "r6id.large";
  readonly r6id_metal: "r6id.metal";
  readonly r6id_xlarge: "r6id.xlarge";
  readonly r6idn_12xlarge: "r6idn.12xlarge";
  readonly r6idn_16xlarge: "r6idn.16xlarge";
  readonly r6idn_24xlarge: "r6idn.24xlarge";
  readonly r6idn_2xlarge: "r6idn.2xlarge";
  readonly r6idn_32xlarge: "r6idn.32xlarge";
  readonly r6idn_4xlarge: "r6idn.4xlarge";
  readonly r6idn_8xlarge: "r6idn.8xlarge";
  readonly r6idn_large: "r6idn.large";
  readonly r6idn_metal: "r6idn.metal";
  readonly r6idn_xlarge: "r6idn.xlarge";
  readonly r6in_12xlarge: "r6in.12xlarge";
  readonly r6in_16xlarge: "r6in.16xlarge";
  readonly r6in_24xlarge: "r6in.24xlarge";
  readonly r6in_2xlarge: "r6in.2xlarge";
  readonly r6in_32xlarge: "r6in.32xlarge";
  readonly r6in_4xlarge: "r6in.4xlarge";
  readonly r6in_8xlarge: "r6in.8xlarge";
  readonly r6in_large: "r6in.large";
  readonly r6in_metal: "r6in.metal";
  readonly r6in_xlarge: "r6in.xlarge";
  readonly r7a_12xlarge: "r7a.12xlarge";
  readonly r7a_16xlarge: "r7a.16xlarge";
  readonly r7a_24xlarge: "r7a.24xlarge";
  readonly r7a_2xlarge: "r7a.2xlarge";
  readonly r7a_32xlarge: "r7a.32xlarge";
  readonly r7a_48xlarge: "r7a.48xlarge";
  readonly r7a_4xlarge: "r7a.4xlarge";
  readonly r7a_8xlarge: "r7a.8xlarge";
  readonly r7a_large: "r7a.large";
  readonly r7a_medium: "r7a.medium";
  readonly r7a_metal_48xl: "r7a.metal-48xl";
  readonly r7a_xlarge: "r7a.xlarge";
  readonly r7g_12xlarge: "r7g.12xlarge";
  readonly r7g_16xlarge: "r7g.16xlarge";
  readonly r7g_2xlarge: "r7g.2xlarge";
  readonly r7g_4xlarge: "r7g.4xlarge";
  readonly r7g_8xlarge: "r7g.8xlarge";
  readonly r7g_large: "r7g.large";
  readonly r7g_medium: "r7g.medium";
  readonly r7g_metal: "r7g.metal";
  readonly r7g_xlarge: "r7g.xlarge";
  readonly r7gd_12xlarge: "r7gd.12xlarge";
  readonly r7gd_16xlarge: "r7gd.16xlarge";
  readonly r7gd_2xlarge: "r7gd.2xlarge";
  readonly r7gd_4xlarge: "r7gd.4xlarge";
  readonly r7gd_8xlarge: "r7gd.8xlarge";
  readonly r7gd_large: "r7gd.large";
  readonly r7gd_medium: "r7gd.medium";
  readonly r7gd_metal: "r7gd.metal";
  readonly r7gd_xlarge: "r7gd.xlarge";
  readonly r7i_12xlarge: "r7i.12xlarge";
  readonly r7i_16xlarge: "r7i.16xlarge";
  readonly r7i_24xlarge: "r7i.24xlarge";
  readonly r7i_2xlarge: "r7i.2xlarge";
  readonly r7i_48xlarge: "r7i.48xlarge";
  readonly r7i_4xlarge: "r7i.4xlarge";
  readonly r7i_8xlarge: "r7i.8xlarge";
  readonly r7i_large: "r7i.large";
  readonly r7i_metal_24xl: "r7i.metal-24xl";
  readonly r7i_metal_48xl: "r7i.metal-48xl";
  readonly r7i_xlarge: "r7i.xlarge";
  readonly r7iz_12xlarge: "r7iz.12xlarge";
  readonly r7iz_16xlarge: "r7iz.16xlarge";
  readonly r7iz_2xlarge: "r7iz.2xlarge";
  readonly r7iz_32xlarge: "r7iz.32xlarge";
  readonly r7iz_4xlarge: "r7iz.4xlarge";
  readonly r7iz_8xlarge: "r7iz.8xlarge";
  readonly r7iz_large: "r7iz.large";
  readonly r7iz_metal_16xl: "r7iz.metal-16xl";
  readonly r7iz_metal_32xl: "r7iz.metal-32xl";
  readonly r7iz_xlarge: "r7iz.xlarge";
  readonly r8g_12xlarge: "r8g.12xlarge";
  readonly r8g_16xlarge: "r8g.16xlarge";
  readonly r8g_24xlarge: "r8g.24xlarge";
  readonly r8g_2xlarge: "r8g.2xlarge";
  readonly r8g_48xlarge: "r8g.48xlarge";
  readonly r8g_4xlarge: "r8g.4xlarge";
  readonly r8g_8xlarge: "r8g.8xlarge";
  readonly r8g_large: "r8g.large";
  readonly r8g_medium: "r8g.medium";
  readonly r8g_metal_24xl: "r8g.metal-24xl";
  readonly r8g_metal_48xl: "r8g.metal-48xl";
  readonly r8g_xlarge: "r8g.xlarge";
  readonly r8gd_12xlarge: "r8gd.12xlarge";
  readonly r8gd_16xlarge: "r8gd.16xlarge";
  readonly r8gd_24xlarge: "r8gd.24xlarge";
  readonly r8gd_2xlarge: "r8gd.2xlarge";
  readonly r8gd_48xlarge: "r8gd.48xlarge";
  readonly r8gd_4xlarge: "r8gd.4xlarge";
  readonly r8gd_8xlarge: "r8gd.8xlarge";
  readonly r8gd_large: "r8gd.large";
  readonly r8gd_medium: "r8gd.medium";
  readonly r8gd_metal_24xl: "r8gd.metal-24xl";
  readonly r8gd_metal_48xl: "r8gd.metal-48xl";
  readonly r8gd_xlarge: "r8gd.xlarge";
  readonly t1_micro: "t1.micro";
  readonly t2_2xlarge: "t2.2xlarge";
  readonly t2_large: "t2.large";
  readonly t2_medium: "t2.medium";
  readonly t2_micro: "t2.micro";
  readonly t2_nano: "t2.nano";
  readonly t2_small: "t2.small";
  readonly t2_xlarge: "t2.xlarge";
  readonly t3_2xlarge: "t3.2xlarge";
  readonly t3_large: "t3.large";
  readonly t3_medium: "t3.medium";
  readonly t3_micro: "t3.micro";
  readonly t3_nano: "t3.nano";
  readonly t3_small: "t3.small";
  readonly t3_xlarge: "t3.xlarge";
  readonly t3a_2xlarge: "t3a.2xlarge";
  readonly t3a_large: "t3a.large";
  readonly t3a_medium: "t3a.medium";
  readonly t3a_micro: "t3a.micro";
  readonly t3a_nano: "t3a.nano";
  readonly t3a_small: "t3a.small";
  readonly t3a_xlarge: "t3a.xlarge";
  readonly t4g_2xlarge: "t4g.2xlarge";
  readonly t4g_large: "t4g.large";
  readonly t4g_medium: "t4g.medium";
  readonly t4g_micro: "t4g.micro";
  readonly t4g_nano: "t4g.nano";
  readonly t4g_small: "t4g.small";
  readonly t4g_xlarge: "t4g.xlarge";
  readonly trn1_2xlarge: "trn1.2xlarge";
  readonly trn1_32xlarge: "trn1.32xlarge";
  readonly trn1n_32xlarge: "trn1n.32xlarge";
  readonly trn2_48xlarge: "trn2.48xlarge";
  readonly u7i_12tb_224xlarge: "u7i-12tb.224xlarge";
  readonly u7i_6tb_112xlarge: "u7i-6tb.112xlarge";
  readonly u7i_8tb_112xlarge: "u7i-8tb.112xlarge";
  readonly u7ib_12tb_224xlarge: "u7ib-12tb.224xlarge";
  readonly u7in_16tb_224xlarge: "u7in-16tb.224xlarge";
  readonly u7in_24tb_224xlarge: "u7in-24tb.224xlarge";
  readonly u7in_32tb_224xlarge: "u7in-32tb.224xlarge";
  readonly u7inh_32tb_480xlarge: "u7inh-32tb.480xlarge";
  readonly u_12tb1_112xlarge: "u-12tb1.112xlarge";
  readonly u_12tb1_metal: "u-12tb1.metal";
  readonly u_18tb1_112xlarge: "u-18tb1.112xlarge";
  readonly u_18tb1_metal: "u-18tb1.metal";
  readonly u_24tb1_112xlarge: "u-24tb1.112xlarge";
  readonly u_24tb1_metal: "u-24tb1.metal";
  readonly u_3tb1_56xlarge: "u-3tb1.56xlarge";
  readonly u_6tb1_112xlarge: "u-6tb1.112xlarge";
  readonly u_6tb1_56xlarge: "u-6tb1.56xlarge";
  readonly u_6tb1_metal: "u-6tb1.metal";
  readonly u_9tb1_112xlarge: "u-9tb1.112xlarge";
  readonly u_9tb1_metal: "u-9tb1.metal";
  readonly vt1_24xlarge: "vt1.24xlarge";
  readonly vt1_3xlarge: "vt1.3xlarge";
  readonly vt1_6xlarge: "vt1.6xlarge";
  readonly x1_16xlarge: "x1.16xlarge";
  readonly x1_32xlarge: "x1.32xlarge";
  readonly x1e_16xlarge: "x1e.16xlarge";
  readonly x1e_2xlarge: "x1e.2xlarge";
  readonly x1e_32xlarge: "x1e.32xlarge";
  readonly x1e_4xlarge: "x1e.4xlarge";
  readonly x1e_8xlarge: "x1e.8xlarge";
  readonly x1e_xlarge: "x1e.xlarge";
  readonly x2gd_12xlarge: "x2gd.12xlarge";
  readonly x2gd_16xlarge: "x2gd.16xlarge";
  readonly x2gd_2xlarge: "x2gd.2xlarge";
  readonly x2gd_4xlarge: "x2gd.4xlarge";
  readonly x2gd_8xlarge: "x2gd.8xlarge";
  readonly x2gd_large: "x2gd.large";
  readonly x2gd_medium: "x2gd.medium";
  readonly x2gd_metal: "x2gd.metal";
  readonly x2gd_xlarge: "x2gd.xlarge";
  readonly x2idn_16xlarge: "x2idn.16xlarge";
  readonly x2idn_24xlarge: "x2idn.24xlarge";
  readonly x2idn_32xlarge: "x2idn.32xlarge";
  readonly x2idn_metal: "x2idn.metal";
  readonly x2iedn_16xlarge: "x2iedn.16xlarge";
  readonly x2iedn_24xlarge: "x2iedn.24xlarge";
  readonly x2iedn_2xlarge: "x2iedn.2xlarge";
  readonly x2iedn_32xlarge: "x2iedn.32xlarge";
  readonly x2iedn_4xlarge: "x2iedn.4xlarge";
  readonly x2iedn_8xlarge: "x2iedn.8xlarge";
  readonly x2iedn_metal: "x2iedn.metal";
  readonly x2iedn_xlarge: "x2iedn.xlarge";
  readonly x2iezn_12xlarge: "x2iezn.12xlarge";
  readonly x2iezn_2xlarge: "x2iezn.2xlarge";
  readonly x2iezn_4xlarge: "x2iezn.4xlarge";
  readonly x2iezn_6xlarge: "x2iezn.6xlarge";
  readonly x2iezn_8xlarge: "x2iezn.8xlarge";
  readonly x2iezn_metal: "x2iezn.metal";
  readonly x8g_12xlarge: "x8g.12xlarge";
  readonly x8g_16xlarge: "x8g.16xlarge";
  readonly x8g_24xlarge: "x8g.24xlarge";
  readonly x8g_2xlarge: "x8g.2xlarge";
  readonly x8g_48xlarge: "x8g.48xlarge";
  readonly x8g_4xlarge: "x8g.4xlarge";
  readonly x8g_8xlarge: "x8g.8xlarge";
  readonly x8g_large: "x8g.large";
  readonly x8g_medium: "x8g.medium";
  readonly x8g_metal_24xl: "x8g.metal-24xl";
  readonly x8g_metal_48xl: "x8g.metal-48xl";
  readonly x8g_xlarge: "x8g.xlarge";
  readonly z1d_12xlarge: "z1d.12xlarge";
  readonly z1d_2xlarge: "z1d.2xlarge";
  readonly z1d_3xlarge: "z1d.3xlarge";
  readonly z1d_6xlarge: "z1d.6xlarge";
  readonly z1d_large: "z1d.large";
  readonly z1d_metal: "z1d.metal";
  readonly z1d_xlarge: "z1d.xlarge";
};
export type _InstanceType = (typeof _InstanceType)[keyof typeof _InstanceType];
export interface ReservationFleetInstanceSpecification {
  InstanceType?: _InstanceType | undefined;
  InstancePlatform?: CapacityReservationInstancePlatform | undefined;
  Weight?: number | undefined;
  AvailabilityZone?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  EbsOptimized?: boolean | undefined;
  Priority?: number | undefined;
}
export declare const FleetCapacityReservationTenancy: {
  readonly default: "default";
};
export type FleetCapacityReservationTenancy =
  (typeof FleetCapacityReservationTenancy)[keyof typeof FleetCapacityReservationTenancy];
export interface CreateCapacityReservationFleetRequest {
  AllocationStrategy?: string | undefined;
  ClientToken?: string | undefined;
  InstanceTypeSpecifications:
    | ReservationFleetInstanceSpecification[]
    | undefined;
  Tenancy?: FleetCapacityReservationTenancy | undefined;
  TotalTargetCapacity: number | undefined;
  EndDate?: Date | undefined;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface FleetCapacityReservation {
  CapacityReservationId?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  InstanceType?: _InstanceType | undefined;
  InstancePlatform?: CapacityReservationInstancePlatform | undefined;
  AvailabilityZone?: string | undefined;
  TotalInstanceCount?: number | undefined;
  FulfilledCapacity?: number | undefined;
  EbsOptimized?: boolean | undefined;
  CreateDate?: Date | undefined;
  Weight?: number | undefined;
  Priority?: number | undefined;
}
export interface CreateCapacityReservationFleetResult {
  CapacityReservationFleetId?: string | undefined;
  State?: CapacityReservationFleetState | undefined;
  TotalTargetCapacity?: number | undefined;
  TotalFulfilledCapacity?: number | undefined;
  InstanceMatchCriteria?: FleetInstanceMatchCriteria | undefined;
  AllocationStrategy?: string | undefined;
  CreateTime?: Date | undefined;
  EndDate?: Date | undefined;
  Tenancy?: FleetCapacityReservationTenancy | undefined;
  FleetCapacityReservations?: FleetCapacityReservation[] | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateCarrierGatewayRequest {
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
}
export declare const CarrierGatewayState: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending: "pending";
};
export type CarrierGatewayState =
  (typeof CarrierGatewayState)[keyof typeof CarrierGatewayState];
export interface CarrierGateway {
  CarrierGatewayId?: string | undefined;
  VpcId?: string | undefined;
  State?: CarrierGatewayState | undefined;
  OwnerId?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateCarrierGatewayResult {
  CarrierGateway?: CarrierGateway | undefined;
}
export interface DirectoryServiceAuthenticationRequest {
  DirectoryId?: string | undefined;
}
export interface FederatedAuthenticationRequest {
  SAMLProviderArn?: string | undefined;
  SelfServiceSAMLProviderArn?: string | undefined;
}
export interface CertificateAuthenticationRequest {
  ClientRootCertificateChainArn?: string | undefined;
}
export declare const ClientVpnAuthenticationType: {
  readonly certificate_authentication: "certificate-authentication";
  readonly directory_service_authentication: "directory-service-authentication";
  readonly federated_authentication: "federated-authentication";
};
export type ClientVpnAuthenticationType =
  (typeof ClientVpnAuthenticationType)[keyof typeof ClientVpnAuthenticationType];
export interface ClientVpnAuthenticationRequest {
  Type?: ClientVpnAuthenticationType | undefined;
  ActiveDirectory?: DirectoryServiceAuthenticationRequest | undefined;
  MutualAuthentication?: CertificateAuthenticationRequest | undefined;
  FederatedAuthentication?: FederatedAuthenticationRequest | undefined;
}
export interface ClientConnectOptions {
  Enabled?: boolean | undefined;
  LambdaFunctionArn?: string | undefined;
}
export interface ClientLoginBannerOptions {
  Enabled?: boolean | undefined;
  BannerText?: string | undefined;
}
export interface ClientRouteEnforcementOptions {
  Enforced?: boolean | undefined;
}
export interface ConnectionLogOptions {
  Enabled?: boolean | undefined;
  CloudwatchLogGroup?: string | undefined;
  CloudwatchLogStream?: string | undefined;
}
export declare const SelfServicePortal: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type SelfServicePortal =
  (typeof SelfServicePortal)[keyof typeof SelfServicePortal];
export declare const TransportProtocol: {
  readonly tcp: "tcp";
  readonly udp: "udp";
};
export type TransportProtocol =
  (typeof TransportProtocol)[keyof typeof TransportProtocol];
export interface CreateClientVpnEndpointRequest {
  ClientCidrBlock: string | undefined;
  ServerCertificateArn: string | undefined;
  AuthenticationOptions: ClientVpnAuthenticationRequest[] | undefined;
  ConnectionLogOptions: ConnectionLogOptions | undefined;
  DnsServers?: string[] | undefined;
  TransportProtocol?: TransportProtocol | undefined;
  VpnPort?: number | undefined;
  Description?: string | undefined;
  SplitTunnel?: boolean | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  SecurityGroupIds?: string[] | undefined;
  VpcId?: string | undefined;
  SelfServicePortal?: SelfServicePortal | undefined;
  ClientConnectOptions?: ClientConnectOptions | undefined;
  SessionTimeoutHours?: number | undefined;
  ClientLoginBannerOptions?: ClientLoginBannerOptions | undefined;
  ClientRouteEnforcementOptions?: ClientRouteEnforcementOptions | undefined;
  DisconnectOnSessionTimeout?: boolean | undefined;
}
export declare const ClientVpnEndpointStatusCode: {
  readonly available: "available";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly pending_associate: "pending-associate";
};
export type ClientVpnEndpointStatusCode =
  (typeof ClientVpnEndpointStatusCode)[keyof typeof ClientVpnEndpointStatusCode];
export interface ClientVpnEndpointStatus {
  Code?: ClientVpnEndpointStatusCode | undefined;
  Message?: string | undefined;
}
export interface CreateClientVpnEndpointResult {
  ClientVpnEndpointId?: string | undefined;
  Status?: ClientVpnEndpointStatus | undefined;
  DnsName?: string | undefined;
}
export interface CreateClientVpnRouteRequest {
  ClientVpnEndpointId: string | undefined;
  DestinationCidrBlock: string | undefined;
  TargetVpcSubnetId: string | undefined;
  Description?: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export declare const ClientVpnRouteStatusCode: {
  readonly active: "active";
  readonly creating: "creating";
  readonly deleting: "deleting";
  readonly failed: "failed";
};
export type ClientVpnRouteStatusCode =
  (typeof ClientVpnRouteStatusCode)[keyof typeof ClientVpnRouteStatusCode];
export interface ClientVpnRouteStatus {
  Code?: ClientVpnRouteStatusCode | undefined;
  Message?: string | undefined;
}
export interface CreateClientVpnRouteResult {
  Status?: ClientVpnRouteStatus | undefined;
}
export interface CreateCoipCidrRequest {
  Cidr: string | undefined;
  CoipPoolId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface CoipCidr {
  Cidr?: string | undefined;
  CoipPoolId?: string | undefined;
  LocalGatewayRouteTableId?: string | undefined;
}
export interface CreateCoipCidrResult {
  CoipCidr?: CoipCidr | undefined;
}
export interface CreateCoipPoolRequest {
  LocalGatewayRouteTableId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface CoipPool {
  PoolId?: string | undefined;
  PoolCidrs?: string[] | undefined;
  LocalGatewayRouteTableId?: string | undefined;
  Tags?: Tag[] | undefined;
  PoolArn?: string | undefined;
}
export interface CreateCoipPoolResult {
  CoipPool?: CoipPool | undefined;
}
export declare const GatewayType: {
  readonly ipsec_1: "ipsec.1";
};
export type GatewayType = (typeof GatewayType)[keyof typeof GatewayType];
export interface CreateCustomerGatewayRequest {
  BgpAsn?: number | undefined;
  PublicIp?: string | undefined;
  CertificateArn?: string | undefined;
  Type: GatewayType | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DeviceName?: string | undefined;
  IpAddress?: string | undefined;
  BgpAsnExtended?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface CustomerGateway {
  CertificateArn?: string | undefined;
  DeviceName?: string | undefined;
  Tags?: Tag[] | undefined;
  BgpAsnExtended?: string | undefined;
  CustomerGatewayId?: string | undefined;
  State?: string | undefined;
  Type?: string | undefined;
  IpAddress?: string | undefined;
  BgpAsn?: string | undefined;
}
export interface CreateCustomerGatewayResult {
  CustomerGateway?: CustomerGateway | undefined;
}
export interface CreateDefaultSubnetRequest {
  AvailabilityZone: string | undefined;
  DryRun?: boolean | undefined;
  Ipv6Native?: boolean | undefined;
}
export declare const BlockPublicAccessMode: {
  readonly block_bidirectional: "block-bidirectional";
  readonly block_ingress: "block-ingress";
  readonly off: "off";
};
export type BlockPublicAccessMode =
  (typeof BlockPublicAccessMode)[keyof typeof BlockPublicAccessMode];
export interface BlockPublicAccessStates {
  InternetGatewayBlockMode?: BlockPublicAccessMode | undefined;
}
export declare const HostnameType: {
  readonly ip_name: "ip-name";
  readonly resource_name: "resource-name";
};
export type HostnameType = (typeof HostnameType)[keyof typeof HostnameType];
export interface PrivateDnsNameOptionsOnLaunch {
  HostnameType?: HostnameType | undefined;
  EnableResourceNameDnsARecord?: boolean | undefined;
  EnableResourceNameDnsAAAARecord?: boolean | undefined;
}
export declare const SubnetState: {
  readonly available: "available";
  readonly failed: "failed";
  readonly failed_insufficient_capacity: "failed-insufficient-capacity";
  readonly pending: "pending";
  readonly unavailable: "unavailable";
};
export type SubnetState = (typeof SubnetState)[keyof typeof SubnetState];
export interface Subnet {
  AvailabilityZoneId?: string | undefined;
  EnableLniAtDeviceIndex?: number | undefined;
  MapCustomerOwnedIpOnLaunch?: boolean | undefined;
  CustomerOwnedIpv4Pool?: string | undefined;
  OwnerId?: string | undefined;
  AssignIpv6AddressOnCreation?: boolean | undefined;
  Ipv6CidrBlockAssociationSet?: SubnetIpv6CidrBlockAssociation[] | undefined;
  Tags?: Tag[] | undefined;
  SubnetArn?: string | undefined;
  OutpostArn?: string | undefined;
  EnableDns64?: boolean | undefined;
  Ipv6Native?: boolean | undefined;
  PrivateDnsNameOptionsOnLaunch?: PrivateDnsNameOptionsOnLaunch | undefined;
  BlockPublicAccessStates?: BlockPublicAccessStates | undefined;
  Type?: string | undefined;
  SubnetId?: string | undefined;
  State?: SubnetState | undefined;
  VpcId?: string | undefined;
  CidrBlock?: string | undefined;
  AvailableIpAddressCount?: number | undefined;
  AvailabilityZone?: string | undefined;
  DefaultForAz?: boolean | undefined;
  MapPublicIpOnLaunch?: boolean | undefined;
}
export interface CreateDefaultSubnetResult {
  Subnet?: Subnet | undefined;
}
export interface CreateDefaultVpcRequest {
  DryRun?: boolean | undefined;
}
export declare const VpcEncryptionControlMode: {
  readonly enforce: "enforce";
  readonly monitor: "monitor";
};
export type VpcEncryptionControlMode =
  (typeof VpcEncryptionControlMode)[keyof typeof VpcEncryptionControlMode];
export declare const VpcEncryptionControlExclusionState: {
  readonly disabled: "disabled";
  readonly disabling: "disabling";
  readonly enabled: "enabled";
  readonly enabling: "enabling";
};
export type VpcEncryptionControlExclusionState =
  (typeof VpcEncryptionControlExclusionState)[keyof typeof VpcEncryptionControlExclusionState];
export interface VpcEncryptionControlExclusion {
  State?: VpcEncryptionControlExclusionState | undefined;
  StateMessage?: string | undefined;
}
export interface VpcEncryptionControlExclusions {
  InternetGateway?: VpcEncryptionControlExclusion | undefined;
  EgressOnlyInternetGateway?: VpcEncryptionControlExclusion | undefined;
  NatGateway?: VpcEncryptionControlExclusion | undefined;
  VirtualPrivateGateway?: VpcEncryptionControlExclusion | undefined;
  VpcPeering?: VpcEncryptionControlExclusion | undefined;
}
export declare const VpcEncryptionControlState: {
  readonly available: "available";
  readonly creating: "creating";
  readonly delete_failed: "delete-failed";
  readonly deleted: "deleted";
  readonly deleting: "deleting";
  readonly enforce_failed: "enforce-failed";
  readonly enforce_in_progress: "enforce-in-progress";
  readonly monitor_failed: "monitor-failed";
  readonly monitor_in_progress: "monitor-in-progress";
};
export type VpcEncryptionControlState =
  (typeof VpcEncryptionControlState)[keyof typeof VpcEncryptionControlState];
export interface VpcEncryptionControl {
  VpcId?: string | undefined;
  VpcEncryptionControlId?: string | undefined;
  Mode?: VpcEncryptionControlMode | undefined;
  State?: VpcEncryptionControlState | undefined;
  StateMessage?: string | undefined;
  ResourceExclusions?: VpcEncryptionControlExclusions | undefined;
  Tags?: Tag[] | undefined;
}
export declare const Tenancy: {
  readonly dedicated: "dedicated";
  readonly default: "default";
  readonly host: "host";
};
export type Tenancy = (typeof Tenancy)[keyof typeof Tenancy];
export declare const VpcState: {
  readonly available: "available";
  readonly pending: "pending";
};
export type VpcState = (typeof VpcState)[keyof typeof VpcState];
export interface Vpc {
  OwnerId?: string | undefined;
  InstanceTenancy?: Tenancy | undefined;
  Ipv6CidrBlockAssociationSet?: VpcIpv6CidrBlockAssociation[] | undefined;
  CidrBlockAssociationSet?: VpcCidrBlockAssociation[] | undefined;
  IsDefault?: boolean | undefined;
  EncryptionControl?: VpcEncryptionControl | undefined;
  Tags?: Tag[] | undefined;
  BlockPublicAccessStates?: BlockPublicAccessStates | undefined;
  VpcId?: string | undefined;
  State?: VpcState | undefined;
  CidrBlock?: string | undefined;
  DhcpOptionsId?: string | undefined;
}
export interface CreateDefaultVpcResult {
  Vpc?: Vpc | undefined;
}
export interface CreateDelegateMacVolumeOwnershipTaskRequest {
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  MacCredentials: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export declare const MacSystemIntegrityProtectionSettingStatus: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type MacSystemIntegrityProtectionSettingStatus =
  (typeof MacSystemIntegrityProtectionSettingStatus)[keyof typeof MacSystemIntegrityProtectionSettingStatus];
export interface MacSystemIntegrityProtectionConfiguration {
  AppleInternal?: MacSystemIntegrityProtectionSettingStatus | undefined;
  BaseSystem?: MacSystemIntegrityProtectionSettingStatus | undefined;
  DebuggingRestrictions?: MacSystemIntegrityProtectionSettingStatus | undefined;
  DTraceRestrictions?: MacSystemIntegrityProtectionSettingStatus | undefined;
  FilesystemProtections?: MacSystemIntegrityProtectionSettingStatus | undefined;
  KextSigning?: MacSystemIntegrityProtectionSettingStatus | undefined;
  NvramProtections?: MacSystemIntegrityProtectionSettingStatus | undefined;
  Status?: MacSystemIntegrityProtectionSettingStatus | undefined;
}
export declare const MacModificationTaskState: {
  readonly failed: "failed";
  readonly inprogress: "in-progress";
  readonly pending: "pending";
  readonly successful: "successful";
};
export type MacModificationTaskState =
  (typeof MacModificationTaskState)[keyof typeof MacModificationTaskState];
export declare const MacModificationTaskType: {
  readonly SIPModification: "sip-modification";
  readonly VolumeOwnershipDelegation: "volume-ownership-delegation";
};
export type MacModificationTaskType =
  (typeof MacModificationTaskType)[keyof typeof MacModificationTaskType];
export interface MacModificationTask {
  InstanceId?: string | undefined;
  MacModificationTaskId?: string | undefined;
  MacSystemIntegrityProtectionConfig?:
    | MacSystemIntegrityProtectionConfiguration
    | undefined;
  StartTime?: Date | undefined;
  Tags?: Tag[] | undefined;
  TaskState?: MacModificationTaskState | undefined;
  TaskType?: MacModificationTaskType | undefined;
}
export interface CreateDelegateMacVolumeOwnershipTaskResult {
  MacModificationTask?: MacModificationTask | undefined;
}
export interface NewDhcpConfiguration {
  Key?: string | undefined;
  Values?: string[] | undefined;
}
export interface CreateDhcpOptionsRequest {
  DhcpConfigurations: NewDhcpConfiguration[] | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface AttributeValue {
  Value?: string | undefined;
}
export interface DhcpConfiguration {
  Key?: string | undefined;
  Values?: AttributeValue[] | undefined;
}
export interface DhcpOptions {
  OwnerId?: string | undefined;
  Tags?: Tag[] | undefined;
  DhcpOptionsId?: string | undefined;
  DhcpConfigurations?: DhcpConfiguration[] | undefined;
}
export interface CreateDhcpOptionsResult {
  DhcpOptions?: DhcpOptions | undefined;
}
export interface CreateEgressOnlyInternetGatewayRequest {
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  VpcId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface InternetGatewayAttachment {
  State?: AttachmentStatus | undefined;
  VpcId?: string | undefined;
}
export interface EgressOnlyInternetGateway {
  Attachments?: InternetGatewayAttachment[] | undefined;
  EgressOnlyInternetGatewayId?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateEgressOnlyInternetGatewayResult {
  ClientToken?: string | undefined;
  EgressOnlyInternetGateway?: EgressOnlyInternetGateway | undefined;
}
export declare const FleetExcessCapacityTerminationPolicy: {
  readonly NO_TERMINATION: "no-termination";
  readonly TERMINATION: "termination";
};
export type FleetExcessCapacityTerminationPolicy =
  (typeof FleetExcessCapacityTerminationPolicy)[keyof typeof FleetExcessCapacityTerminationPolicy];
export interface FleetLaunchTemplateSpecificationRequest {
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  Version?: string | undefined;
}
export declare const VolumeType: {
  readonly gp2: "gp2";
  readonly gp3: "gp3";
  readonly io1: "io1";
  readonly io2: "io2";
  readonly sc1: "sc1";
  readonly st1: "st1";
  readonly standard: "standard";
};
export type VolumeType = (typeof VolumeType)[keyof typeof VolumeType];
export interface FleetEbsBlockDeviceRequest {
  Encrypted?: boolean | undefined;
  DeleteOnTermination?: boolean | undefined;
  Iops?: number | undefined;
  Throughput?: number | undefined;
  KmsKeyId?: string | undefined;
  SnapshotId?: string | undefined;
  VolumeSize?: number | undefined;
  VolumeType?: VolumeType | undefined;
}
export interface FleetBlockDeviceMappingRequest {
  DeviceName?: string | undefined;
  VirtualName?: string | undefined;
  Ebs?: FleetEbsBlockDeviceRequest | undefined;
  NoDevice?: string | undefined;
}
export declare const BareMetal: {
  readonly EXCLUDED: "excluded";
  readonly INCLUDED: "included";
  readonly REQUIRED: "required";
};
export type BareMetal = (typeof BareMetal)[keyof typeof BareMetal];
export interface BaselineEbsBandwidthMbpsRequest {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface PerformanceFactorReferenceRequest {
  InstanceFamily?: string | undefined;
}
export interface CpuPerformanceFactorRequest {
  References?: PerformanceFactorReferenceRequest[] | undefined;
}
export interface BaselinePerformanceFactorsRequest {
  Cpu?: CpuPerformanceFactorRequest | undefined;
}
export declare const BurstablePerformance: {
  readonly EXCLUDED: "excluded";
  readonly INCLUDED: "included";
  readonly REQUIRED: "required";
};
export type BurstablePerformance =
  (typeof BurstablePerformance)[keyof typeof BurstablePerformance];
export declare const CpuManufacturer: {
  readonly AMAZON_WEB_SERVICES: "amazon-web-services";
  readonly AMD: "amd";
  readonly APPLE: "apple";
  readonly INTEL: "intel";
};
export type CpuManufacturer =
  (typeof CpuManufacturer)[keyof typeof CpuManufacturer];
export declare const InstanceGeneration: {
  readonly CURRENT: "current";
  readonly PREVIOUS: "previous";
};
export type InstanceGeneration =
  (typeof InstanceGeneration)[keyof typeof InstanceGeneration];
export declare const LocalStorage: {
  readonly EXCLUDED: "excluded";
  readonly INCLUDED: "included";
  readonly REQUIRED: "required";
};
export type LocalStorage = (typeof LocalStorage)[keyof typeof LocalStorage];
export declare const LocalStorageType: {
  readonly HDD: "hdd";
  readonly SSD: "ssd";
};
export type LocalStorageType =
  (typeof LocalStorageType)[keyof typeof LocalStorageType];
export interface MemoryGiBPerVCpuRequest {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface MemoryMiBRequest {
  Min: number | undefined;
  Max?: number | undefined;
}
export interface NetworkBandwidthGbpsRequest {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface NetworkInterfaceCountRequest {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface TotalLocalStorageGBRequest {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface VCpuCountRangeRequest {
  Min: number | undefined;
  Max?: number | undefined;
}
export interface InstanceRequirementsRequest {
  VCpuCount: VCpuCountRangeRequest | undefined;
  MemoryMiB: MemoryMiBRequest | undefined;
  CpuManufacturers?: CpuManufacturer[] | undefined;
  MemoryGiBPerVCpu?: MemoryGiBPerVCpuRequest | undefined;
  ExcludedInstanceTypes?: string[] | undefined;
  InstanceGenerations?: InstanceGeneration[] | undefined;
  SpotMaxPricePercentageOverLowestPrice?: number | undefined;
  OnDemandMaxPricePercentageOverLowestPrice?: number | undefined;
  BareMetal?: BareMetal | undefined;
  BurstablePerformance?: BurstablePerformance | undefined;
  RequireHibernateSupport?: boolean | undefined;
  NetworkInterfaceCount?: NetworkInterfaceCountRequest | undefined;
  LocalStorage?: LocalStorage | undefined;
  LocalStorageTypes?: LocalStorageType[] | undefined;
  TotalLocalStorageGB?: TotalLocalStorageGBRequest | undefined;
  BaselineEbsBandwidthMbps?: BaselineEbsBandwidthMbpsRequest | undefined;
  AcceleratorTypes?: AcceleratorType[] | undefined;
  AcceleratorCount?: AcceleratorCountRequest | undefined;
  AcceleratorManufacturers?: AcceleratorManufacturer[] | undefined;
  AcceleratorNames?: AcceleratorName[] | undefined;
  AcceleratorTotalMemoryMiB?: AcceleratorTotalMemoryMiBRequest | undefined;
  NetworkBandwidthGbps?: NetworkBandwidthGbpsRequest | undefined;
  AllowedInstanceTypes?: string[] | undefined;
  MaxSpotPriceAsPercentageOfOptimalOnDemandPrice?: number | undefined;
  BaselinePerformanceFactors?: BaselinePerformanceFactorsRequest | undefined;
}
export interface Placement {
  Affinity?: string | undefined;
  GroupName?: string | undefined;
  PartitionNumber?: number | undefined;
  HostId?: string | undefined;
  Tenancy?: Tenancy | undefined;
  SpreadDomain?: string | undefined;
  HostResourceGroupArn?: string | undefined;
  GroupId?: string | undefined;
  AvailabilityZone?: string | undefined;
}
export interface FleetLaunchTemplateOverridesRequest {
  InstanceType?: _InstanceType | undefined;
  MaxPrice?: string | undefined;
  SubnetId?: string | undefined;
  AvailabilityZone?: string | undefined;
  WeightedCapacity?: number | undefined;
  Priority?: number | undefined;
  Placement?: Placement | undefined;
  BlockDeviceMappings?: FleetBlockDeviceMappingRequest[] | undefined;
  InstanceRequirements?: InstanceRequirementsRequest | undefined;
  ImageId?: string | undefined;
}
export interface FleetLaunchTemplateConfigRequest {
  LaunchTemplateSpecification?:
    | FleetLaunchTemplateSpecificationRequest
    | undefined;
  Overrides?: FleetLaunchTemplateOverridesRequest[] | undefined;
}
export declare const FleetOnDemandAllocationStrategy: {
  readonly LOWEST_PRICE: "lowest-price";
  readonly PRIORITIZED: "prioritized";
};
export type FleetOnDemandAllocationStrategy =
  (typeof FleetOnDemandAllocationStrategy)[keyof typeof FleetOnDemandAllocationStrategy];
export declare const FleetCapacityReservationUsageStrategy: {
  readonly USE_CAPACITY_RESERVATIONS_FIRST: "use-capacity-reservations-first";
};
export type FleetCapacityReservationUsageStrategy =
  (typeof FleetCapacityReservationUsageStrategy)[keyof typeof FleetCapacityReservationUsageStrategy];
export interface CapacityReservationOptionsRequest {
  UsageStrategy?: FleetCapacityReservationUsageStrategy | undefined;
}
export interface OnDemandOptionsRequest {
  AllocationStrategy?: FleetOnDemandAllocationStrategy | undefined;
  CapacityReservationOptions?: CapacityReservationOptionsRequest | undefined;
  SingleInstanceType?: boolean | undefined;
  SingleAvailabilityZone?: boolean | undefined;
  MinTargetCapacity?: number | undefined;
  MaxTotalPrice?: string | undefined;
}
export declare const SpotAllocationStrategy: {
  readonly CAPACITY_OPTIMIZED: "capacity-optimized";
  readonly CAPACITY_OPTIMIZED_PRIORITIZED: "capacity-optimized-prioritized";
  readonly DIVERSIFIED: "diversified";
  readonly LOWEST_PRICE: "lowest-price";
  readonly PRICE_CAPACITY_OPTIMIZED: "price-capacity-optimized";
};
export type SpotAllocationStrategy =
  (typeof SpotAllocationStrategy)[keyof typeof SpotAllocationStrategy];
export declare const SpotInstanceInterruptionBehavior: {
  readonly hibernate: "hibernate";
  readonly stop: "stop";
  readonly terminate: "terminate";
};
export type SpotInstanceInterruptionBehavior =
  (typeof SpotInstanceInterruptionBehavior)[keyof typeof SpotInstanceInterruptionBehavior];
export declare const FleetReplacementStrategy: {
  readonly LAUNCH: "launch";
  readonly LAUNCH_BEFORE_TERMINATE: "launch-before-terminate";
};
export type FleetReplacementStrategy =
  (typeof FleetReplacementStrategy)[keyof typeof FleetReplacementStrategy];
export interface FleetSpotCapacityRebalanceRequest {
  ReplacementStrategy?: FleetReplacementStrategy | undefined;
  TerminationDelay?: number | undefined;
}
export interface FleetSpotMaintenanceStrategiesRequest {
  CapacityRebalance?: FleetSpotCapacityRebalanceRequest | undefined;
}
export interface SpotOptionsRequest {
  AllocationStrategy?: SpotAllocationStrategy | undefined;
  MaintenanceStrategies?: FleetSpotMaintenanceStrategiesRequest | undefined;
  InstanceInterruptionBehavior?: SpotInstanceInterruptionBehavior | undefined;
  InstancePoolsToUseCount?: number | undefined;
  SingleInstanceType?: boolean | undefined;
  SingleAvailabilityZone?: boolean | undefined;
  MinTargetCapacity?: number | undefined;
  MaxTotalPrice?: string | undefined;
}
export declare const DefaultTargetCapacityType: {
  readonly CAPACITY_BLOCK: "capacity-block";
  readonly ON_DEMAND: "on-demand";
  readonly SPOT: "spot";
};
export type DefaultTargetCapacityType =
  (typeof DefaultTargetCapacityType)[keyof typeof DefaultTargetCapacityType];
export declare const TargetCapacityUnitType: {
  readonly MEMORY_MIB: "memory-mib";
  readonly UNITS: "units";
  readonly VCPU: "vcpu";
};
export type TargetCapacityUnitType =
  (typeof TargetCapacityUnitType)[keyof typeof TargetCapacityUnitType];
export interface TargetCapacitySpecificationRequest {
  TotalTargetCapacity: number | undefined;
  OnDemandTargetCapacity?: number | undefined;
  SpotTargetCapacity?: number | undefined;
  DefaultTargetCapacityType?: DefaultTargetCapacityType | undefined;
  TargetCapacityUnitType?: TargetCapacityUnitType | undefined;
}
export declare const FleetType: {
  readonly INSTANT: "instant";
  readonly MAINTAIN: "maintain";
  readonly REQUEST: "request";
};
export type FleetType = (typeof FleetType)[keyof typeof FleetType];
export interface CreateFleetRequest {
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  SpotOptions?: SpotOptionsRequest | undefined;
  OnDemandOptions?: OnDemandOptionsRequest | undefined;
  ExcessCapacityTerminationPolicy?:
    | FleetExcessCapacityTerminationPolicy
    | undefined;
  LaunchTemplateConfigs: FleetLaunchTemplateConfigRequest[] | undefined;
  TargetCapacitySpecification: TargetCapacitySpecificationRequest | undefined;
  TerminateInstancesWithExpiration?: boolean | undefined;
  Type?: FleetType | undefined;
  ValidFrom?: Date | undefined;
  ValidUntil?: Date | undefined;
  ReplaceUnhealthyInstances?: boolean | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  Context?: string | undefined;
}
export interface FleetLaunchTemplateSpecification {
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  Version?: string | undefined;
}
export interface EbsBlockDeviceResponse {
  Encrypted?: boolean | undefined;
  DeleteOnTermination?: boolean | undefined;
  Iops?: number | undefined;
  Throughput?: number | undefined;
  KmsKeyId?: string | undefined;
  SnapshotId?: string | undefined;
  VolumeSize?: number | undefined;
  VolumeType?: VolumeType | undefined;
}
export interface BlockDeviceMappingResponse {
  DeviceName?: string | undefined;
  VirtualName?: string | undefined;
  Ebs?: EbsBlockDeviceResponse | undefined;
  NoDevice?: string | undefined;
}
export interface BaselineEbsBandwidthMbps {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface PerformanceFactorReference {
  InstanceFamily?: string | undefined;
}
export interface CpuPerformanceFactor {
  References?: PerformanceFactorReference[] | undefined;
}
export interface BaselinePerformanceFactors {
  Cpu?: CpuPerformanceFactor | undefined;
}
export interface MemoryGiBPerVCpu {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface MemoryMiB {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface NetworkBandwidthGbps {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface NetworkInterfaceCount {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface TotalLocalStorageGB {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface VCpuCountRange {
  Min?: number | undefined;
  Max?: number | undefined;
}
export interface InstanceRequirements {
  VCpuCount?: VCpuCountRange | undefined;
  MemoryMiB?: MemoryMiB | undefined;
  CpuManufacturers?: CpuManufacturer[] | undefined;
  MemoryGiBPerVCpu?: MemoryGiBPerVCpu | undefined;
  ExcludedInstanceTypes?: string[] | undefined;
  InstanceGenerations?: InstanceGeneration[] | undefined;
  SpotMaxPricePercentageOverLowestPrice?: number | undefined;
  OnDemandMaxPricePercentageOverLowestPrice?: number | undefined;
  BareMetal?: BareMetal | undefined;
  BurstablePerformance?: BurstablePerformance | undefined;
  RequireHibernateSupport?: boolean | undefined;
  NetworkInterfaceCount?: NetworkInterfaceCount | undefined;
  LocalStorage?: LocalStorage | undefined;
  LocalStorageTypes?: LocalStorageType[] | undefined;
  TotalLocalStorageGB?: TotalLocalStorageGB | undefined;
  BaselineEbsBandwidthMbps?: BaselineEbsBandwidthMbps | undefined;
  AcceleratorTypes?: AcceleratorType[] | undefined;
  AcceleratorCount?: AcceleratorCount | undefined;
  AcceleratorManufacturers?: AcceleratorManufacturer[] | undefined;
  AcceleratorNames?: AcceleratorName[] | undefined;
  AcceleratorTotalMemoryMiB?: AcceleratorTotalMemoryMiB | undefined;
  NetworkBandwidthGbps?: NetworkBandwidthGbps | undefined;
  AllowedInstanceTypes?: string[] | undefined;
  MaxSpotPriceAsPercentageOfOptimalOnDemandPrice?: number | undefined;
  BaselinePerformanceFactors?: BaselinePerformanceFactors | undefined;
}
export interface PlacementResponse {
  GroupName?: string | undefined;
}
export interface FleetLaunchTemplateOverrides {
  InstanceType?: _InstanceType | undefined;
  MaxPrice?: string | undefined;
  SubnetId?: string | undefined;
  AvailabilityZone?: string | undefined;
  WeightedCapacity?: number | undefined;
  Priority?: number | undefined;
  Placement?: PlacementResponse | undefined;
  InstanceRequirements?: InstanceRequirements | undefined;
  ImageId?: string | undefined;
  BlockDeviceMappings?: BlockDeviceMappingResponse[] | undefined;
}
export interface LaunchTemplateAndOverridesResponse {
  LaunchTemplateSpecification?: FleetLaunchTemplateSpecification | undefined;
  Overrides?: FleetLaunchTemplateOverrides | undefined;
}
export declare const InstanceLifecycle: {
  readonly ON_DEMAND: "on-demand";
  readonly SPOT: "spot";
};
export type InstanceLifecycle =
  (typeof InstanceLifecycle)[keyof typeof InstanceLifecycle];
export interface CreateFleetError {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse | undefined;
  Lifecycle?: InstanceLifecycle | undefined;
  ErrorCode?: string | undefined;
  ErrorMessage?: string | undefined;
}
export declare const PlatformValues: {
  readonly Windows: "Windows";
};
export type PlatformValues =
  (typeof PlatformValues)[keyof typeof PlatformValues];
export interface CreateFleetInstance {
  LaunchTemplateAndOverrides?: LaunchTemplateAndOverridesResponse | undefined;
  Lifecycle?: InstanceLifecycle | undefined;
  InstanceIds?: string[] | undefined;
  InstanceType?: _InstanceType | undefined;
  Platform?: PlatformValues | undefined;
}
export interface CreateFleetResult {
  FleetId?: string | undefined;
  Errors?: CreateFleetError[] | undefined;
  Instances?: CreateFleetInstance[] | undefined;
}
export declare const DestinationFileFormat: {
  readonly parquet: "parquet";
  readonly plain_text: "plain-text";
};
export type DestinationFileFormat =
  (typeof DestinationFileFormat)[keyof typeof DestinationFileFormat];
export interface DestinationOptionsRequest {
  FileFormat?: DestinationFileFormat | undefined;
  HiveCompatiblePartitions?: boolean | undefined;
  PerHourPartition?: boolean | undefined;
}
export declare const LogDestinationType: {
  readonly cloud_watch_logs: "cloud-watch-logs";
  readonly kinesis_data_firehose: "kinesis-data-firehose";
  readonly s3: "s3";
};
export type LogDestinationType =
  (typeof LogDestinationType)[keyof typeof LogDestinationType];
export declare const FlowLogsResourceType: {
  readonly NetworkInterface: "NetworkInterface";
  readonly Subnet: "Subnet";
  readonly TransitGateway: "TransitGateway";
  readonly TransitGatewayAttachment: "TransitGatewayAttachment";
  readonly VPC: "VPC";
};
export type FlowLogsResourceType =
  (typeof FlowLogsResourceType)[keyof typeof FlowLogsResourceType];
export declare const TrafficType: {
  readonly ACCEPT: "ACCEPT";
  readonly ALL: "ALL";
  readonly REJECT: "REJECT";
};
export type TrafficType = (typeof TrafficType)[keyof typeof TrafficType];
export interface CreateFlowLogsRequest {
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  DeliverLogsPermissionArn?: string | undefined;
  DeliverCrossAccountRole?: string | undefined;
  LogGroupName?: string | undefined;
  ResourceIds: string[] | undefined;
  ResourceType: FlowLogsResourceType | undefined;
  TrafficType?: TrafficType | undefined;
  LogDestinationType?: LogDestinationType | undefined;
  LogDestination?: string | undefined;
  LogFormat?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  MaxAggregationInterval?: number | undefined;
  DestinationOptions?: DestinationOptionsRequest | undefined;
}
export interface CreateFlowLogsResult {
  ClientToken?: string | undefined;
  FlowLogIds?: string[] | undefined;
  Unsuccessful?: UnsuccessfulItem[] | undefined;
}
export interface StorageLocation {
  Bucket?: string | undefined;
  Key?: string | undefined;
}
export interface CreateFpgaImageRequest {
  DryRun?: boolean | undefined;
  InputStorageLocation: StorageLocation | undefined;
  LogsStorageLocation?: StorageLocation | undefined;
  Description?: string | undefined;
  Name?: string | undefined;
  ClientToken?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface CreateFpgaImageResult {
  FpgaImageId?: string | undefined;
  FpgaImageGlobalId?: string | undefined;
}
export interface EbsBlockDevice {
  DeleteOnTermination?: boolean | undefined;
  Iops?: number | undefined;
  SnapshotId?: string | undefined;
  VolumeSize?: number | undefined;
  VolumeType?: VolumeType | undefined;
  KmsKeyId?: string | undefined;
  Throughput?: number | undefined;
  OutpostArn?: string | undefined;
  AvailabilityZone?: string | undefined;
  Encrypted?: boolean | undefined;
  VolumeInitializationRate?: number | undefined;
  AvailabilityZoneId?: string | undefined;
}
export interface BlockDeviceMapping {
  Ebs?: EbsBlockDevice | undefined;
  NoDevice?: string | undefined;
  DeviceName?: string | undefined;
  VirtualName?: string | undefined;
}
export declare const SnapshotLocationEnum: {
  readonly LOCAL: "local";
  readonly REGIONAL: "regional";
};
export type SnapshotLocationEnum =
  (typeof SnapshotLocationEnum)[keyof typeof SnapshotLocationEnum];
export interface CreateImageRequest {
  TagSpecifications?: TagSpecification[] | undefined;
  SnapshotLocation?: SnapshotLocationEnum | undefined;
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  Name: string | undefined;
  Description?: string | undefined;
  NoReboot?: boolean | undefined;
  BlockDeviceMappings?: BlockDeviceMapping[] | undefined;
}
export interface CreateImageResult {
  ImageId?: string | undefined;
}
export interface CreateInstanceConnectEndpointRequest {
  DryRun?: boolean | undefined;
  SubnetId: string | undefined;
  SecurityGroupIds?: string[] | undefined;
  PreserveClientIp?: boolean | undefined;
  ClientToken?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export declare const Ec2InstanceConnectEndpointState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
};
export type Ec2InstanceConnectEndpointState =
  (typeof Ec2InstanceConnectEndpointState)[keyof typeof Ec2InstanceConnectEndpointState];
export interface Ec2InstanceConnectEndpoint {
  OwnerId?: string | undefined;
  InstanceConnectEndpointId?: string | undefined;
  InstanceConnectEndpointArn?: string | undefined;
  State?: Ec2InstanceConnectEndpointState | undefined;
  StateMessage?: string | undefined;
  DnsName?: string | undefined;
  FipsDnsName?: string | undefined;
  NetworkInterfaceIds?: string[] | undefined;
  VpcId?: string | undefined;
  AvailabilityZone?: string | undefined;
  CreatedAt?: Date | undefined;
  SubnetId?: string | undefined;
  PreserveClientIp?: boolean | undefined;
  SecurityGroupIds?: string[] | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateInstanceConnectEndpointResult {
  InstanceConnectEndpoint?: Ec2InstanceConnectEndpoint | undefined;
  ClientToken?: string | undefined;
}
export interface InstanceEventWindowTimeRangeRequest {
  StartWeekDay?: WeekDay | undefined;
  StartHour?: number | undefined;
  EndWeekDay?: WeekDay | undefined;
  EndHour?: number | undefined;
}
export interface CreateInstanceEventWindowRequest {
  DryRun?: boolean | undefined;
  Name?: string | undefined;
  TimeRanges?: InstanceEventWindowTimeRangeRequest[] | undefined;
  CronExpression?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface CreateInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow | undefined;
}
export declare const ContainerFormat: {
  readonly ova: "ova";
};
export type ContainerFormat =
  (typeof ContainerFormat)[keyof typeof ContainerFormat];
export declare const DiskImageFormat: {
  readonly RAW: "RAW";
  readonly VHD: "VHD";
  readonly VMDK: "VMDK";
};
export type DiskImageFormat =
  (typeof DiskImageFormat)[keyof typeof DiskImageFormat];
export interface ExportToS3TaskSpecification {
  DiskImageFormat?: DiskImageFormat | undefined;
  ContainerFormat?: ContainerFormat | undefined;
  S3Bucket?: string | undefined;
  S3Prefix?: string | undefined;
}
export declare const ExportEnvironment: {
  readonly citrix: "citrix";
  readonly microsoft: "microsoft";
  readonly vmware: "vmware";
};
export type ExportEnvironment =
  (typeof ExportEnvironment)[keyof typeof ExportEnvironment];
export interface CreateInstanceExportTaskRequest {
  TagSpecifications?: TagSpecification[] | undefined;
  Description?: string | undefined;
  InstanceId: string | undefined;
  TargetEnvironment: ExportEnvironment | undefined;
  ExportToS3Task: ExportToS3TaskSpecification | undefined;
}
export interface ExportToS3Task {
  ContainerFormat?: ContainerFormat | undefined;
  DiskImageFormat?: DiskImageFormat | undefined;
  S3Bucket?: string | undefined;
  S3Key?: string | undefined;
}
export interface InstanceExportDetails {
  InstanceId?: string | undefined;
  TargetEnvironment?: ExportEnvironment | undefined;
}
export declare const ExportTaskState: {
  readonly active: "active";
  readonly cancelled: "cancelled";
  readonly cancelling: "cancelling";
  readonly completed: "completed";
};
export type ExportTaskState =
  (typeof ExportTaskState)[keyof typeof ExportTaskState];
export interface ExportTask {
  Description?: string | undefined;
  ExportTaskId?: string | undefined;
  ExportToS3Task?: ExportToS3Task | undefined;
  InstanceExportDetails?: InstanceExportDetails | undefined;
  State?: ExportTaskState | undefined;
  StatusMessage?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateInstanceExportTaskResult {
  ExportTask?: ExportTask | undefined;
}
export interface CreateInternetGatewayRequest {
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
}
export interface InternetGateway {
  Attachments?: InternetGatewayAttachment[] | undefined;
  InternetGatewayId?: string | undefined;
  OwnerId?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateInternetGatewayResult {
  InternetGateway?: InternetGateway | undefined;
}
export declare const IpamMeteredAccount: {
  readonly ipam_owner: "ipam-owner";
  readonly resource_owner: "resource-owner";
};
export type IpamMeteredAccount =
  (typeof IpamMeteredAccount)[keyof typeof IpamMeteredAccount];
export declare const IpamTier: {
  readonly advanced: "advanced";
  readonly free: "free";
};
export type IpamTier = (typeof IpamTier)[keyof typeof IpamTier];
export interface CreateIpamRequest {
  DryRun?: boolean | undefined;
  Description?: string | undefined;
  OperatingRegions?: AddIpamOperatingRegion[] | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
  Tier?: IpamTier | undefined;
  EnablePrivateGua?: boolean | undefined;
  MeteredAccount?: IpamMeteredAccount | undefined;
}
export interface IpamOperatingRegion {
  RegionName?: string | undefined;
}
export declare const IpamState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
  readonly isolate_complete: "isolate-complete";
  readonly isolate_in_progress: "isolate-in-progress";
  readonly modify_complete: "modify-complete";
  readonly modify_failed: "modify-failed";
  readonly modify_in_progress: "modify-in-progress";
  readonly restore_in_progress: "restore-in-progress";
};
export type IpamState = (typeof IpamState)[keyof typeof IpamState];
export interface Ipam {
  OwnerId?: string | undefined;
  IpamId?: string | undefined;
  IpamArn?: string | undefined;
  IpamRegion?: string | undefined;
  PublicDefaultScopeId?: string | undefined;
  PrivateDefaultScopeId?: string | undefined;
  ScopeCount?: number | undefined;
  Description?: string | undefined;
  OperatingRegions?: IpamOperatingRegion[] | undefined;
  State?: IpamState | undefined;
  Tags?: Tag[] | undefined;
  DefaultResourceDiscoveryId?: string | undefined;
  DefaultResourceDiscoveryAssociationId?: string | undefined;
  ResourceDiscoveryAssociationCount?: number | undefined;
  StateMessage?: string | undefined;
  Tier?: IpamTier | undefined;
  EnablePrivateGua?: boolean | undefined;
  MeteredAccount?: IpamMeteredAccount | undefined;
}
export interface CreateIpamResult {
  Ipam?: Ipam | undefined;
}
export interface CreateIpamExternalResourceVerificationTokenRequest {
  DryRun?: boolean | undefined;
  IpamId: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
}
export declare const IpamExternalResourceVerificationTokenState: {
  readonly CREATE_COMPLETE: "create-complete";
  readonly CREATE_FAILED: "create-failed";
  readonly CREATE_IN_PROGRESS: "create-in-progress";
  readonly DELETE_COMPLETE: "delete-complete";
  readonly DELETE_FAILED: "delete-failed";
  readonly DELETE_IN_PROGRESS: "delete-in-progress";
};
export type IpamExternalResourceVerificationTokenState =
  (typeof IpamExternalResourceVerificationTokenState)[keyof typeof IpamExternalResourceVerificationTokenState];
export declare const TokenState: {
  readonly expired: "expired";
  readonly valid: "valid";
};
export type TokenState = (typeof TokenState)[keyof typeof TokenState];
export interface IpamExternalResourceVerificationToken {
  IpamExternalResourceVerificationTokenId?: string | undefined;
  IpamExternalResourceVerificationTokenArn?: string | undefined;
  IpamId?: string | undefined;
  IpamArn?: string | undefined;
  IpamRegion?: string | undefined;
  TokenValue?: string | undefined;
  TokenName?: string | undefined;
  NotAfter?: Date | undefined;
  Status?: TokenState | undefined;
  Tags?: Tag[] | undefined;
  State?: IpamExternalResourceVerificationTokenState | undefined;
}
export interface CreateIpamExternalResourceVerificationTokenResult {
  IpamExternalResourceVerificationToken?:
    | IpamExternalResourceVerificationToken
    | undefined;
}
export interface RequestIpamResourceTag {
  Key?: string | undefined;
  Value?: string | undefined;
}
export declare const IpamPoolAwsService: {
  readonly ec2: "ec2";
};
export type IpamPoolAwsService =
  (typeof IpamPoolAwsService)[keyof typeof IpamPoolAwsService];
export declare const IpamPoolPublicIpSource: {
  readonly amazon: "amazon";
  readonly byoip: "byoip";
};
export type IpamPoolPublicIpSource =
  (typeof IpamPoolPublicIpSource)[keyof typeof IpamPoolPublicIpSource];
export declare const IpamPoolSourceResourceType: {
  readonly vpc: "vpc";
};
export type IpamPoolSourceResourceType =
  (typeof IpamPoolSourceResourceType)[keyof typeof IpamPoolSourceResourceType];
export interface IpamPoolSourceResourceRequest {
  ResourceId?: string | undefined;
  ResourceType?: IpamPoolSourceResourceType | undefined;
  ResourceRegion?: string | undefined;
  ResourceOwner?: string | undefined;
}
export interface CreateIpamPoolRequest {
  DryRun?: boolean | undefined;
  IpamScopeId: string | undefined;
  Locale?: string | undefined;
  SourceIpamPoolId?: string | undefined;
  Description?: string | undefined;
  AddressFamily: AddressFamily | undefined;
  AutoImport?: boolean | undefined;
  PubliclyAdvertisable?: boolean | undefined;
  AllocationMinNetmaskLength?: number | undefined;
  AllocationMaxNetmaskLength?: number | undefined;
  AllocationDefaultNetmaskLength?: number | undefined;
  AllocationResourceTags?: RequestIpamResourceTag[] | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
  AwsService?: IpamPoolAwsService | undefined;
  PublicIpSource?: IpamPoolPublicIpSource | undefined;
  SourceResource?: IpamPoolSourceResourceRequest | undefined;
}
export interface IpamResourceTag {
  Key?: string | undefined;
  Value?: string | undefined;
}
export declare const IpamScopeType: {
  readonly private: "private";
  readonly public: "public";
};
export type IpamScopeType = (typeof IpamScopeType)[keyof typeof IpamScopeType];
export interface IpamPoolSourceResource {
  ResourceId?: string | undefined;
  ResourceType?: IpamPoolSourceResourceType | undefined;
  ResourceRegion?: string | undefined;
  ResourceOwner?: string | undefined;
}
export declare const IpamPoolState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
  readonly isolate_complete: "isolate-complete";
  readonly isolate_in_progress: "isolate-in-progress";
  readonly modify_complete: "modify-complete";
  readonly modify_failed: "modify-failed";
  readonly modify_in_progress: "modify-in-progress";
  readonly restore_in_progress: "restore-in-progress";
};
export type IpamPoolState = (typeof IpamPoolState)[keyof typeof IpamPoolState];
export interface IpamPool {
  OwnerId?: string | undefined;
  IpamPoolId?: string | undefined;
  SourceIpamPoolId?: string | undefined;
  IpamPoolArn?: string | undefined;
  IpamScopeArn?: string | undefined;
  IpamScopeType?: IpamScopeType | undefined;
  IpamArn?: string | undefined;
  IpamRegion?: string | undefined;
  Locale?: string | undefined;
  PoolDepth?: number | undefined;
  State?: IpamPoolState | undefined;
  StateMessage?: string | undefined;
  Description?: string | undefined;
  AutoImport?: boolean | undefined;
  PubliclyAdvertisable?: boolean | undefined;
  AddressFamily?: AddressFamily | undefined;
  AllocationMinNetmaskLength?: number | undefined;
  AllocationMaxNetmaskLength?: number | undefined;
  AllocationDefaultNetmaskLength?: number | undefined;
  AllocationResourceTags?: IpamResourceTag[] | undefined;
  Tags?: Tag[] | undefined;
  AwsService?: IpamPoolAwsService | undefined;
  PublicIpSource?: IpamPoolPublicIpSource | undefined;
  SourceResource?: IpamPoolSourceResource | undefined;
}
export interface CreateIpamPoolResult {
  IpamPool?: IpamPool | undefined;
}
export interface CreateIpamResourceDiscoveryRequest {
  DryRun?: boolean | undefined;
  Description?: string | undefined;
  OperatingRegions?: AddIpamOperatingRegion[] | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
}
export interface IpamOrganizationalUnitExclusion {
  OrganizationsEntityPath?: string | undefined;
}
export declare const IpamResourceDiscoveryState: {
  readonly CREATE_COMPLETE: "create-complete";
  readonly CREATE_FAILED: "create-failed";
  readonly CREATE_IN_PROGRESS: "create-in-progress";
  readonly DELETE_COMPLETE: "delete-complete";
  readonly DELETE_FAILED: "delete-failed";
  readonly DELETE_IN_PROGRESS: "delete-in-progress";
  readonly ISOLATE_COMPLETE: "isolate-complete";
  readonly ISOLATE_IN_PROGRESS: "isolate-in-progress";
  readonly MODIFY_COMPLETE: "modify-complete";
  readonly MODIFY_FAILED: "modify-failed";
  readonly MODIFY_IN_PROGRESS: "modify-in-progress";
  readonly RESTORE_IN_PROGRESS: "restore-in-progress";
};
export type IpamResourceDiscoveryState =
  (typeof IpamResourceDiscoveryState)[keyof typeof IpamResourceDiscoveryState];
export interface IpamResourceDiscovery {
  OwnerId?: string | undefined;
  IpamResourceDiscoveryId?: string | undefined;
  IpamResourceDiscoveryArn?: string | undefined;
  IpamResourceDiscoveryRegion?: string | undefined;
  Description?: string | undefined;
  OperatingRegions?: IpamOperatingRegion[] | undefined;
  IsDefault?: boolean | undefined;
  State?: IpamResourceDiscoveryState | undefined;
  Tags?: Tag[] | undefined;
  OrganizationalUnitExclusions?: IpamOrganizationalUnitExclusion[] | undefined;
}
export interface CreateIpamResourceDiscoveryResult {
  IpamResourceDiscovery?: IpamResourceDiscovery | undefined;
}
export interface CreateIpamScopeRequest {
  DryRun?: boolean | undefined;
  IpamId: string | undefined;
  Description?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  ClientToken?: string | undefined;
}
export declare const IpamScopeState: {
  readonly create_complete: "create-complete";
  readonly create_failed: "create-failed";
  readonly create_in_progress: "create-in-progress";
  readonly delete_complete: "delete-complete";
  readonly delete_failed: "delete-failed";
  readonly delete_in_progress: "delete-in-progress";
  readonly isolate_complete: "isolate-complete";
  readonly isolate_in_progress: "isolate-in-progress";
  readonly modify_complete: "modify-complete";
  readonly modify_failed: "modify-failed";
  readonly modify_in_progress: "modify-in-progress";
  readonly restore_in_progress: "restore-in-progress";
};
export type IpamScopeState =
  (typeof IpamScopeState)[keyof typeof IpamScopeState];
export interface IpamScope {
  OwnerId?: string | undefined;
  IpamScopeId?: string | undefined;
  IpamScopeArn?: string | undefined;
  IpamArn?: string | undefined;
  IpamRegion?: string | undefined;
  IpamScopeType?: IpamScopeType | undefined;
  IsDefault?: boolean | undefined;
  Description?: string | undefined;
  PoolCount?: number | undefined;
  State?: IpamScopeState | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateIpamScopeResult {
  IpamScope?: IpamScope | undefined;
}
export declare const KeyFormat: {
  readonly pem: "pem";
  readonly ppk: "ppk";
};
export type KeyFormat = (typeof KeyFormat)[keyof typeof KeyFormat];
export declare const KeyType: {
  readonly ed25519: "ed25519";
  readonly rsa: "rsa";
};
export type KeyType = (typeof KeyType)[keyof typeof KeyType];
export interface CreateKeyPairRequest {
  KeyName: string | undefined;
  KeyType?: KeyType | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  KeyFormat?: KeyFormat | undefined;
  DryRun?: boolean | undefined;
}
export interface KeyPair {
  KeyPairId?: string | undefined;
  Tags?: Tag[] | undefined;
  KeyName?: string | undefined;
  KeyFingerprint?: string | undefined;
  KeyMaterial?: string | undefined;
}
export interface LaunchTemplateEbsBlockDeviceRequest {
  Encrypted?: boolean | undefined;
  DeleteOnTermination?: boolean | undefined;
  Iops?: number | undefined;
  KmsKeyId?: string | undefined;
  SnapshotId?: string | undefined;
  VolumeSize?: number | undefined;
  VolumeType?: VolumeType | undefined;
  Throughput?: number | undefined;
  VolumeInitializationRate?: number | undefined;
}
export interface LaunchTemplateBlockDeviceMappingRequest {
  DeviceName?: string | undefined;
  VirtualName?: string | undefined;
  Ebs?: LaunchTemplateEbsBlockDeviceRequest | undefined;
  NoDevice?: string | undefined;
}
export declare const CapacityReservationPreference: {
  readonly capacity_reservations_only: "capacity-reservations-only";
  readonly none: "none";
  readonly open: "open";
};
export type CapacityReservationPreference =
  (typeof CapacityReservationPreference)[keyof typeof CapacityReservationPreference];
export interface CapacityReservationTarget {
  CapacityReservationId?: string | undefined;
  CapacityReservationResourceGroupArn?: string | undefined;
}
export interface LaunchTemplateCapacityReservationSpecificationRequest {
  CapacityReservationPreference?: CapacityReservationPreference | undefined;
  CapacityReservationTarget?: CapacityReservationTarget | undefined;
}
export declare const AmdSevSnpSpecification: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type AmdSevSnpSpecification =
  (typeof AmdSevSnpSpecification)[keyof typeof AmdSevSnpSpecification];
export interface LaunchTemplateCpuOptionsRequest {
  CoreCount?: number | undefined;
  ThreadsPerCore?: number | undefined;
  AmdSevSnp?: AmdSevSnpSpecification | undefined;
}
export interface CreditSpecificationRequest {
  CpuCredits: string | undefined;
}
export interface ElasticGpuSpecification {
  Type: string | undefined;
}
export interface LaunchTemplateElasticInferenceAccelerator {
  Type: string | undefined;
  Count?: number | undefined;
}
export interface LaunchTemplateEnclaveOptionsRequest {
  Enabled?: boolean | undefined;
}
export interface LaunchTemplateHibernationOptionsRequest {
  Configured?: boolean | undefined;
}
export interface LaunchTemplateIamInstanceProfileSpecificationRequest {
  Arn?: string | undefined;
  Name?: string | undefined;
}
export declare const ShutdownBehavior: {
  readonly stop: "stop";
  readonly terminate: "terminate";
};
export type ShutdownBehavior =
  (typeof ShutdownBehavior)[keyof typeof ShutdownBehavior];
export declare const MarketType: {
  readonly capacity_block: "capacity-block";
  readonly spot: "spot";
};
export type MarketType = (typeof MarketType)[keyof typeof MarketType];
export declare const InstanceInterruptionBehavior: {
  readonly hibernate: "hibernate";
  readonly stop: "stop";
  readonly terminate: "terminate";
};
export type InstanceInterruptionBehavior =
  (typeof InstanceInterruptionBehavior)[keyof typeof InstanceInterruptionBehavior];
export declare const SpotInstanceType: {
  readonly one_time: "one-time";
  readonly persistent: "persistent";
};
export type SpotInstanceType =
  (typeof SpotInstanceType)[keyof typeof SpotInstanceType];
export interface LaunchTemplateSpotMarketOptionsRequest {
  MaxPrice?: string | undefined;
  SpotInstanceType?: SpotInstanceType | undefined;
  BlockDurationMinutes?: number | undefined;
  ValidUntil?: Date | undefined;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior | undefined;
}
export interface LaunchTemplateInstanceMarketOptionsRequest {
  MarketType?: MarketType | undefined;
  SpotOptions?: LaunchTemplateSpotMarketOptionsRequest | undefined;
}
export interface LaunchTemplateLicenseConfigurationRequest {
  LicenseConfigurationArn?: string | undefined;
}
export declare const LaunchTemplateAutoRecoveryState: {
  readonly default: "default";
  readonly disabled: "disabled";
};
export type LaunchTemplateAutoRecoveryState =
  (typeof LaunchTemplateAutoRecoveryState)[keyof typeof LaunchTemplateAutoRecoveryState];
export interface LaunchTemplateInstanceMaintenanceOptionsRequest {
  AutoRecovery?: LaunchTemplateAutoRecoveryState | undefined;
}
export declare const LaunchTemplateInstanceMetadataEndpointState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type LaunchTemplateInstanceMetadataEndpointState =
  (typeof LaunchTemplateInstanceMetadataEndpointState)[keyof typeof LaunchTemplateInstanceMetadataEndpointState];
export declare const LaunchTemplateInstanceMetadataProtocolIpv6: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type LaunchTemplateInstanceMetadataProtocolIpv6 =
  (typeof LaunchTemplateInstanceMetadataProtocolIpv6)[keyof typeof LaunchTemplateInstanceMetadataProtocolIpv6];
export declare const LaunchTemplateHttpTokensState: {
  readonly optional: "optional";
  readonly required: "required";
};
export type LaunchTemplateHttpTokensState =
  (typeof LaunchTemplateHttpTokensState)[keyof typeof LaunchTemplateHttpTokensState];
export declare const LaunchTemplateInstanceMetadataTagsState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
};
export type LaunchTemplateInstanceMetadataTagsState =
  (typeof LaunchTemplateInstanceMetadataTagsState)[keyof typeof LaunchTemplateInstanceMetadataTagsState];
export interface LaunchTemplateInstanceMetadataOptionsRequest {
  HttpTokens?: LaunchTemplateHttpTokensState | undefined;
  HttpPutResponseHopLimit?: number | undefined;
  HttpEndpoint?: LaunchTemplateInstanceMetadataEndpointState | undefined;
  HttpProtocolIpv6?: LaunchTemplateInstanceMetadataProtocolIpv6 | undefined;
  InstanceMetadataTags?: LaunchTemplateInstanceMetadataTagsState | undefined;
}
export interface LaunchTemplatesMonitoringRequest {
  Enabled?: boolean | undefined;
}
export interface ConnectionTrackingSpecificationRequest {
  TcpEstablishedTimeout?: number | undefined;
  UdpStreamTimeout?: number | undefined;
  UdpTimeout?: number | undefined;
}
export interface EnaSrdUdpSpecificationRequest {
  EnaSrdUdpEnabled?: boolean | undefined;
}
export interface EnaSrdSpecificationRequest {
  EnaSrdEnabled?: boolean | undefined;
  EnaSrdUdpSpecification?: EnaSrdUdpSpecificationRequest | undefined;
}
export interface Ipv4PrefixSpecificationRequest {
  Ipv4Prefix?: string | undefined;
}
export interface InstanceIpv6AddressRequest {
  Ipv6Address?: string | undefined;
}
export interface Ipv6PrefixSpecificationRequest {
  Ipv6Prefix?: string | undefined;
}
export interface PrivateIpAddressSpecification {
  Primary?: boolean | undefined;
  PrivateIpAddress?: string | undefined;
}
export interface LaunchTemplateInstanceNetworkInterfaceSpecificationRequest {
  AssociateCarrierIpAddress?: boolean | undefined;
  AssociatePublicIpAddress?: boolean | undefined;
  DeleteOnTermination?: boolean | undefined;
  Description?: string | undefined;
  DeviceIndex?: number | undefined;
  Groups?: string[] | undefined;
  InterfaceType?: string | undefined;
  Ipv6AddressCount?: number | undefined;
  Ipv6Addresses?: InstanceIpv6AddressRequest[] | undefined;
  NetworkInterfaceId?: string | undefined;
  PrivateIpAddress?: string | undefined;
  PrivateIpAddresses?: PrivateIpAddressSpecification[] | undefined;
  SecondaryPrivateIpAddressCount?: number | undefined;
  SubnetId?: string | undefined;
  NetworkCardIndex?: number | undefined;
  Ipv4Prefixes?: Ipv4PrefixSpecificationRequest[] | undefined;
  Ipv4PrefixCount?: number | undefined;
  Ipv6Prefixes?: Ipv6PrefixSpecificationRequest[] | undefined;
  Ipv6PrefixCount?: number | undefined;
  PrimaryIpv6?: boolean | undefined;
  EnaSrdSpecification?: EnaSrdSpecificationRequest | undefined;
  ConnectionTrackingSpecification?:
    | ConnectionTrackingSpecificationRequest
    | undefined;
  EnaQueueCount?: number | undefined;
}
export declare const InstanceBandwidthWeighting: {
  readonly DEFAULT: "default";
  readonly EBS_1: "ebs-1";
  readonly VPC_1: "vpc-1";
};
export type InstanceBandwidthWeighting =
  (typeof InstanceBandwidthWeighting)[keyof typeof InstanceBandwidthWeighting];
export interface LaunchTemplateNetworkPerformanceOptionsRequest {
  BandwidthWeighting?: InstanceBandwidthWeighting | undefined;
}
export interface OperatorRequest {
  Principal?: string | undefined;
}
export interface LaunchTemplatePlacementRequest {
  AvailabilityZone?: string | undefined;
  Affinity?: string | undefined;
  GroupName?: string | undefined;
  HostId?: string | undefined;
  Tenancy?: Tenancy | undefined;
  SpreadDomain?: string | undefined;
  HostResourceGroupArn?: string | undefined;
  PartitionNumber?: number | undefined;
  GroupId?: string | undefined;
}
export interface LaunchTemplatePrivateDnsNameOptionsRequest {
  HostnameType?: HostnameType | undefined;
  EnableResourceNameDnsARecord?: boolean | undefined;
  EnableResourceNameDnsAAAARecord?: boolean | undefined;
}
export interface LaunchTemplateTagSpecificationRequest {
  ResourceType?: ResourceType | undefined;
  Tags?: Tag[] | undefined;
}
export interface RequestLaunchTemplateData {
  KernelId?: string | undefined;
  EbsOptimized?: boolean | undefined;
  IamInstanceProfile?:
    | LaunchTemplateIamInstanceProfileSpecificationRequest
    | undefined;
  BlockDeviceMappings?: LaunchTemplateBlockDeviceMappingRequest[] | undefined;
  NetworkInterfaces?:
    | LaunchTemplateInstanceNetworkInterfaceSpecificationRequest[]
    | undefined;
  ImageId?: string | undefined;
  InstanceType?: _InstanceType | undefined;
  KeyName?: string | undefined;
  Monitoring?: LaunchTemplatesMonitoringRequest | undefined;
  Placement?: LaunchTemplatePlacementRequest | undefined;
  RamDiskId?: string | undefined;
  DisableApiTermination?: boolean | undefined;
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior | undefined;
  UserData?: string | undefined;
  TagSpecifications?: LaunchTemplateTagSpecificationRequest[] | undefined;
  ElasticGpuSpecifications?: ElasticGpuSpecification[] | undefined;
  ElasticInferenceAccelerators?:
    | LaunchTemplateElasticInferenceAccelerator[]
    | undefined;
  SecurityGroupIds?: string[] | undefined;
  SecurityGroups?: string[] | undefined;
  InstanceMarketOptions?:
    | LaunchTemplateInstanceMarketOptionsRequest
    | undefined;
  CreditSpecification?: CreditSpecificationRequest | undefined;
  CpuOptions?: LaunchTemplateCpuOptionsRequest | undefined;
  CapacityReservationSpecification?:
    | LaunchTemplateCapacityReservationSpecificationRequest
    | undefined;
  LicenseSpecifications?:
    | LaunchTemplateLicenseConfigurationRequest[]
    | undefined;
  HibernationOptions?: LaunchTemplateHibernationOptionsRequest | undefined;
  MetadataOptions?: LaunchTemplateInstanceMetadataOptionsRequest | undefined;
  EnclaveOptions?: LaunchTemplateEnclaveOptionsRequest | undefined;
  InstanceRequirements?: InstanceRequirementsRequest | undefined;
  PrivateDnsNameOptions?:
    | LaunchTemplatePrivateDnsNameOptionsRequest
    | undefined;
  MaintenanceOptions?:
    | LaunchTemplateInstanceMaintenanceOptionsRequest
    | undefined;
  DisableApiStop?: boolean | undefined;
  Operator?: OperatorRequest | undefined;
  NetworkPerformanceOptions?:
    | LaunchTemplateNetworkPerformanceOptionsRequest
    | undefined;
}
export interface CreateLaunchTemplateRequest {
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  LaunchTemplateName: string | undefined;
  VersionDescription?: string | undefined;
  LaunchTemplateData: RequestLaunchTemplateData | undefined;
  Operator?: OperatorRequest | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface OperatorResponse {
  Managed?: boolean | undefined;
  Principal?: string | undefined;
}
export interface LaunchTemplate {
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  CreateTime?: Date | undefined;
  CreatedBy?: string | undefined;
  DefaultVersionNumber?: number | undefined;
  LatestVersionNumber?: number | undefined;
  Tags?: Tag[] | undefined;
  Operator?: OperatorResponse | undefined;
}
export interface ValidationError {
  Code?: string | undefined;
  Message?: string | undefined;
}
export interface ValidationWarning {
  Errors?: ValidationError[] | undefined;
}
export interface CreateLaunchTemplateResult {
  LaunchTemplate?: LaunchTemplate | undefined;
  Warning?: ValidationWarning | undefined;
}
export interface CreateLaunchTemplateVersionRequest {
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  SourceVersion?: string | undefined;
  VersionDescription?: string | undefined;
  LaunchTemplateData: RequestLaunchTemplateData | undefined;
  ResolveAlias?: boolean | undefined;
}
export interface LaunchTemplateEbsBlockDevice {
  Encrypted?: boolean | undefined;
  DeleteOnTermination?: boolean | undefined;
  Iops?: number | undefined;
  KmsKeyId?: string | undefined;
  SnapshotId?: string | undefined;
  VolumeSize?: number | undefined;
  VolumeType?: VolumeType | undefined;
  Throughput?: number | undefined;
  VolumeInitializationRate?: number | undefined;
}
export interface LaunchTemplateBlockDeviceMapping {
  DeviceName?: string | undefined;
  VirtualName?: string | undefined;
  Ebs?: LaunchTemplateEbsBlockDevice | undefined;
  NoDevice?: string | undefined;
}
export interface CapacityReservationTargetResponse {
  CapacityReservationId?: string | undefined;
  CapacityReservationResourceGroupArn?: string | undefined;
}
export interface LaunchTemplateCapacityReservationSpecificationResponse {
  CapacityReservationPreference?: CapacityReservationPreference | undefined;
  CapacityReservationTarget?: CapacityReservationTargetResponse | undefined;
}
export interface LaunchTemplateCpuOptions {
  CoreCount?: number | undefined;
  ThreadsPerCore?: number | undefined;
  AmdSevSnp?: AmdSevSnpSpecification | undefined;
}
export interface CreditSpecification {
  CpuCredits?: string | undefined;
}
export interface ElasticGpuSpecificationResponse {
  Type?: string | undefined;
}
export interface LaunchTemplateElasticInferenceAcceleratorResponse {
  Type?: string | undefined;
  Count?: number | undefined;
}
export interface LaunchTemplateEnclaveOptions {
  Enabled?: boolean | undefined;
}
export interface LaunchTemplateHibernationOptions {
  Configured?: boolean | undefined;
}
export interface LaunchTemplateIamInstanceProfileSpecification {
  Arn?: string | undefined;
  Name?: string | undefined;
}
export interface LaunchTemplateSpotMarketOptions {
  MaxPrice?: string | undefined;
  SpotInstanceType?: SpotInstanceType | undefined;
  BlockDurationMinutes?: number | undefined;
  ValidUntil?: Date | undefined;
  InstanceInterruptionBehavior?: InstanceInterruptionBehavior | undefined;
}
export interface LaunchTemplateInstanceMarketOptions {
  MarketType?: MarketType | undefined;
  SpotOptions?: LaunchTemplateSpotMarketOptions | undefined;
}
export interface LaunchTemplateLicenseConfiguration {
  LicenseConfigurationArn?: string | undefined;
}
export interface LaunchTemplateInstanceMaintenanceOptions {
  AutoRecovery?: LaunchTemplateAutoRecoveryState | undefined;
}
export declare const LaunchTemplateInstanceMetadataOptionsState: {
  readonly applied: "applied";
  readonly pending: "pending";
};
export type LaunchTemplateInstanceMetadataOptionsState =
  (typeof LaunchTemplateInstanceMetadataOptionsState)[keyof typeof LaunchTemplateInstanceMetadataOptionsState];
export interface LaunchTemplateInstanceMetadataOptions {
  State?: LaunchTemplateInstanceMetadataOptionsState | undefined;
  HttpTokens?: LaunchTemplateHttpTokensState | undefined;
  HttpPutResponseHopLimit?: number | undefined;
  HttpEndpoint?: LaunchTemplateInstanceMetadataEndpointState | undefined;
  HttpProtocolIpv6?: LaunchTemplateInstanceMetadataProtocolIpv6 | undefined;
  InstanceMetadataTags?: LaunchTemplateInstanceMetadataTagsState | undefined;
}
export interface LaunchTemplatesMonitoring {
  Enabled?: boolean | undefined;
}
export interface ConnectionTrackingSpecification {
  TcpEstablishedTimeout?: number | undefined;
  UdpTimeout?: number | undefined;
  UdpStreamTimeout?: number | undefined;
}
export interface LaunchTemplateEnaSrdUdpSpecification {
  EnaSrdUdpEnabled?: boolean | undefined;
}
export declare const CopySnapshotRequestFilterSensitiveLog: (
  obj: CopySnapshotRequest
) => any;
export declare const CreateDelegateMacVolumeOwnershipTaskRequestFilterSensitiveLog: (
  obj: CreateDelegateMacVolumeOwnershipTaskRequest
) => any;
export declare const KeyPairFilterSensitiveLog: (obj: KeyPair) => any;
export declare const RequestLaunchTemplateDataFilterSensitiveLog: (
  obj: RequestLaunchTemplateData
) => any;
export declare const CreateLaunchTemplateRequestFilterSensitiveLog: (
  obj: CreateLaunchTemplateRequest
) => any;
export declare const CreateLaunchTemplateVersionRequestFilterSensitiveLog: (
  obj: CreateLaunchTemplateVersionRequest
) => any;
