import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetActiveVpnTunnelStatusRequest, GetActiveVpnTunnelStatusResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link GetActiveVpnTunnelStatusCommand}.
 */
export interface GetActiveVpnTunnelStatusCommandInput extends GetActiveVpnTunnelStatusRequest {
}
/**
 * @public
 *
 * The output of {@link GetActiveVpnTunnelStatusCommand}.
 */
export interface GetActiveVpnTunnelStatusCommandOutput extends GetActiveVpnTunnelStatusResult, __MetadataBearer {
}
declare const GetActiveVpnTunnelStatusCommand_base: {
    new (input: GetActiveVpnTunnelStatusCommandInput): import("@smithy/smithy-client").CommandImpl<GetActiveVpnTunnelStatusCommandInput, GetActiveVpnTunnelStatusCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: GetActiveVpnTunnelStatusCommandInput): import("@smithy/smithy-client").CommandImpl<GetActiveVpnTunnelStatusCommandInput, GetActiveVpnTunnelStatusCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns the currently negotiated security parameters for an active VPN tunnel, including IKE version, DH groups, encryption algorithms, and integrity algorithms.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetActiveVpnTunnelStatusCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetActiveVpnTunnelStatusCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // GetActiveVpnTunnelStatusRequest
 *   VpnConnectionId: "STRING_VALUE", // required
 *   VpnTunnelOutsideIpAddress: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new GetActiveVpnTunnelStatusCommand(input);
 * const response = await client.send(command);
 * // { // GetActiveVpnTunnelStatusResult
 * //   ActiveVpnTunnelStatus: { // ActiveVpnTunnelStatus
 * //     Phase1EncryptionAlgorithm: "STRING_VALUE",
 * //     Phase2EncryptionAlgorithm: "STRING_VALUE",
 * //     Phase1IntegrityAlgorithm: "STRING_VALUE",
 * //     Phase2IntegrityAlgorithm: "STRING_VALUE",
 * //     Phase1DHGroup: Number("int"),
 * //     Phase2DHGroup: Number("int"),
 * //     IkeVersion: "STRING_VALUE",
 * //     ProvisioningStatus: "available" || "pending" || "failed",
 * //     ProvisioningStatusReason: "STRING_VALUE",
 * //   },
 * // };
 *
 * ```
 *
 * @param GetActiveVpnTunnelStatusCommandInput - {@link GetActiveVpnTunnelStatusCommandInput}
 * @returns {@link GetActiveVpnTunnelStatusCommandOutput}
 * @see {@link GetActiveVpnTunnelStatusCommandInput} for command's `input` shape.
 * @see {@link GetActiveVpnTunnelStatusCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class GetActiveVpnTunnelStatusCommand extends GetActiveVpnTunnelStatusCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: GetActiveVpnTunnelStatusRequest;
            output: GetActiveVpnTunnelStatusResult;
        };
        sdk: {
            input: GetActiveVpnTunnelStatusCommandInput;
            output: GetActiveVpnTunnelStatusCommandOutput;
        };
    };
}
