import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ExportVerifiedAccessInstanceClientConfigurationRequest, ExportVerifiedAccessInstanceClientConfigurationResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ExportVerifiedAccessInstanceClientConfigurationCommand}.
 */
export interface ExportVerifiedAccessInstanceClientConfigurationCommandInput extends ExportVerifiedAccessInstanceClientConfigurationRequest {
}
/**
 * @public
 *
 * The output of {@link ExportVerifiedAccessInstanceClientConfigurationCommand}.
 */
export interface ExportVerifiedAccessInstanceClientConfigurationCommandOutput extends ExportVerifiedAccessInstanceClientConfigurationResult, __MetadataBearer {
}
declare const ExportVerifiedAccessInstanceClientConfigurationCommand_base: {
    new (input: ExportVerifiedAccessInstanceClientConfigurationCommandInput): import("@smithy/smithy-client").CommandImpl<ExportVerifiedAccessInstanceClientConfigurationCommandInput, ExportVerifiedAccessInstanceClientConfigurationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ExportVerifiedAccessInstanceClientConfigurationCommandInput): import("@smithy/smithy-client").CommandImpl<ExportVerifiedAccessInstanceClientConfigurationCommandInput, ExportVerifiedAccessInstanceClientConfigurationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Exports the client configuration for a Verified Access instance.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ExportVerifiedAccessInstanceClientConfigurationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ExportVerifiedAccessInstanceClientConfigurationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // ExportVerifiedAccessInstanceClientConfigurationRequest
 *   VerifiedAccessInstanceId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new ExportVerifiedAccessInstanceClientConfigurationCommand(input);
 * const response = await client.send(command);
 * // { // ExportVerifiedAccessInstanceClientConfigurationResult
 * //   Version: "STRING_VALUE",
 * //   VerifiedAccessInstanceId: "STRING_VALUE",
 * //   Region: "STRING_VALUE",
 * //   DeviceTrustProviders: [ // DeviceTrustProviderTypeList
 * //     "jamf" || "crowdstrike" || "jumpcloud",
 * //   ],
 * //   UserTrustProvider: { // VerifiedAccessInstanceUserTrustProviderClientConfiguration
 * //     Type: "iam-identity-center" || "oidc",
 * //     Scopes: "STRING_VALUE",
 * //     Issuer: "STRING_VALUE",
 * //     AuthorizationEndpoint: "STRING_VALUE",
 * //     PublicSigningKeyEndpoint: "STRING_VALUE",
 * //     TokenEndpoint: "STRING_VALUE",
 * //     UserInfoEndpoint: "STRING_VALUE",
 * //     ClientId: "STRING_VALUE",
 * //     ClientSecret: "STRING_VALUE",
 * //     PkceEnabled: true || false,
 * //   },
 * //   OpenVpnConfigurations: [ // VerifiedAccessInstanceOpenVpnClientConfigurationList
 * //     { // VerifiedAccessInstanceOpenVpnClientConfiguration
 * //       Config: "STRING_VALUE",
 * //       Routes: [ // VerifiedAccessInstanceOpenVpnClientConfigurationRouteList
 * //         { // VerifiedAccessInstanceOpenVpnClientConfigurationRoute
 * //           Cidr: "STRING_VALUE",
 * //         },
 * //       ],
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param ExportVerifiedAccessInstanceClientConfigurationCommandInput - {@link ExportVerifiedAccessInstanceClientConfigurationCommandInput}
 * @returns {@link ExportVerifiedAccessInstanceClientConfigurationCommandOutput}
 * @see {@link ExportVerifiedAccessInstanceClientConfigurationCommandInput} for command's `input` shape.
 * @see {@link ExportVerifiedAccessInstanceClientConfigurationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class ExportVerifiedAccessInstanceClientConfigurationCommand extends ExportVerifiedAccessInstanceClientConfigurationCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ExportVerifiedAccessInstanceClientConfigurationRequest;
            output: ExportVerifiedAccessInstanceClientConfigurationResult;
        };
        sdk: {
            input: ExportVerifiedAccessInstanceClientConfigurationCommandInput;
            output: ExportVerifiedAccessInstanceClientConfigurationCommandOutput;
        };
    };
}
