import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeClientVpnRoutesRequest, DescribeClientVpnRoutesResult } from "../models/models_4";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeClientVpnRoutesCommand}.
 */
export interface DescribeClientVpnRoutesCommandInput extends DescribeClientVpnRoutesRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeClientVpnRoutesCommand}.
 */
export interface DescribeClientVpnRoutesCommandOutput extends DescribeClientVpnRoutesResult, __MetadataBearer {
}
declare const DescribeClientVpnRoutesCommand_base: {
    new (input: DescribeClientVpnRoutesCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeClientVpnRoutesCommandInput, DescribeClientVpnRoutesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DescribeClientVpnRoutesCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeClientVpnRoutesCommandInput, DescribeClientVpnRoutesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the routes for the specified Client VPN endpoint.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeClientVpnRoutesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeClientVpnRoutesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // DescribeClientVpnRoutesRequest
 *   ClientVpnEndpointId: "STRING_VALUE", // required
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 *   DryRun: true || false,
 * };
 * const command = new DescribeClientVpnRoutesCommand(input);
 * const response = await client.send(command);
 * // { // DescribeClientVpnRoutesResult
 * //   Routes: [ // ClientVpnRouteSet
 * //     { // ClientVpnRoute
 * //       ClientVpnEndpointId: "STRING_VALUE",
 * //       DestinationCidr: "STRING_VALUE",
 * //       TargetSubnet: "STRING_VALUE",
 * //       Type: "STRING_VALUE",
 * //       Origin: "STRING_VALUE",
 * //       Status: { // ClientVpnRouteStatus
 * //         Code: "creating" || "active" || "failed" || "deleting",
 * //         Message: "STRING_VALUE",
 * //       },
 * //       Description: "STRING_VALUE",
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeClientVpnRoutesCommandInput - {@link DescribeClientVpnRoutesCommandInput}
 * @returns {@link DescribeClientVpnRoutesCommandOutput}
 * @see {@link DescribeClientVpnRoutesCommandInput} for command's `input` shape.
 * @see {@link DescribeClientVpnRoutesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class DescribeClientVpnRoutesCommand extends DescribeClientVpnRoutesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeClientVpnRoutesRequest;
            output: DescribeClientVpnRoutesResult;
        };
        sdk: {
            input: DescribeClientVpnRoutesCommandInput;
            output: DescribeClientVpnRoutesCommandOutput;
        };
    };
}
