import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CancelDeclarativePoliciesReportRequest, CancelDeclarativePoliciesReportResult } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link CancelDeclarativePoliciesReportCommand}.
 */
export interface CancelDeclarativePoliciesReportCommandInput extends CancelDeclarativePoliciesReportRequest {
}
/**
 * @public
 *
 * The output of {@link CancelDeclarativePoliciesReportCommand}.
 */
export interface CancelDeclarativePoliciesReportCommandOutput extends CancelDeclarativePoliciesReportResult, __MetadataBearer {
}
declare const CancelDeclarativePoliciesReportCommand_base: {
    new (input: CancelDeclarativePoliciesReportCommandInput): import("@smithy/smithy-client").CommandImpl<CancelDeclarativePoliciesReportCommandInput, CancelDeclarativePoliciesReportCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: CancelDeclarativePoliciesReportCommandInput): import("@smithy/smithy-client").CommandImpl<CancelDeclarativePoliciesReportCommandInput, CancelDeclarativePoliciesReportCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Cancels the generation of an account status report.</p>
 *          <p>You can only cancel a report while it has the <code>running</code> status. Reports
 *             with other statuses (<code>complete</code>, <code>cancelled</code>, or
 *                 <code>error</code>) can't be canceled.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative_status-report.html">Generating the account status report for declarative policies</a> in the
 *                 <i>Amazon Web Services Organizations User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CancelDeclarativePoliciesReportCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CancelDeclarativePoliciesReportCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // CancelDeclarativePoliciesReportRequest
 *   DryRun: true || false,
 *   ReportId: "STRING_VALUE", // required
 * };
 * const command = new CancelDeclarativePoliciesReportCommand(input);
 * const response = await client.send(command);
 * // { // CancelDeclarativePoliciesReportResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param CancelDeclarativePoliciesReportCommandInput - {@link CancelDeclarativePoliciesReportCommandInput}
 * @returns {@link CancelDeclarativePoliciesReportCommandOutput}
 * @see {@link CancelDeclarativePoliciesReportCommandInput} for command's `input` shape.
 * @see {@link CancelDeclarativePoliciesReportCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class CancelDeclarativePoliciesReportCommand extends CancelDeclarativePoliciesReportCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: CancelDeclarativePoliciesReportRequest;
            output: CancelDeclarativePoliciesReportResult;
        };
        sdk: {
            input: CancelDeclarativePoliciesReportCommandInput;
            output: CancelDeclarativePoliciesReportCommandOutput;
        };
    };
}
