import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CodeCommitServiceException as __BaseException } from "./CodeCommitServiceException";
export declare class ActorDoesNotExistException extends __BaseException {
  readonly name: "ActorDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ActorDoesNotExistException, __BaseException>
  );
}
export declare const ApprovalState: {
  readonly APPROVE: "APPROVE";
  readonly REVOKE: "REVOKE";
};
export type ApprovalState = (typeof ApprovalState)[keyof typeof ApprovalState];
export interface Approval {
  userArn?: string | undefined;
  approvalState?: ApprovalState | undefined;
}
export interface OriginApprovalRuleTemplate {
  approvalRuleTemplateId?: string | undefined;
  approvalRuleTemplateName?: string | undefined;
}
export interface ApprovalRule {
  approvalRuleId?: string | undefined;
  approvalRuleName?: string | undefined;
  approvalRuleContent?: string | undefined;
  ruleContentSha256?: string | undefined;
  lastModifiedDate?: Date | undefined;
  creationDate?: Date | undefined;
  lastModifiedUser?: string | undefined;
  originApprovalRuleTemplate?: OriginApprovalRuleTemplate | undefined;
}
export declare class ApprovalRuleContentRequiredException extends __BaseException {
  readonly name: "ApprovalRuleContentRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApprovalRuleContentRequiredException,
      __BaseException
    >
  );
}
export declare class ApprovalRuleDoesNotExistException extends __BaseException {
  readonly name: "ApprovalRuleDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApprovalRuleDoesNotExistException,
      __BaseException
    >
  );
}
export interface ApprovalRuleEventMetadata {
  approvalRuleName?: string | undefined;
  approvalRuleId?: string | undefined;
  approvalRuleContent?: string | undefined;
}
export declare class ApprovalRuleNameAlreadyExistsException extends __BaseException {
  readonly name: "ApprovalRuleNameAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApprovalRuleNameAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class ApprovalRuleNameRequiredException extends __BaseException {
  readonly name: "ApprovalRuleNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApprovalRuleNameRequiredException,
      __BaseException
    >
  );
}
export declare const OverrideStatus: {
  readonly OVERRIDE: "OVERRIDE";
  readonly REVOKE: "REVOKE";
};
export type OverrideStatus =
  (typeof OverrideStatus)[keyof typeof OverrideStatus];
export interface ApprovalRuleOverriddenEventMetadata {
  revisionId?: string | undefined;
  overrideStatus?: OverrideStatus | undefined;
}
export interface ApprovalRuleTemplate {
  approvalRuleTemplateId?: string | undefined;
  approvalRuleTemplateName?: string | undefined;
  approvalRuleTemplateDescription?: string | undefined;
  approvalRuleTemplateContent?: string | undefined;
  ruleContentSha256?: string | undefined;
  lastModifiedDate?: Date | undefined;
  creationDate?: Date | undefined;
  lastModifiedUser?: string | undefined;
}
export declare class ApprovalRuleTemplateContentRequiredException extends __BaseException {
  readonly name: "ApprovalRuleTemplateContentRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApprovalRuleTemplateContentRequiredException,
      __BaseException
    >
  );
}
export declare class ApprovalRuleTemplateDoesNotExistException extends __BaseException {
  readonly name: "ApprovalRuleTemplateDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApprovalRuleTemplateDoesNotExistException,
      __BaseException
    >
  );
}
export declare class ApprovalRuleTemplateInUseException extends __BaseException {
  readonly name: "ApprovalRuleTemplateInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApprovalRuleTemplateInUseException,
      __BaseException
    >
  );
}
export declare class ApprovalRuleTemplateNameAlreadyExistsException extends __BaseException {
  readonly name: "ApprovalRuleTemplateNameAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApprovalRuleTemplateNameAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class ApprovalRuleTemplateNameRequiredException extends __BaseException {
  readonly name: "ApprovalRuleTemplateNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ApprovalRuleTemplateNameRequiredException,
      __BaseException
    >
  );
}
export interface ApprovalStateChangedEventMetadata {
  revisionId?: string | undefined;
  approvalStatus?: ApprovalState | undefined;
}
export declare class ApprovalStateRequiredException extends __BaseException {
  readonly name: "ApprovalStateRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ApprovalStateRequiredException, __BaseException>
  );
}
export interface AssociateApprovalRuleTemplateWithRepositoryInput {
  approvalRuleTemplateName: string | undefined;
  repositoryName: string | undefined;
}
export declare class EncryptionIntegrityChecksFailedException extends __BaseException {
  readonly name: "EncryptionIntegrityChecksFailedException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<
      EncryptionIntegrityChecksFailedException,
      __BaseException
    >
  );
}
export declare class EncryptionKeyAccessDeniedException extends __BaseException {
  readonly name: "EncryptionKeyAccessDeniedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      EncryptionKeyAccessDeniedException,
      __BaseException
    >
  );
}
export declare class EncryptionKeyDisabledException extends __BaseException {
  readonly name: "EncryptionKeyDisabledException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<EncryptionKeyDisabledException, __BaseException>
  );
}
export declare class EncryptionKeyNotFoundException extends __BaseException {
  readonly name: "EncryptionKeyNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<EncryptionKeyNotFoundException, __BaseException>
  );
}
export declare class EncryptionKeyUnavailableException extends __BaseException {
  readonly name: "EncryptionKeyUnavailableException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      EncryptionKeyUnavailableException,
      __BaseException
    >
  );
}
export declare class InvalidApprovalRuleTemplateNameException extends __BaseException {
  readonly name: "InvalidApprovalRuleTemplateNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidApprovalRuleTemplateNameException,
      __BaseException
    >
  );
}
export declare class InvalidRepositoryNameException extends __BaseException {
  readonly name: "InvalidRepositoryNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidRepositoryNameException, __BaseException>
  );
}
export declare class MaximumRuleTemplatesAssociatedWithRepositoryException extends __BaseException {
  readonly name: "MaximumRuleTemplatesAssociatedWithRepositoryException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumRuleTemplatesAssociatedWithRepositoryException,
      __BaseException
    >
  );
}
export declare class RepositoryDoesNotExistException extends __BaseException {
  readonly name: "RepositoryDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryDoesNotExistException,
      __BaseException
    >
  );
}
export declare class RepositoryNameRequiredException extends __BaseException {
  readonly name: "RepositoryNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryNameRequiredException,
      __BaseException
    >
  );
}
export declare class AuthorDoesNotExistException extends __BaseException {
  readonly name: "AuthorDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AuthorDoesNotExistException, __BaseException>
  );
}
export interface BatchAssociateApprovalRuleTemplateWithRepositoriesInput {
  approvalRuleTemplateName: string | undefined;
  repositoryNames: string[] | undefined;
}
export interface BatchAssociateApprovalRuleTemplateWithRepositoriesError {
  repositoryName?: string | undefined;
  errorCode?: string | undefined;
  errorMessage?: string | undefined;
}
export interface BatchAssociateApprovalRuleTemplateWithRepositoriesOutput {
  associatedRepositoryNames: string[] | undefined;
  errors: BatchAssociateApprovalRuleTemplateWithRepositoriesError[] | undefined;
}
export declare class MaximumRepositoryNamesExceededException extends __BaseException {
  readonly name: "MaximumRepositoryNamesExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumRepositoryNamesExceededException,
      __BaseException
    >
  );
}
export declare class RepositoryNamesRequiredException extends __BaseException {
  readonly name: "RepositoryNamesRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryNamesRequiredException,
      __BaseException
    >
  );
}
export declare const ConflictDetailLevelTypeEnum: {
  readonly FILE_LEVEL: "FILE_LEVEL";
  readonly LINE_LEVEL: "LINE_LEVEL";
};
export type ConflictDetailLevelTypeEnum =
  (typeof ConflictDetailLevelTypeEnum)[keyof typeof ConflictDetailLevelTypeEnum];
export declare const ConflictResolutionStrategyTypeEnum: {
  readonly ACCEPT_DESTINATION: "ACCEPT_DESTINATION";
  readonly ACCEPT_SOURCE: "ACCEPT_SOURCE";
  readonly AUTOMERGE: "AUTOMERGE";
  readonly NONE: "NONE";
};
export type ConflictResolutionStrategyTypeEnum =
  (typeof ConflictResolutionStrategyTypeEnum)[keyof typeof ConflictResolutionStrategyTypeEnum];
export declare const MergeOptionTypeEnum: {
  readonly FAST_FORWARD_MERGE: "FAST_FORWARD_MERGE";
  readonly SQUASH_MERGE: "SQUASH_MERGE";
  readonly THREE_WAY_MERGE: "THREE_WAY_MERGE";
};
export type MergeOptionTypeEnum =
  (typeof MergeOptionTypeEnum)[keyof typeof MergeOptionTypeEnum];
export interface BatchDescribeMergeConflictsInput {
  repositoryName: string | undefined;
  destinationCommitSpecifier: string | undefined;
  sourceCommitSpecifier: string | undefined;
  mergeOption: MergeOptionTypeEnum | undefined;
  maxMergeHunks?: number | undefined;
  maxConflictFiles?: number | undefined;
  filePaths?: string[] | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
  nextToken?: string | undefined;
}
export declare const FileModeTypeEnum: {
  readonly EXECUTABLE: "EXECUTABLE";
  readonly NORMAL: "NORMAL";
  readonly SYMLINK: "SYMLINK";
};
export type FileModeTypeEnum =
  (typeof FileModeTypeEnum)[keyof typeof FileModeTypeEnum];
export interface FileModes {
  source?: FileModeTypeEnum | undefined;
  destination?: FileModeTypeEnum | undefined;
  base?: FileModeTypeEnum | undefined;
}
export interface FileSizes {
  source?: number | undefined;
  destination?: number | undefined;
  base?: number | undefined;
}
export interface IsBinaryFile {
  source?: boolean | undefined;
  destination?: boolean | undefined;
  base?: boolean | undefined;
}
export declare const ChangeTypeEnum: {
  readonly ADDED: "A";
  readonly DELETED: "D";
  readonly MODIFIED: "M";
};
export type ChangeTypeEnum =
  (typeof ChangeTypeEnum)[keyof typeof ChangeTypeEnum];
export interface MergeOperations {
  source?: ChangeTypeEnum | undefined;
  destination?: ChangeTypeEnum | undefined;
}
export declare const ObjectTypeEnum: {
  readonly DIRECTORY: "DIRECTORY";
  readonly FILE: "FILE";
  readonly GIT_LINK: "GIT_LINK";
  readonly SYMBOLIC_LINK: "SYMBOLIC_LINK";
};
export type ObjectTypeEnum =
  (typeof ObjectTypeEnum)[keyof typeof ObjectTypeEnum];
export interface ObjectTypes {
  source?: ObjectTypeEnum | undefined;
  destination?: ObjectTypeEnum | undefined;
  base?: ObjectTypeEnum | undefined;
}
export interface ConflictMetadata {
  filePath?: string | undefined;
  fileSizes?: FileSizes | undefined;
  fileModes?: FileModes | undefined;
  objectTypes?: ObjectTypes | undefined;
  numberOfConflicts?: number | undefined;
  isBinaryFile?: IsBinaryFile | undefined;
  contentConflict?: boolean | undefined;
  fileModeConflict?: boolean | undefined;
  objectTypeConflict?: boolean | undefined;
  mergeOperations?: MergeOperations | undefined;
}
export interface MergeHunkDetail {
  startLine?: number | undefined;
  endLine?: number | undefined;
  hunkContent?: string | undefined;
}
export interface MergeHunk {
  isConflict?: boolean | undefined;
  source?: MergeHunkDetail | undefined;
  destination?: MergeHunkDetail | undefined;
  base?: MergeHunkDetail | undefined;
}
export interface Conflict {
  conflictMetadata?: ConflictMetadata | undefined;
  mergeHunks?: MergeHunk[] | undefined;
}
export interface BatchDescribeMergeConflictsError {
  filePath: string | undefined;
  exceptionName: string | undefined;
  message: string | undefined;
}
export interface BatchDescribeMergeConflictsOutput {
  conflicts: Conflict[] | undefined;
  nextToken?: string | undefined;
  errors?: BatchDescribeMergeConflictsError[] | undefined;
  destinationCommitId: string | undefined;
  sourceCommitId: string | undefined;
  baseCommitId?: string | undefined;
}
export declare class CommitDoesNotExistException extends __BaseException {
  readonly name: "CommitDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CommitDoesNotExistException, __BaseException>
  );
}
export declare class CommitRequiredException extends __BaseException {
  readonly name: "CommitRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CommitRequiredException, __BaseException>
  );
}
export declare class InvalidCommitException extends __BaseException {
  readonly name: "InvalidCommitException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidCommitException, __BaseException>
  );
}
export declare class InvalidConflictDetailLevelException extends __BaseException {
  readonly name: "InvalidConflictDetailLevelException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidConflictDetailLevelException,
      __BaseException
    >
  );
}
export declare class InvalidConflictResolutionStrategyException extends __BaseException {
  readonly name: "InvalidConflictResolutionStrategyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidConflictResolutionStrategyException,
      __BaseException
    >
  );
}
export declare class InvalidContinuationTokenException extends __BaseException {
  readonly name: "InvalidContinuationTokenException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidContinuationTokenException,
      __BaseException
    >
  );
}
export declare class InvalidMaxConflictFilesException extends __BaseException {
  readonly name: "InvalidMaxConflictFilesException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidMaxConflictFilesException,
      __BaseException
    >
  );
}
export declare class InvalidMaxMergeHunksException extends __BaseException {
  readonly name: "InvalidMaxMergeHunksException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidMaxMergeHunksException, __BaseException>
  );
}
export declare class InvalidMergeOptionException extends __BaseException {
  readonly name: "InvalidMergeOptionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidMergeOptionException, __BaseException>
  );
}
export declare class MaximumFileContentToLoadExceededException extends __BaseException {
  readonly name: "MaximumFileContentToLoadExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumFileContentToLoadExceededException,
      __BaseException
    >
  );
}
export declare class MaximumItemsToCompareExceededException extends __BaseException {
  readonly name: "MaximumItemsToCompareExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumItemsToCompareExceededException,
      __BaseException
    >
  );
}
export declare class MergeOptionRequiredException extends __BaseException {
  readonly name: "MergeOptionRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<MergeOptionRequiredException, __BaseException>
  );
}
export declare class TipsDivergenceExceededException extends __BaseException {
  readonly name: "TipsDivergenceExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      TipsDivergenceExceededException,
      __BaseException
    >
  );
}
export interface BatchDisassociateApprovalRuleTemplateFromRepositoriesInput {
  approvalRuleTemplateName: string | undefined;
  repositoryNames: string[] | undefined;
}
export interface BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
  repositoryName?: string | undefined;
  errorCode?: string | undefined;
  errorMessage?: string | undefined;
}
export interface BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput {
  disassociatedRepositoryNames: string[] | undefined;
  errors:
    | BatchDisassociateApprovalRuleTemplateFromRepositoriesError[]
    | undefined;
}
export interface BatchGetCommitsInput {
  commitIds: string[] | undefined;
  repositoryName: string | undefined;
}
export interface UserInfo {
  name?: string | undefined;
  email?: string | undefined;
  date?: string | undefined;
}
export interface Commit {
  commitId?: string | undefined;
  treeId?: string | undefined;
  parents?: string[] | undefined;
  message?: string | undefined;
  author?: UserInfo | undefined;
  committer?: UserInfo | undefined;
  additionalData?: string | undefined;
}
export interface BatchGetCommitsError {
  commitId?: string | undefined;
  errorCode?: string | undefined;
  errorMessage?: string | undefined;
}
export interface BatchGetCommitsOutput {
  commits?: Commit[] | undefined;
  errors?: BatchGetCommitsError[] | undefined;
}
export declare class CommitIdsLimitExceededException extends __BaseException {
  readonly name: "CommitIdsLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CommitIdsLimitExceededException,
      __BaseException
    >
  );
}
export declare class CommitIdsListRequiredException extends __BaseException {
  readonly name: "CommitIdsListRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CommitIdsListRequiredException, __BaseException>
  );
}
export interface BatchGetRepositoriesInput {
  repositoryNames: string[] | undefined;
}
export declare const BatchGetRepositoriesErrorCodeEnum: {
  readonly ENCRYPTION_INTEGRITY_CHECKS_FAILED_EXCEPTION: "EncryptionIntegrityChecksFailedException";
  readonly ENCRYPTION_KEY_ACCESS_DENIED_EXCEPTION: "EncryptionKeyAccessDeniedException";
  readonly ENCRYPTION_KEY_DISABLED_EXCEPTION: "EncryptionKeyDisabledException";
  readonly ENCRYPTION_KEY_NOT_FOUND_EXCEPTION: "EncryptionKeyNotFoundException";
  readonly ENCRYPTION_KEY_UNAVAILABLE_EXCEPTION: "EncryptionKeyUnavailableException";
  readonly REPOSITORY_DOES_NOT_EXIST_EXCEPTION: "RepositoryDoesNotExistException";
};
export type BatchGetRepositoriesErrorCodeEnum =
  (typeof BatchGetRepositoriesErrorCodeEnum)[keyof typeof BatchGetRepositoriesErrorCodeEnum];
export interface BatchGetRepositoriesError {
  repositoryId?: string | undefined;
  repositoryName?: string | undefined;
  errorCode?: BatchGetRepositoriesErrorCodeEnum | undefined;
  errorMessage?: string | undefined;
}
export interface RepositoryMetadata {
  accountId?: string | undefined;
  repositoryId?: string | undefined;
  repositoryName?: string | undefined;
  repositoryDescription?: string | undefined;
  defaultBranch?: string | undefined;
  lastModifiedDate?: Date | undefined;
  creationDate?: Date | undefined;
  cloneUrlHttp?: string | undefined;
  cloneUrlSsh?: string | undefined;
  Arn?: string | undefined;
  kmsKeyId?: string | undefined;
}
export interface BatchGetRepositoriesOutput {
  repositories?: RepositoryMetadata[] | undefined;
  repositoriesNotFound?: string[] | undefined;
  errors?: BatchGetRepositoriesError[] | undefined;
}
export declare class BeforeCommitIdAndAfterCommitIdAreSameException extends __BaseException {
  readonly name: "BeforeCommitIdAndAfterCommitIdAreSameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      BeforeCommitIdAndAfterCommitIdAreSameException,
      __BaseException
    >
  );
}
export declare class BlobIdDoesNotExistException extends __BaseException {
  readonly name: "BlobIdDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BlobIdDoesNotExistException, __BaseException>
  );
}
export declare class BlobIdRequiredException extends __BaseException {
  readonly name: "BlobIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BlobIdRequiredException, __BaseException>
  );
}
export interface BlobMetadata {
  blobId?: string | undefined;
  path?: string | undefined;
  mode?: string | undefined;
}
export declare class BranchDoesNotExistException extends __BaseException {
  readonly name: "BranchDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BranchDoesNotExistException, __BaseException>
  );
}
export interface BranchInfo {
  branchName?: string | undefined;
  commitId?: string | undefined;
}
export declare class BranchNameExistsException extends __BaseException {
  readonly name: "BranchNameExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BranchNameExistsException, __BaseException>
  );
}
export declare class BranchNameIsTagNameException extends __BaseException {
  readonly name: "BranchNameIsTagNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BranchNameIsTagNameException, __BaseException>
  );
}
export declare class BranchNameRequiredException extends __BaseException {
  readonly name: "BranchNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BranchNameRequiredException, __BaseException>
  );
}
export declare class CannotDeleteApprovalRuleFromTemplateException extends __BaseException {
  readonly name: "CannotDeleteApprovalRuleFromTemplateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CannotDeleteApprovalRuleFromTemplateException,
      __BaseException
    >
  );
}
export declare class CannotModifyApprovalRuleFromTemplateException extends __BaseException {
  readonly name: "CannotModifyApprovalRuleFromTemplateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CannotModifyApprovalRuleFromTemplateException,
      __BaseException
    >
  );
}
export declare class ClientRequestTokenRequiredException extends __BaseException {
  readonly name: "ClientRequestTokenRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ClientRequestTokenRequiredException,
      __BaseException
    >
  );
}
export interface CreateApprovalRuleTemplateInput {
  approvalRuleTemplateName: string | undefined;
  approvalRuleTemplateContent: string | undefined;
  approvalRuleTemplateDescription?: string | undefined;
}
export interface CreateApprovalRuleTemplateOutput {
  approvalRuleTemplate: ApprovalRuleTemplate | undefined;
}
export declare class InvalidApprovalRuleTemplateContentException extends __BaseException {
  readonly name: "InvalidApprovalRuleTemplateContentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidApprovalRuleTemplateContentException,
      __BaseException
    >
  );
}
export declare class InvalidApprovalRuleTemplateDescriptionException extends __BaseException {
  readonly name: "InvalidApprovalRuleTemplateDescriptionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidApprovalRuleTemplateDescriptionException,
      __BaseException
    >
  );
}
export declare class NumberOfRuleTemplatesExceededException extends __BaseException {
  readonly name: "NumberOfRuleTemplatesExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      NumberOfRuleTemplatesExceededException,
      __BaseException
    >
  );
}
export declare class CommitIdRequiredException extends __BaseException {
  readonly name: "CommitIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CommitIdRequiredException, __BaseException>
  );
}
export interface CreateBranchInput {
  repositoryName: string | undefined;
  branchName: string | undefined;
  commitId: string | undefined;
}
export declare class InvalidBranchNameException extends __BaseException {
  readonly name: "InvalidBranchNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidBranchNameException, __BaseException>
  );
}
export declare class InvalidCommitIdException extends __BaseException {
  readonly name: "InvalidCommitIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidCommitIdException, __BaseException>
  );
}
export declare class CommitMessageLengthExceededException extends __BaseException {
  readonly name: "CommitMessageLengthExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CommitMessageLengthExceededException,
      __BaseException
    >
  );
}
export interface DeleteFileEntry {
  filePath: string | undefined;
}
export interface SourceFileSpecifier {
  filePath: string | undefined;
  isMove?: boolean | undefined;
}
export interface PutFileEntry {
  filePath: string | undefined;
  fileMode?: FileModeTypeEnum | undefined;
  fileContent?: Uint8Array | undefined;
  sourceFile?: SourceFileSpecifier | undefined;
}
export interface SetFileModeEntry {
  filePath: string | undefined;
  fileMode: FileModeTypeEnum | undefined;
}
export interface CreateCommitInput {
  repositoryName: string | undefined;
  branchName: string | undefined;
  parentCommitId?: string | undefined;
  authorName?: string | undefined;
  email?: string | undefined;
  commitMessage?: string | undefined;
  keepEmptyFolders?: boolean | undefined;
  putFiles?: PutFileEntry[] | undefined;
  deleteFiles?: DeleteFileEntry[] | undefined;
  setFileModes?: SetFileModeEntry[] | undefined;
}
export interface FileMetadata {
  absolutePath?: string | undefined;
  blobId?: string | undefined;
  fileMode?: FileModeTypeEnum | undefined;
}
export interface CreateCommitOutput {
  commitId?: string | undefined;
  treeId?: string | undefined;
  filesAdded?: FileMetadata[] | undefined;
  filesUpdated?: FileMetadata[] | undefined;
  filesDeleted?: FileMetadata[] | undefined;
}
export declare class DirectoryNameConflictsWithFileNameException extends __BaseException {
  readonly name: "DirectoryNameConflictsWithFileNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DirectoryNameConflictsWithFileNameException,
      __BaseException
    >
  );
}
export declare class FileContentAndSourceFileSpecifiedException extends __BaseException {
  readonly name: "FileContentAndSourceFileSpecifiedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      FileContentAndSourceFileSpecifiedException,
      __BaseException
    >
  );
}
export declare class FileContentSizeLimitExceededException extends __BaseException {
  readonly name: "FileContentSizeLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      FileContentSizeLimitExceededException,
      __BaseException
    >
  );
}
export declare class FileDoesNotExistException extends __BaseException {
  readonly name: "FileDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<FileDoesNotExistException, __BaseException>
  );
}
export declare class FileEntryRequiredException extends __BaseException {
  readonly name: "FileEntryRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<FileEntryRequiredException, __BaseException>
  );
}
export declare class FileModeRequiredException extends __BaseException {
  readonly name: "FileModeRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<FileModeRequiredException, __BaseException>
  );
}
export declare class FileNameConflictsWithDirectoryNameException extends __BaseException {
  readonly name: "FileNameConflictsWithDirectoryNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      FileNameConflictsWithDirectoryNameException,
      __BaseException
    >
  );
}
export declare class FilePathConflictsWithSubmodulePathException extends __BaseException {
  readonly name: "FilePathConflictsWithSubmodulePathException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      FilePathConflictsWithSubmodulePathException,
      __BaseException
    >
  );
}
export declare class FolderContentSizeLimitExceededException extends __BaseException {
  readonly name: "FolderContentSizeLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      FolderContentSizeLimitExceededException,
      __BaseException
    >
  );
}
export declare class InvalidDeletionParameterException extends __BaseException {
  readonly name: "InvalidDeletionParameterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeletionParameterException,
      __BaseException
    >
  );
}
export declare class InvalidEmailException extends __BaseException {
  readonly name: "InvalidEmailException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidEmailException, __BaseException>
  );
}
export declare class InvalidFileModeException extends __BaseException {
  readonly name: "InvalidFileModeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidFileModeException, __BaseException>
  );
}
export declare class InvalidParentCommitIdException extends __BaseException {
  readonly name: "InvalidParentCommitIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidParentCommitIdException, __BaseException>
  );
}
export declare class InvalidPathException extends __BaseException {
  readonly name: "InvalidPathException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidPathException, __BaseException>
  );
}
export declare class MaximumFileEntriesExceededException extends __BaseException {
  readonly name: "MaximumFileEntriesExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumFileEntriesExceededException,
      __BaseException
    >
  );
}
export declare class NameLengthExceededException extends __BaseException {
  readonly name: "NameLengthExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<NameLengthExceededException, __BaseException>
  );
}
export declare class NoChangeException extends __BaseException {
  readonly name: "NoChangeException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<NoChangeException, __BaseException>);
}
export declare class ParentCommitDoesNotExistException extends __BaseException {
  readonly name: "ParentCommitDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ParentCommitDoesNotExistException,
      __BaseException
    >
  );
}
export declare class ParentCommitIdOutdatedException extends __BaseException {
  readonly name: "ParentCommitIdOutdatedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ParentCommitIdOutdatedException,
      __BaseException
    >
  );
}
export declare class ParentCommitIdRequiredException extends __BaseException {
  readonly name: "ParentCommitIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ParentCommitIdRequiredException,
      __BaseException
    >
  );
}
export declare class PathRequiredException extends __BaseException {
  readonly name: "PathRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PathRequiredException, __BaseException>
  );
}
export declare class PutFileEntryConflictException extends __BaseException {
  readonly name: "PutFileEntryConflictException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PutFileEntryConflictException, __BaseException>
  );
}
export declare class RestrictedSourceFileException extends __BaseException {
  readonly name: "RestrictedSourceFileException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RestrictedSourceFileException, __BaseException>
  );
}
export declare class SamePathRequestException extends __BaseException {
  readonly name: "SamePathRequestException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SamePathRequestException, __BaseException>
  );
}
export declare class SourceFileOrContentRequiredException extends __BaseException {
  readonly name: "SourceFileOrContentRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      SourceFileOrContentRequiredException,
      __BaseException
    >
  );
}
export interface Target {
  repositoryName: string | undefined;
  sourceReference: string | undefined;
  destinationReference?: string | undefined;
}
export interface CreatePullRequestInput {
  title: string | undefined;
  description?: string | undefined;
  targets: Target[] | undefined;
  clientRequestToken?: string | undefined;
}
export declare const PullRequestStatusEnum: {
  readonly CLOSED: "CLOSED";
  readonly OPEN: "OPEN";
};
export type PullRequestStatusEnum =
  (typeof PullRequestStatusEnum)[keyof typeof PullRequestStatusEnum];
export interface MergeMetadata {
  isMerged?: boolean | undefined;
  mergedBy?: string | undefined;
  mergeCommitId?: string | undefined;
  mergeOption?: MergeOptionTypeEnum | undefined;
}
export interface PullRequestTarget {
  repositoryName?: string | undefined;
  sourceReference?: string | undefined;
  destinationReference?: string | undefined;
  destinationCommit?: string | undefined;
  sourceCommit?: string | undefined;
  mergeBase?: string | undefined;
  mergeMetadata?: MergeMetadata | undefined;
}
export interface PullRequest {
  pullRequestId?: string | undefined;
  title?: string | undefined;
  description?: string | undefined;
  lastActivityDate?: Date | undefined;
  creationDate?: Date | undefined;
  pullRequestStatus?: PullRequestStatusEnum | undefined;
  authorArn?: string | undefined;
  pullRequestTargets?: PullRequestTarget[] | undefined;
  clientRequestToken?: string | undefined;
  revisionId?: string | undefined;
  approvalRules?: ApprovalRule[] | undefined;
}
export interface CreatePullRequestOutput {
  pullRequest: PullRequest | undefined;
}
export declare class IdempotencyParameterMismatchException extends __BaseException {
  readonly name: "IdempotencyParameterMismatchException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      IdempotencyParameterMismatchException,
      __BaseException
    >
  );
}
export declare class InvalidClientRequestTokenException extends __BaseException {
  readonly name: "InvalidClientRequestTokenException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidClientRequestTokenException,
      __BaseException
    >
  );
}
export declare class InvalidDescriptionException extends __BaseException {
  readonly name: "InvalidDescriptionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDescriptionException, __BaseException>
  );
}
export declare class InvalidReferenceNameException extends __BaseException {
  readonly name: "InvalidReferenceNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidReferenceNameException, __BaseException>
  );
}
export declare class InvalidTargetException extends __BaseException {
  readonly name: "InvalidTargetException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTargetException, __BaseException>
  );
}
export declare class InvalidTargetsException extends __BaseException {
  readonly name: "InvalidTargetsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTargetsException, __BaseException>
  );
}
export declare class InvalidTitleException extends __BaseException {
  readonly name: "InvalidTitleException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTitleException, __BaseException>
  );
}
export declare class MaximumOpenPullRequestsExceededException extends __BaseException {
  readonly name: "MaximumOpenPullRequestsExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumOpenPullRequestsExceededException,
      __BaseException
    >
  );
}
export declare class MultipleRepositoriesInPullRequestException extends __BaseException {
  readonly name: "MultipleRepositoriesInPullRequestException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MultipleRepositoriesInPullRequestException,
      __BaseException
    >
  );
}
export declare class ReferenceDoesNotExistException extends __BaseException {
  readonly name: "ReferenceDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ReferenceDoesNotExistException, __BaseException>
  );
}
export declare class ReferenceNameRequiredException extends __BaseException {
  readonly name: "ReferenceNameRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ReferenceNameRequiredException, __BaseException>
  );
}
export declare class ReferenceTypeNotSupportedException extends __BaseException {
  readonly name: "ReferenceTypeNotSupportedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ReferenceTypeNotSupportedException,
      __BaseException
    >
  );
}
export declare class SourceAndDestinationAreSameException extends __BaseException {
  readonly name: "SourceAndDestinationAreSameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      SourceAndDestinationAreSameException,
      __BaseException
    >
  );
}
export declare class TargetRequiredException extends __BaseException {
  readonly name: "TargetRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TargetRequiredException, __BaseException>
  );
}
export declare class TargetsRequiredException extends __BaseException {
  readonly name: "TargetsRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TargetsRequiredException, __BaseException>
  );
}
export declare class TitleRequiredException extends __BaseException {
  readonly name: "TitleRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TitleRequiredException, __BaseException>
  );
}
export interface CreatePullRequestApprovalRuleInput {
  pullRequestId: string | undefined;
  approvalRuleName: string | undefined;
  approvalRuleContent: string | undefined;
}
export interface CreatePullRequestApprovalRuleOutput {
  approvalRule: ApprovalRule | undefined;
}
export declare class InvalidApprovalRuleContentException extends __BaseException {
  readonly name: "InvalidApprovalRuleContentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidApprovalRuleContentException,
      __BaseException
    >
  );
}
export declare class InvalidApprovalRuleNameException extends __BaseException {
  readonly name: "InvalidApprovalRuleNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidApprovalRuleNameException,
      __BaseException
    >
  );
}
export declare class InvalidPullRequestIdException extends __BaseException {
  readonly name: "InvalidPullRequestIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidPullRequestIdException, __BaseException>
  );
}
export declare class NumberOfRulesExceededException extends __BaseException {
  readonly name: "NumberOfRulesExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<NumberOfRulesExceededException, __BaseException>
  );
}
export declare class PullRequestAlreadyClosedException extends __BaseException {
  readonly name: "PullRequestAlreadyClosedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PullRequestAlreadyClosedException,
      __BaseException
    >
  );
}
export declare class PullRequestDoesNotExistException extends __BaseException {
  readonly name: "PullRequestDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PullRequestDoesNotExistException,
      __BaseException
    >
  );
}
export declare class PullRequestIdRequiredException extends __BaseException {
  readonly name: "PullRequestIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PullRequestIdRequiredException, __BaseException>
  );
}
export interface CreateRepositoryInput {
  repositoryName: string | undefined;
  repositoryDescription?: string | undefined;
  tags?: Record<string, string> | undefined;
  kmsKeyId?: string | undefined;
}
export interface CreateRepositoryOutput {
  repositoryMetadata?: RepositoryMetadata | undefined;
}
export declare class EncryptionKeyInvalidIdException extends __BaseException {
  readonly name: "EncryptionKeyInvalidIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      EncryptionKeyInvalidIdException,
      __BaseException
    >
  );
}
export declare class EncryptionKeyInvalidUsageException extends __BaseException {
  readonly name: "EncryptionKeyInvalidUsageException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      EncryptionKeyInvalidUsageException,
      __BaseException
    >
  );
}
export declare class InvalidRepositoryDescriptionException extends __BaseException {
  readonly name: "InvalidRepositoryDescriptionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidRepositoryDescriptionException,
      __BaseException
    >
  );
}
export declare class InvalidSystemTagUsageException extends __BaseException {
  readonly name: "InvalidSystemTagUsageException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidSystemTagUsageException, __BaseException>
  );
}
export declare class InvalidTagsMapException extends __BaseException {
  readonly name: "InvalidTagsMapException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidTagsMapException, __BaseException>
  );
}
export declare class OperationNotAllowedException extends __BaseException {
  readonly name: "OperationNotAllowedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<OperationNotAllowedException, __BaseException>
  );
}
export declare class RepositoryLimitExceededException extends __BaseException {
  readonly name: "RepositoryLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryLimitExceededException,
      __BaseException
    >
  );
}
export declare class RepositoryNameExistsException extends __BaseException {
  readonly name: "RepositoryNameExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RepositoryNameExistsException, __BaseException>
  );
}
export declare class TagPolicyException extends __BaseException {
  readonly name: "TagPolicyException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<TagPolicyException, __BaseException>);
}
export declare class TooManyTagsException extends __BaseException {
  readonly name: "TooManyTagsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TooManyTagsException, __BaseException>
  );
}
export declare class ConcurrentReferenceUpdateException extends __BaseException {
  readonly name: "ConcurrentReferenceUpdateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ConcurrentReferenceUpdateException,
      __BaseException
    >
  );
}
export declare const ReplacementTypeEnum: {
  readonly KEEP_BASE: "KEEP_BASE";
  readonly KEEP_DESTINATION: "KEEP_DESTINATION";
  readonly KEEP_SOURCE: "KEEP_SOURCE";
  readonly USE_NEW_CONTENT: "USE_NEW_CONTENT";
};
export type ReplacementTypeEnum =
  (typeof ReplacementTypeEnum)[keyof typeof ReplacementTypeEnum];
export interface ReplaceContentEntry {
  filePath: string | undefined;
  replacementType: ReplacementTypeEnum | undefined;
  content?: Uint8Array | undefined;
  fileMode?: FileModeTypeEnum | undefined;
}
export interface ConflictResolution {
  replaceContents?: ReplaceContentEntry[] | undefined;
  deleteFiles?: DeleteFileEntry[] | undefined;
  setFileModes?: SetFileModeEntry[] | undefined;
}
export interface CreateUnreferencedMergeCommitInput {
  repositoryName: string | undefined;
  sourceCommitSpecifier: string | undefined;
  destinationCommitSpecifier: string | undefined;
  mergeOption: MergeOptionTypeEnum | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
  authorName?: string | undefined;
  email?: string | undefined;
  commitMessage?: string | undefined;
  keepEmptyFolders?: boolean | undefined;
  conflictResolution?: ConflictResolution | undefined;
}
export interface CreateUnreferencedMergeCommitOutput {
  commitId?: string | undefined;
  treeId?: string | undefined;
}
export declare class InvalidConflictResolutionException extends __BaseException {
  readonly name: "InvalidConflictResolutionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidConflictResolutionException,
      __BaseException
    >
  );
}
export declare class InvalidReplacementContentException extends __BaseException {
  readonly name: "InvalidReplacementContentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidReplacementContentException,
      __BaseException
    >
  );
}
export declare class InvalidReplacementTypeException extends __BaseException {
  readonly name: "InvalidReplacementTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidReplacementTypeException,
      __BaseException
    >
  );
}
export declare class ManualMergeRequiredException extends __BaseException {
  readonly name: "ManualMergeRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ManualMergeRequiredException, __BaseException>
  );
}
export declare class MaximumConflictResolutionEntriesExceededException extends __BaseException {
  readonly name: "MaximumConflictResolutionEntriesExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MaximumConflictResolutionEntriesExceededException,
      __BaseException
    >
  );
}
export declare class MultipleConflictResolutionEntriesException extends __BaseException {
  readonly name: "MultipleConflictResolutionEntriesException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MultipleConflictResolutionEntriesException,
      __BaseException
    >
  );
}
export declare class ReplacementContentRequiredException extends __BaseException {
  readonly name: "ReplacementContentRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ReplacementContentRequiredException,
      __BaseException
    >
  );
}
export declare class ReplacementTypeRequiredException extends __BaseException {
  readonly name: "ReplacementTypeRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ReplacementTypeRequiredException,
      __BaseException
    >
  );
}
export interface DeleteApprovalRuleTemplateInput {
  approvalRuleTemplateName: string | undefined;
}
export interface DeleteApprovalRuleTemplateOutput {
  approvalRuleTemplateId: string | undefined;
}
export declare class DefaultBranchCannotBeDeletedException extends __BaseException {
  readonly name: "DefaultBranchCannotBeDeletedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DefaultBranchCannotBeDeletedException,
      __BaseException
    >
  );
}
export interface DeleteBranchInput {
  repositoryName: string | undefined;
  branchName: string | undefined;
}
export interface DeleteBranchOutput {
  deletedBranch?: BranchInfo | undefined;
}
export declare class CommentDeletedException extends __BaseException {
  readonly name: "CommentDeletedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CommentDeletedException, __BaseException>
  );
}
export declare class CommentDoesNotExistException extends __BaseException {
  readonly name: "CommentDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CommentDoesNotExistException, __BaseException>
  );
}
export declare class CommentIdRequiredException extends __BaseException {
  readonly name: "CommentIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CommentIdRequiredException, __BaseException>
  );
}
export interface DeleteCommentContentInput {
  commentId: string | undefined;
}
export interface Comment {
  commentId?: string | undefined;
  content?: string | undefined;
  inReplyTo?: string | undefined;
  creationDate?: Date | undefined;
  lastModifiedDate?: Date | undefined;
  authorArn?: string | undefined;
  deleted?: boolean | undefined;
  clientRequestToken?: string | undefined;
  callerReactions?: string[] | undefined;
  reactionCounts?: Record<string, number> | undefined;
}
export interface DeleteCommentContentOutput {
  comment?: Comment | undefined;
}
export declare class InvalidCommentIdException extends __BaseException {
  readonly name: "InvalidCommentIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidCommentIdException, __BaseException>
  );
}
export interface DeleteFileInput {
  repositoryName: string | undefined;
  branchName: string | undefined;
  filePath: string | undefined;
  parentCommitId: string | undefined;
  keepEmptyFolders?: boolean | undefined;
  commitMessage?: string | undefined;
  name?: string | undefined;
  email?: string | undefined;
}
export interface DeleteFileOutput {
  commitId: string | undefined;
  blobId: string | undefined;
  treeId: string | undefined;
  filePath: string | undefined;
}
export interface DeletePullRequestApprovalRuleInput {
  pullRequestId: string | undefined;
  approvalRuleName: string | undefined;
}
export interface DeletePullRequestApprovalRuleOutput {
  approvalRuleId: string | undefined;
}
export interface DeleteRepositoryInput {
  repositoryName: string | undefined;
}
export interface DeleteRepositoryOutput {
  repositoryId?: string | undefined;
}
export interface DescribeMergeConflictsInput {
  repositoryName: string | undefined;
  destinationCommitSpecifier: string | undefined;
  sourceCommitSpecifier: string | undefined;
  mergeOption: MergeOptionTypeEnum | undefined;
  maxMergeHunks?: number | undefined;
  filePath: string | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
  nextToken?: string | undefined;
}
export interface DescribeMergeConflictsOutput {
  conflictMetadata: ConflictMetadata | undefined;
  mergeHunks: MergeHunk[] | undefined;
  nextToken?: string | undefined;
  destinationCommitId: string | undefined;
  sourceCommitId: string | undefined;
  baseCommitId?: string | undefined;
}
export declare const PullRequestEventType: {
  readonly PULL_REQUEST_APPROVAL_RULE_CREATED: "PULL_REQUEST_APPROVAL_RULE_CREATED";
  readonly PULL_REQUEST_APPROVAL_RULE_DELETED: "PULL_REQUEST_APPROVAL_RULE_DELETED";
  readonly PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN: "PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN";
  readonly PULL_REQUEST_APPROVAL_RULE_UPDATED: "PULL_REQUEST_APPROVAL_RULE_UPDATED";
  readonly PULL_REQUEST_APPROVAL_STATE_CHANGED: "PULL_REQUEST_APPROVAL_STATE_CHANGED";
  readonly PULL_REQUEST_CREATED: "PULL_REQUEST_CREATED";
  readonly PULL_REQUEST_MERGE_STATE_CHANGED: "PULL_REQUEST_MERGE_STATE_CHANGED";
  readonly PULL_REQUEST_SOURCE_REFERENCE_UPDATED: "PULL_REQUEST_SOURCE_REFERENCE_UPDATED";
  readonly PULL_REQUEST_STATUS_CHANGED: "PULL_REQUEST_STATUS_CHANGED";
};
export type PullRequestEventType =
  (typeof PullRequestEventType)[keyof typeof PullRequestEventType];
export interface DescribePullRequestEventsInput {
  pullRequestId: string | undefined;
  pullRequestEventType?: PullRequestEventType | undefined;
  actorArn?: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface PullRequestCreatedEventMetadata {
  repositoryName?: string | undefined;
  sourceCommitId?: string | undefined;
  destinationCommitId?: string | undefined;
  mergeBase?: string | undefined;
}
export interface PullRequestMergedStateChangedEventMetadata {
  repositoryName?: string | undefined;
  destinationReference?: string | undefined;
  mergeMetadata?: MergeMetadata | undefined;
}
export interface PullRequestSourceReferenceUpdatedEventMetadata {
  repositoryName?: string | undefined;
  beforeCommitId?: string | undefined;
  afterCommitId?: string | undefined;
  mergeBase?: string | undefined;
}
export interface PullRequestStatusChangedEventMetadata {
  pullRequestStatus?: PullRequestStatusEnum | undefined;
}
export interface PullRequestEvent {
  pullRequestId?: string | undefined;
  eventDate?: Date | undefined;
  pullRequestEventType?: PullRequestEventType | undefined;
  actorArn?: string | undefined;
  pullRequestCreatedEventMetadata?: PullRequestCreatedEventMetadata | undefined;
  pullRequestStatusChangedEventMetadata?:
    | PullRequestStatusChangedEventMetadata
    | undefined;
  pullRequestSourceReferenceUpdatedEventMetadata?:
    | PullRequestSourceReferenceUpdatedEventMetadata
    | undefined;
  pullRequestMergedStateChangedEventMetadata?:
    | PullRequestMergedStateChangedEventMetadata
    | undefined;
  approvalRuleEventMetadata?: ApprovalRuleEventMetadata | undefined;
  approvalStateChangedEventMetadata?:
    | ApprovalStateChangedEventMetadata
    | undefined;
  approvalRuleOverriddenEventMetadata?:
    | ApprovalRuleOverriddenEventMetadata
    | undefined;
}
export interface DescribePullRequestEventsOutput {
  pullRequestEvents: PullRequestEvent[] | undefined;
  nextToken?: string | undefined;
}
export declare class InvalidActorArnException extends __BaseException {
  readonly name: "InvalidActorArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidActorArnException, __BaseException>
  );
}
export declare class InvalidMaxResultsException extends __BaseException {
  readonly name: "InvalidMaxResultsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidMaxResultsException, __BaseException>
  );
}
export declare class InvalidPullRequestEventTypeException extends __BaseException {
  readonly name: "InvalidPullRequestEventTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidPullRequestEventTypeException,
      __BaseException
    >
  );
}
export interface DisassociateApprovalRuleTemplateFromRepositoryInput {
  approvalRuleTemplateName: string | undefined;
  repositoryName: string | undefined;
}
export interface EvaluatePullRequestApprovalRulesInput {
  pullRequestId: string | undefined;
  revisionId: string | undefined;
}
export interface Evaluation {
  approved?: boolean | undefined;
  overridden?: boolean | undefined;
  approvalRulesSatisfied?: string[] | undefined;
  approvalRulesNotSatisfied?: string[] | undefined;
}
export interface EvaluatePullRequestApprovalRulesOutput {
  evaluation: Evaluation | undefined;
}
export declare class InvalidRevisionIdException extends __BaseException {
  readonly name: "InvalidRevisionIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidRevisionIdException, __BaseException>
  );
}
export declare class RevisionIdRequiredException extends __BaseException {
  readonly name: "RevisionIdRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RevisionIdRequiredException, __BaseException>
  );
}
export declare class RevisionNotCurrentException extends __BaseException {
  readonly name: "RevisionNotCurrentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<RevisionNotCurrentException, __BaseException>
  );
}
export interface GetApprovalRuleTemplateInput {
  approvalRuleTemplateName: string | undefined;
}
export interface GetApprovalRuleTemplateOutput {
  approvalRuleTemplate: ApprovalRuleTemplate | undefined;
}
export declare class FileTooLargeException extends __BaseException {
  readonly name: "FileTooLargeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<FileTooLargeException, __BaseException>
  );
}
export interface GetBlobInput {
  repositoryName: string | undefined;
  blobId: string | undefined;
}
export interface GetBlobOutput {
  content: Uint8Array | undefined;
}
export declare class InvalidBlobIdException extends __BaseException {
  readonly name: "InvalidBlobIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidBlobIdException, __BaseException>
  );
}
export interface GetBranchInput {
  repositoryName?: string | undefined;
  branchName?: string | undefined;
}
export interface GetBranchOutput {
  branch?: BranchInfo | undefined;
}
export interface GetCommentInput {
  commentId: string | undefined;
}
export interface GetCommentOutput {
  comment?: Comment | undefined;
}
export interface GetCommentReactionsInput {
  commentId: string | undefined;
  reactionUserArn?: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ReactionValueFormats {
  emoji?: string | undefined;
  shortCode?: string | undefined;
  unicode?: string | undefined;
}
export interface ReactionForComment {
  reaction?: ReactionValueFormats | undefined;
  reactionUsers?: string[] | undefined;
  reactionsFromDeletedUsersCount?: number | undefined;
}
export interface GetCommentReactionsOutput {
  reactionsForComment: ReactionForComment[] | undefined;
  nextToken?: string | undefined;
}
export declare class InvalidReactionUserArnException extends __BaseException {
  readonly name: "InvalidReactionUserArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidReactionUserArnException,
      __BaseException
    >
  );
}
export interface GetCommentsForComparedCommitInput {
  repositoryName: string | undefined;
  beforeCommitId?: string | undefined;
  afterCommitId: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export declare const RelativeFileVersionEnum: {
  readonly AFTER: "AFTER";
  readonly BEFORE: "BEFORE";
};
export type RelativeFileVersionEnum =
  (typeof RelativeFileVersionEnum)[keyof typeof RelativeFileVersionEnum];
export interface Location {
  filePath?: string | undefined;
  filePosition?: number | undefined;
  relativeFileVersion?: RelativeFileVersionEnum | undefined;
}
export interface CommentsForComparedCommit {
  repositoryName?: string | undefined;
  beforeCommitId?: string | undefined;
  afterCommitId?: string | undefined;
  beforeBlobId?: string | undefined;
  afterBlobId?: string | undefined;
  location?: Location | undefined;
  comments?: Comment[] | undefined;
}
export interface GetCommentsForComparedCommitOutput {
  commentsForComparedCommitData?: CommentsForComparedCommit[] | undefined;
  nextToken?: string | undefined;
}
export interface GetCommentsForPullRequestInput {
  pullRequestId: string | undefined;
  repositoryName?: string | undefined;
  beforeCommitId?: string | undefined;
  afterCommitId?: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface CommentsForPullRequest {
  pullRequestId?: string | undefined;
  repositoryName?: string | undefined;
  beforeCommitId?: string | undefined;
  afterCommitId?: string | undefined;
  beforeBlobId?: string | undefined;
  afterBlobId?: string | undefined;
  location?: Location | undefined;
  comments?: Comment[] | undefined;
}
export interface GetCommentsForPullRequestOutput {
  commentsForPullRequestData?: CommentsForPullRequest[] | undefined;
  nextToken?: string | undefined;
}
export declare class RepositoryNotAssociatedWithPullRequestException extends __BaseException {
  readonly name: "RepositoryNotAssociatedWithPullRequestException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      RepositoryNotAssociatedWithPullRequestException,
      __BaseException
    >
  );
}
export declare class CommitIdDoesNotExistException extends __BaseException {
  readonly name: "CommitIdDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CommitIdDoesNotExistException, __BaseException>
  );
}
export interface GetCommitInput {
  repositoryName: string | undefined;
  commitId: string | undefined;
}
export interface GetCommitOutput {
  commit: Commit | undefined;
}
export interface GetDifferencesInput {
  repositoryName: string | undefined;
  beforeCommitSpecifier?: string | undefined;
  afterCommitSpecifier: string | undefined;
  beforePath?: string | undefined;
  afterPath?: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface Difference {
  beforeBlob?: BlobMetadata | undefined;
  afterBlob?: BlobMetadata | undefined;
  changeType?: ChangeTypeEnum | undefined;
}
export interface GetDifferencesOutput {
  differences?: Difference[] | undefined;
  NextToken?: string | undefined;
}
export declare class PathDoesNotExistException extends __BaseException {
  readonly name: "PathDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PathDoesNotExistException, __BaseException>
  );
}
export interface GetFileInput {
  repositoryName: string | undefined;
  commitSpecifier?: string | undefined;
  filePath: string | undefined;
}
export interface GetFileOutput {
  commitId: string | undefined;
  blobId: string | undefined;
  filePath: string | undefined;
  fileMode: FileModeTypeEnum | undefined;
  fileSize: number | undefined;
  fileContent: Uint8Array | undefined;
}
export declare class FolderDoesNotExistException extends __BaseException {
  readonly name: "FolderDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<FolderDoesNotExistException, __BaseException>
  );
}
export interface GetFolderInput {
  repositoryName: string | undefined;
  commitSpecifier?: string | undefined;
  folderPath: string | undefined;
}
export interface File {
  blobId?: string | undefined;
  absolutePath?: string | undefined;
  relativePath?: string | undefined;
  fileMode?: FileModeTypeEnum | undefined;
}
export interface Folder {
  treeId?: string | undefined;
  absolutePath?: string | undefined;
  relativePath?: string | undefined;
}
export interface SubModule {
  commitId?: string | undefined;
  absolutePath?: string | undefined;
  relativePath?: string | undefined;
}
export interface SymbolicLink {
  blobId?: string | undefined;
  absolutePath?: string | undefined;
  relativePath?: string | undefined;
  fileMode?: FileModeTypeEnum | undefined;
}
export interface GetFolderOutput {
  commitId: string | undefined;
  folderPath: string | undefined;
  treeId?: string | undefined;
  subFolders?: Folder[] | undefined;
  files?: File[] | undefined;
  symbolicLinks?: SymbolicLink[] | undefined;
  subModules?: SubModule[] | undefined;
}
export interface GetMergeCommitInput {
  repositoryName: string | undefined;
  sourceCommitSpecifier: string | undefined;
  destinationCommitSpecifier: string | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
}
export interface GetMergeCommitOutput {
  sourceCommitId?: string | undefined;
  destinationCommitId?: string | undefined;
  baseCommitId?: string | undefined;
  mergedCommitId?: string | undefined;
}
export interface GetMergeConflictsInput {
  repositoryName: string | undefined;
  destinationCommitSpecifier: string | undefined;
  sourceCommitSpecifier: string | undefined;
  mergeOption: MergeOptionTypeEnum | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  maxConflictFiles?: number | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
  nextToken?: string | undefined;
}
export interface GetMergeConflictsOutput {
  mergeable: boolean | undefined;
  destinationCommitId: string | undefined;
  sourceCommitId: string | undefined;
  baseCommitId?: string | undefined;
  conflictMetadataList: ConflictMetadata[] | undefined;
  nextToken?: string | undefined;
}
export declare class InvalidDestinationCommitSpecifierException extends __BaseException {
  readonly name: "InvalidDestinationCommitSpecifierException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDestinationCommitSpecifierException,
      __BaseException
    >
  );
}
export declare class InvalidSourceCommitSpecifierException extends __BaseException {
  readonly name: "InvalidSourceCommitSpecifierException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidSourceCommitSpecifierException,
      __BaseException
    >
  );
}
export interface GetMergeOptionsInput {
  repositoryName: string | undefined;
  sourceCommitSpecifier: string | undefined;
  destinationCommitSpecifier: string | undefined;
  conflictDetailLevel?: ConflictDetailLevelTypeEnum | undefined;
  conflictResolutionStrategy?: ConflictResolutionStrategyTypeEnum | undefined;
}
export interface GetMergeOptionsOutput {
  mergeOptions: MergeOptionTypeEnum[] | undefined;
  sourceCommitId: string | undefined;
  destinationCommitId: string | undefined;
  baseCommitId: string | undefined;
}
export interface GetPullRequestInput {
  pullRequestId: string | undefined;
}
export interface GetPullRequestOutput {
  pullRequest: PullRequest | undefined;
}
export interface GetPullRequestApprovalStatesInput {
  pullRequestId: string | undefined;
  revisionId: string | undefined;
}
export interface GetPullRequestApprovalStatesOutput {
  approvals?: Approval[] | undefined;
}
export interface GetPullRequestOverrideStateInput {
  pullRequestId: string | undefined;
  revisionId: string | undefined;
}
export interface GetPullRequestOverrideStateOutput {
  overridden?: boolean | undefined;
  overrider?: string | undefined;
}
export interface GetRepositoryInput {
  repositoryName: string | undefined;
}
export interface GetRepositoryOutput {
  repositoryMetadata?: RepositoryMetadata | undefined;
}
export interface GetRepositoryTriggersInput {
  repositoryName: string | undefined;
}
export declare const RepositoryTriggerEventEnum: {
  readonly ALL: "all";
  readonly CREATE_REFERENCE: "createReference";
  readonly DELETE_REFERENCE: "deleteReference";
  readonly UPDATE_REFERENCE: "updateReference";
};
export type RepositoryTriggerEventEnum =
  (typeof RepositoryTriggerEventEnum)[keyof typeof RepositoryTriggerEventEnum];
export interface RepositoryTrigger {
  name: string | undefined;
  destinationArn: string | undefined;
  customData?: string | undefined;
  branches?: string[] | undefined;
  events: RepositoryTriggerEventEnum[] | undefined;
}
export interface GetRepositoryTriggersOutput {
  configurationId?: string | undefined;
  triggers?: RepositoryTrigger[] | undefined;
}
export interface ListApprovalRuleTemplatesInput {
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListApprovalRuleTemplatesOutput {
  approvalRuleTemplateNames?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListAssociatedApprovalRuleTemplatesForRepositoryInput {
  repositoryName: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListAssociatedApprovalRuleTemplatesForRepositoryOutput {
  approvalRuleTemplateNames?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListBranchesInput {
  repositoryName: string | undefined;
  nextToken?: string | undefined;
}
export interface ListBranchesOutput {
  branches?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListFileCommitHistoryRequest {
  repositoryName: string | undefined;
  commitSpecifier?: string | undefined;
  filePath: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
