import { HttpHandlerOptions as __HttpHandlerOptions } from "@smithy/types";
import { CodeCommitClient } from "./CodeCommitClient";
import {
  AssociateApprovalRuleTemplateWithRepositoryCommandInput,
  AssociateApprovalRuleTemplateWithRepositoryCommandOutput,
} from "./commands/AssociateApprovalRuleTemplateWithRepositoryCommand";
import {
  BatchAssociateApprovalRuleTemplateWithRepositoriesCommandInput,
  BatchAssociateApprovalRuleTemplateWithRepositoriesCommandOutput,
} from "./commands/BatchAssociateApprovalRuleTemplateWithRepositoriesCommand";
import {
  BatchDescribeMergeConflictsCommandInput,
  BatchDescribeMergeConflictsCommandOutput,
} from "./commands/BatchDescribeMergeConflictsCommand";
import {
  BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandInput,
  BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandOutput,
} from "./commands/BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand";
import {
  BatchGetCommitsCommandInput,
  BatchGetCommitsCommandOutput,
} from "./commands/BatchGetCommitsCommand";
import {
  BatchGetRepositoriesCommandInput,
  BatchGetRepositoriesCommandOutput,
} from "./commands/BatchGetRepositoriesCommand";
import {
  CreateApprovalRuleTemplateCommandInput,
  CreateApprovalRuleTemplateCommandOutput,
} from "./commands/CreateApprovalRuleTemplateCommand";
import {
  CreateBranchCommandInput,
  CreateBranchCommandOutput,
} from "./commands/CreateBranchCommand";
import {
  CreateCommitCommandInput,
  CreateCommitCommandOutput,
} from "./commands/CreateCommitCommand";
import {
  CreatePullRequestApprovalRuleCommandInput,
  CreatePullRequestApprovalRuleCommandOutput,
} from "./commands/CreatePullRequestApprovalRuleCommand";
import {
  CreatePullRequestCommandInput,
  CreatePullRequestCommandOutput,
} from "./commands/CreatePullRequestCommand";
import {
  CreateRepositoryCommandInput,
  CreateRepositoryCommandOutput,
} from "./commands/CreateRepositoryCommand";
import {
  CreateUnreferencedMergeCommitCommandInput,
  CreateUnreferencedMergeCommitCommandOutput,
} from "./commands/CreateUnreferencedMergeCommitCommand";
import {
  DeleteApprovalRuleTemplateCommandInput,
  DeleteApprovalRuleTemplateCommandOutput,
} from "./commands/DeleteApprovalRuleTemplateCommand";
import {
  DeleteBranchCommandInput,
  DeleteBranchCommandOutput,
} from "./commands/DeleteBranchCommand";
import {
  DeleteCommentContentCommandInput,
  DeleteCommentContentCommandOutput,
} from "./commands/DeleteCommentContentCommand";
import {
  DeleteFileCommandInput,
  DeleteFileCommandOutput,
} from "./commands/DeleteFileCommand";
import {
  DeletePullRequestApprovalRuleCommandInput,
  DeletePullRequestApprovalRuleCommandOutput,
} from "./commands/DeletePullRequestApprovalRuleCommand";
import {
  DeleteRepositoryCommandInput,
  DeleteRepositoryCommandOutput,
} from "./commands/DeleteRepositoryCommand";
import {
  DescribeMergeConflictsCommandInput,
  DescribeMergeConflictsCommandOutput,
} from "./commands/DescribeMergeConflictsCommand";
import {
  DescribePullRequestEventsCommandInput,
  DescribePullRequestEventsCommandOutput,
} from "./commands/DescribePullRequestEventsCommand";
import {
  DisassociateApprovalRuleTemplateFromRepositoryCommandInput,
  DisassociateApprovalRuleTemplateFromRepositoryCommandOutput,
} from "./commands/DisassociateApprovalRuleTemplateFromRepositoryCommand";
import {
  EvaluatePullRequestApprovalRulesCommandInput,
  EvaluatePullRequestApprovalRulesCommandOutput,
} from "./commands/EvaluatePullRequestApprovalRulesCommand";
import {
  GetApprovalRuleTemplateCommandInput,
  GetApprovalRuleTemplateCommandOutput,
} from "./commands/GetApprovalRuleTemplateCommand";
import {
  GetBlobCommandInput,
  GetBlobCommandOutput,
} from "./commands/GetBlobCommand";
import {
  GetBranchCommandInput,
  GetBranchCommandOutput,
} from "./commands/GetBranchCommand";
import {
  GetCommentCommandInput,
  GetCommentCommandOutput,
} from "./commands/GetCommentCommand";
import {
  GetCommentReactionsCommandInput,
  GetCommentReactionsCommandOutput,
} from "./commands/GetCommentReactionsCommand";
import {
  GetCommentsForComparedCommitCommandInput,
  GetCommentsForComparedCommitCommandOutput,
} from "./commands/GetCommentsForComparedCommitCommand";
import {
  GetCommentsForPullRequestCommandInput,
  GetCommentsForPullRequestCommandOutput,
} from "./commands/GetCommentsForPullRequestCommand";
import {
  GetCommitCommandInput,
  GetCommitCommandOutput,
} from "./commands/GetCommitCommand";
import {
  GetDifferencesCommandInput,
  GetDifferencesCommandOutput,
} from "./commands/GetDifferencesCommand";
import {
  GetFileCommandInput,
  GetFileCommandOutput,
} from "./commands/GetFileCommand";
import {
  GetFolderCommandInput,
  GetFolderCommandOutput,
} from "./commands/GetFolderCommand";
import {
  GetMergeCommitCommandInput,
  GetMergeCommitCommandOutput,
} from "./commands/GetMergeCommitCommand";
import {
  GetMergeConflictsCommandInput,
  GetMergeConflictsCommandOutput,
} from "./commands/GetMergeConflictsCommand";
import {
  GetMergeOptionsCommandInput,
  GetMergeOptionsCommandOutput,
} from "./commands/GetMergeOptionsCommand";
import {
  GetPullRequestApprovalStatesCommandInput,
  GetPullRequestApprovalStatesCommandOutput,
} from "./commands/GetPullRequestApprovalStatesCommand";
import {
  GetPullRequestCommandInput,
  GetPullRequestCommandOutput,
} from "./commands/GetPullRequestCommand";
import {
  GetPullRequestOverrideStateCommandInput,
  GetPullRequestOverrideStateCommandOutput,
} from "./commands/GetPullRequestOverrideStateCommand";
import {
  GetRepositoryCommandInput,
  GetRepositoryCommandOutput,
} from "./commands/GetRepositoryCommand";
import {
  GetRepositoryTriggersCommandInput,
  GetRepositoryTriggersCommandOutput,
} from "./commands/GetRepositoryTriggersCommand";
import {
  ListApprovalRuleTemplatesCommandInput,
  ListApprovalRuleTemplatesCommandOutput,
} from "./commands/ListApprovalRuleTemplatesCommand";
import {
  ListAssociatedApprovalRuleTemplatesForRepositoryCommandInput,
  ListAssociatedApprovalRuleTemplatesForRepositoryCommandOutput,
} from "./commands/ListAssociatedApprovalRuleTemplatesForRepositoryCommand";
import {
  ListBranchesCommandInput,
  ListBranchesCommandOutput,
} from "./commands/ListBranchesCommand";
import {
  ListFileCommitHistoryCommandInput,
  ListFileCommitHistoryCommandOutput,
} from "./commands/ListFileCommitHistoryCommand";
import {
  ListPullRequestsCommandInput,
  ListPullRequestsCommandOutput,
} from "./commands/ListPullRequestsCommand";
import {
  ListRepositoriesCommandInput,
  ListRepositoriesCommandOutput,
} from "./commands/ListRepositoriesCommand";
import {
  ListRepositoriesForApprovalRuleTemplateCommandInput,
  ListRepositoriesForApprovalRuleTemplateCommandOutput,
} from "./commands/ListRepositoriesForApprovalRuleTemplateCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  MergeBranchesByFastForwardCommandInput,
  MergeBranchesByFastForwardCommandOutput,
} from "./commands/MergeBranchesByFastForwardCommand";
import {
  MergeBranchesBySquashCommandInput,
  MergeBranchesBySquashCommandOutput,
} from "./commands/MergeBranchesBySquashCommand";
import {
  MergeBranchesByThreeWayCommandInput,
  MergeBranchesByThreeWayCommandOutput,
} from "./commands/MergeBranchesByThreeWayCommand";
import {
  MergePullRequestByFastForwardCommandInput,
  MergePullRequestByFastForwardCommandOutput,
} from "./commands/MergePullRequestByFastForwardCommand";
import {
  MergePullRequestBySquashCommandInput,
  MergePullRequestBySquashCommandOutput,
} from "./commands/MergePullRequestBySquashCommand";
import {
  MergePullRequestByThreeWayCommandInput,
  MergePullRequestByThreeWayCommandOutput,
} from "./commands/MergePullRequestByThreeWayCommand";
import {
  OverridePullRequestApprovalRulesCommandInput,
  OverridePullRequestApprovalRulesCommandOutput,
} from "./commands/OverridePullRequestApprovalRulesCommand";
import {
  PostCommentForComparedCommitCommandInput,
  PostCommentForComparedCommitCommandOutput,
} from "./commands/PostCommentForComparedCommitCommand";
import {
  PostCommentForPullRequestCommandInput,
  PostCommentForPullRequestCommandOutput,
} from "./commands/PostCommentForPullRequestCommand";
import {
  PostCommentReplyCommandInput,
  PostCommentReplyCommandOutput,
} from "./commands/PostCommentReplyCommand";
import {
  PutCommentReactionCommandInput,
  PutCommentReactionCommandOutput,
} from "./commands/PutCommentReactionCommand";
import {
  PutFileCommandInput,
  PutFileCommandOutput,
} from "./commands/PutFileCommand";
import {
  PutRepositoryTriggersCommandInput,
  PutRepositoryTriggersCommandOutput,
} from "./commands/PutRepositoryTriggersCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  TestRepositoryTriggersCommandInput,
  TestRepositoryTriggersCommandOutput,
} from "./commands/TestRepositoryTriggersCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateApprovalRuleTemplateContentCommandInput,
  UpdateApprovalRuleTemplateContentCommandOutput,
} from "./commands/UpdateApprovalRuleTemplateContentCommand";
import {
  UpdateApprovalRuleTemplateDescriptionCommandInput,
  UpdateApprovalRuleTemplateDescriptionCommandOutput,
} from "./commands/UpdateApprovalRuleTemplateDescriptionCommand";
import {
  UpdateApprovalRuleTemplateNameCommandInput,
  UpdateApprovalRuleTemplateNameCommandOutput,
} from "./commands/UpdateApprovalRuleTemplateNameCommand";
import {
  UpdateCommentCommandInput,
  UpdateCommentCommandOutput,
} from "./commands/UpdateCommentCommand";
import {
  UpdateDefaultBranchCommandInput,
  UpdateDefaultBranchCommandOutput,
} from "./commands/UpdateDefaultBranchCommand";
import {
  UpdatePullRequestApprovalRuleContentCommandInput,
  UpdatePullRequestApprovalRuleContentCommandOutput,
} from "./commands/UpdatePullRequestApprovalRuleContentCommand";
import {
  UpdatePullRequestApprovalStateCommandInput,
  UpdatePullRequestApprovalStateCommandOutput,
} from "./commands/UpdatePullRequestApprovalStateCommand";
import {
  UpdatePullRequestDescriptionCommandInput,
  UpdatePullRequestDescriptionCommandOutput,
} from "./commands/UpdatePullRequestDescriptionCommand";
import {
  UpdatePullRequestStatusCommandInput,
  UpdatePullRequestStatusCommandOutput,
} from "./commands/UpdatePullRequestStatusCommand";
import {
  UpdatePullRequestTitleCommandInput,
  UpdatePullRequestTitleCommandOutput,
} from "./commands/UpdatePullRequestTitleCommand";
import {
  UpdateRepositoryDescriptionCommandInput,
  UpdateRepositoryDescriptionCommandOutput,
} from "./commands/UpdateRepositoryDescriptionCommand";
import {
  UpdateRepositoryEncryptionKeyCommandInput,
  UpdateRepositoryEncryptionKeyCommandOutput,
} from "./commands/UpdateRepositoryEncryptionKeyCommand";
import {
  UpdateRepositoryNameCommandInput,
  UpdateRepositoryNameCommandOutput,
} from "./commands/UpdateRepositoryNameCommand";
export interface CodeCommit {
  associateApprovalRuleTemplateWithRepository(
    args: AssociateApprovalRuleTemplateWithRepositoryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AssociateApprovalRuleTemplateWithRepositoryCommandOutput>;
  associateApprovalRuleTemplateWithRepository(
    args: AssociateApprovalRuleTemplateWithRepositoryCommandInput,
    cb: (
      err: any,
      data?: AssociateApprovalRuleTemplateWithRepositoryCommandOutput
    ) => void
  ): void;
  associateApprovalRuleTemplateWithRepository(
    args: AssociateApprovalRuleTemplateWithRepositoryCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: AssociateApprovalRuleTemplateWithRepositoryCommandOutput
    ) => void
  ): void;
  batchAssociateApprovalRuleTemplateWithRepositories(
    args: BatchAssociateApprovalRuleTemplateWithRepositoriesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<BatchAssociateApprovalRuleTemplateWithRepositoriesCommandOutput>;
  batchAssociateApprovalRuleTemplateWithRepositories(
    args: BatchAssociateApprovalRuleTemplateWithRepositoriesCommandInput,
    cb: (
      err: any,
      data?: BatchAssociateApprovalRuleTemplateWithRepositoriesCommandOutput
    ) => void
  ): void;
  batchAssociateApprovalRuleTemplateWithRepositories(
    args: BatchAssociateApprovalRuleTemplateWithRepositoriesCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: BatchAssociateApprovalRuleTemplateWithRepositoriesCommandOutput
    ) => void
  ): void;
  batchDescribeMergeConflicts(
    args: BatchDescribeMergeConflictsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<BatchDescribeMergeConflictsCommandOutput>;
  batchDescribeMergeConflicts(
    args: BatchDescribeMergeConflictsCommandInput,
    cb: (err: any, data?: BatchDescribeMergeConflictsCommandOutput) => void
  ): void;
  batchDescribeMergeConflicts(
    args: BatchDescribeMergeConflictsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: BatchDescribeMergeConflictsCommandOutput) => void
  ): void;
  batchDisassociateApprovalRuleTemplateFromRepositories(
    args: BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandOutput>;
  batchDisassociateApprovalRuleTemplateFromRepositories(
    args: BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandInput,
    cb: (
      err: any,
      data?: BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandOutput
    ) => void
  ): void;
  batchDisassociateApprovalRuleTemplateFromRepositories(
    args: BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: BatchDisassociateApprovalRuleTemplateFromRepositoriesCommandOutput
    ) => void
  ): void;
  batchGetCommits(
    args: BatchGetCommitsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<BatchGetCommitsCommandOutput>;
  batchGetCommits(
    args: BatchGetCommitsCommandInput,
    cb: (err: any, data?: BatchGetCommitsCommandOutput) => void
  ): void;
  batchGetCommits(
    args: BatchGetCommitsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: BatchGetCommitsCommandOutput) => void
  ): void;
  batchGetRepositories(
    args: BatchGetRepositoriesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<BatchGetRepositoriesCommandOutput>;
  batchGetRepositories(
    args: BatchGetRepositoriesCommandInput,
    cb: (err: any, data?: BatchGetRepositoriesCommandOutput) => void
  ): void;
  batchGetRepositories(
    args: BatchGetRepositoriesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: BatchGetRepositoriesCommandOutput) => void
  ): void;
  createApprovalRuleTemplate(
    args: CreateApprovalRuleTemplateCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateApprovalRuleTemplateCommandOutput>;
  createApprovalRuleTemplate(
    args: CreateApprovalRuleTemplateCommandInput,
    cb: (err: any, data?: CreateApprovalRuleTemplateCommandOutput) => void
  ): void;
  createApprovalRuleTemplate(
    args: CreateApprovalRuleTemplateCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateApprovalRuleTemplateCommandOutput) => void
  ): void;
  createBranch(
    args: CreateBranchCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateBranchCommandOutput>;
  createBranch(
    args: CreateBranchCommandInput,
    cb: (err: any, data?: CreateBranchCommandOutput) => void
  ): void;
  createBranch(
    args: CreateBranchCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateBranchCommandOutput) => void
  ): void;
  createCommit(
    args: CreateCommitCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateCommitCommandOutput>;
  createCommit(
    args: CreateCommitCommandInput,
    cb: (err: any, data?: CreateCommitCommandOutput) => void
  ): void;
  createCommit(
    args: CreateCommitCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateCommitCommandOutput) => void
  ): void;
  createPullRequest(
    args: CreatePullRequestCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreatePullRequestCommandOutput>;
  createPullRequest(
    args: CreatePullRequestCommandInput,
    cb: (err: any, data?: CreatePullRequestCommandOutput) => void
  ): void;
  createPullRequest(
    args: CreatePullRequestCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreatePullRequestCommandOutput) => void
  ): void;
  createPullRequestApprovalRule(
    args: CreatePullRequestApprovalRuleCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreatePullRequestApprovalRuleCommandOutput>;
  createPullRequestApprovalRule(
    args: CreatePullRequestApprovalRuleCommandInput,
    cb: (err: any, data?: CreatePullRequestApprovalRuleCommandOutput) => void
  ): void;
  createPullRequestApprovalRule(
    args: CreatePullRequestApprovalRuleCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreatePullRequestApprovalRuleCommandOutput) => void
  ): void;
  createRepository(
    args: CreateRepositoryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateRepositoryCommandOutput>;
  createRepository(
    args: CreateRepositoryCommandInput,
    cb: (err: any, data?: CreateRepositoryCommandOutput) => void
  ): void;
  createRepository(
    args: CreateRepositoryCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateRepositoryCommandOutput) => void
  ): void;
  createUnreferencedMergeCommit(
    args: CreateUnreferencedMergeCommitCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateUnreferencedMergeCommitCommandOutput>;
  createUnreferencedMergeCommit(
    args: CreateUnreferencedMergeCommitCommandInput,
    cb: (err: any, data?: CreateUnreferencedMergeCommitCommandOutput) => void
  ): void;
  createUnreferencedMergeCommit(
    args: CreateUnreferencedMergeCommitCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateUnreferencedMergeCommitCommandOutput) => void
  ): void;
  deleteApprovalRuleTemplate(
    args: DeleteApprovalRuleTemplateCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteApprovalRuleTemplateCommandOutput>;
  deleteApprovalRuleTemplate(
    args: DeleteApprovalRuleTemplateCommandInput,
    cb: (err: any, data?: DeleteApprovalRuleTemplateCommandOutput) => void
  ): void;
  deleteApprovalRuleTemplate(
    args: DeleteApprovalRuleTemplateCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteApprovalRuleTemplateCommandOutput) => void
  ): void;
  deleteBranch(
    args: DeleteBranchCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteBranchCommandOutput>;
  deleteBranch(
    args: DeleteBranchCommandInput,
    cb: (err: any, data?: DeleteBranchCommandOutput) => void
  ): void;
  deleteBranch(
    args: DeleteBranchCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteBranchCommandOutput) => void
  ): void;
  deleteCommentContent(
    args: DeleteCommentContentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteCommentContentCommandOutput>;
  deleteCommentContent(
    args: DeleteCommentContentCommandInput,
    cb: (err: any, data?: DeleteCommentContentCommandOutput) => void
  ): void;
  deleteCommentContent(
    args: DeleteCommentContentCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteCommentContentCommandOutput) => void
  ): void;
  deleteFile(
    args: DeleteFileCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteFileCommandOutput>;
  deleteFile(
    args: DeleteFileCommandInput,
    cb: (err: any, data?: DeleteFileCommandOutput) => void
  ): void;
  deleteFile(
    args: DeleteFileCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteFileCommandOutput) => void
  ): void;
  deletePullRequestApprovalRule(
    args: DeletePullRequestApprovalRuleCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeletePullRequestApprovalRuleCommandOutput>;
  deletePullRequestApprovalRule(
    args: DeletePullRequestApprovalRuleCommandInput,
    cb: (err: any, data?: DeletePullRequestApprovalRuleCommandOutput) => void
  ): void;
  deletePullRequestApprovalRule(
    args: DeletePullRequestApprovalRuleCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeletePullRequestApprovalRuleCommandOutput) => void
  ): void;
  deleteRepository(
    args: DeleteRepositoryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteRepositoryCommandOutput>;
  deleteRepository(
    args: DeleteRepositoryCommandInput,
    cb: (err: any, data?: DeleteRepositoryCommandOutput) => void
  ): void;
  deleteRepository(
    args: DeleteRepositoryCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteRepositoryCommandOutput) => void
  ): void;
  describeMergeConflicts(
    args: DescribeMergeConflictsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeMergeConflictsCommandOutput>;
  describeMergeConflicts(
    args: DescribeMergeConflictsCommandInput,
    cb: (err: any, data?: DescribeMergeConflictsCommandOutput) => void
  ): void;
  describeMergeConflicts(
    args: DescribeMergeConflictsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeMergeConflictsCommandOutput) => void
  ): void;
  describePullRequestEvents(
    args: DescribePullRequestEventsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribePullRequestEventsCommandOutput>;
  describePullRequestEvents(
    args: DescribePullRequestEventsCommandInput,
    cb: (err: any, data?: DescribePullRequestEventsCommandOutput) => void
  ): void;
  describePullRequestEvents(
    args: DescribePullRequestEventsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribePullRequestEventsCommandOutput) => void
  ): void;
  disassociateApprovalRuleTemplateFromRepository(
    args: DisassociateApprovalRuleTemplateFromRepositoryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DisassociateApprovalRuleTemplateFromRepositoryCommandOutput>;
  disassociateApprovalRuleTemplateFromRepository(
    args: DisassociateApprovalRuleTemplateFromRepositoryCommandInput,
    cb: (
      err: any,
      data?: DisassociateApprovalRuleTemplateFromRepositoryCommandOutput
    ) => void
  ): void;
  disassociateApprovalRuleTemplateFromRepository(
    args: DisassociateApprovalRuleTemplateFromRepositoryCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DisassociateApprovalRuleTemplateFromRepositoryCommandOutput
    ) => void
  ): void;
  evaluatePullRequestApprovalRules(
    args: EvaluatePullRequestApprovalRulesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<EvaluatePullRequestApprovalRulesCommandOutput>;
  evaluatePullRequestApprovalRules(
    args: EvaluatePullRequestApprovalRulesCommandInput,
    cb: (err: any, data?: EvaluatePullRequestApprovalRulesCommandOutput) => void
  ): void;
  evaluatePullRequestApprovalRules(
    args: EvaluatePullRequestApprovalRulesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: EvaluatePullRequestApprovalRulesCommandOutput) => void
  ): void;
  getApprovalRuleTemplate(
    args: GetApprovalRuleTemplateCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetApprovalRuleTemplateCommandOutput>;
  getApprovalRuleTemplate(
    args: GetApprovalRuleTemplateCommandInput,
    cb: (err: any, data?: GetApprovalRuleTemplateCommandOutput) => void
  ): void;
  getApprovalRuleTemplate(
    args: GetApprovalRuleTemplateCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetApprovalRuleTemplateCommandOutput) => void
  ): void;
  getBlob(
    args: GetBlobCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetBlobCommandOutput>;
  getBlob(
    args: GetBlobCommandInput,
    cb: (err: any, data?: GetBlobCommandOutput) => void
  ): void;
  getBlob(
    args: GetBlobCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetBlobCommandOutput) => void
  ): void;
  getBranch(): Promise<GetBranchCommandOutput>;
  getBranch(
    args: GetBranchCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetBranchCommandOutput>;
  getBranch(
    args: GetBranchCommandInput,
    cb: (err: any, data?: GetBranchCommandOutput) => void
  ): void;
  getBranch(
    args: GetBranchCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetBranchCommandOutput) => void
  ): void;
  getComment(
    args: GetCommentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCommentCommandOutput>;
  getComment(
    args: GetCommentCommandInput,
    cb: (err: any, data?: GetCommentCommandOutput) => void
  ): void;
  getComment(
    args: GetCommentCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCommentCommandOutput) => void
  ): void;
  getCommentReactions(
    args: GetCommentReactionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCommentReactionsCommandOutput>;
  getCommentReactions(
    args: GetCommentReactionsCommandInput,
    cb: (err: any, data?: GetCommentReactionsCommandOutput) => void
  ): void;
  getCommentReactions(
    args: GetCommentReactionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCommentReactionsCommandOutput) => void
  ): void;
  getCommentsForComparedCommit(
    args: GetCommentsForComparedCommitCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCommentsForComparedCommitCommandOutput>;
  getCommentsForComparedCommit(
    args: GetCommentsForComparedCommitCommandInput,
    cb: (err: any, data?: GetCommentsForComparedCommitCommandOutput) => void
  ): void;
  getCommentsForComparedCommit(
    args: GetCommentsForComparedCommitCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCommentsForComparedCommitCommandOutput) => void
  ): void;
  getCommentsForPullRequest(
    args: GetCommentsForPullRequestCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCommentsForPullRequestCommandOutput>;
  getCommentsForPullRequest(
    args: GetCommentsForPullRequestCommandInput,
    cb: (err: any, data?: GetCommentsForPullRequestCommandOutput) => void
  ): void;
  getCommentsForPullRequest(
    args: GetCommentsForPullRequestCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCommentsForPullRequestCommandOutput) => void
  ): void;
  getCommit(
    args: GetCommitCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCommitCommandOutput>;
  getCommit(
    args: GetCommitCommandInput,
    cb: (err: any, data?: GetCommitCommandOutput) => void
  ): void;
  getCommit(
    args: GetCommitCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCommitCommandOutput) => void
  ): void;
  getDifferences(
    args: GetDifferencesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetDifferencesCommandOutput>;
  getDifferences(
    args: GetDifferencesCommandInput,
    cb: (err: any, data?: GetDifferencesCommandOutput) => void
  ): void;
  getDifferences(
    args: GetDifferencesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetDifferencesCommandOutput) => void
  ): void;
  getFile(
    args: GetFileCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFileCommandOutput>;
  getFile(
    args: GetFileCommandInput,
    cb: (err: any, data?: GetFileCommandOutput) => void
  ): void;
  getFile(
    args: GetFileCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFileCommandOutput) => void
  ): void;
  getFolder(
    args: GetFolderCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFolderCommandOutput>;
  getFolder(
    args: GetFolderCommandInput,
    cb: (err: any, data?: GetFolderCommandOutput) => void
  ): void;
  getFolder(
    args: GetFolderCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFolderCommandOutput) => void
  ): void;
  getMergeCommit(
    args: GetMergeCommitCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetMergeCommitCommandOutput>;
  getMergeCommit(
    args: GetMergeCommitCommandInput,
    cb: (err: any, data?: GetMergeCommitCommandOutput) => void
  ): void;
  getMergeCommit(
    args: GetMergeCommitCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetMergeCommitCommandOutput) => void
  ): void;
  getMergeConflicts(
    args: GetMergeConflictsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetMergeConflictsCommandOutput>;
  getMergeConflicts(
    args: GetMergeConflictsCommandInput,
    cb: (err: any, data?: GetMergeConflictsCommandOutput) => void
  ): void;
  getMergeConflicts(
    args: GetMergeConflictsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetMergeConflictsCommandOutput) => void
  ): void;
  getMergeOptions(
    args: GetMergeOptionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetMergeOptionsCommandOutput>;
  getMergeOptions(
    args: GetMergeOptionsCommandInput,
    cb: (err: any, data?: GetMergeOptionsCommandOutput) => void
  ): void;
  getMergeOptions(
    args: GetMergeOptionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetMergeOptionsCommandOutput) => void
  ): void;
  getPullRequest(
    args: GetPullRequestCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetPullRequestCommandOutput>;
  getPullRequest(
    args: GetPullRequestCommandInput,
    cb: (err: any, data?: GetPullRequestCommandOutput) => void
  ): void;
  getPullRequest(
    args: GetPullRequestCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetPullRequestCommandOutput) => void
  ): void;
  getPullRequestApprovalStates(
    args: GetPullRequestApprovalStatesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetPullRequestApprovalStatesCommandOutput>;
  getPullRequestApprovalStates(
    args: GetPullRequestApprovalStatesCommandInput,
    cb: (err: any, data?: GetPullRequestApprovalStatesCommandOutput) => void
  ): void;
  getPullRequestApprovalStates(
    args: GetPullRequestApprovalStatesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetPullRequestApprovalStatesCommandOutput) => void
  ): void;
  getPullRequestOverrideState(
    args: GetPullRequestOverrideStateCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetPullRequestOverrideStateCommandOutput>;
  getPullRequestOverrideState(
    args: GetPullRequestOverrideStateCommandInput,
    cb: (err: any, data?: GetPullRequestOverrideStateCommandOutput) => void
  ): void;
  getPullRequestOverrideState(
    args: GetPullRequestOverrideStateCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetPullRequestOverrideStateCommandOutput) => void
  ): void;
  getRepository(
    args: GetRepositoryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetRepositoryCommandOutput>;
  getRepository(
    args: GetRepositoryCommandInput,
    cb: (err: any, data?: GetRepositoryCommandOutput) => void
  ): void;
  getRepository(
    args: GetRepositoryCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetRepositoryCommandOutput) => void
  ): void;
  getRepositoryTriggers(
    args: GetRepositoryTriggersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetRepositoryTriggersCommandOutput>;
  getRepositoryTriggers(
    args: GetRepositoryTriggersCommandInput,
    cb: (err: any, data?: GetRepositoryTriggersCommandOutput) => void
  ): void;
  getRepositoryTriggers(
    args: GetRepositoryTriggersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetRepositoryTriggersCommandOutput) => void
  ): void;
  listApprovalRuleTemplates(): Promise<ListApprovalRuleTemplatesCommandOutput>;
  listApprovalRuleTemplates(
    args: ListApprovalRuleTemplatesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListApprovalRuleTemplatesCommandOutput>;
  listApprovalRuleTemplates(
    args: ListApprovalRuleTemplatesCommandInput,
    cb: (err: any, data?: ListApprovalRuleTemplatesCommandOutput) => void
  ): void;
  listApprovalRuleTemplates(
    args: ListApprovalRuleTemplatesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListApprovalRuleTemplatesCommandOutput) => void
  ): void;
  listAssociatedApprovalRuleTemplatesForRepository(
    args: ListAssociatedApprovalRuleTemplatesForRepositoryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListAssociatedApprovalRuleTemplatesForRepositoryCommandOutput>;
  listAssociatedApprovalRuleTemplatesForRepository(
    args: ListAssociatedApprovalRuleTemplatesForRepositoryCommandInput,
    cb: (
      err: any,
      data?: ListAssociatedApprovalRuleTemplatesForRepositoryCommandOutput
    ) => void
  ): void;
  listAssociatedApprovalRuleTemplatesForRepository(
    args: ListAssociatedApprovalRuleTemplatesForRepositoryCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListAssociatedApprovalRuleTemplatesForRepositoryCommandOutput
    ) => void
  ): void;
  listBranches(
    args: ListBranchesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListBranchesCommandOutput>;
  listBranches(
    args: ListBranchesCommandInput,
    cb: (err: any, data?: ListBranchesCommandOutput) => void
  ): void;
  listBranches(
    args: ListBranchesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListBranchesCommandOutput) => void
  ): void;
  listFileCommitHistory(
    args: ListFileCommitHistoryCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListFileCommitHistoryCommandOutput>;
  listFileCommitHistory(
    args: ListFileCommitHistoryCommandInput,
    cb: (err: any, data?: ListFileCommitHistoryCommandOutput) => void
  ): void;
  listFileCommitHistory(
    args: ListFileCommitHistoryCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListFileCommitHistoryCommandOutput) => void
  ): void;
  listPullRequests(
    args: ListPullRequestsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListPullRequestsCommandOutput>;
  listPullRequests(
    args: ListPullRequestsCommandInput,
    cb: (err: any, data?: ListPullRequestsCommandOutput) => void
  ): void;
  listPullRequests(
    args: ListPullRequestsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListPullRequestsCommandOutput) => void
  ): void;
  listRepositories(): Promise<ListRepositoriesCommandOutput>;
  listRepositories(
    args: ListRepositoriesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListRepositoriesCommandOutput>;
  listRepositories(
    args: ListRepositoriesCommandInput,
    cb: (err: any, data?: ListRepositoriesCommandOutput) => void
  ): void;
  listRepositories(
    args: ListRepositoriesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListRepositoriesCommandOutput) => void
  ): void;
  listRepositoriesForApprovalRuleTemplate(
    args: ListRepositoriesForApprovalRuleTemplateCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListRepositoriesForApprovalRuleTemplateCommandOutput>;
  listRepositoriesForApprovalRuleTemplate(
    args: ListRepositoriesForApprovalRuleTemplateCommandInput,
    cb: (
      err: any,
      data?: ListRepositoriesForApprovalRuleTemplateCommandOutput
    ) => void
  ): void;
  listRepositoriesForApprovalRuleTemplate(
    args: ListRepositoriesForApprovalRuleTemplateCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListRepositoriesForApprovalRuleTemplateCommandOutput
    ) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListTagsForResourceCommandOutput>;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  mergeBranchesByFastForward(
    args: MergeBranchesByFastForwardCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<MergeBranchesByFastForwardCommandOutput>;
  mergeBranchesByFastForward(
    args: MergeBranchesByFastForwardCommandInput,
    cb: (err: any, data?: MergeBranchesByFastForwardCommandOutput) => void
  ): void;
  mergeBranchesByFastForward(
    args: MergeBranchesByFastForwardCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: MergeBranchesByFastForwardCommandOutput) => void
  ): void;
  mergeBranchesBySquash(
    args: MergeBranchesBySquashCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<MergeBranchesBySquashCommandOutput>;
  mergeBranchesBySquash(
    args: MergeBranchesBySquashCommandInput,
    cb: (err: any, data?: MergeBranchesBySquashCommandOutput) => void
  ): void;
  mergeBranchesBySquash(
    args: MergeBranchesBySquashCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: MergeBranchesBySquashCommandOutput) => void
  ): void;
  mergeBranchesByThreeWay(
    args: MergeBranchesByThreeWayCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<MergeBranchesByThreeWayCommandOutput>;
  mergeBranchesByThreeWay(
    args: MergeBranchesByThreeWayCommandInput,
    cb: (err: any, data?: MergeBranchesByThreeWayCommandOutput) => void
  ): void;
  mergeBranchesByThreeWay(
    args: MergeBranchesByThreeWayCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: MergeBranchesByThreeWayCommandOutput) => void
  ): void;
  mergePullRequestByFastForward(
    args: MergePullRequestByFastForwardCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<MergePullRequestByFastForwardCommandOutput>;
  mergePullRequestByFastForward(
    args: MergePullRequestByFastForwardCommandInput,
    cb: (err: any, data?: MergePullRequestByFastForwardCommandOutput) => void
  ): void;
  mergePullRequestByFastForward(
    args: MergePullRequestByFastForwardCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: MergePullRequestByFastForwardCommandOutput) => void
  ): void;
  mergePullRequestBySquash(
    args: MergePullRequestBySquashCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<MergePullRequestBySquashCommandOutput>;
  mergePullRequestBySquash(
    args: MergePullRequestBySquashCommandInput,
    cb: (err: any, data?: MergePullRequestBySquashCommandOutput) => void
  ): void;
  mergePullRequestBySquash(
    args: MergePullRequestBySquashCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: MergePullRequestBySquashCommandOutput) => void
  ): void;
  mergePullRequestByThreeWay(
    args: MergePullRequestByThreeWayCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<MergePullRequestByThreeWayCommandOutput>;
  mergePullRequestByThreeWay(
    args: MergePullRequestByThreeWayCommandInput,
    cb: (err: any, data?: MergePullRequestByThreeWayCommandOutput) => void
  ): void;
  mergePullRequestByThreeWay(
    args: MergePullRequestByThreeWayCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: MergePullRequestByThreeWayCommandOutput) => void
  ): void;
  overridePullRequestApprovalRules(
    args: OverridePullRequestApprovalRulesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<OverridePullRequestApprovalRulesCommandOutput>;
  overridePullRequestApprovalRules(
    args: OverridePullRequestApprovalRulesCommandInput,
    cb: (err: any, data?: OverridePullRequestApprovalRulesCommandOutput) => void
  ): void;
  overridePullRequestApprovalRules(
    args: OverridePullRequestApprovalRulesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: OverridePullRequestApprovalRulesCommandOutput) => void
  ): void;
  postCommentForComparedCommit(
    args: PostCommentForComparedCommitCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PostCommentForComparedCommitCommandOutput>;
  postCommentForComparedCommit(
    args: PostCommentForComparedCommitCommandInput,
    cb: (err: any, data?: PostCommentForComparedCommitCommandOutput) => void
  ): void;
  postCommentForComparedCommit(
    args: PostCommentForComparedCommitCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PostCommentForComparedCommitCommandOutput) => void
  ): void;
  postCommentForPullRequest(
    args: PostCommentForPullRequestCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PostCommentForPullRequestCommandOutput>;
  postCommentForPullRequest(
    args: PostCommentForPullRequestCommandInput,
    cb: (err: any, data?: PostCommentForPullRequestCommandOutput) => void
  ): void;
  postCommentForPullRequest(
    args: PostCommentForPullRequestCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PostCommentForPullRequestCommandOutput) => void
  ): void;
  postCommentReply(
    args: PostCommentReplyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PostCommentReplyCommandOutput>;
  postCommentReply(
    args: PostCommentReplyCommandInput,
    cb: (err: any, data?: PostCommentReplyCommandOutput) => void
  ): void;
  postCommentReply(
    args: PostCommentReplyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PostCommentReplyCommandOutput) => void
  ): void;
  putCommentReaction(
    args: PutCommentReactionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PutCommentReactionCommandOutput>;
  putCommentReaction(
    args: PutCommentReactionCommandInput,
    cb: (err: any, data?: PutCommentReactionCommandOutput) => void
  ): void;
  putCommentReaction(
    args: PutCommentReactionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PutCommentReactionCommandOutput) => void
  ): void;
  putFile(
    args: PutFileCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PutFileCommandOutput>;
  putFile(
    args: PutFileCommandInput,
    cb: (err: any, data?: PutFileCommandOutput) => void
  ): void;
  putFile(
    args: PutFileCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PutFileCommandOutput) => void
  ): void;
  putRepositoryTriggers(
    args: PutRepositoryTriggersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PutRepositoryTriggersCommandOutput>;
  putRepositoryTriggers(
    args: PutRepositoryTriggersCommandInput,
    cb: (err: any, data?: PutRepositoryTriggersCommandOutput) => void
  ): void;
  putRepositoryTriggers(
    args: PutRepositoryTriggersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PutRepositoryTriggersCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<TagResourceCommandOutput>;
  tagResource(
    args: TagResourceCommandInput,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  testRepositoryTriggers(
    args: TestRepositoryTriggersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<TestRepositoryTriggersCommandOutput>;
  testRepositoryTriggers(
    args: TestRepositoryTriggersCommandInput,
    cb: (err: any, data?: TestRepositoryTriggersCommandOutput) => void
  ): void;
  testRepositoryTriggers(
    args: TestRepositoryTriggersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: TestRepositoryTriggersCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UntagResourceCommandOutput>;
  untagResource(
    args: UntagResourceCommandInput,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  updateApprovalRuleTemplateContent(
    args: UpdateApprovalRuleTemplateContentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateApprovalRuleTemplateContentCommandOutput>;
  updateApprovalRuleTemplateContent(
    args: UpdateApprovalRuleTemplateContentCommandInput,
    cb: (
      err: any,
      data?: UpdateApprovalRuleTemplateContentCommandOutput
    ) => void
  ): void;
  updateApprovalRuleTemplateContent(
    args: UpdateApprovalRuleTemplateContentCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: UpdateApprovalRuleTemplateContentCommandOutput
    ) => void
  ): void;
  updateApprovalRuleTemplateDescription(
    args: UpdateApprovalRuleTemplateDescriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateApprovalRuleTemplateDescriptionCommandOutput>;
  updateApprovalRuleTemplateDescription(
    args: UpdateApprovalRuleTemplateDescriptionCommandInput,
    cb: (
      err: any,
      data?: UpdateApprovalRuleTemplateDescriptionCommandOutput
    ) => void
  ): void;
  updateApprovalRuleTemplateDescription(
    args: UpdateApprovalRuleTemplateDescriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: UpdateApprovalRuleTemplateDescriptionCommandOutput
    ) => void
  ): void;
  updateApprovalRuleTemplateName(
    args: UpdateApprovalRuleTemplateNameCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateApprovalRuleTemplateNameCommandOutput>;
  updateApprovalRuleTemplateName(
    args: UpdateApprovalRuleTemplateNameCommandInput,
    cb: (err: any, data?: UpdateApprovalRuleTemplateNameCommandOutput) => void
  ): void;
  updateApprovalRuleTemplateName(
    args: UpdateApprovalRuleTemplateNameCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateApprovalRuleTemplateNameCommandOutput) => void
  ): void;
  updateComment(
    args: UpdateCommentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateCommentCommandOutput>;
  updateComment(
    args: UpdateCommentCommandInput,
    cb: (err: any, data?: UpdateCommentCommandOutput) => void
  ): void;
  updateComment(
    args: UpdateCommentCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateCommentCommandOutput) => void
  ): void;
  updateDefaultBranch(
    args: UpdateDefaultBranchCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateDefaultBranchCommandOutput>;
  updateDefaultBranch(
    args: UpdateDefaultBranchCommandInput,
    cb: (err: any, data?: UpdateDefaultBranchCommandOutput) => void
  ): void;
  updateDefaultBranch(
    args: UpdateDefaultBranchCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateDefaultBranchCommandOutput) => void
  ): void;
  updatePullRequestApprovalRuleContent(
    args: UpdatePullRequestApprovalRuleContentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdatePullRequestApprovalRuleContentCommandOutput>;
  updatePullRequestApprovalRuleContent(
    args: UpdatePullRequestApprovalRuleContentCommandInput,
    cb: (
      err: any,
      data?: UpdatePullRequestApprovalRuleContentCommandOutput
    ) => void
  ): void;
  updatePullRequestApprovalRuleContent(
    args: UpdatePullRequestApprovalRuleContentCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: UpdatePullRequestApprovalRuleContentCommandOutput
    ) => void
  ): void;
  updatePullRequestApprovalState(
    args: UpdatePullRequestApprovalStateCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdatePullRequestApprovalStateCommandOutput>;
  updatePullRequestApprovalState(
    args: UpdatePullRequestApprovalStateCommandInput,
    cb: (err: any, data?: UpdatePullRequestApprovalStateCommandOutput) => void
  ): void;
  updatePullRequestApprovalState(
    args: UpdatePullRequestApprovalStateCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdatePullRequestApprovalStateCommandOutput) => void
  ): void;
  updatePullRequestDescription(
    args: UpdatePullRequestDescriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdatePullRequestDescriptionCommandOutput>;
  updatePullRequestDescription(
    args: UpdatePullRequestDescriptionCommandInput,
    cb: (err: any, data?: UpdatePullRequestDescriptionCommandOutput) => void
  ): void;
  updatePullRequestDescription(
    args: UpdatePullRequestDescriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdatePullRequestDescriptionCommandOutput) => void
  ): void;
  updatePullRequestStatus(
    args: UpdatePullRequestStatusCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdatePullRequestStatusCommandOutput>;
  updatePullRequestStatus(
    args: UpdatePullRequestStatusCommandInput,
    cb: (err: any, data?: UpdatePullRequestStatusCommandOutput) => void
  ): void;
  updatePullRequestStatus(
    args: UpdatePullRequestStatusCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdatePullRequestStatusCommandOutput) => void
  ): void;
  updatePullRequestTitle(
    args: UpdatePullRequestTitleCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdatePullRequestTitleCommandOutput>;
  updatePullRequestTitle(
    args: UpdatePullRequestTitleCommandInput,
    cb: (err: any, data?: UpdatePullRequestTitleCommandOutput) => void
  ): void;
  updatePullRequestTitle(
    args: UpdatePullRequestTitleCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdatePullRequestTitleCommandOutput) => void
  ): void;
  updateRepositoryDescription(
    args: UpdateRepositoryDescriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateRepositoryDescriptionCommandOutput>;
  updateRepositoryDescription(
    args: UpdateRepositoryDescriptionCommandInput,
    cb: (err: any, data?: UpdateRepositoryDescriptionCommandOutput) => void
  ): void;
  updateRepositoryDescription(
    args: UpdateRepositoryDescriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateRepositoryDescriptionCommandOutput) => void
  ): void;
  updateRepositoryEncryptionKey(
    args: UpdateRepositoryEncryptionKeyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateRepositoryEncryptionKeyCommandOutput>;
  updateRepositoryEncryptionKey(
    args: UpdateRepositoryEncryptionKeyCommandInput,
    cb: (err: any, data?: UpdateRepositoryEncryptionKeyCommandOutput) => void
  ): void;
  updateRepositoryEncryptionKey(
    args: UpdateRepositoryEncryptionKeyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateRepositoryEncryptionKeyCommandOutput) => void
  ): void;
  updateRepositoryName(
    args: UpdateRepositoryNameCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateRepositoryNameCommandOutput>;
  updateRepositoryName(
    args: UpdateRepositoryNameCommandInput,
    cb: (err: any, data?: UpdateRepositoryNameCommandOutput) => void
  ): void;
  updateRepositoryName(
    args: UpdateRepositoryNameCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateRepositoryNameCommandOutput) => void
  ): void;
}
export declare class CodeCommit
  extends CodeCommitClient
  implements CodeCommit {}
