import { loadRestJsonErrorCode, parseJsonBody as parseBody, parseJsonErrorBody as parseErrorBody } from "@aws-sdk/core";
import { HttpRequest as __HttpRequest } from "@smithy/protocol-http";
import { _json, collectBody, decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectLong as __expectLong, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectString as __expectString, parseEpochTimestamp as __parseEpochTimestamp, take, withBaseException, } from "@smithy/smithy-client";
import { v4 as generateIdempotencyToken } from "uuid";
import { CodeCommitServiceException as __BaseException } from "../models/CodeCommitServiceException";
import { ActorDoesNotExistException, ApprovalRuleContentRequiredException, ApprovalRuleDoesNotExistException, ApprovalRuleNameAlreadyExistsException, ApprovalRuleNameRequiredException, ApprovalRuleTemplateContentRequiredException, ApprovalRuleTemplateDoesNotExistException, ApprovalRuleTemplateInUseException, ApprovalRuleTemplateNameAlreadyExistsException, ApprovalRuleTemplateNameRequiredException, ApprovalStateRequiredException, AuthorDoesNotExistException, BeforeCommitIdAndAfterCommitIdAreSameException, BlobIdDoesNotExistException, BlobIdRequiredException, BranchDoesNotExistException, BranchNameExistsException, BranchNameIsTagNameException, BranchNameRequiredException, CannotDeleteApprovalRuleFromTemplateException, CannotModifyApprovalRuleFromTemplateException, ClientRequestTokenRequiredException, CommentDeletedException, CommentDoesNotExistException, CommentIdRequiredException, CommitDoesNotExistException, CommitIdDoesNotExistException, CommitIdRequiredException, CommitIdsLimitExceededException, CommitIdsListRequiredException, CommitMessageLengthExceededException, CommitRequiredException, ConcurrentReferenceUpdateException, DefaultBranchCannotBeDeletedException, DirectoryNameConflictsWithFileNameException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyInvalidIdException, EncryptionKeyInvalidUsageException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, FileContentAndSourceFileSpecifiedException, FileContentSizeLimitExceededException, FileDoesNotExistException, FileEntryRequiredException, FileModeRequiredException, FileNameConflictsWithDirectoryNameException, FilePathConflictsWithSubmodulePathException, FileTooLargeException, FolderContentSizeLimitExceededException, FolderDoesNotExistException, IdempotencyParameterMismatchException, InvalidActorArnException, InvalidApprovalRuleContentException, InvalidApprovalRuleNameException, InvalidApprovalRuleTemplateContentException, InvalidApprovalRuleTemplateDescriptionException, InvalidApprovalRuleTemplateNameException, InvalidBlobIdException, InvalidBranchNameException, InvalidClientRequestTokenException, InvalidCommentIdException, InvalidCommitException, InvalidCommitIdException, InvalidConflictDetailLevelException, InvalidConflictResolutionException, InvalidConflictResolutionStrategyException, InvalidContinuationTokenException, InvalidDeletionParameterException, InvalidDescriptionException, InvalidDestinationCommitSpecifierException, InvalidEmailException, InvalidFileModeException, InvalidMaxConflictFilesException, InvalidMaxMergeHunksException, InvalidMaxResultsException, InvalidMergeOptionException, InvalidParentCommitIdException, InvalidPathException, InvalidPullRequestEventTypeException, InvalidPullRequestIdException, InvalidReactionUserArnException, InvalidReferenceNameException, InvalidReplacementContentException, InvalidReplacementTypeException, InvalidRepositoryDescriptionException, InvalidRepositoryNameException, InvalidRevisionIdException, InvalidSourceCommitSpecifierException, InvalidSystemTagUsageException, InvalidTagsMapException, InvalidTargetException, InvalidTargetsException, InvalidTitleException, ManualMergeRequiredException, MaximumConflictResolutionEntriesExceededException, MaximumFileContentToLoadExceededException, MaximumFileEntriesExceededException, MaximumItemsToCompareExceededException, MaximumOpenPullRequestsExceededException, MaximumRepositoryNamesExceededException, MaximumRuleTemplatesAssociatedWithRepositoryException, MergeOptionRequiredException, MultipleConflictResolutionEntriesException, MultipleRepositoriesInPullRequestException, NameLengthExceededException, NoChangeException, NumberOfRulesExceededException, NumberOfRuleTemplatesExceededException, OperationNotAllowedException, ParentCommitDoesNotExistException, ParentCommitIdOutdatedException, ParentCommitIdRequiredException, PathDoesNotExistException, PathRequiredException, PullRequestAlreadyClosedException, PullRequestDoesNotExistException, PullRequestIdRequiredException, PutFileEntryConflictException, ReferenceDoesNotExistException, ReferenceNameRequiredException, ReferenceTypeNotSupportedException, ReplacementContentRequiredException, ReplacementTypeRequiredException, RepositoryDoesNotExistException, RepositoryLimitExceededException, RepositoryNameExistsException, RepositoryNameRequiredException, RepositoryNamesRequiredException, RepositoryNotAssociatedWithPullRequestException, RestrictedSourceFileException, RevisionIdRequiredException, RevisionNotCurrentException, SamePathRequestException, SourceAndDestinationAreSameException, SourceFileOrContentRequiredException, TagPolicyException, TargetRequiredException, TargetsRequiredException, TipsDivergenceExceededException, TitleRequiredException, TooManyTagsException, } from "../models/models_0";
import { CommentContentRequiredException, CommentContentSizeLimitExceededException, CommentNotCreatedByCallerException, EncryptionKeyRequiredException, FileContentRequiredException, InvalidApprovalStateException, InvalidAuthorArnException, InvalidFileLocationException, InvalidFilePositionException, InvalidOrderException, InvalidOverrideStatusException, InvalidPullRequestStatusException, InvalidPullRequestStatusUpdateException, InvalidReactionValueException, InvalidRelativeFileVersionEnumException, InvalidRepositoryTriggerBranchNameException, InvalidRepositoryTriggerCustomDataException, InvalidRepositoryTriggerDestinationArnException, InvalidRepositoryTriggerEventsException, InvalidRepositoryTriggerNameException, InvalidRepositoryTriggerRegionException, InvalidResourceArnException, InvalidRuleContentSha256Exception, InvalidSortByException, InvalidTagKeysListException, InvalidTargetBranchException, MaximumBranchesExceededException, MaximumNumberOfApprovalsExceededException, MaximumRepositoryTriggersExceededException, OverrideAlreadySetException, OverrideStatusRequiredException, PullRequestApprovalRulesNotSatisfiedException, PullRequestCannotBeApprovedByAuthorException, PullRequestStatusRequiredException, ReactionLimitExceededException, ReactionValueRequiredException, RepositoryTriggerBranchNameListRequiredException, RepositoryTriggerDestinationArnRequiredException, RepositoryTriggerEventsListRequiredException, RepositoryTriggerNameRequiredException, RepositoryTriggersListRequiredException, ResourceArnRequiredException, SameFileContentException, TagKeysListRequiredException, TagsMapRequiredException, TipOfSourceReferenceIsDifferentException, } from "../models/models_1";
export const se_AssociateApprovalRuleTemplateWithRepositoryCommand = async (input, context) => {
    const headers = sharedHeaders("AssociateApprovalRuleTemplateWithRepository");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchAssociateApprovalRuleTemplateWithRepositoriesCommand = async (input, context) => {
    const headers = sharedHeaders("BatchAssociateApprovalRuleTemplateWithRepositories");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchDescribeMergeConflictsCommand = async (input, context) => {
    const headers = sharedHeaders("BatchDescribeMergeConflicts");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand = async (input, context) => {
    const headers = sharedHeaders("BatchDisassociateApprovalRuleTemplateFromRepositories");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetCommitsCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetCommits");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetRepositoriesCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetRepositories");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateApprovalRuleTemplateCommand = async (input, context) => {
    const headers = sharedHeaders("CreateApprovalRuleTemplate");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateBranchCommand = async (input, context) => {
    const headers = sharedHeaders("CreateBranch");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateCommitCommand = async (input, context) => {
    const headers = sharedHeaders("CreateCommit");
    let body;
    body = JSON.stringify(se_CreateCommitInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreatePullRequestCommand = async (input, context) => {
    const headers = sharedHeaders("CreatePullRequest");
    let body;
    body = JSON.stringify(se_CreatePullRequestInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreatePullRequestApprovalRuleCommand = async (input, context) => {
    const headers = sharedHeaders("CreatePullRequestApprovalRule");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateRepositoryCommand = async (input, context) => {
    const headers = sharedHeaders("CreateRepository");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateUnreferencedMergeCommitCommand = async (input, context) => {
    const headers = sharedHeaders("CreateUnreferencedMergeCommit");
    let body;
    body = JSON.stringify(se_CreateUnreferencedMergeCommitInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteApprovalRuleTemplateCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteApprovalRuleTemplate");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteBranchCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteBranch");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteCommentContentCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteCommentContent");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteFileCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteFile");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeletePullRequestApprovalRuleCommand = async (input, context) => {
    const headers = sharedHeaders("DeletePullRequestApprovalRule");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRepositoryCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteRepository");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeMergeConflictsCommand = async (input, context) => {
    const headers = sharedHeaders("DescribeMergeConflicts");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribePullRequestEventsCommand = async (input, context) => {
    const headers = sharedHeaders("DescribePullRequestEvents");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateApprovalRuleTemplateFromRepositoryCommand = async (input, context) => {
    const headers = sharedHeaders("DisassociateApprovalRuleTemplateFromRepository");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EvaluatePullRequestApprovalRulesCommand = async (input, context) => {
    const headers = sharedHeaders("EvaluatePullRequestApprovalRules");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetApprovalRuleTemplateCommand = async (input, context) => {
    const headers = sharedHeaders("GetApprovalRuleTemplate");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetBlobCommand = async (input, context) => {
    const headers = sharedHeaders("GetBlob");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetBranchCommand = async (input, context) => {
    const headers = sharedHeaders("GetBranch");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetCommentCommand = async (input, context) => {
    const headers = sharedHeaders("GetComment");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetCommentReactionsCommand = async (input, context) => {
    const headers = sharedHeaders("GetCommentReactions");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetCommentsForComparedCommitCommand = async (input, context) => {
    const headers = sharedHeaders("GetCommentsForComparedCommit");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetCommentsForPullRequestCommand = async (input, context) => {
    const headers = sharedHeaders("GetCommentsForPullRequest");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetCommitCommand = async (input, context) => {
    const headers = sharedHeaders("GetCommit");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetDifferencesCommand = async (input, context) => {
    const headers = sharedHeaders("GetDifferences");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetFileCommand = async (input, context) => {
    const headers = sharedHeaders("GetFile");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetFolderCommand = async (input, context) => {
    const headers = sharedHeaders("GetFolder");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetMergeCommitCommand = async (input, context) => {
    const headers = sharedHeaders("GetMergeCommit");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetMergeConflictsCommand = async (input, context) => {
    const headers = sharedHeaders("GetMergeConflicts");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetMergeOptionsCommand = async (input, context) => {
    const headers = sharedHeaders("GetMergeOptions");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetPullRequestCommand = async (input, context) => {
    const headers = sharedHeaders("GetPullRequest");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetPullRequestApprovalStatesCommand = async (input, context) => {
    const headers = sharedHeaders("GetPullRequestApprovalStates");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetPullRequestOverrideStateCommand = async (input, context) => {
    const headers = sharedHeaders("GetPullRequestOverrideState");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetRepositoryCommand = async (input, context) => {
    const headers = sharedHeaders("GetRepository");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetRepositoryTriggersCommand = async (input, context) => {
    const headers = sharedHeaders("GetRepositoryTriggers");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListApprovalRuleTemplatesCommand = async (input, context) => {
    const headers = sharedHeaders("ListApprovalRuleTemplates");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListAssociatedApprovalRuleTemplatesForRepositoryCommand = async (input, context) => {
    const headers = sharedHeaders("ListAssociatedApprovalRuleTemplatesForRepository");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListBranchesCommand = async (input, context) => {
    const headers = sharedHeaders("ListBranches");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListFileCommitHistoryCommand = async (input, context) => {
    const headers = sharedHeaders("ListFileCommitHistory");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListPullRequestsCommand = async (input, context) => {
    const headers = sharedHeaders("ListPullRequests");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListRepositoriesCommand = async (input, context) => {
    const headers = sharedHeaders("ListRepositories");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListRepositoriesForApprovalRuleTemplateCommand = async (input, context) => {
    const headers = sharedHeaders("ListRepositoriesForApprovalRuleTemplate");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListTagsForResourceCommand = async (input, context) => {
    const headers = sharedHeaders("ListTagsForResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MergeBranchesByFastForwardCommand = async (input, context) => {
    const headers = sharedHeaders("MergeBranchesByFastForward");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MergeBranchesBySquashCommand = async (input, context) => {
    const headers = sharedHeaders("MergeBranchesBySquash");
    let body;
    body = JSON.stringify(se_MergeBranchesBySquashInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MergeBranchesByThreeWayCommand = async (input, context) => {
    const headers = sharedHeaders("MergeBranchesByThreeWay");
    let body;
    body = JSON.stringify(se_MergeBranchesByThreeWayInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MergePullRequestByFastForwardCommand = async (input, context) => {
    const headers = sharedHeaders("MergePullRequestByFastForward");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MergePullRequestBySquashCommand = async (input, context) => {
    const headers = sharedHeaders("MergePullRequestBySquash");
    let body;
    body = JSON.stringify(se_MergePullRequestBySquashInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MergePullRequestByThreeWayCommand = async (input, context) => {
    const headers = sharedHeaders("MergePullRequestByThreeWay");
    let body;
    body = JSON.stringify(se_MergePullRequestByThreeWayInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_OverridePullRequestApprovalRulesCommand = async (input, context) => {
    const headers = sharedHeaders("OverridePullRequestApprovalRules");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PostCommentForComparedCommitCommand = async (input, context) => {
    const headers = sharedHeaders("PostCommentForComparedCommit");
    let body;
    body = JSON.stringify(se_PostCommentForComparedCommitInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PostCommentForPullRequestCommand = async (input, context) => {
    const headers = sharedHeaders("PostCommentForPullRequest");
    let body;
    body = JSON.stringify(se_PostCommentForPullRequestInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PostCommentReplyCommand = async (input, context) => {
    const headers = sharedHeaders("PostCommentReply");
    let body;
    body = JSON.stringify(se_PostCommentReplyInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutCommentReactionCommand = async (input, context) => {
    const headers = sharedHeaders("PutCommentReaction");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutFileCommand = async (input, context) => {
    const headers = sharedHeaders("PutFile");
    let body;
    body = JSON.stringify(se_PutFileInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutRepositoryTriggersCommand = async (input, context) => {
    const headers = sharedHeaders("PutRepositoryTriggers");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_TagResourceCommand = async (input, context) => {
    const headers = sharedHeaders("TagResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_TestRepositoryTriggersCommand = async (input, context) => {
    const headers = sharedHeaders("TestRepositoryTriggers");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UntagResourceCommand = async (input, context) => {
    const headers = sharedHeaders("UntagResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateApprovalRuleTemplateContentCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateApprovalRuleTemplateContent");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateApprovalRuleTemplateDescriptionCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateApprovalRuleTemplateDescription");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateApprovalRuleTemplateNameCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateApprovalRuleTemplateName");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateCommentCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateComment");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateDefaultBranchCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateDefaultBranch");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdatePullRequestApprovalRuleContentCommand = async (input, context) => {
    const headers = sharedHeaders("UpdatePullRequestApprovalRuleContent");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdatePullRequestApprovalStateCommand = async (input, context) => {
    const headers = sharedHeaders("UpdatePullRequestApprovalState");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdatePullRequestDescriptionCommand = async (input, context) => {
    const headers = sharedHeaders("UpdatePullRequestDescription");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdatePullRequestStatusCommand = async (input, context) => {
    const headers = sharedHeaders("UpdatePullRequestStatus");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdatePullRequestTitleCommand = async (input, context) => {
    const headers = sharedHeaders("UpdatePullRequestTitle");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateRepositoryDescriptionCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateRepositoryDescription");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateRepositoryEncryptionKeyCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateRepositoryEncryptionKey");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateRepositoryNameCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateRepositoryName");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const de_AssociateApprovalRuleTemplateWithRepositoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_BatchAssociateApprovalRuleTemplateWithRepositoriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_BatchDescribeMergeConflictsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_BatchGetCommitsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_BatchGetRepositoriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BatchGetRepositoriesOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateApprovalRuleTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateApprovalRuleTemplateOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateBranchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_CreateCommitCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreatePullRequestCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreatePullRequestOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreatePullRequestApprovalRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreatePullRequestApprovalRuleOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateRepositoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateRepositoryOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateUnreferencedMergeCommitCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteApprovalRuleTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteBranchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteCommentContentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteCommentContentOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteFileCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeletePullRequestApprovalRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteRepositoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeMergeConflictsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribePullRequestEventsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribePullRequestEventsOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateApprovalRuleTemplateFromRepositoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_EvaluatePullRequestApprovalRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetApprovalRuleTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetApprovalRuleTemplateOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetBlobCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetBlobOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetBranchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetCommentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetCommentOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetCommentReactionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetCommentsForComparedCommitCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetCommentsForComparedCommitOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetCommentsForPullRequestCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetCommentsForPullRequestOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetCommitCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetDifferencesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetFileCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetFileOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetFolderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetMergeCommitCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetMergeConflictsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetMergeOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetPullRequestCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetPullRequestOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetPullRequestApprovalStatesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetPullRequestOverrideStateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetRepositoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetRepositoryOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetRepositoryTriggersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListApprovalRuleTemplatesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListAssociatedApprovalRuleTemplatesForRepositoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListBranchesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListFileCommitHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListPullRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListRepositoriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListRepositoriesForApprovalRuleTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MergeBranchesByFastForwardCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MergeBranchesBySquashCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MergeBranchesByThreeWayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MergePullRequestByFastForwardCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_MergePullRequestByFastForwardOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MergePullRequestBySquashCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_MergePullRequestBySquashOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MergePullRequestByThreeWayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_MergePullRequestByThreeWayOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_OverridePullRequestApprovalRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_PostCommentForComparedCommitCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PostCommentForComparedCommitOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PostCommentForPullRequestCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PostCommentForPullRequestOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PostCommentReplyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PostCommentReplyOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutCommentReactionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_PutFileCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PutRepositoryTriggersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_TestRepositoryTriggersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_UpdateApprovalRuleTemplateContentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateApprovalRuleTemplateContentOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateApprovalRuleTemplateDescriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateApprovalRuleTemplateDescriptionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateApprovalRuleTemplateNameCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateApprovalRuleTemplateNameOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateCommentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateCommentOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateDefaultBranchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_UpdatePullRequestApprovalRuleContentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdatePullRequestApprovalRuleContentOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdatePullRequestApprovalStateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_UpdatePullRequestDescriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdatePullRequestDescriptionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdatePullRequestStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdatePullRequestStatusOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdatePullRequestTitleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdatePullRequestTitleOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateRepositoryDescriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_UpdateRepositoryEncryptionKeyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateRepositoryNameCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_CommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApprovalRuleTemplateDoesNotExistException":
        case "com.amazonaws.codecommit#ApprovalRuleTemplateDoesNotExistException":
            throw await de_ApprovalRuleTemplateDoesNotExistExceptionRes(parsedOutput, context);
        case "ApprovalRuleTemplateNameRequiredException":
        case "com.amazonaws.codecommit#ApprovalRuleTemplateNameRequiredException":
            throw await de_ApprovalRuleTemplateNameRequiredExceptionRes(parsedOutput, context);
        case "EncryptionIntegrityChecksFailedException":
        case "com.amazonaws.codecommit#EncryptionIntegrityChecksFailedException":
            throw await de_EncryptionIntegrityChecksFailedExceptionRes(parsedOutput, context);
        case "EncryptionKeyAccessDeniedException":
        case "com.amazonaws.codecommit#EncryptionKeyAccessDeniedException":
            throw await de_EncryptionKeyAccessDeniedExceptionRes(parsedOutput, context);
        case "EncryptionKeyDisabledException":
        case "com.amazonaws.codecommit#EncryptionKeyDisabledException":
            throw await de_EncryptionKeyDisabledExceptionRes(parsedOutput, context);
        case "EncryptionKeyNotFoundException":
        case "com.amazonaws.codecommit#EncryptionKeyNotFoundException":
            throw await de_EncryptionKeyNotFoundExceptionRes(parsedOutput, context);
        case "EncryptionKeyUnavailableException":
        case "com.amazonaws.codecommit#EncryptionKeyUnavailableException":
            throw await de_EncryptionKeyUnavailableExceptionRes(parsedOutput, context);
        case "InvalidApprovalRuleTemplateNameException":
        case "com.amazonaws.codecommit#InvalidApprovalRuleTemplateNameException":
            throw await de_InvalidApprovalRuleTemplateNameExceptionRes(parsedOutput, context);
        case "InvalidRepositoryNameException":
        case "com.amazonaws.codecommit#InvalidRepositoryNameException":
            throw await de_InvalidRepositoryNameExceptionRes(parsedOutput, context);
        case "MaximumRuleTemplatesAssociatedWithRepositoryException":
        case "com.amazonaws.codecommit#MaximumRuleTemplatesAssociatedWithRepositoryException":
            throw await de_MaximumRuleTemplatesAssociatedWithRepositoryExceptionRes(parsedOutput, context);
        case "RepositoryDoesNotExistException":
        case "com.amazonaws.codecommit#RepositoryDoesNotExistException":
            throw await de_RepositoryDoesNotExistExceptionRes(parsedOutput, context);
        case "RepositoryNameRequiredException":
        case "com.amazonaws.codecommit#RepositoryNameRequiredException":
            throw await de_RepositoryNameRequiredExceptionRes(parsedOutput, context);
        case "MaximumRepositoryNamesExceededException":
        case "com.amazonaws.codecommit#MaximumRepositoryNamesExceededException":
            throw await de_MaximumRepositoryNamesExceededExceptionRes(parsedOutput, context);
        case "RepositoryNamesRequiredException":
        case "com.amazonaws.codecommit#RepositoryNamesRequiredException":
            throw await de_RepositoryNamesRequiredExceptionRes(parsedOutput, context);
        case "CommitDoesNotExistException":
        case "com.amazonaws.codecommit#CommitDoesNotExistException":
            throw await de_CommitDoesNotExistExceptionRes(parsedOutput, context);
        case "CommitRequiredException":
        case "com.amazonaws.codecommit#CommitRequiredException":
            throw await de_CommitRequiredExceptionRes(parsedOutput, context);
        case "InvalidCommitException":
        case "com.amazonaws.codecommit#InvalidCommitException":
            throw await de_InvalidCommitExceptionRes(parsedOutput, context);
        case "InvalidConflictDetailLevelException":
        case "com.amazonaws.codecommit#InvalidConflictDetailLevelException":
            throw await de_InvalidConflictDetailLevelExceptionRes(parsedOutput, context);
        case "InvalidConflictResolutionStrategyException":
        case "com.amazonaws.codecommit#InvalidConflictResolutionStrategyException":
            throw await de_InvalidConflictResolutionStrategyExceptionRes(parsedOutput, context);
        case "InvalidContinuationTokenException":
        case "com.amazonaws.codecommit#InvalidContinuationTokenException":
            throw await de_InvalidContinuationTokenExceptionRes(parsedOutput, context);
        case "InvalidMaxConflictFilesException":
        case "com.amazonaws.codecommit#InvalidMaxConflictFilesException":
            throw await de_InvalidMaxConflictFilesExceptionRes(parsedOutput, context);
        case "InvalidMaxMergeHunksException":
        case "com.amazonaws.codecommit#InvalidMaxMergeHunksException":
            throw await de_InvalidMaxMergeHunksExceptionRes(parsedOutput, context);
        case "InvalidMergeOptionException":
        case "com.amazonaws.codecommit#InvalidMergeOptionException":
            throw await de_InvalidMergeOptionExceptionRes(parsedOutput, context);
        case "MaximumFileContentToLoadExceededException":
        case "com.amazonaws.codecommit#MaximumFileContentToLoadExceededException":
            throw await de_MaximumFileContentToLoadExceededExceptionRes(parsedOutput, context);
        case "MaximumItemsToCompareExceededException":
        case "com.amazonaws.codecommit#MaximumItemsToCompareExceededException":
            throw await de_MaximumItemsToCompareExceededExceptionRes(parsedOutput, context);
        case "MergeOptionRequiredException":
        case "com.amazonaws.codecommit#MergeOptionRequiredException":
            throw await de_MergeOptionRequiredExceptionRes(parsedOutput, context);
        case "TipsDivergenceExceededException":
        case "com.amazonaws.codecommit#TipsDivergenceExceededException":
            throw await de_TipsDivergenceExceededExceptionRes(parsedOutput, context);
        case "CommitIdsLimitExceededException":
        case "com.amazonaws.codecommit#CommitIdsLimitExceededException":
            throw await de_CommitIdsLimitExceededExceptionRes(parsedOutput, context);
        case "CommitIdsListRequiredException":
        case "com.amazonaws.codecommit#CommitIdsListRequiredException":
            throw await de_CommitIdsListRequiredExceptionRes(parsedOutput, context);
        case "ApprovalRuleTemplateContentRequiredException":
        case "com.amazonaws.codecommit#ApprovalRuleTemplateContentRequiredException":
            throw await de_ApprovalRuleTemplateContentRequiredExceptionRes(parsedOutput, context);
        case "ApprovalRuleTemplateNameAlreadyExistsException":
        case "com.amazonaws.codecommit#ApprovalRuleTemplateNameAlreadyExistsException":
            throw await de_ApprovalRuleTemplateNameAlreadyExistsExceptionRes(parsedOutput, context);
        case "InvalidApprovalRuleTemplateContentException":
        case "com.amazonaws.codecommit#InvalidApprovalRuleTemplateContentException":
            throw await de_InvalidApprovalRuleTemplateContentExceptionRes(parsedOutput, context);
        case "InvalidApprovalRuleTemplateDescriptionException":
        case "com.amazonaws.codecommit#InvalidApprovalRuleTemplateDescriptionException":
            throw await de_InvalidApprovalRuleTemplateDescriptionExceptionRes(parsedOutput, context);
        case "NumberOfRuleTemplatesExceededException":
        case "com.amazonaws.codecommit#NumberOfRuleTemplatesExceededException":
            throw await de_NumberOfRuleTemplatesExceededExceptionRes(parsedOutput, context);
        case "BranchNameExistsException":
        case "com.amazonaws.codecommit#BranchNameExistsException":
            throw await de_BranchNameExistsExceptionRes(parsedOutput, context);
        case "BranchNameRequiredException":
        case "com.amazonaws.codecommit#BranchNameRequiredException":
            throw await de_BranchNameRequiredExceptionRes(parsedOutput, context);
        case "CommitIdRequiredException":
        case "com.amazonaws.codecommit#CommitIdRequiredException":
            throw await de_CommitIdRequiredExceptionRes(parsedOutput, context);
        case "InvalidBranchNameException":
        case "com.amazonaws.codecommit#InvalidBranchNameException":
            throw await de_InvalidBranchNameExceptionRes(parsedOutput, context);
        case "InvalidCommitIdException":
        case "com.amazonaws.codecommit#InvalidCommitIdException":
            throw await de_InvalidCommitIdExceptionRes(parsedOutput, context);
        case "BranchDoesNotExistException":
        case "com.amazonaws.codecommit#BranchDoesNotExistException":
            throw await de_BranchDoesNotExistExceptionRes(parsedOutput, context);
        case "BranchNameIsTagNameException":
        case "com.amazonaws.codecommit#BranchNameIsTagNameException":
            throw await de_BranchNameIsTagNameExceptionRes(parsedOutput, context);
        case "CommitMessageLengthExceededException":
        case "com.amazonaws.codecommit#CommitMessageLengthExceededException":
            throw await de_CommitMessageLengthExceededExceptionRes(parsedOutput, context);
        case "DirectoryNameConflictsWithFileNameException":
        case "com.amazonaws.codecommit#DirectoryNameConflictsWithFileNameException":
            throw await de_DirectoryNameConflictsWithFileNameExceptionRes(parsedOutput, context);
        case "FileContentAndSourceFileSpecifiedException":
        case "com.amazonaws.codecommit#FileContentAndSourceFileSpecifiedException":
            throw await de_FileContentAndSourceFileSpecifiedExceptionRes(parsedOutput, context);
        case "FileContentSizeLimitExceededException":
        case "com.amazonaws.codecommit#FileContentSizeLimitExceededException":
            throw await de_FileContentSizeLimitExceededExceptionRes(parsedOutput, context);
        case "FileDoesNotExistException":
        case "com.amazonaws.codecommit#FileDoesNotExistException":
            throw await de_FileDoesNotExistExceptionRes(parsedOutput, context);
        case "FileEntryRequiredException":
        case "com.amazonaws.codecommit#FileEntryRequiredException":
            throw await de_FileEntryRequiredExceptionRes(parsedOutput, context);
        case "FileModeRequiredException":
        case "com.amazonaws.codecommit#FileModeRequiredException":
            throw await de_FileModeRequiredExceptionRes(parsedOutput, context);
        case "FileNameConflictsWithDirectoryNameException":
        case "com.amazonaws.codecommit#FileNameConflictsWithDirectoryNameException":
            throw await de_FileNameConflictsWithDirectoryNameExceptionRes(parsedOutput, context);
        case "FilePathConflictsWithSubmodulePathException":
        case "com.amazonaws.codecommit#FilePathConflictsWithSubmodulePathException":
            throw await de_FilePathConflictsWithSubmodulePathExceptionRes(parsedOutput, context);
        case "FolderContentSizeLimitExceededException":
        case "com.amazonaws.codecommit#FolderContentSizeLimitExceededException":
            throw await de_FolderContentSizeLimitExceededExceptionRes(parsedOutput, context);
        case "InvalidDeletionParameterException":
        case "com.amazonaws.codecommit#InvalidDeletionParameterException":
            throw await de_InvalidDeletionParameterExceptionRes(parsedOutput, context);
        case "InvalidEmailException":
        case "com.amazonaws.codecommit#InvalidEmailException":
            throw await de_InvalidEmailExceptionRes(parsedOutput, context);
        case "InvalidFileModeException":
        case "com.amazonaws.codecommit#InvalidFileModeException":
            throw await de_InvalidFileModeExceptionRes(parsedOutput, context);
        case "InvalidParentCommitIdException":
        case "com.amazonaws.codecommit#InvalidParentCommitIdException":
            throw await de_InvalidParentCommitIdExceptionRes(parsedOutput, context);
        case "InvalidPathException":
        case "com.amazonaws.codecommit#InvalidPathException":
            throw await de_InvalidPathExceptionRes(parsedOutput, context);
        case "MaximumFileEntriesExceededException":
        case "com.amazonaws.codecommit#MaximumFileEntriesExceededException":
            throw await de_MaximumFileEntriesExceededExceptionRes(parsedOutput, context);
        case "NameLengthExceededException":
        case "com.amazonaws.codecommit#NameLengthExceededException":
            throw await de_NameLengthExceededExceptionRes(parsedOutput, context);
        case "NoChangeException":
        case "com.amazonaws.codecommit#NoChangeException":
            throw await de_NoChangeExceptionRes(parsedOutput, context);
        case "ParentCommitDoesNotExistException":
        case "com.amazonaws.codecommit#ParentCommitDoesNotExistException":
            throw await de_ParentCommitDoesNotExistExceptionRes(parsedOutput, context);
        case "ParentCommitIdOutdatedException":
        case "com.amazonaws.codecommit#ParentCommitIdOutdatedException":
            throw await de_ParentCommitIdOutdatedExceptionRes(parsedOutput, context);
        case "ParentCommitIdRequiredException":
        case "com.amazonaws.codecommit#ParentCommitIdRequiredException":
            throw await de_ParentCommitIdRequiredExceptionRes(parsedOutput, context);
        case "PathRequiredException":
        case "com.amazonaws.codecommit#PathRequiredException":
            throw await de_PathRequiredExceptionRes(parsedOutput, context);
        case "PutFileEntryConflictException":
        case "com.amazonaws.codecommit#PutFileEntryConflictException":
            throw await de_PutFileEntryConflictExceptionRes(parsedOutput, context);
        case "RestrictedSourceFileException":
        case "com.amazonaws.codecommit#RestrictedSourceFileException":
            throw await de_RestrictedSourceFileExceptionRes(parsedOutput, context);
        case "SamePathRequestException":
        case "com.amazonaws.codecommit#SamePathRequestException":
            throw await de_SamePathRequestExceptionRes(parsedOutput, context);
        case "SourceFileOrContentRequiredException":
        case "com.amazonaws.codecommit#SourceFileOrContentRequiredException":
            throw await de_SourceFileOrContentRequiredExceptionRes(parsedOutput, context);
        case "ClientRequestTokenRequiredException":
        case "com.amazonaws.codecommit#ClientRequestTokenRequiredException":
            throw await de_ClientRequestTokenRequiredExceptionRes(parsedOutput, context);
        case "IdempotencyParameterMismatchException":
        case "com.amazonaws.codecommit#IdempotencyParameterMismatchException":
            throw await de_IdempotencyParameterMismatchExceptionRes(parsedOutput, context);
        case "InvalidClientRequestTokenException":
        case "com.amazonaws.codecommit#InvalidClientRequestTokenException":
            throw await de_InvalidClientRequestTokenExceptionRes(parsedOutput, context);
        case "InvalidDescriptionException":
        case "com.amazonaws.codecommit#InvalidDescriptionException":
            throw await de_InvalidDescriptionExceptionRes(parsedOutput, context);
        case "InvalidReferenceNameException":
        case "com.amazonaws.codecommit#InvalidReferenceNameException":
            throw await de_InvalidReferenceNameExceptionRes(parsedOutput, context);
        case "InvalidTargetException":
        case "com.amazonaws.codecommit#InvalidTargetException":
            throw await de_InvalidTargetExceptionRes(parsedOutput, context);
        case "InvalidTargetsException":
        case "com.amazonaws.codecommit#InvalidTargetsException":
            throw await de_InvalidTargetsExceptionRes(parsedOutput, context);
        case "InvalidTitleException":
        case "com.amazonaws.codecommit#InvalidTitleException":
            throw await de_InvalidTitleExceptionRes(parsedOutput, context);
        case "MaximumOpenPullRequestsExceededException":
        case "com.amazonaws.codecommit#MaximumOpenPullRequestsExceededException":
            throw await de_MaximumOpenPullRequestsExceededExceptionRes(parsedOutput, context);
        case "MultipleRepositoriesInPullRequestException":
        case "com.amazonaws.codecommit#MultipleRepositoriesInPullRequestException":
            throw await de_MultipleRepositoriesInPullRequestExceptionRes(parsedOutput, context);
        case "ReferenceDoesNotExistException":
        case "com.amazonaws.codecommit#ReferenceDoesNotExistException":
            throw await de_ReferenceDoesNotExistExceptionRes(parsedOutput, context);
        case "ReferenceNameRequiredException":
        case "com.amazonaws.codecommit#ReferenceNameRequiredException":
            throw await de_ReferenceNameRequiredExceptionRes(parsedOutput, context);
        case "ReferenceTypeNotSupportedException":
        case "com.amazonaws.codecommit#ReferenceTypeNotSupportedException":
            throw await de_ReferenceTypeNotSupportedExceptionRes(parsedOutput, context);
        case "SourceAndDestinationAreSameException":
        case "com.amazonaws.codecommit#SourceAndDestinationAreSameException":
            throw await de_SourceAndDestinationAreSameExceptionRes(parsedOutput, context);
        case "TargetRequiredException":
        case "com.amazonaws.codecommit#TargetRequiredException":
            throw await de_TargetRequiredExceptionRes(parsedOutput, context);
        case "TargetsRequiredException":
        case "com.amazonaws.codecommit#TargetsRequiredException":
            throw await de_TargetsRequiredExceptionRes(parsedOutput, context);
        case "TitleRequiredException":
        case "com.amazonaws.codecommit#TitleRequiredException":
            throw await de_TitleRequiredExceptionRes(parsedOutput, context);
        case "ApprovalRuleContentRequiredException":
        case "com.amazonaws.codecommit#ApprovalRuleContentRequiredException":
            throw await de_ApprovalRuleContentRequiredExceptionRes(parsedOutput, context);
        case "ApprovalRuleNameAlreadyExistsException":
        case "com.amazonaws.codecommit#ApprovalRuleNameAlreadyExistsException":
            throw await de_ApprovalRuleNameAlreadyExistsExceptionRes(parsedOutput, context);
        case "ApprovalRuleNameRequiredException":
        case "com.amazonaws.codecommit#ApprovalRuleNameRequiredException":
            throw await de_ApprovalRuleNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApprovalRuleContentException":
        case "com.amazonaws.codecommit#InvalidApprovalRuleContentException":
            throw await de_InvalidApprovalRuleContentExceptionRes(parsedOutput, context);
        case "InvalidApprovalRuleNameException":
        case "com.amazonaws.codecommit#InvalidApprovalRuleNameException":
            throw await de_InvalidApprovalRuleNameExceptionRes(parsedOutput, context);
        case "InvalidPullRequestIdException":
        case "com.amazonaws.codecommit#InvalidPullRequestIdException":
            throw await de_InvalidPullRequestIdExceptionRes(parsedOutput, context);
        case "NumberOfRulesExceededException":
        case "com.amazonaws.codecommit#NumberOfRulesExceededException":
            throw await de_NumberOfRulesExceededExceptionRes(parsedOutput, context);
        case "PullRequestAlreadyClosedException":
        case "com.amazonaws.codecommit#PullRequestAlreadyClosedException":
            throw await de_PullRequestAlreadyClosedExceptionRes(parsedOutput, context);
        case "PullRequestDoesNotExistException":
        case "com.amazonaws.codecommit#PullRequestDoesNotExistException":
            throw await de_PullRequestDoesNotExistExceptionRes(parsedOutput, context);
        case "PullRequestIdRequiredException":
        case "com.amazonaws.codecommit#PullRequestIdRequiredException":
            throw await de_PullRequestIdRequiredExceptionRes(parsedOutput, context);
        case "EncryptionKeyInvalidIdException":
        case "com.amazonaws.codecommit#EncryptionKeyInvalidIdException":
            throw await de_EncryptionKeyInvalidIdExceptionRes(parsedOutput, context);
        case "EncryptionKeyInvalidUsageException":
        case "com.amazonaws.codecommit#EncryptionKeyInvalidUsageException":
            throw await de_EncryptionKeyInvalidUsageExceptionRes(parsedOutput, context);
        case "InvalidRepositoryDescriptionException":
        case "com.amazonaws.codecommit#InvalidRepositoryDescriptionException":
            throw await de_InvalidRepositoryDescriptionExceptionRes(parsedOutput, context);
        case "InvalidSystemTagUsageException":
        case "com.amazonaws.codecommit#InvalidSystemTagUsageException":
            throw await de_InvalidSystemTagUsageExceptionRes(parsedOutput, context);
        case "InvalidTagsMapException":
        case "com.amazonaws.codecommit#InvalidTagsMapException":
            throw await de_InvalidTagsMapExceptionRes(parsedOutput, context);
        case "OperationNotAllowedException":
        case "com.amazonaws.codecommit#OperationNotAllowedException":
            throw await de_OperationNotAllowedExceptionRes(parsedOutput, context);
        case "RepositoryLimitExceededException":
        case "com.amazonaws.codecommit#RepositoryLimitExceededException":
            throw await de_RepositoryLimitExceededExceptionRes(parsedOutput, context);
        case "RepositoryNameExistsException":
        case "com.amazonaws.codecommit#RepositoryNameExistsException":
            throw await de_RepositoryNameExistsExceptionRes(parsedOutput, context);
        case "TagPolicyException":
        case "com.amazonaws.codecommit#TagPolicyException":
            throw await de_TagPolicyExceptionRes(parsedOutput, context);
        case "TooManyTagsException":
        case "com.amazonaws.codecommit#TooManyTagsException":
            throw await de_TooManyTagsExceptionRes(parsedOutput, context);
        case "ConcurrentReferenceUpdateException":
        case "com.amazonaws.codecommit#ConcurrentReferenceUpdateException":
            throw await de_ConcurrentReferenceUpdateExceptionRes(parsedOutput, context);
        case "InvalidConflictResolutionException":
        case "com.amazonaws.codecommit#InvalidConflictResolutionException":
            throw await de_InvalidConflictResolutionExceptionRes(parsedOutput, context);
        case "InvalidReplacementContentException":
        case "com.amazonaws.codecommit#InvalidReplacementContentException":
            throw await de_InvalidReplacementContentExceptionRes(parsedOutput, context);
        case "InvalidReplacementTypeException":
        case "com.amazonaws.codecommit#InvalidReplacementTypeException":
            throw await de_InvalidReplacementTypeExceptionRes(parsedOutput, context);
        case "ManualMergeRequiredException":
        case "com.amazonaws.codecommit#ManualMergeRequiredException":
            throw await de_ManualMergeRequiredExceptionRes(parsedOutput, context);
        case "MaximumConflictResolutionEntriesExceededException":
        case "com.amazonaws.codecommit#MaximumConflictResolutionEntriesExceededException":
            throw await de_MaximumConflictResolutionEntriesExceededExceptionRes(parsedOutput, context);
        case "MultipleConflictResolutionEntriesException":
        case "com.amazonaws.codecommit#MultipleConflictResolutionEntriesException":
            throw await de_MultipleConflictResolutionEntriesExceptionRes(parsedOutput, context);
        case "ReplacementContentRequiredException":
        case "com.amazonaws.codecommit#ReplacementContentRequiredException":
            throw await de_ReplacementContentRequiredExceptionRes(parsedOutput, context);
        case "ReplacementTypeRequiredException":
        case "com.amazonaws.codecommit#ReplacementTypeRequiredException":
            throw await de_ReplacementTypeRequiredExceptionRes(parsedOutput, context);
        case "ApprovalRuleTemplateInUseException":
        case "com.amazonaws.codecommit#ApprovalRuleTemplateInUseException":
            throw await de_ApprovalRuleTemplateInUseExceptionRes(parsedOutput, context);
        case "DefaultBranchCannotBeDeletedException":
        case "com.amazonaws.codecommit#DefaultBranchCannotBeDeletedException":
            throw await de_DefaultBranchCannotBeDeletedExceptionRes(parsedOutput, context);
        case "CommentDeletedException":
        case "com.amazonaws.codecommit#CommentDeletedException":
            throw await de_CommentDeletedExceptionRes(parsedOutput, context);
        case "CommentDoesNotExistException":
        case "com.amazonaws.codecommit#CommentDoesNotExistException":
            throw await de_CommentDoesNotExistExceptionRes(parsedOutput, context);
        case "CommentIdRequiredException":
        case "com.amazonaws.codecommit#CommentIdRequiredException":
            throw await de_CommentIdRequiredExceptionRes(parsedOutput, context);
        case "InvalidCommentIdException":
        case "com.amazonaws.codecommit#InvalidCommentIdException":
            throw await de_InvalidCommentIdExceptionRes(parsedOutput, context);
        case "CannotDeleteApprovalRuleFromTemplateException":
        case "com.amazonaws.codecommit#CannotDeleteApprovalRuleFromTemplateException":
            throw await de_CannotDeleteApprovalRuleFromTemplateExceptionRes(parsedOutput, context);
        case "ActorDoesNotExistException":
        case "com.amazonaws.codecommit#ActorDoesNotExistException":
            throw await de_ActorDoesNotExistExceptionRes(parsedOutput, context);
        case "InvalidActorArnException":
        case "com.amazonaws.codecommit#InvalidActorArnException":
            throw await de_InvalidActorArnExceptionRes(parsedOutput, context);
        case "InvalidMaxResultsException":
        case "com.amazonaws.codecommit#InvalidMaxResultsException":
            throw await de_InvalidMaxResultsExceptionRes(parsedOutput, context);
        case "InvalidPullRequestEventTypeException":
        case "com.amazonaws.codecommit#InvalidPullRequestEventTypeException":
            throw await de_InvalidPullRequestEventTypeExceptionRes(parsedOutput, context);
        case "InvalidRevisionIdException":
        case "com.amazonaws.codecommit#InvalidRevisionIdException":
            throw await de_InvalidRevisionIdExceptionRes(parsedOutput, context);
        case "RevisionIdRequiredException":
        case "com.amazonaws.codecommit#RevisionIdRequiredException":
            throw await de_RevisionIdRequiredExceptionRes(parsedOutput, context);
        case "RevisionNotCurrentException":
        case "com.amazonaws.codecommit#RevisionNotCurrentException":
            throw await de_RevisionNotCurrentExceptionRes(parsedOutput, context);
        case "BlobIdDoesNotExistException":
        case "com.amazonaws.codecommit#BlobIdDoesNotExistException":
            throw await de_BlobIdDoesNotExistExceptionRes(parsedOutput, context);
        case "BlobIdRequiredException":
        case "com.amazonaws.codecommit#BlobIdRequiredException":
            throw await de_BlobIdRequiredExceptionRes(parsedOutput, context);
        case "FileTooLargeException":
        case "com.amazonaws.codecommit#FileTooLargeException":
            throw await de_FileTooLargeExceptionRes(parsedOutput, context);
        case "InvalidBlobIdException":
        case "com.amazonaws.codecommit#InvalidBlobIdException":
            throw await de_InvalidBlobIdExceptionRes(parsedOutput, context);
        case "InvalidReactionUserArnException":
        case "com.amazonaws.codecommit#InvalidReactionUserArnException":
            throw await de_InvalidReactionUserArnExceptionRes(parsedOutput, context);
        case "RepositoryNotAssociatedWithPullRequestException":
        case "com.amazonaws.codecommit#RepositoryNotAssociatedWithPullRequestException":
            throw await de_RepositoryNotAssociatedWithPullRequestExceptionRes(parsedOutput, context);
        case "CommitIdDoesNotExistException":
        case "com.amazonaws.codecommit#CommitIdDoesNotExistException":
            throw await de_CommitIdDoesNotExistExceptionRes(parsedOutput, context);
        case "PathDoesNotExistException":
        case "com.amazonaws.codecommit#PathDoesNotExistException":
            throw await de_PathDoesNotExistExceptionRes(parsedOutput, context);
        case "FolderDoesNotExistException":
        case "com.amazonaws.codecommit#FolderDoesNotExistException":
            throw await de_FolderDoesNotExistExceptionRes(parsedOutput, context);
        case "InvalidDestinationCommitSpecifierException":
        case "com.amazonaws.codecommit#InvalidDestinationCommitSpecifierException":
            throw await de_InvalidDestinationCommitSpecifierExceptionRes(parsedOutput, context);
        case "InvalidSourceCommitSpecifierException":
        case "com.amazonaws.codecommit#InvalidSourceCommitSpecifierException":
            throw await de_InvalidSourceCommitSpecifierExceptionRes(parsedOutput, context);
        case "AuthorDoesNotExistException":
        case "com.amazonaws.codecommit#AuthorDoesNotExistException":
            throw await de_AuthorDoesNotExistExceptionRes(parsedOutput, context);
        case "InvalidAuthorArnException":
        case "com.amazonaws.codecommit#InvalidAuthorArnException":
            throw await de_InvalidAuthorArnExceptionRes(parsedOutput, context);
        case "InvalidPullRequestStatusException":
        case "com.amazonaws.codecommit#InvalidPullRequestStatusException":
            throw await de_InvalidPullRequestStatusExceptionRes(parsedOutput, context);
        case "InvalidOrderException":
        case "com.amazonaws.codecommit#InvalidOrderException":
            throw await de_InvalidOrderExceptionRes(parsedOutput, context);
        case "InvalidSortByException":
        case "com.amazonaws.codecommit#InvalidSortByException":
            throw await de_InvalidSortByExceptionRes(parsedOutput, context);
        case "InvalidResourceArnException":
        case "com.amazonaws.codecommit#InvalidResourceArnException":
            throw await de_InvalidResourceArnExceptionRes(parsedOutput, context);
        case "ResourceArnRequiredException":
        case "com.amazonaws.codecommit#ResourceArnRequiredException":
            throw await de_ResourceArnRequiredExceptionRes(parsedOutput, context);
        case "InvalidTargetBranchException":
        case "com.amazonaws.codecommit#InvalidTargetBranchException":
            throw await de_InvalidTargetBranchExceptionRes(parsedOutput, context);
        case "PullRequestApprovalRulesNotSatisfiedException":
        case "com.amazonaws.codecommit#PullRequestApprovalRulesNotSatisfiedException":
            throw await de_PullRequestApprovalRulesNotSatisfiedExceptionRes(parsedOutput, context);
        case "TipOfSourceReferenceIsDifferentException":
        case "com.amazonaws.codecommit#TipOfSourceReferenceIsDifferentException":
            throw await de_TipOfSourceReferenceIsDifferentExceptionRes(parsedOutput, context);
        case "InvalidOverrideStatusException":
        case "com.amazonaws.codecommit#InvalidOverrideStatusException":
            throw await de_InvalidOverrideStatusExceptionRes(parsedOutput, context);
        case "OverrideAlreadySetException":
        case "com.amazonaws.codecommit#OverrideAlreadySetException":
            throw await de_OverrideAlreadySetExceptionRes(parsedOutput, context);
        case "OverrideStatusRequiredException":
        case "com.amazonaws.codecommit#OverrideStatusRequiredException":
            throw await de_OverrideStatusRequiredExceptionRes(parsedOutput, context);
        case "BeforeCommitIdAndAfterCommitIdAreSameException":
        case "com.amazonaws.codecommit#BeforeCommitIdAndAfterCommitIdAreSameException":
            throw await de_BeforeCommitIdAndAfterCommitIdAreSameExceptionRes(parsedOutput, context);
        case "CommentContentRequiredException":
        case "com.amazonaws.codecommit#CommentContentRequiredException":
            throw await de_CommentContentRequiredExceptionRes(parsedOutput, context);
        case "CommentContentSizeLimitExceededException":
        case "com.amazonaws.codecommit#CommentContentSizeLimitExceededException":
            throw await de_CommentContentSizeLimitExceededExceptionRes(parsedOutput, context);
        case "InvalidFileLocationException":
        case "com.amazonaws.codecommit#InvalidFileLocationException":
            throw await de_InvalidFileLocationExceptionRes(parsedOutput, context);
        case "InvalidFilePositionException":
        case "com.amazonaws.codecommit#InvalidFilePositionException":
            throw await de_InvalidFilePositionExceptionRes(parsedOutput, context);
        case "InvalidRelativeFileVersionEnumException":
        case "com.amazonaws.codecommit#InvalidRelativeFileVersionEnumException":
            throw await de_InvalidRelativeFileVersionEnumExceptionRes(parsedOutput, context);
        case "InvalidReactionValueException":
        case "com.amazonaws.codecommit#InvalidReactionValueException":
            throw await de_InvalidReactionValueExceptionRes(parsedOutput, context);
        case "ReactionLimitExceededException":
        case "com.amazonaws.codecommit#ReactionLimitExceededException":
            throw await de_ReactionLimitExceededExceptionRes(parsedOutput, context);
        case "ReactionValueRequiredException":
        case "com.amazonaws.codecommit#ReactionValueRequiredException":
            throw await de_ReactionValueRequiredExceptionRes(parsedOutput, context);
        case "FileContentRequiredException":
        case "com.amazonaws.codecommit#FileContentRequiredException":
            throw await de_FileContentRequiredExceptionRes(parsedOutput, context);
        case "SameFileContentException":
        case "com.amazonaws.codecommit#SameFileContentException":
            throw await de_SameFileContentExceptionRes(parsedOutput, context);
        case "InvalidRepositoryTriggerBranchNameException":
        case "com.amazonaws.codecommit#InvalidRepositoryTriggerBranchNameException":
            throw await de_InvalidRepositoryTriggerBranchNameExceptionRes(parsedOutput, context);
        case "InvalidRepositoryTriggerCustomDataException":
        case "com.amazonaws.codecommit#InvalidRepositoryTriggerCustomDataException":
            throw await de_InvalidRepositoryTriggerCustomDataExceptionRes(parsedOutput, context);
        case "InvalidRepositoryTriggerDestinationArnException":
        case "com.amazonaws.codecommit#InvalidRepositoryTriggerDestinationArnException":
            throw await de_InvalidRepositoryTriggerDestinationArnExceptionRes(parsedOutput, context);
        case "InvalidRepositoryTriggerEventsException":
        case "com.amazonaws.codecommit#InvalidRepositoryTriggerEventsException":
            throw await de_InvalidRepositoryTriggerEventsExceptionRes(parsedOutput, context);
        case "InvalidRepositoryTriggerNameException":
        case "com.amazonaws.codecommit#InvalidRepositoryTriggerNameException":
            throw await de_InvalidRepositoryTriggerNameExceptionRes(parsedOutput, context);
        case "InvalidRepositoryTriggerRegionException":
        case "com.amazonaws.codecommit#InvalidRepositoryTriggerRegionException":
            throw await de_InvalidRepositoryTriggerRegionExceptionRes(parsedOutput, context);
        case "MaximumBranchesExceededException":
        case "com.amazonaws.codecommit#MaximumBranchesExceededException":
            throw await de_MaximumBranchesExceededExceptionRes(parsedOutput, context);
        case "MaximumRepositoryTriggersExceededException":
        case "com.amazonaws.codecommit#MaximumRepositoryTriggersExceededException":
            throw await de_MaximumRepositoryTriggersExceededExceptionRes(parsedOutput, context);
        case "RepositoryTriggerBranchNameListRequiredException":
        case "com.amazonaws.codecommit#RepositoryTriggerBranchNameListRequiredException":
            throw await de_RepositoryTriggerBranchNameListRequiredExceptionRes(parsedOutput, context);
        case "RepositoryTriggerDestinationArnRequiredException":
        case "com.amazonaws.codecommit#RepositoryTriggerDestinationArnRequiredException":
            throw await de_RepositoryTriggerDestinationArnRequiredExceptionRes(parsedOutput, context);
        case "RepositoryTriggerEventsListRequiredException":
        case "com.amazonaws.codecommit#RepositoryTriggerEventsListRequiredException":
            throw await de_RepositoryTriggerEventsListRequiredExceptionRes(parsedOutput, context);
        case "RepositoryTriggerNameRequiredException":
        case "com.amazonaws.codecommit#RepositoryTriggerNameRequiredException":
            throw await de_RepositoryTriggerNameRequiredExceptionRes(parsedOutput, context);
        case "RepositoryTriggersListRequiredException":
        case "com.amazonaws.codecommit#RepositoryTriggersListRequiredException":
            throw await de_RepositoryTriggersListRequiredExceptionRes(parsedOutput, context);
        case "TagsMapRequiredException":
        case "com.amazonaws.codecommit#TagsMapRequiredException":
            throw await de_TagsMapRequiredExceptionRes(parsedOutput, context);
        case "InvalidTagKeysListException":
        case "com.amazonaws.codecommit#InvalidTagKeysListException":
            throw await de_InvalidTagKeysListExceptionRes(parsedOutput, context);
        case "TagKeysListRequiredException":
        case "com.amazonaws.codecommit#TagKeysListRequiredException":
            throw await de_TagKeysListRequiredExceptionRes(parsedOutput, context);
        case "InvalidRuleContentSha256Exception":
        case "com.amazonaws.codecommit#InvalidRuleContentSha256Exception":
            throw await de_InvalidRuleContentSha256ExceptionRes(parsedOutput, context);
        case "CommentNotCreatedByCallerException":
        case "com.amazonaws.codecommit#CommentNotCreatedByCallerException":
            throw await de_CommentNotCreatedByCallerExceptionRes(parsedOutput, context);
        case "ApprovalRuleDoesNotExistException":
        case "com.amazonaws.codecommit#ApprovalRuleDoesNotExistException":
            throw await de_ApprovalRuleDoesNotExistExceptionRes(parsedOutput, context);
        case "CannotModifyApprovalRuleFromTemplateException":
        case "com.amazonaws.codecommit#CannotModifyApprovalRuleFromTemplateException":
            throw await de_CannotModifyApprovalRuleFromTemplateExceptionRes(parsedOutput, context);
        case "ApprovalStateRequiredException":
        case "com.amazonaws.codecommit#ApprovalStateRequiredException":
            throw await de_ApprovalStateRequiredExceptionRes(parsedOutput, context);
        case "InvalidApprovalStateException":
        case "com.amazonaws.codecommit#InvalidApprovalStateException":
            throw await de_InvalidApprovalStateExceptionRes(parsedOutput, context);
        case "MaximumNumberOfApprovalsExceededException":
        case "com.amazonaws.codecommit#MaximumNumberOfApprovalsExceededException":
            throw await de_MaximumNumberOfApprovalsExceededExceptionRes(parsedOutput, context);
        case "PullRequestCannotBeApprovedByAuthorException":
        case "com.amazonaws.codecommit#PullRequestCannotBeApprovedByAuthorException":
            throw await de_PullRequestCannotBeApprovedByAuthorExceptionRes(parsedOutput, context);
        case "InvalidPullRequestStatusUpdateException":
        case "com.amazonaws.codecommit#InvalidPullRequestStatusUpdateException":
            throw await de_InvalidPullRequestStatusUpdateExceptionRes(parsedOutput, context);
        case "PullRequestStatusRequiredException":
        case "com.amazonaws.codecommit#PullRequestStatusRequiredException":
            throw await de_PullRequestStatusRequiredExceptionRes(parsedOutput, context);
        case "EncryptionKeyRequiredException":
        case "com.amazonaws.codecommit#EncryptionKeyRequiredException":
            throw await de_EncryptionKeyRequiredExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_ActorDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ActorDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalRuleContentRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalRuleContentRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalRuleDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalRuleDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalRuleNameAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalRuleNameAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalRuleNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalRuleNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalRuleTemplateContentRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalRuleTemplateContentRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalRuleTemplateDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalRuleTemplateDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalRuleTemplateInUseExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalRuleTemplateInUseException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalRuleTemplateNameAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalRuleTemplateNameAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalRuleTemplateNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalRuleTemplateNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApprovalStateRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApprovalStateRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_AuthorDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new AuthorDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BeforeCommitIdAndAfterCommitIdAreSameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new BeforeCommitIdAndAfterCommitIdAreSameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BlobIdDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new BlobIdDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BlobIdRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new BlobIdRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BranchDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new BranchDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BranchNameExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new BranchNameExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BranchNameIsTagNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new BranchNameIsTagNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BranchNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new BranchNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CannotDeleteApprovalRuleFromTemplateExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CannotDeleteApprovalRuleFromTemplateException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CannotModifyApprovalRuleFromTemplateExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CannotModifyApprovalRuleFromTemplateException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ClientRequestTokenRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ClientRequestTokenRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommentContentRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommentContentRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommentContentSizeLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommentContentSizeLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommentDeletedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommentDeletedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommentDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommentDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommentIdRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommentIdRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommentNotCreatedByCallerExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommentNotCreatedByCallerException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommitDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommitDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommitIdDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommitIdDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommitIdRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommitIdRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommitIdsLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommitIdsLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommitIdsListRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommitIdsListRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommitMessageLengthExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommitMessageLengthExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CommitRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new CommitRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ConcurrentReferenceUpdateExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ConcurrentReferenceUpdateException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DefaultBranchCannotBeDeletedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DefaultBranchCannotBeDeletedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DirectoryNameConflictsWithFileNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DirectoryNameConflictsWithFileNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_EncryptionIntegrityChecksFailedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new EncryptionIntegrityChecksFailedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_EncryptionKeyAccessDeniedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new EncryptionKeyAccessDeniedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_EncryptionKeyDisabledExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new EncryptionKeyDisabledException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_EncryptionKeyInvalidIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new EncryptionKeyInvalidIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_EncryptionKeyInvalidUsageExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new EncryptionKeyInvalidUsageException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_EncryptionKeyNotFoundExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new EncryptionKeyNotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_EncryptionKeyRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new EncryptionKeyRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_EncryptionKeyUnavailableExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new EncryptionKeyUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FileContentAndSourceFileSpecifiedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FileContentAndSourceFileSpecifiedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FileContentRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FileContentRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FileContentSizeLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FileContentSizeLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FileDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FileDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FileEntryRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FileEntryRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FileModeRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FileModeRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FileNameConflictsWithDirectoryNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FileNameConflictsWithDirectoryNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FilePathConflictsWithSubmodulePathExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FilePathConflictsWithSubmodulePathException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FileTooLargeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FileTooLargeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FolderContentSizeLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FolderContentSizeLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_FolderDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new FolderDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IdempotencyParameterMismatchExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new IdempotencyParameterMismatchException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidActorArnExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidActorArnException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidApprovalRuleContentExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidApprovalRuleContentException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidApprovalRuleNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidApprovalRuleNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidApprovalRuleTemplateContentExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidApprovalRuleTemplateContentException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidApprovalRuleTemplateDescriptionExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidApprovalRuleTemplateDescriptionException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidApprovalRuleTemplateNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidApprovalRuleTemplateNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidApprovalStateExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidApprovalStateException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidAuthorArnExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidAuthorArnException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidBlobIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidBlobIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidBranchNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidBranchNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidClientRequestTokenExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidClientRequestTokenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidCommentIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidCommentIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidCommitExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidCommitException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidCommitIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidCommitIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidConflictDetailLevelExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidConflictDetailLevelException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidConflictResolutionExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidConflictResolutionException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidConflictResolutionStrategyExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidConflictResolutionStrategyException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidContinuationTokenExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidContinuationTokenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeletionParameterExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeletionParameterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDescriptionExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDescriptionException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDestinationCommitSpecifierExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDestinationCommitSpecifierException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidEmailExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidEmailException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidFileLocationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidFileLocationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidFileModeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidFileModeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidFilePositionExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidFilePositionException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidMaxConflictFilesExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidMaxConflictFilesException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidMaxMergeHunksExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidMaxMergeHunksException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidMaxResultsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidMaxResultsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidMergeOptionExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidMergeOptionException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidOrderExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidOrderException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidOverrideStatusExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidOverrideStatusException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidParentCommitIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidParentCommitIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidPathExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidPathException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidPullRequestEventTypeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidPullRequestEventTypeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidPullRequestIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidPullRequestIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidPullRequestStatusExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidPullRequestStatusException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidPullRequestStatusUpdateExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidPullRequestStatusUpdateException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidReactionUserArnExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidReactionUserArnException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidReactionValueExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidReactionValueException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidReferenceNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidReferenceNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRelativeFileVersionEnumExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRelativeFileVersionEnumException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidReplacementContentExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidReplacementContentException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidReplacementTypeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidReplacementTypeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRepositoryDescriptionExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRepositoryDescriptionException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRepositoryNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRepositoryNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRepositoryTriggerBranchNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRepositoryTriggerBranchNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRepositoryTriggerCustomDataExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRepositoryTriggerCustomDataException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRepositoryTriggerDestinationArnExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRepositoryTriggerDestinationArnException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRepositoryTriggerEventsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRepositoryTriggerEventsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRepositoryTriggerNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRepositoryTriggerNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRepositoryTriggerRegionExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRepositoryTriggerRegionException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidResourceArnExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidResourceArnException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRevisionIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRevisionIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRuleContentSha256ExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRuleContentSha256Exception({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidSortByExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidSortByException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidSourceCommitSpecifierExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidSourceCommitSpecifierException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidSystemTagUsageExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidSystemTagUsageException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTagKeysListExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTagKeysListException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTagsMapExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTagsMapException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTargetBranchExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTargetBranchException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTargetExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTargetException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTargetsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTargetsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTitleExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTitleException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ManualMergeRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ManualMergeRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumBranchesExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumBranchesExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumConflictResolutionEntriesExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumConflictResolutionEntriesExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumFileContentToLoadExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumFileContentToLoadExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumFileEntriesExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumFileEntriesExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumItemsToCompareExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumItemsToCompareExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumNumberOfApprovalsExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumNumberOfApprovalsExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumOpenPullRequestsExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumOpenPullRequestsExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumRepositoryNamesExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumRepositoryNamesExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumRepositoryTriggersExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumRepositoryTriggersExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaximumRuleTemplatesAssociatedWithRepositoryExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MaximumRuleTemplatesAssociatedWithRepositoryException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MergeOptionRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MergeOptionRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MultipleConflictResolutionEntriesExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MultipleConflictResolutionEntriesException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MultipleRepositoriesInPullRequestExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MultipleRepositoriesInPullRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_NameLengthExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new NameLengthExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_NoChangeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new NoChangeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_NumberOfRulesExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new NumberOfRulesExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_NumberOfRuleTemplatesExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new NumberOfRuleTemplatesExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OperationNotAllowedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new OperationNotAllowedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OverrideAlreadySetExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new OverrideAlreadySetException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OverrideStatusRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new OverrideStatusRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ParentCommitDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ParentCommitDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ParentCommitIdOutdatedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ParentCommitIdOutdatedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ParentCommitIdRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ParentCommitIdRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PathDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PathDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PathRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PathRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PullRequestAlreadyClosedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PullRequestAlreadyClosedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PullRequestApprovalRulesNotSatisfiedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PullRequestApprovalRulesNotSatisfiedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PullRequestCannotBeApprovedByAuthorExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PullRequestCannotBeApprovedByAuthorException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PullRequestDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PullRequestDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PullRequestIdRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PullRequestIdRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PullRequestStatusRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PullRequestStatusRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PutFileEntryConflictExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new PutFileEntryConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReactionLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ReactionLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReactionValueRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ReactionValueRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReferenceDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ReferenceDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReferenceNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ReferenceNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReferenceTypeNotSupportedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ReferenceTypeNotSupportedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReplacementContentRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ReplacementContentRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReplacementTypeRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ReplacementTypeRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryNameExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryNameExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryNamesRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryNamesRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryNotAssociatedWithPullRequestExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryNotAssociatedWithPullRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryTriggerBranchNameListRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryTriggerBranchNameListRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryTriggerDestinationArnRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryTriggerDestinationArnRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryTriggerEventsListRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryTriggerEventsListRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryTriggerNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryTriggerNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RepositoryTriggersListRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RepositoryTriggersListRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ResourceArnRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ResourceArnRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RestrictedSourceFileExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RestrictedSourceFileException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RevisionIdRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RevisionIdRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RevisionNotCurrentExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RevisionNotCurrentException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SameFileContentExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new SameFileContentException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SamePathRequestExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new SamePathRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SourceAndDestinationAreSameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new SourceAndDestinationAreSameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SourceFileOrContentRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new SourceFileOrContentRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TagKeysListRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TagKeysListRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TagPolicyExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TagPolicyException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TagsMapRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TagsMapRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TargetRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TargetRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TargetsRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TargetsRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TipOfSourceReferenceIsDifferentExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TipOfSourceReferenceIsDifferentException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TipsDivergenceExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TipsDivergenceExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TitleRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TitleRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TooManyTagsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TooManyTagsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const se_ConflictResolution = (input, context) => {
    return take(input, {
        deleteFiles: _json,
        replaceContents: (_) => se_ReplaceContentEntries(_, context),
        setFileModes: _json,
    });
};
const se_CreateCommitInput = (input, context) => {
    return take(input, {
        authorName: [],
        branchName: [],
        commitMessage: [],
        deleteFiles: _json,
        email: [],
        keepEmptyFolders: [],
        parentCommitId: [],
        putFiles: (_) => se_PutFileEntries(_, context),
        repositoryName: [],
        setFileModes: _json,
    });
};
const se_CreatePullRequestInput = (input, context) => {
    return take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        description: [],
        targets: _json,
        title: [],
    });
};
const se_CreateUnreferencedMergeCommitInput = (input, context) => {
    return take(input, {
        authorName: [],
        commitMessage: [],
        conflictDetailLevel: [],
        conflictResolution: (_) => se_ConflictResolution(_, context),
        conflictResolutionStrategy: [],
        destinationCommitSpecifier: [],
        email: [],
        keepEmptyFolders: [],
        mergeOption: [],
        repositoryName: [],
        sourceCommitSpecifier: [],
    });
};
const se_MergeBranchesBySquashInput = (input, context) => {
    return take(input, {
        authorName: [],
        commitMessage: [],
        conflictDetailLevel: [],
        conflictResolution: (_) => se_ConflictResolution(_, context),
        conflictResolutionStrategy: [],
        destinationCommitSpecifier: [],
        email: [],
        keepEmptyFolders: [],
        repositoryName: [],
        sourceCommitSpecifier: [],
        targetBranch: [],
    });
};
const se_MergeBranchesByThreeWayInput = (input, context) => {
    return take(input, {
        authorName: [],
        commitMessage: [],
        conflictDetailLevel: [],
        conflictResolution: (_) => se_ConflictResolution(_, context),
        conflictResolutionStrategy: [],
        destinationCommitSpecifier: [],
        email: [],
        keepEmptyFolders: [],
        repositoryName: [],
        sourceCommitSpecifier: [],
        targetBranch: [],
    });
};
const se_MergePullRequestBySquashInput = (input, context) => {
    return take(input, {
        authorName: [],
        commitMessage: [],
        conflictDetailLevel: [],
        conflictResolution: (_) => se_ConflictResolution(_, context),
        conflictResolutionStrategy: [],
        email: [],
        keepEmptyFolders: [],
        pullRequestId: [],
        repositoryName: [],
        sourceCommitId: [],
    });
};
const se_MergePullRequestByThreeWayInput = (input, context) => {
    return take(input, {
        authorName: [],
        commitMessage: [],
        conflictDetailLevel: [],
        conflictResolution: (_) => se_ConflictResolution(_, context),
        conflictResolutionStrategy: [],
        email: [],
        keepEmptyFolders: [],
        pullRequestId: [],
        repositoryName: [],
        sourceCommitId: [],
    });
};
const se_PostCommentForComparedCommitInput = (input, context) => {
    return take(input, {
        afterCommitId: [],
        beforeCommitId: [],
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        content: [],
        location: _json,
        repositoryName: [],
    });
};
const se_PostCommentForPullRequestInput = (input, context) => {
    return take(input, {
        afterCommitId: [],
        beforeCommitId: [],
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        content: [],
        location: _json,
        pullRequestId: [],
        repositoryName: [],
    });
};
const se_PostCommentReplyInput = (input, context) => {
    return take(input, {
        clientRequestToken: [true, (_) => _ ?? generateIdempotencyToken()],
        content: [],
        inReplyTo: [],
    });
};
const se_PutFileEntries = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_PutFileEntry(entry, context);
    });
};
const se_PutFileEntry = (input, context) => {
    return take(input, {
        fileContent: context.base64Encoder,
        fileMode: [],
        filePath: [],
        sourceFile: _json,
    });
};
const se_PutFileInput = (input, context) => {
    return take(input, {
        branchName: [],
        commitMessage: [],
        email: [],
        fileContent: context.base64Encoder,
        fileMode: [],
        filePath: [],
        name: [],
        parentCommitId: [],
        repositoryName: [],
    });
};
const se_ReplaceContentEntries = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_ReplaceContentEntry(entry, context);
    });
};
const se_ReplaceContentEntry = (input, context) => {
    return take(input, {
        content: context.base64Encoder,
        fileMode: [],
        filePath: [],
        replacementType: [],
    });
};
const de_ApprovalRule = (output, context) => {
    return take(output, {
        approvalRuleContent: __expectString,
        approvalRuleId: __expectString,
        approvalRuleName: __expectString,
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lastModifiedDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lastModifiedUser: __expectString,
        originApprovalRuleTemplate: _json,
        ruleContentSha256: __expectString,
    });
};
const de_ApprovalRulesList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ApprovalRule(entry, context);
    });
    return retVal;
};
const de_ApprovalRuleTemplate = (output, context) => {
    return take(output, {
        approvalRuleTemplateContent: __expectString,
        approvalRuleTemplateDescription: __expectString,
        approvalRuleTemplateId: __expectString,
        approvalRuleTemplateName: __expectString,
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lastModifiedDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lastModifiedUser: __expectString,
        ruleContentSha256: __expectString,
    });
};
const de_BatchGetRepositoriesOutput = (output, context) => {
    return take(output, {
        errors: _json,
        repositories: (_) => de_RepositoryMetadataList(_, context),
        repositoriesNotFound: _json,
    });
};
const de_Comment = (output, context) => {
    return take(output, {
        authorArn: __expectString,
        callerReactions: _json,
        clientRequestToken: __expectString,
        commentId: __expectString,
        content: __expectString,
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        deleted: __expectBoolean,
        inReplyTo: __expectString,
        lastModifiedDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        reactionCounts: _json,
    });
};
const de_Comments = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Comment(entry, context);
    });
    return retVal;
};
const de_CommentsForComparedCommit = (output, context) => {
    return take(output, {
        afterBlobId: __expectString,
        afterCommitId: __expectString,
        beforeBlobId: __expectString,
        beforeCommitId: __expectString,
        comments: (_) => de_Comments(_, context),
        location: _json,
        repositoryName: __expectString,
    });
};
const de_CommentsForComparedCommitData = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CommentsForComparedCommit(entry, context);
    });
    return retVal;
};
const de_CommentsForPullRequest = (output, context) => {
    return take(output, {
        afterBlobId: __expectString,
        afterCommitId: __expectString,
        beforeBlobId: __expectString,
        beforeCommitId: __expectString,
        comments: (_) => de_Comments(_, context),
        location: _json,
        pullRequestId: __expectString,
        repositoryName: __expectString,
    });
};
const de_CommentsForPullRequestData = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CommentsForPullRequest(entry, context);
    });
    return retVal;
};
const de_CreateApprovalRuleTemplateOutput = (output, context) => {
    return take(output, {
        approvalRuleTemplate: (_) => de_ApprovalRuleTemplate(_, context),
    });
};
const de_CreatePullRequestApprovalRuleOutput = (output, context) => {
    return take(output, {
        approvalRule: (_) => de_ApprovalRule(_, context),
    });
};
const de_CreatePullRequestOutput = (output, context) => {
    return take(output, {
        pullRequest: (_) => de_PullRequest(_, context),
    });
};
const de_CreateRepositoryOutput = (output, context) => {
    return take(output, {
        repositoryMetadata: (_) => de_RepositoryMetadata(_, context),
    });
};
const de_DeleteCommentContentOutput = (output, context) => {
    return take(output, {
        comment: (_) => de_Comment(_, context),
    });
};
const de_DescribePullRequestEventsOutput = (output, context) => {
    return take(output, {
        nextToken: __expectString,
        pullRequestEvents: (_) => de_PullRequestEventList(_, context),
    });
};
const de_GetApprovalRuleTemplateOutput = (output, context) => {
    return take(output, {
        approvalRuleTemplate: (_) => de_ApprovalRuleTemplate(_, context),
    });
};
const de_GetBlobOutput = (output, context) => {
    return take(output, {
        content: context.base64Decoder,
    });
};
const de_GetCommentOutput = (output, context) => {
    return take(output, {
        comment: (_) => de_Comment(_, context),
    });
};
const de_GetCommentsForComparedCommitOutput = (output, context) => {
    return take(output, {
        commentsForComparedCommitData: (_) => de_CommentsForComparedCommitData(_, context),
        nextToken: __expectString,
    });
};
const de_GetCommentsForPullRequestOutput = (output, context) => {
    return take(output, {
        commentsForPullRequestData: (_) => de_CommentsForPullRequestData(_, context),
        nextToken: __expectString,
    });
};
const de_GetFileOutput = (output, context) => {
    return take(output, {
        blobId: __expectString,
        commitId: __expectString,
        fileContent: context.base64Decoder,
        fileMode: __expectString,
        filePath: __expectString,
        fileSize: __expectLong,
    });
};
const de_GetPullRequestOutput = (output, context) => {
    return take(output, {
        pullRequest: (_) => de_PullRequest(_, context),
    });
};
const de_GetRepositoryOutput = (output, context) => {
    return take(output, {
        repositoryMetadata: (_) => de_RepositoryMetadata(_, context),
    });
};
const de_MergePullRequestByFastForwardOutput = (output, context) => {
    return take(output, {
        pullRequest: (_) => de_PullRequest(_, context),
    });
};
const de_MergePullRequestBySquashOutput = (output, context) => {
    return take(output, {
        pullRequest: (_) => de_PullRequest(_, context),
    });
};
const de_MergePullRequestByThreeWayOutput = (output, context) => {
    return take(output, {
        pullRequest: (_) => de_PullRequest(_, context),
    });
};
const de_PostCommentForComparedCommitOutput = (output, context) => {
    return take(output, {
        afterBlobId: __expectString,
        afterCommitId: __expectString,
        beforeBlobId: __expectString,
        beforeCommitId: __expectString,
        comment: (_) => de_Comment(_, context),
        location: _json,
        repositoryName: __expectString,
    });
};
const de_PostCommentForPullRequestOutput = (output, context) => {
    return take(output, {
        afterBlobId: __expectString,
        afterCommitId: __expectString,
        beforeBlobId: __expectString,
        beforeCommitId: __expectString,
        comment: (_) => de_Comment(_, context),
        location: _json,
        pullRequestId: __expectString,
        repositoryName: __expectString,
    });
};
const de_PostCommentReplyOutput = (output, context) => {
    return take(output, {
        comment: (_) => de_Comment(_, context),
    });
};
const de_PullRequest = (output, context) => {
    return take(output, {
        approvalRules: (_) => de_ApprovalRulesList(_, context),
        authorArn: __expectString,
        clientRequestToken: __expectString,
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        description: __expectString,
        lastActivityDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        pullRequestId: __expectString,
        pullRequestStatus: __expectString,
        pullRequestTargets: _json,
        revisionId: __expectString,
        title: __expectString,
    });
};
const de_PullRequestEvent = (output, context) => {
    return take(output, {
        actorArn: __expectString,
        approvalRuleEventMetadata: _json,
        approvalRuleOverriddenEventMetadata: _json,
        approvalStateChangedEventMetadata: _json,
        eventDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        pullRequestCreatedEventMetadata: _json,
        pullRequestEventType: __expectString,
        pullRequestId: __expectString,
        pullRequestMergedStateChangedEventMetadata: _json,
        pullRequestSourceReferenceUpdatedEventMetadata: _json,
        pullRequestStatusChangedEventMetadata: _json,
    });
};
const de_PullRequestEventList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PullRequestEvent(entry, context);
    });
    return retVal;
};
const de_RepositoryMetadata = (output, context) => {
    return take(output, {
        Arn: __expectString,
        accountId: __expectString,
        cloneUrlHttp: __expectString,
        cloneUrlSsh: __expectString,
        creationDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        defaultBranch: __expectString,
        kmsKeyId: __expectString,
        lastModifiedDate: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        repositoryDescription: __expectString,
        repositoryId: __expectString,
        repositoryName: __expectString,
    });
};
const de_RepositoryMetadataList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RepositoryMetadata(entry, context);
    });
    return retVal;
};
const de_UpdateApprovalRuleTemplateContentOutput = (output, context) => {
    return take(output, {
        approvalRuleTemplate: (_) => de_ApprovalRuleTemplate(_, context),
    });
};
const de_UpdateApprovalRuleTemplateDescriptionOutput = (output, context) => {
    return take(output, {
        approvalRuleTemplate: (_) => de_ApprovalRuleTemplate(_, context),
    });
};
const de_UpdateApprovalRuleTemplateNameOutput = (output, context) => {
    return take(output, {
        approvalRuleTemplate: (_) => de_ApprovalRuleTemplate(_, context),
    });
};
const de_UpdateCommentOutput = (output, context) => {
    return take(output, {
        comment: (_) => de_Comment(_, context),
    });
};
const de_UpdatePullRequestApprovalRuleContentOutput = (output, context) => {
    return take(output, {
        approvalRule: (_) => de_ApprovalRule(_, context),
    });
};
const de_UpdatePullRequestDescriptionOutput = (output, context) => {
    return take(output, {
        pullRequest: (_) => de_PullRequest(_, context),
    });
};
const de_UpdatePullRequestStatusOutput = (output, context) => {
    return take(output, {
        pullRequest: (_) => de_PullRequest(_, context),
    });
};
const de_UpdatePullRequestTitleOutput = (output, context) => {
    return take(output, {
        pullRequest: (_) => de_PullRequest(_, context),
    });
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const throwDefaultError = withBaseException(__BaseException);
const buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers,
    };
    if (resolvedHostname !== undefined) {
        contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
        contents.body = body;
    }
    return new __HttpRequest(contents);
};
function sharedHeaders(operation) {
    return {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": `CodeCommit_20150413.${operation}`,
    };
}
