import { CodeCommitServiceException as __BaseException } from "./CodeCommitServiceException";
export class ActorDoesNotExistException extends __BaseException {
    name = "ActorDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ActorDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ActorDoesNotExistException.prototype);
    }
}
export const ApprovalState = {
    APPROVE: "APPROVE",
    REVOKE: "REVOKE",
};
export class ApprovalRuleContentRequiredException extends __BaseException {
    name = "ApprovalRuleContentRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalRuleContentRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalRuleContentRequiredException.prototype);
    }
}
export class ApprovalRuleDoesNotExistException extends __BaseException {
    name = "ApprovalRuleDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalRuleDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalRuleDoesNotExistException.prototype);
    }
}
export class ApprovalRuleNameAlreadyExistsException extends __BaseException {
    name = "ApprovalRuleNameAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalRuleNameAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalRuleNameAlreadyExistsException.prototype);
    }
}
export class ApprovalRuleNameRequiredException extends __BaseException {
    name = "ApprovalRuleNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalRuleNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalRuleNameRequiredException.prototype);
    }
}
export const OverrideStatus = {
    OVERRIDE: "OVERRIDE",
    REVOKE: "REVOKE",
};
export class ApprovalRuleTemplateContentRequiredException extends __BaseException {
    name = "ApprovalRuleTemplateContentRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalRuleTemplateContentRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalRuleTemplateContentRequiredException.prototype);
    }
}
export class ApprovalRuleTemplateDoesNotExistException extends __BaseException {
    name = "ApprovalRuleTemplateDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalRuleTemplateDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalRuleTemplateDoesNotExistException.prototype);
    }
}
export class ApprovalRuleTemplateInUseException extends __BaseException {
    name = "ApprovalRuleTemplateInUseException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalRuleTemplateInUseException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalRuleTemplateInUseException.prototype);
    }
}
export class ApprovalRuleTemplateNameAlreadyExistsException extends __BaseException {
    name = "ApprovalRuleTemplateNameAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalRuleTemplateNameAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalRuleTemplateNameAlreadyExistsException.prototype);
    }
}
export class ApprovalRuleTemplateNameRequiredException extends __BaseException {
    name = "ApprovalRuleTemplateNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalRuleTemplateNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalRuleTemplateNameRequiredException.prototype);
    }
}
export class ApprovalStateRequiredException extends __BaseException {
    name = "ApprovalStateRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApprovalStateRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApprovalStateRequiredException.prototype);
    }
}
export class EncryptionIntegrityChecksFailedException extends __BaseException {
    name = "EncryptionIntegrityChecksFailedException";
    $fault = "server";
    constructor(opts) {
        super({
            name: "EncryptionIntegrityChecksFailedException",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, EncryptionIntegrityChecksFailedException.prototype);
    }
}
export class EncryptionKeyAccessDeniedException extends __BaseException {
    name = "EncryptionKeyAccessDeniedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "EncryptionKeyAccessDeniedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, EncryptionKeyAccessDeniedException.prototype);
    }
}
export class EncryptionKeyDisabledException extends __BaseException {
    name = "EncryptionKeyDisabledException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "EncryptionKeyDisabledException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, EncryptionKeyDisabledException.prototype);
    }
}
export class EncryptionKeyNotFoundException extends __BaseException {
    name = "EncryptionKeyNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "EncryptionKeyNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, EncryptionKeyNotFoundException.prototype);
    }
}
export class EncryptionKeyUnavailableException extends __BaseException {
    name = "EncryptionKeyUnavailableException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "EncryptionKeyUnavailableException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, EncryptionKeyUnavailableException.prototype);
    }
}
export class InvalidApprovalRuleTemplateNameException extends __BaseException {
    name = "InvalidApprovalRuleTemplateNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidApprovalRuleTemplateNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidApprovalRuleTemplateNameException.prototype);
    }
}
export class InvalidRepositoryNameException extends __BaseException {
    name = "InvalidRepositoryNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidRepositoryNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRepositoryNameException.prototype);
    }
}
export class MaximumRuleTemplatesAssociatedWithRepositoryException extends __BaseException {
    name = "MaximumRuleTemplatesAssociatedWithRepositoryException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MaximumRuleTemplatesAssociatedWithRepositoryException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MaximumRuleTemplatesAssociatedWithRepositoryException.prototype);
    }
}
export class RepositoryDoesNotExistException extends __BaseException {
    name = "RepositoryDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryDoesNotExistException.prototype);
    }
}
export class RepositoryNameRequiredException extends __BaseException {
    name = "RepositoryNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryNameRequiredException.prototype);
    }
}
export class AuthorDoesNotExistException extends __BaseException {
    name = "AuthorDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "AuthorDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AuthorDoesNotExistException.prototype);
    }
}
export class MaximumRepositoryNamesExceededException extends __BaseException {
    name = "MaximumRepositoryNamesExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MaximumRepositoryNamesExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MaximumRepositoryNamesExceededException.prototype);
    }
}
export class RepositoryNamesRequiredException extends __BaseException {
    name = "RepositoryNamesRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryNamesRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryNamesRequiredException.prototype);
    }
}
export const ConflictDetailLevelTypeEnum = {
    FILE_LEVEL: "FILE_LEVEL",
    LINE_LEVEL: "LINE_LEVEL",
};
export const ConflictResolutionStrategyTypeEnum = {
    ACCEPT_DESTINATION: "ACCEPT_DESTINATION",
    ACCEPT_SOURCE: "ACCEPT_SOURCE",
    AUTOMERGE: "AUTOMERGE",
    NONE: "NONE",
};
export const MergeOptionTypeEnum = {
    FAST_FORWARD_MERGE: "FAST_FORWARD_MERGE",
    SQUASH_MERGE: "SQUASH_MERGE",
    THREE_WAY_MERGE: "THREE_WAY_MERGE",
};
export const FileModeTypeEnum = {
    EXECUTABLE: "EXECUTABLE",
    NORMAL: "NORMAL",
    SYMLINK: "SYMLINK",
};
export const ChangeTypeEnum = {
    ADDED: "A",
    DELETED: "D",
    MODIFIED: "M",
};
export const ObjectTypeEnum = {
    DIRECTORY: "DIRECTORY",
    FILE: "FILE",
    GIT_LINK: "GIT_LINK",
    SYMBOLIC_LINK: "SYMBOLIC_LINK",
};
export class CommitDoesNotExistException extends __BaseException {
    name = "CommitDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommitDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommitDoesNotExistException.prototype);
    }
}
export class CommitRequiredException extends __BaseException {
    name = "CommitRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommitRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommitRequiredException.prototype);
    }
}
export class InvalidCommitException extends __BaseException {
    name = "InvalidCommitException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidCommitException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidCommitException.prototype);
    }
}
export class InvalidConflictDetailLevelException extends __BaseException {
    name = "InvalidConflictDetailLevelException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidConflictDetailLevelException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidConflictDetailLevelException.prototype);
    }
}
export class InvalidConflictResolutionStrategyException extends __BaseException {
    name = "InvalidConflictResolutionStrategyException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidConflictResolutionStrategyException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidConflictResolutionStrategyException.prototype);
    }
}
export class InvalidContinuationTokenException extends __BaseException {
    name = "InvalidContinuationTokenException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidContinuationTokenException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidContinuationTokenException.prototype);
    }
}
export class InvalidMaxConflictFilesException extends __BaseException {
    name = "InvalidMaxConflictFilesException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidMaxConflictFilesException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidMaxConflictFilesException.prototype);
    }
}
export class InvalidMaxMergeHunksException extends __BaseException {
    name = "InvalidMaxMergeHunksException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidMaxMergeHunksException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidMaxMergeHunksException.prototype);
    }
}
export class InvalidMergeOptionException extends __BaseException {
    name = "InvalidMergeOptionException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidMergeOptionException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidMergeOptionException.prototype);
    }
}
export class MaximumFileContentToLoadExceededException extends __BaseException {
    name = "MaximumFileContentToLoadExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MaximumFileContentToLoadExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MaximumFileContentToLoadExceededException.prototype);
    }
}
export class MaximumItemsToCompareExceededException extends __BaseException {
    name = "MaximumItemsToCompareExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MaximumItemsToCompareExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MaximumItemsToCompareExceededException.prototype);
    }
}
export class MergeOptionRequiredException extends __BaseException {
    name = "MergeOptionRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MergeOptionRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MergeOptionRequiredException.prototype);
    }
}
export class TipsDivergenceExceededException extends __BaseException {
    name = "TipsDivergenceExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TipsDivergenceExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TipsDivergenceExceededException.prototype);
    }
}
export class CommitIdsLimitExceededException extends __BaseException {
    name = "CommitIdsLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommitIdsLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommitIdsLimitExceededException.prototype);
    }
}
export class CommitIdsListRequiredException extends __BaseException {
    name = "CommitIdsListRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommitIdsListRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommitIdsListRequiredException.prototype);
    }
}
export const BatchGetRepositoriesErrorCodeEnum = {
    ENCRYPTION_INTEGRITY_CHECKS_FAILED_EXCEPTION: "EncryptionIntegrityChecksFailedException",
    ENCRYPTION_KEY_ACCESS_DENIED_EXCEPTION: "EncryptionKeyAccessDeniedException",
    ENCRYPTION_KEY_DISABLED_EXCEPTION: "EncryptionKeyDisabledException",
    ENCRYPTION_KEY_NOT_FOUND_EXCEPTION: "EncryptionKeyNotFoundException",
    ENCRYPTION_KEY_UNAVAILABLE_EXCEPTION: "EncryptionKeyUnavailableException",
    REPOSITORY_DOES_NOT_EXIST_EXCEPTION: "RepositoryDoesNotExistException",
};
export class BeforeCommitIdAndAfterCommitIdAreSameException extends __BaseException {
    name = "BeforeCommitIdAndAfterCommitIdAreSameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BeforeCommitIdAndAfterCommitIdAreSameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BeforeCommitIdAndAfterCommitIdAreSameException.prototype);
    }
}
export class BlobIdDoesNotExistException extends __BaseException {
    name = "BlobIdDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BlobIdDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BlobIdDoesNotExistException.prototype);
    }
}
export class BlobIdRequiredException extends __BaseException {
    name = "BlobIdRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BlobIdRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BlobIdRequiredException.prototype);
    }
}
export class BranchDoesNotExistException extends __BaseException {
    name = "BranchDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BranchDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BranchDoesNotExistException.prototype);
    }
}
export class BranchNameExistsException extends __BaseException {
    name = "BranchNameExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BranchNameExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BranchNameExistsException.prototype);
    }
}
export class BranchNameIsTagNameException extends __BaseException {
    name = "BranchNameIsTagNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BranchNameIsTagNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BranchNameIsTagNameException.prototype);
    }
}
export class BranchNameRequiredException extends __BaseException {
    name = "BranchNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BranchNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BranchNameRequiredException.prototype);
    }
}
export class CannotDeleteApprovalRuleFromTemplateException extends __BaseException {
    name = "CannotDeleteApprovalRuleFromTemplateException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CannotDeleteApprovalRuleFromTemplateException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CannotDeleteApprovalRuleFromTemplateException.prototype);
    }
}
export class CannotModifyApprovalRuleFromTemplateException extends __BaseException {
    name = "CannotModifyApprovalRuleFromTemplateException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CannotModifyApprovalRuleFromTemplateException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CannotModifyApprovalRuleFromTemplateException.prototype);
    }
}
export class ClientRequestTokenRequiredException extends __BaseException {
    name = "ClientRequestTokenRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ClientRequestTokenRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ClientRequestTokenRequiredException.prototype);
    }
}
export class InvalidApprovalRuleTemplateContentException extends __BaseException {
    name = "InvalidApprovalRuleTemplateContentException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidApprovalRuleTemplateContentException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidApprovalRuleTemplateContentException.prototype);
    }
}
export class InvalidApprovalRuleTemplateDescriptionException extends __BaseException {
    name = "InvalidApprovalRuleTemplateDescriptionException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidApprovalRuleTemplateDescriptionException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidApprovalRuleTemplateDescriptionException.prototype);
    }
}
export class NumberOfRuleTemplatesExceededException extends __BaseException {
    name = "NumberOfRuleTemplatesExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NumberOfRuleTemplatesExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NumberOfRuleTemplatesExceededException.prototype);
    }
}
export class CommitIdRequiredException extends __BaseException {
    name = "CommitIdRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommitIdRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommitIdRequiredException.prototype);
    }
}
export class InvalidBranchNameException extends __BaseException {
    name = "InvalidBranchNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidBranchNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidBranchNameException.prototype);
    }
}
export class InvalidCommitIdException extends __BaseException {
    name = "InvalidCommitIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidCommitIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidCommitIdException.prototype);
    }
}
export class CommitMessageLengthExceededException extends __BaseException {
    name = "CommitMessageLengthExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommitMessageLengthExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommitMessageLengthExceededException.prototype);
    }
}
export class DirectoryNameConflictsWithFileNameException extends __BaseException {
    name = "DirectoryNameConflictsWithFileNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DirectoryNameConflictsWithFileNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DirectoryNameConflictsWithFileNameException.prototype);
    }
}
export class FileContentAndSourceFileSpecifiedException extends __BaseException {
    name = "FileContentAndSourceFileSpecifiedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FileContentAndSourceFileSpecifiedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FileContentAndSourceFileSpecifiedException.prototype);
    }
}
export class FileContentSizeLimitExceededException extends __BaseException {
    name = "FileContentSizeLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FileContentSizeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FileContentSizeLimitExceededException.prototype);
    }
}
export class FileDoesNotExistException extends __BaseException {
    name = "FileDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FileDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FileDoesNotExistException.prototype);
    }
}
export class FileEntryRequiredException extends __BaseException {
    name = "FileEntryRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FileEntryRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FileEntryRequiredException.prototype);
    }
}
export class FileModeRequiredException extends __BaseException {
    name = "FileModeRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FileModeRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FileModeRequiredException.prototype);
    }
}
export class FileNameConflictsWithDirectoryNameException extends __BaseException {
    name = "FileNameConflictsWithDirectoryNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FileNameConflictsWithDirectoryNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FileNameConflictsWithDirectoryNameException.prototype);
    }
}
export class FilePathConflictsWithSubmodulePathException extends __BaseException {
    name = "FilePathConflictsWithSubmodulePathException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FilePathConflictsWithSubmodulePathException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FilePathConflictsWithSubmodulePathException.prototype);
    }
}
export class FolderContentSizeLimitExceededException extends __BaseException {
    name = "FolderContentSizeLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FolderContentSizeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FolderContentSizeLimitExceededException.prototype);
    }
}
export class InvalidDeletionParameterException extends __BaseException {
    name = "InvalidDeletionParameterException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeletionParameterException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeletionParameterException.prototype);
    }
}
export class InvalidEmailException extends __BaseException {
    name = "InvalidEmailException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidEmailException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidEmailException.prototype);
    }
}
export class InvalidFileModeException extends __BaseException {
    name = "InvalidFileModeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidFileModeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidFileModeException.prototype);
    }
}
export class InvalidParentCommitIdException extends __BaseException {
    name = "InvalidParentCommitIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidParentCommitIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidParentCommitIdException.prototype);
    }
}
export class InvalidPathException extends __BaseException {
    name = "InvalidPathException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidPathException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidPathException.prototype);
    }
}
export class MaximumFileEntriesExceededException extends __BaseException {
    name = "MaximumFileEntriesExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MaximumFileEntriesExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MaximumFileEntriesExceededException.prototype);
    }
}
export class NameLengthExceededException extends __BaseException {
    name = "NameLengthExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NameLengthExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NameLengthExceededException.prototype);
    }
}
export class NoChangeException extends __BaseException {
    name = "NoChangeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NoChangeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoChangeException.prototype);
    }
}
export class ParentCommitDoesNotExistException extends __BaseException {
    name = "ParentCommitDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ParentCommitDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ParentCommitDoesNotExistException.prototype);
    }
}
export class ParentCommitIdOutdatedException extends __BaseException {
    name = "ParentCommitIdOutdatedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ParentCommitIdOutdatedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ParentCommitIdOutdatedException.prototype);
    }
}
export class ParentCommitIdRequiredException extends __BaseException {
    name = "ParentCommitIdRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ParentCommitIdRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ParentCommitIdRequiredException.prototype);
    }
}
export class PathRequiredException extends __BaseException {
    name = "PathRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "PathRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PathRequiredException.prototype);
    }
}
export class PutFileEntryConflictException extends __BaseException {
    name = "PutFileEntryConflictException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "PutFileEntryConflictException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PutFileEntryConflictException.prototype);
    }
}
export class RestrictedSourceFileException extends __BaseException {
    name = "RestrictedSourceFileException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RestrictedSourceFileException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RestrictedSourceFileException.prototype);
    }
}
export class SamePathRequestException extends __BaseException {
    name = "SamePathRequestException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SamePathRequestException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SamePathRequestException.prototype);
    }
}
export class SourceFileOrContentRequiredException extends __BaseException {
    name = "SourceFileOrContentRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SourceFileOrContentRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SourceFileOrContentRequiredException.prototype);
    }
}
export const PullRequestStatusEnum = {
    CLOSED: "CLOSED",
    OPEN: "OPEN",
};
export class IdempotencyParameterMismatchException extends __BaseException {
    name = "IdempotencyParameterMismatchException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IdempotencyParameterMismatchException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IdempotencyParameterMismatchException.prototype);
    }
}
export class InvalidClientRequestTokenException extends __BaseException {
    name = "InvalidClientRequestTokenException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidClientRequestTokenException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidClientRequestTokenException.prototype);
    }
}
export class InvalidDescriptionException extends __BaseException {
    name = "InvalidDescriptionException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDescriptionException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDescriptionException.prototype);
    }
}
export class InvalidReferenceNameException extends __BaseException {
    name = "InvalidReferenceNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidReferenceNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidReferenceNameException.prototype);
    }
}
export class InvalidTargetException extends __BaseException {
    name = "InvalidTargetException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTargetException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTargetException.prototype);
    }
}
export class InvalidTargetsException extends __BaseException {
    name = "InvalidTargetsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTargetsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTargetsException.prototype);
    }
}
export class InvalidTitleException extends __BaseException {
    name = "InvalidTitleException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTitleException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTitleException.prototype);
    }
}
export class MaximumOpenPullRequestsExceededException extends __BaseException {
    name = "MaximumOpenPullRequestsExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MaximumOpenPullRequestsExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MaximumOpenPullRequestsExceededException.prototype);
    }
}
export class MultipleRepositoriesInPullRequestException extends __BaseException {
    name = "MultipleRepositoriesInPullRequestException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MultipleRepositoriesInPullRequestException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MultipleRepositoriesInPullRequestException.prototype);
    }
}
export class ReferenceDoesNotExistException extends __BaseException {
    name = "ReferenceDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReferenceDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReferenceDoesNotExistException.prototype);
    }
}
export class ReferenceNameRequiredException extends __BaseException {
    name = "ReferenceNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReferenceNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReferenceNameRequiredException.prototype);
    }
}
export class ReferenceTypeNotSupportedException extends __BaseException {
    name = "ReferenceTypeNotSupportedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReferenceTypeNotSupportedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReferenceTypeNotSupportedException.prototype);
    }
}
export class SourceAndDestinationAreSameException extends __BaseException {
    name = "SourceAndDestinationAreSameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SourceAndDestinationAreSameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SourceAndDestinationAreSameException.prototype);
    }
}
export class TargetRequiredException extends __BaseException {
    name = "TargetRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TargetRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TargetRequiredException.prototype);
    }
}
export class TargetsRequiredException extends __BaseException {
    name = "TargetsRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TargetsRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TargetsRequiredException.prototype);
    }
}
export class TitleRequiredException extends __BaseException {
    name = "TitleRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TitleRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TitleRequiredException.prototype);
    }
}
export class InvalidApprovalRuleContentException extends __BaseException {
    name = "InvalidApprovalRuleContentException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidApprovalRuleContentException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidApprovalRuleContentException.prototype);
    }
}
export class InvalidApprovalRuleNameException extends __BaseException {
    name = "InvalidApprovalRuleNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidApprovalRuleNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidApprovalRuleNameException.prototype);
    }
}
export class InvalidPullRequestIdException extends __BaseException {
    name = "InvalidPullRequestIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidPullRequestIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidPullRequestIdException.prototype);
    }
}
export class NumberOfRulesExceededException extends __BaseException {
    name = "NumberOfRulesExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NumberOfRulesExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NumberOfRulesExceededException.prototype);
    }
}
export class PullRequestAlreadyClosedException extends __BaseException {
    name = "PullRequestAlreadyClosedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "PullRequestAlreadyClosedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PullRequestAlreadyClosedException.prototype);
    }
}
export class PullRequestDoesNotExistException extends __BaseException {
    name = "PullRequestDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "PullRequestDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PullRequestDoesNotExistException.prototype);
    }
}
export class PullRequestIdRequiredException extends __BaseException {
    name = "PullRequestIdRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "PullRequestIdRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PullRequestIdRequiredException.prototype);
    }
}
export class EncryptionKeyInvalidIdException extends __BaseException {
    name = "EncryptionKeyInvalidIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "EncryptionKeyInvalidIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, EncryptionKeyInvalidIdException.prototype);
    }
}
export class EncryptionKeyInvalidUsageException extends __BaseException {
    name = "EncryptionKeyInvalidUsageException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "EncryptionKeyInvalidUsageException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, EncryptionKeyInvalidUsageException.prototype);
    }
}
export class InvalidRepositoryDescriptionException extends __BaseException {
    name = "InvalidRepositoryDescriptionException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidRepositoryDescriptionException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRepositoryDescriptionException.prototype);
    }
}
export class InvalidSystemTagUsageException extends __BaseException {
    name = "InvalidSystemTagUsageException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidSystemTagUsageException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidSystemTagUsageException.prototype);
    }
}
export class InvalidTagsMapException extends __BaseException {
    name = "InvalidTagsMapException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTagsMapException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTagsMapException.prototype);
    }
}
export class OperationNotAllowedException extends __BaseException {
    name = "OperationNotAllowedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "OperationNotAllowedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OperationNotAllowedException.prototype);
    }
}
export class RepositoryLimitExceededException extends __BaseException {
    name = "RepositoryLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryLimitExceededException.prototype);
    }
}
export class RepositoryNameExistsException extends __BaseException {
    name = "RepositoryNameExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryNameExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryNameExistsException.prototype);
    }
}
export class TagPolicyException extends __BaseException {
    name = "TagPolicyException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TagPolicyException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TagPolicyException.prototype);
    }
}
export class TooManyTagsException extends __BaseException {
    name = "TooManyTagsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TooManyTagsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyTagsException.prototype);
    }
}
export class ConcurrentReferenceUpdateException extends __BaseException {
    name = "ConcurrentReferenceUpdateException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ConcurrentReferenceUpdateException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ConcurrentReferenceUpdateException.prototype);
    }
}
export const ReplacementTypeEnum = {
    KEEP_BASE: "KEEP_BASE",
    KEEP_DESTINATION: "KEEP_DESTINATION",
    KEEP_SOURCE: "KEEP_SOURCE",
    USE_NEW_CONTENT: "USE_NEW_CONTENT",
};
export class InvalidConflictResolutionException extends __BaseException {
    name = "InvalidConflictResolutionException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidConflictResolutionException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidConflictResolutionException.prototype);
    }
}
export class InvalidReplacementContentException extends __BaseException {
    name = "InvalidReplacementContentException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidReplacementContentException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidReplacementContentException.prototype);
    }
}
export class InvalidReplacementTypeException extends __BaseException {
    name = "InvalidReplacementTypeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidReplacementTypeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidReplacementTypeException.prototype);
    }
}
export class ManualMergeRequiredException extends __BaseException {
    name = "ManualMergeRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ManualMergeRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ManualMergeRequiredException.prototype);
    }
}
export class MaximumConflictResolutionEntriesExceededException extends __BaseException {
    name = "MaximumConflictResolutionEntriesExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MaximumConflictResolutionEntriesExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MaximumConflictResolutionEntriesExceededException.prototype);
    }
}
export class MultipleConflictResolutionEntriesException extends __BaseException {
    name = "MultipleConflictResolutionEntriesException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MultipleConflictResolutionEntriesException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MultipleConflictResolutionEntriesException.prototype);
    }
}
export class ReplacementContentRequiredException extends __BaseException {
    name = "ReplacementContentRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReplacementContentRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReplacementContentRequiredException.prototype);
    }
}
export class ReplacementTypeRequiredException extends __BaseException {
    name = "ReplacementTypeRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReplacementTypeRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReplacementTypeRequiredException.prototype);
    }
}
export class DefaultBranchCannotBeDeletedException extends __BaseException {
    name = "DefaultBranchCannotBeDeletedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DefaultBranchCannotBeDeletedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DefaultBranchCannotBeDeletedException.prototype);
    }
}
export class CommentDeletedException extends __BaseException {
    name = "CommentDeletedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommentDeletedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommentDeletedException.prototype);
    }
}
export class CommentDoesNotExistException extends __BaseException {
    name = "CommentDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommentDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommentDoesNotExistException.prototype);
    }
}
export class CommentIdRequiredException extends __BaseException {
    name = "CommentIdRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommentIdRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommentIdRequiredException.prototype);
    }
}
export class InvalidCommentIdException extends __BaseException {
    name = "InvalidCommentIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidCommentIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidCommentIdException.prototype);
    }
}
export const PullRequestEventType = {
    PULL_REQUEST_APPROVAL_RULE_CREATED: "PULL_REQUEST_APPROVAL_RULE_CREATED",
    PULL_REQUEST_APPROVAL_RULE_DELETED: "PULL_REQUEST_APPROVAL_RULE_DELETED",
    PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN: "PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN",
    PULL_REQUEST_APPROVAL_RULE_UPDATED: "PULL_REQUEST_APPROVAL_RULE_UPDATED",
    PULL_REQUEST_APPROVAL_STATE_CHANGED: "PULL_REQUEST_APPROVAL_STATE_CHANGED",
    PULL_REQUEST_CREATED: "PULL_REQUEST_CREATED",
    PULL_REQUEST_MERGE_STATE_CHANGED: "PULL_REQUEST_MERGE_STATE_CHANGED",
    PULL_REQUEST_SOURCE_REFERENCE_UPDATED: "PULL_REQUEST_SOURCE_REFERENCE_UPDATED",
    PULL_REQUEST_STATUS_CHANGED: "PULL_REQUEST_STATUS_CHANGED",
};
export class InvalidActorArnException extends __BaseException {
    name = "InvalidActorArnException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidActorArnException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidActorArnException.prototype);
    }
}
export class InvalidMaxResultsException extends __BaseException {
    name = "InvalidMaxResultsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidMaxResultsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidMaxResultsException.prototype);
    }
}
export class InvalidPullRequestEventTypeException extends __BaseException {
    name = "InvalidPullRequestEventTypeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidPullRequestEventTypeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidPullRequestEventTypeException.prototype);
    }
}
export class InvalidRevisionIdException extends __BaseException {
    name = "InvalidRevisionIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidRevisionIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRevisionIdException.prototype);
    }
}
export class RevisionIdRequiredException extends __BaseException {
    name = "RevisionIdRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RevisionIdRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RevisionIdRequiredException.prototype);
    }
}
export class RevisionNotCurrentException extends __BaseException {
    name = "RevisionNotCurrentException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RevisionNotCurrentException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RevisionNotCurrentException.prototype);
    }
}
export class FileTooLargeException extends __BaseException {
    name = "FileTooLargeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FileTooLargeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FileTooLargeException.prototype);
    }
}
export class InvalidBlobIdException extends __BaseException {
    name = "InvalidBlobIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidBlobIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidBlobIdException.prototype);
    }
}
export class InvalidReactionUserArnException extends __BaseException {
    name = "InvalidReactionUserArnException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidReactionUserArnException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidReactionUserArnException.prototype);
    }
}
export const RelativeFileVersionEnum = {
    AFTER: "AFTER",
    BEFORE: "BEFORE",
};
export class RepositoryNotAssociatedWithPullRequestException extends __BaseException {
    name = "RepositoryNotAssociatedWithPullRequestException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RepositoryNotAssociatedWithPullRequestException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RepositoryNotAssociatedWithPullRequestException.prototype);
    }
}
export class CommitIdDoesNotExistException extends __BaseException {
    name = "CommitIdDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "CommitIdDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CommitIdDoesNotExistException.prototype);
    }
}
export class PathDoesNotExistException extends __BaseException {
    name = "PathDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "PathDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PathDoesNotExistException.prototype);
    }
}
export class FolderDoesNotExistException extends __BaseException {
    name = "FolderDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "FolderDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, FolderDoesNotExistException.prototype);
    }
}
export class InvalidDestinationCommitSpecifierException extends __BaseException {
    name = "InvalidDestinationCommitSpecifierException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDestinationCommitSpecifierException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDestinationCommitSpecifierException.prototype);
    }
}
export class InvalidSourceCommitSpecifierException extends __BaseException {
    name = "InvalidSourceCommitSpecifierException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidSourceCommitSpecifierException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidSourceCommitSpecifierException.prototype);
    }
}
export const RepositoryTriggerEventEnum = {
    ALL: "all",
    CREATE_REFERENCE: "createReference",
    DELETE_REFERENCE: "deleteReference",
    UPDATE_REFERENCE: "updateReference",
};
