import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListRepositoriesCommand, se_ListRepositoriesCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class ListRepositoriesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "ListRepositories", {})
    .n("CodeCommitClient", "ListRepositoriesCommand")
    .f(void 0, void 0)
    .ser(se_ListRepositoriesCommand)
    .de(de_ListRepositoriesCommand)
    .build() {
}
