import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetPullRequestApprovalStatesCommand, se_GetPullRequestApprovalStatesCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class GetPullRequestApprovalStatesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "GetPullRequestApprovalStates", {})
    .n("CodeCommitClient", "GetPullRequestApprovalStatesCommand")
    .f(void 0, void 0)
    .ser(se_GetPullRequestApprovalStatesCommand)
    .de(de_GetPullRequestApprovalStatesCommand)
    .build() {
}
