import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetFolderCommand, se_GetFolderCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetFolderCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "GetFolder", {})
    .n("CodeCommitClient", "GetFolderCommand")
    .f(void 0, void 0)
    .ser(se_GetFolderCommand)
    .de(de_GetFolderCommand)
    .build() {
}
