import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetFileCommand, se_GetFileCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetFileCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "GetFile", {})
    .n("CodeCommitClient", "GetFileCommand")
    .f(void 0, void 0)
    .ser(se_GetFileCommand)
    .de(de_GetFileCommand)
    .build() {
}
