import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetCommentsForPullRequestCommand, se_GetCommentsForPullRequestCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetCommentsForPullRequestCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "GetCommentsForPullRequest", {})
    .n("CodeCommitClient", "GetCommentsForPullRequestCommand")
    .f(void 0, void 0)
    .ser(se_GetCommentsForPullRequestCommand)
    .de(de_GetCommentsForPullRequestCommand)
    .build() {
}
