import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetCommentsForComparedCommitCommand, se_GetCommentsForComparedCommitCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class GetCommentsForComparedCommitCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "GetCommentsForComparedCommit", {})
    .n("CodeCommitClient", "GetCommentsForComparedCommitCommand")
    .f(void 0, void 0)
    .ser(se_GetCommentsForComparedCommitCommand)
    .de(de_GetCommentsForComparedCommitCommand)
    .build() {
}
