import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteFileCommand, se_DeleteFileCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class DeleteFileCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "DeleteFile", {})
    .n("CodeCommitClient", "DeleteFileCommand")
    .f(void 0, void 0)
    .ser(se_DeleteFileCommand)
    .de(de_DeleteFileCommand)
    .build() {
}
