import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_BatchGetCommitsCommand, se_BatchGetCommitsCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class BatchGetCommitsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeCommit_20150413", "BatchGetCommits", {})
    .n("CodeCommitClient", "BatchGetCommitsCommand")
    .f(void 0, void 0)
    .ser(se_BatchGetCommitsCommand)
    .de(de_BatchGetCommitsCommand)
    .build() {
}
