"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  ActorDoesNotExistException: () => ActorDoesNotExistException,
  ApprovalRuleContentRequiredException: () => ApprovalRuleContentRequiredException,
  ApprovalRuleDoesNotExistException: () => ApprovalRuleDoesNotExistException,
  ApprovalRuleNameAlreadyExistsException: () => ApprovalRuleNameAlreadyExistsException,
  ApprovalRuleNameRequiredException: () => ApprovalRuleNameRequiredException,
  ApprovalRuleTemplateContentRequiredException: () => ApprovalRuleTemplateContentRequiredException,
  ApprovalRuleTemplateDoesNotExistException: () => ApprovalRuleTemplateDoesNotExistException,
  ApprovalRuleTemplateInUseException: () => ApprovalRuleTemplateInUseException,
  ApprovalRuleTemplateNameAlreadyExistsException: () => ApprovalRuleTemplateNameAlreadyExistsException,
  ApprovalRuleTemplateNameRequiredException: () => ApprovalRuleTemplateNameRequiredException,
  ApprovalState: () => ApprovalState,
  ApprovalStateRequiredException: () => ApprovalStateRequiredException,
  AssociateApprovalRuleTemplateWithRepositoryCommand: () => AssociateApprovalRuleTemplateWithRepositoryCommand,
  AuthorDoesNotExistException: () => AuthorDoesNotExistException,
  BatchAssociateApprovalRuleTemplateWithRepositoriesCommand: () => BatchAssociateApprovalRuleTemplateWithRepositoriesCommand,
  BatchDescribeMergeConflictsCommand: () => BatchDescribeMergeConflictsCommand,
  BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand: () => BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand,
  BatchGetCommitsCommand: () => BatchGetCommitsCommand,
  BatchGetRepositoriesCommand: () => BatchGetRepositoriesCommand,
  BatchGetRepositoriesErrorCodeEnum: () => BatchGetRepositoriesErrorCodeEnum,
  BeforeCommitIdAndAfterCommitIdAreSameException: () => BeforeCommitIdAndAfterCommitIdAreSameException,
  BlobIdDoesNotExistException: () => BlobIdDoesNotExistException,
  BlobIdRequiredException: () => BlobIdRequiredException,
  BranchDoesNotExistException: () => BranchDoesNotExistException,
  BranchNameExistsException: () => BranchNameExistsException,
  BranchNameIsTagNameException: () => BranchNameIsTagNameException,
  BranchNameRequiredException: () => BranchNameRequiredException,
  CannotDeleteApprovalRuleFromTemplateException: () => CannotDeleteApprovalRuleFromTemplateException,
  CannotModifyApprovalRuleFromTemplateException: () => CannotModifyApprovalRuleFromTemplateException,
  ChangeTypeEnum: () => ChangeTypeEnum,
  ClientRequestTokenRequiredException: () => ClientRequestTokenRequiredException,
  CodeCommit: () => CodeCommit,
  CodeCommitClient: () => CodeCommitClient,
  CodeCommitServiceException: () => CodeCommitServiceException,
  CommentContentRequiredException: () => CommentContentRequiredException,
  CommentContentSizeLimitExceededException: () => CommentContentSizeLimitExceededException,
  CommentDeletedException: () => CommentDeletedException,
  CommentDoesNotExistException: () => CommentDoesNotExistException,
  CommentIdRequiredException: () => CommentIdRequiredException,
  CommentNotCreatedByCallerException: () => CommentNotCreatedByCallerException,
  CommitDoesNotExistException: () => CommitDoesNotExistException,
  CommitIdDoesNotExistException: () => CommitIdDoesNotExistException,
  CommitIdRequiredException: () => CommitIdRequiredException,
  CommitIdsLimitExceededException: () => CommitIdsLimitExceededException,
  CommitIdsListRequiredException: () => CommitIdsListRequiredException,
  CommitMessageLengthExceededException: () => CommitMessageLengthExceededException,
  CommitRequiredException: () => CommitRequiredException,
  ConcurrentReferenceUpdateException: () => ConcurrentReferenceUpdateException,
  ConflictDetailLevelTypeEnum: () => ConflictDetailLevelTypeEnum,
  ConflictResolutionStrategyTypeEnum: () => ConflictResolutionStrategyTypeEnum,
  CreateApprovalRuleTemplateCommand: () => CreateApprovalRuleTemplateCommand,
  CreateBranchCommand: () => CreateBranchCommand,
  CreateCommitCommand: () => CreateCommitCommand,
  CreatePullRequestApprovalRuleCommand: () => CreatePullRequestApprovalRuleCommand,
  CreatePullRequestCommand: () => CreatePullRequestCommand,
  CreateRepositoryCommand: () => CreateRepositoryCommand,
  CreateUnreferencedMergeCommitCommand: () => CreateUnreferencedMergeCommitCommand,
  DefaultBranchCannotBeDeletedException: () => DefaultBranchCannotBeDeletedException,
  DeleteApprovalRuleTemplateCommand: () => DeleteApprovalRuleTemplateCommand,
  DeleteBranchCommand: () => DeleteBranchCommand,
  DeleteCommentContentCommand: () => DeleteCommentContentCommand,
  DeleteFileCommand: () => DeleteFileCommand,
  DeletePullRequestApprovalRuleCommand: () => DeletePullRequestApprovalRuleCommand,
  DeleteRepositoryCommand: () => DeleteRepositoryCommand,
  DescribeMergeConflictsCommand: () => DescribeMergeConflictsCommand,
  DescribePullRequestEventsCommand: () => DescribePullRequestEventsCommand,
  DirectoryNameConflictsWithFileNameException: () => DirectoryNameConflictsWithFileNameException,
  DisassociateApprovalRuleTemplateFromRepositoryCommand: () => DisassociateApprovalRuleTemplateFromRepositoryCommand,
  EncryptionIntegrityChecksFailedException: () => EncryptionIntegrityChecksFailedException,
  EncryptionKeyAccessDeniedException: () => EncryptionKeyAccessDeniedException,
  EncryptionKeyDisabledException: () => EncryptionKeyDisabledException,
  EncryptionKeyInvalidIdException: () => EncryptionKeyInvalidIdException,
  EncryptionKeyInvalidUsageException: () => EncryptionKeyInvalidUsageException,
  EncryptionKeyNotFoundException: () => EncryptionKeyNotFoundException,
  EncryptionKeyRequiredException: () => EncryptionKeyRequiredException,
  EncryptionKeyUnavailableException: () => EncryptionKeyUnavailableException,
  EvaluatePullRequestApprovalRulesCommand: () => EvaluatePullRequestApprovalRulesCommand,
  FileContentAndSourceFileSpecifiedException: () => FileContentAndSourceFileSpecifiedException,
  FileContentRequiredException: () => FileContentRequiredException,
  FileContentSizeLimitExceededException: () => FileContentSizeLimitExceededException,
  FileDoesNotExistException: () => FileDoesNotExistException,
  FileEntryRequiredException: () => FileEntryRequiredException,
  FileModeRequiredException: () => FileModeRequiredException,
  FileModeTypeEnum: () => FileModeTypeEnum,
  FileNameConflictsWithDirectoryNameException: () => FileNameConflictsWithDirectoryNameException,
  FilePathConflictsWithSubmodulePathException: () => FilePathConflictsWithSubmodulePathException,
  FileTooLargeException: () => FileTooLargeException,
  FolderContentSizeLimitExceededException: () => FolderContentSizeLimitExceededException,
  FolderDoesNotExistException: () => FolderDoesNotExistException,
  GetApprovalRuleTemplateCommand: () => GetApprovalRuleTemplateCommand,
  GetBlobCommand: () => GetBlobCommand,
  GetBranchCommand: () => GetBranchCommand,
  GetCommentCommand: () => GetCommentCommand,
  GetCommentReactionsCommand: () => GetCommentReactionsCommand,
  GetCommentsForComparedCommitCommand: () => GetCommentsForComparedCommitCommand,
  GetCommentsForPullRequestCommand: () => GetCommentsForPullRequestCommand,
  GetCommitCommand: () => GetCommitCommand,
  GetDifferencesCommand: () => GetDifferencesCommand,
  GetFileCommand: () => GetFileCommand,
  GetFolderCommand: () => GetFolderCommand,
  GetMergeCommitCommand: () => GetMergeCommitCommand,
  GetMergeConflictsCommand: () => GetMergeConflictsCommand,
  GetMergeOptionsCommand: () => GetMergeOptionsCommand,
  GetPullRequestApprovalStatesCommand: () => GetPullRequestApprovalStatesCommand,
  GetPullRequestCommand: () => GetPullRequestCommand,
  GetPullRequestOverrideStateCommand: () => GetPullRequestOverrideStateCommand,
  GetRepositoryCommand: () => GetRepositoryCommand,
  GetRepositoryTriggersCommand: () => GetRepositoryTriggersCommand,
  IdempotencyParameterMismatchException: () => IdempotencyParameterMismatchException,
  InvalidActorArnException: () => InvalidActorArnException,
  InvalidApprovalRuleContentException: () => InvalidApprovalRuleContentException,
  InvalidApprovalRuleNameException: () => InvalidApprovalRuleNameException,
  InvalidApprovalRuleTemplateContentException: () => InvalidApprovalRuleTemplateContentException,
  InvalidApprovalRuleTemplateDescriptionException: () => InvalidApprovalRuleTemplateDescriptionException,
  InvalidApprovalRuleTemplateNameException: () => InvalidApprovalRuleTemplateNameException,
  InvalidApprovalStateException: () => InvalidApprovalStateException,
  InvalidAuthorArnException: () => InvalidAuthorArnException,
  InvalidBlobIdException: () => InvalidBlobIdException,
  InvalidBranchNameException: () => InvalidBranchNameException,
  InvalidClientRequestTokenException: () => InvalidClientRequestTokenException,
  InvalidCommentIdException: () => InvalidCommentIdException,
  InvalidCommitException: () => InvalidCommitException,
  InvalidCommitIdException: () => InvalidCommitIdException,
  InvalidConflictDetailLevelException: () => InvalidConflictDetailLevelException,
  InvalidConflictResolutionException: () => InvalidConflictResolutionException,
  InvalidConflictResolutionStrategyException: () => InvalidConflictResolutionStrategyException,
  InvalidContinuationTokenException: () => InvalidContinuationTokenException,
  InvalidDeletionParameterException: () => InvalidDeletionParameterException,
  InvalidDescriptionException: () => InvalidDescriptionException,
  InvalidDestinationCommitSpecifierException: () => InvalidDestinationCommitSpecifierException,
  InvalidEmailException: () => InvalidEmailException,
  InvalidFileLocationException: () => InvalidFileLocationException,
  InvalidFileModeException: () => InvalidFileModeException,
  InvalidFilePositionException: () => InvalidFilePositionException,
  InvalidMaxConflictFilesException: () => InvalidMaxConflictFilesException,
  InvalidMaxMergeHunksException: () => InvalidMaxMergeHunksException,
  InvalidMaxResultsException: () => InvalidMaxResultsException,
  InvalidMergeOptionException: () => InvalidMergeOptionException,
  InvalidOrderException: () => InvalidOrderException,
  InvalidOverrideStatusException: () => InvalidOverrideStatusException,
  InvalidParentCommitIdException: () => InvalidParentCommitIdException,
  InvalidPathException: () => InvalidPathException,
  InvalidPullRequestEventTypeException: () => InvalidPullRequestEventTypeException,
  InvalidPullRequestIdException: () => InvalidPullRequestIdException,
  InvalidPullRequestStatusException: () => InvalidPullRequestStatusException,
  InvalidPullRequestStatusUpdateException: () => InvalidPullRequestStatusUpdateException,
  InvalidReactionUserArnException: () => InvalidReactionUserArnException,
  InvalidReactionValueException: () => InvalidReactionValueException,
  InvalidReferenceNameException: () => InvalidReferenceNameException,
  InvalidRelativeFileVersionEnumException: () => InvalidRelativeFileVersionEnumException,
  InvalidReplacementContentException: () => InvalidReplacementContentException,
  InvalidReplacementTypeException: () => InvalidReplacementTypeException,
  InvalidRepositoryDescriptionException: () => InvalidRepositoryDescriptionException,
  InvalidRepositoryNameException: () => InvalidRepositoryNameException,
  InvalidRepositoryTriggerBranchNameException: () => InvalidRepositoryTriggerBranchNameException,
  InvalidRepositoryTriggerCustomDataException: () => InvalidRepositoryTriggerCustomDataException,
  InvalidRepositoryTriggerDestinationArnException: () => InvalidRepositoryTriggerDestinationArnException,
  InvalidRepositoryTriggerEventsException: () => InvalidRepositoryTriggerEventsException,
  InvalidRepositoryTriggerNameException: () => InvalidRepositoryTriggerNameException,
  InvalidRepositoryTriggerRegionException: () => InvalidRepositoryTriggerRegionException,
  InvalidResourceArnException: () => InvalidResourceArnException,
  InvalidRevisionIdException: () => InvalidRevisionIdException,
  InvalidRuleContentSha256Exception: () => InvalidRuleContentSha256Exception,
  InvalidSortByException: () => InvalidSortByException,
  InvalidSourceCommitSpecifierException: () => InvalidSourceCommitSpecifierException,
  InvalidSystemTagUsageException: () => InvalidSystemTagUsageException,
  InvalidTagKeysListException: () => InvalidTagKeysListException,
  InvalidTagsMapException: () => InvalidTagsMapException,
  InvalidTargetBranchException: () => InvalidTargetBranchException,
  InvalidTargetException: () => InvalidTargetException,
  InvalidTargetsException: () => InvalidTargetsException,
  InvalidTitleException: () => InvalidTitleException,
  ListApprovalRuleTemplatesCommand: () => ListApprovalRuleTemplatesCommand,
  ListAssociatedApprovalRuleTemplatesForRepositoryCommand: () => ListAssociatedApprovalRuleTemplatesForRepositoryCommand,
  ListBranchesCommand: () => ListBranchesCommand,
  ListFileCommitHistoryCommand: () => ListFileCommitHistoryCommand,
  ListPullRequestsCommand: () => ListPullRequestsCommand,
  ListRepositoriesCommand: () => ListRepositoriesCommand,
  ListRepositoriesForApprovalRuleTemplateCommand: () => ListRepositoriesForApprovalRuleTemplateCommand,
  ListTagsForResourceCommand: () => ListTagsForResourceCommand,
  ManualMergeRequiredException: () => ManualMergeRequiredException,
  MaximumBranchesExceededException: () => MaximumBranchesExceededException,
  MaximumConflictResolutionEntriesExceededException: () => MaximumConflictResolutionEntriesExceededException,
  MaximumFileContentToLoadExceededException: () => MaximumFileContentToLoadExceededException,
  MaximumFileEntriesExceededException: () => MaximumFileEntriesExceededException,
  MaximumItemsToCompareExceededException: () => MaximumItemsToCompareExceededException,
  MaximumNumberOfApprovalsExceededException: () => MaximumNumberOfApprovalsExceededException,
  MaximumOpenPullRequestsExceededException: () => MaximumOpenPullRequestsExceededException,
  MaximumRepositoryNamesExceededException: () => MaximumRepositoryNamesExceededException,
  MaximumRepositoryTriggersExceededException: () => MaximumRepositoryTriggersExceededException,
  MaximumRuleTemplatesAssociatedWithRepositoryException: () => MaximumRuleTemplatesAssociatedWithRepositoryException,
  MergeBranchesByFastForwardCommand: () => MergeBranchesByFastForwardCommand,
  MergeBranchesBySquashCommand: () => MergeBranchesBySquashCommand,
  MergeBranchesByThreeWayCommand: () => MergeBranchesByThreeWayCommand,
  MergeOptionRequiredException: () => MergeOptionRequiredException,
  MergeOptionTypeEnum: () => MergeOptionTypeEnum,
  MergePullRequestByFastForwardCommand: () => MergePullRequestByFastForwardCommand,
  MergePullRequestBySquashCommand: () => MergePullRequestBySquashCommand,
  MergePullRequestByThreeWayCommand: () => MergePullRequestByThreeWayCommand,
  MultipleConflictResolutionEntriesException: () => MultipleConflictResolutionEntriesException,
  MultipleRepositoriesInPullRequestException: () => MultipleRepositoriesInPullRequestException,
  NameLengthExceededException: () => NameLengthExceededException,
  NoChangeException: () => NoChangeException,
  NumberOfRuleTemplatesExceededException: () => NumberOfRuleTemplatesExceededException,
  NumberOfRulesExceededException: () => NumberOfRulesExceededException,
  ObjectTypeEnum: () => ObjectTypeEnum,
  OperationNotAllowedException: () => OperationNotAllowedException,
  OrderEnum: () => OrderEnum,
  OverrideAlreadySetException: () => OverrideAlreadySetException,
  OverridePullRequestApprovalRulesCommand: () => OverridePullRequestApprovalRulesCommand,
  OverrideStatus: () => OverrideStatus,
  OverrideStatusRequiredException: () => OverrideStatusRequiredException,
  ParentCommitDoesNotExistException: () => ParentCommitDoesNotExistException,
  ParentCommitIdOutdatedException: () => ParentCommitIdOutdatedException,
  ParentCommitIdRequiredException: () => ParentCommitIdRequiredException,
  PathDoesNotExistException: () => PathDoesNotExistException,
  PathRequiredException: () => PathRequiredException,
  PostCommentForComparedCommitCommand: () => PostCommentForComparedCommitCommand,
  PostCommentForPullRequestCommand: () => PostCommentForPullRequestCommand,
  PostCommentReplyCommand: () => PostCommentReplyCommand,
  PullRequestAlreadyClosedException: () => PullRequestAlreadyClosedException,
  PullRequestApprovalRulesNotSatisfiedException: () => PullRequestApprovalRulesNotSatisfiedException,
  PullRequestCannotBeApprovedByAuthorException: () => PullRequestCannotBeApprovedByAuthorException,
  PullRequestDoesNotExistException: () => PullRequestDoesNotExistException,
  PullRequestEventType: () => PullRequestEventType,
  PullRequestIdRequiredException: () => PullRequestIdRequiredException,
  PullRequestStatusEnum: () => PullRequestStatusEnum,
  PullRequestStatusRequiredException: () => PullRequestStatusRequiredException,
  PutCommentReactionCommand: () => PutCommentReactionCommand,
  PutFileCommand: () => PutFileCommand,
  PutFileEntryConflictException: () => PutFileEntryConflictException,
  PutRepositoryTriggersCommand: () => PutRepositoryTriggersCommand,
  ReactionLimitExceededException: () => ReactionLimitExceededException,
  ReactionValueRequiredException: () => ReactionValueRequiredException,
  ReferenceDoesNotExistException: () => ReferenceDoesNotExistException,
  ReferenceNameRequiredException: () => ReferenceNameRequiredException,
  ReferenceTypeNotSupportedException: () => ReferenceTypeNotSupportedException,
  RelativeFileVersionEnum: () => RelativeFileVersionEnum,
  ReplacementContentRequiredException: () => ReplacementContentRequiredException,
  ReplacementTypeEnum: () => ReplacementTypeEnum,
  ReplacementTypeRequiredException: () => ReplacementTypeRequiredException,
  RepositoryDoesNotExistException: () => RepositoryDoesNotExistException,
  RepositoryLimitExceededException: () => RepositoryLimitExceededException,
  RepositoryNameExistsException: () => RepositoryNameExistsException,
  RepositoryNameRequiredException: () => RepositoryNameRequiredException,
  RepositoryNamesRequiredException: () => RepositoryNamesRequiredException,
  RepositoryNotAssociatedWithPullRequestException: () => RepositoryNotAssociatedWithPullRequestException,
  RepositoryTriggerBranchNameListRequiredException: () => RepositoryTriggerBranchNameListRequiredException,
  RepositoryTriggerDestinationArnRequiredException: () => RepositoryTriggerDestinationArnRequiredException,
  RepositoryTriggerEventEnum: () => RepositoryTriggerEventEnum,
  RepositoryTriggerEventsListRequiredException: () => RepositoryTriggerEventsListRequiredException,
  RepositoryTriggerNameRequiredException: () => RepositoryTriggerNameRequiredException,
  RepositoryTriggersListRequiredException: () => RepositoryTriggersListRequiredException,
  ResourceArnRequiredException: () => ResourceArnRequiredException,
  RestrictedSourceFileException: () => RestrictedSourceFileException,
  RevisionIdRequiredException: () => RevisionIdRequiredException,
  RevisionNotCurrentException: () => RevisionNotCurrentException,
  SameFileContentException: () => SameFileContentException,
  SamePathRequestException: () => SamePathRequestException,
  SortByEnum: () => SortByEnum,
  SourceAndDestinationAreSameException: () => SourceAndDestinationAreSameException,
  SourceFileOrContentRequiredException: () => SourceFileOrContentRequiredException,
  TagKeysListRequiredException: () => TagKeysListRequiredException,
  TagPolicyException: () => TagPolicyException,
  TagResourceCommand: () => TagResourceCommand,
  TagsMapRequiredException: () => TagsMapRequiredException,
  TargetRequiredException: () => TargetRequiredException,
  TargetsRequiredException: () => TargetsRequiredException,
  TestRepositoryTriggersCommand: () => TestRepositoryTriggersCommand,
  TipOfSourceReferenceIsDifferentException: () => TipOfSourceReferenceIsDifferentException,
  TipsDivergenceExceededException: () => TipsDivergenceExceededException,
  TitleRequiredException: () => TitleRequiredException,
  TooManyTagsException: () => TooManyTagsException,
  UntagResourceCommand: () => UntagResourceCommand,
  UpdateApprovalRuleTemplateContentCommand: () => UpdateApprovalRuleTemplateContentCommand,
  UpdateApprovalRuleTemplateDescriptionCommand: () => UpdateApprovalRuleTemplateDescriptionCommand,
  UpdateApprovalRuleTemplateNameCommand: () => UpdateApprovalRuleTemplateNameCommand,
  UpdateCommentCommand: () => UpdateCommentCommand,
  UpdateDefaultBranchCommand: () => UpdateDefaultBranchCommand,
  UpdatePullRequestApprovalRuleContentCommand: () => UpdatePullRequestApprovalRuleContentCommand,
  UpdatePullRequestApprovalStateCommand: () => UpdatePullRequestApprovalStateCommand,
  UpdatePullRequestDescriptionCommand: () => UpdatePullRequestDescriptionCommand,
  UpdatePullRequestStatusCommand: () => UpdatePullRequestStatusCommand,
  UpdatePullRequestTitleCommand: () => UpdatePullRequestTitleCommand,
  UpdateRepositoryDescriptionCommand: () => UpdateRepositoryDescriptionCommand,
  UpdateRepositoryEncryptionKeyCommand: () => UpdateRepositoryEncryptionKeyCommand,
  UpdateRepositoryNameCommand: () => UpdateRepositoryNameCommand,
  __Client: () => import_smithy_client.Client,
  paginateDescribeMergeConflicts: () => paginateDescribeMergeConflicts,
  paginateDescribePullRequestEvents: () => paginateDescribePullRequestEvents,
  paginateGetCommentReactions: () => paginateGetCommentReactions,
  paginateGetCommentsForComparedCommit: () => paginateGetCommentsForComparedCommit,
  paginateGetCommentsForPullRequest: () => paginateGetCommentsForPullRequest,
  paginateGetDifferences: () => paginateGetDifferences,
  paginateGetMergeConflicts: () => paginateGetMergeConflicts,
  paginateListApprovalRuleTemplates: () => paginateListApprovalRuleTemplates,
  paginateListAssociatedApprovalRuleTemplatesForRepository: () => paginateListAssociatedApprovalRuleTemplatesForRepository,
  paginateListBranches: () => paginateListBranches,
  paginateListFileCommitHistory: () => paginateListFileCommitHistory,
  paginateListPullRequests: () => paginateListPullRequests,
  paginateListRepositories: () => paginateListRepositories,
  paginateListRepositoriesForApprovalRuleTemplate: () => paginateListRepositoriesForApprovalRuleTemplate
});
module.exports = __toCommonJS(index_exports);

// src/CodeCommitClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "codecommit"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/CodeCommitClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/CodeCommitClient.ts
var CodeCommitClient = class extends import_smithy_client.Client {
  static {
    __name(this, "CodeCommitClient");
  }
  /**
   * The resolved configuration of CodeCommitClient class. This is resolved and normalized from the {@link CodeCommitClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultCodeCommitHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/CodeCommit.ts


// src/commands/AssociateApprovalRuleTemplateWithRepositoryCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_json1_1.ts
var import_core2 = require("@aws-sdk/core");


var import_uuid = require("uuid");

// src/models/CodeCommitServiceException.ts

var CodeCommitServiceException = class _CodeCommitServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "CodeCommitServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _CodeCommitServiceException.prototype);
  }
};

// src/models/models_0.ts
var ActorDoesNotExistException = class _ActorDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "ActorDoesNotExistException");
  }
  name = "ActorDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ActorDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ActorDoesNotExistException.prototype);
  }
};
var ApprovalState = {
  APPROVE: "APPROVE",
  REVOKE: "REVOKE"
};
var ApprovalRuleContentRequiredException = class _ApprovalRuleContentRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalRuleContentRequiredException");
  }
  name = "ApprovalRuleContentRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalRuleContentRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalRuleContentRequiredException.prototype);
  }
};
var ApprovalRuleDoesNotExistException = class _ApprovalRuleDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalRuleDoesNotExistException");
  }
  name = "ApprovalRuleDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalRuleDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalRuleDoesNotExistException.prototype);
  }
};
var ApprovalRuleNameAlreadyExistsException = class _ApprovalRuleNameAlreadyExistsException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalRuleNameAlreadyExistsException");
  }
  name = "ApprovalRuleNameAlreadyExistsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalRuleNameAlreadyExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalRuleNameAlreadyExistsException.prototype);
  }
};
var ApprovalRuleNameRequiredException = class _ApprovalRuleNameRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalRuleNameRequiredException");
  }
  name = "ApprovalRuleNameRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalRuleNameRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalRuleNameRequiredException.prototype);
  }
};
var OverrideStatus = {
  OVERRIDE: "OVERRIDE",
  REVOKE: "REVOKE"
};
var ApprovalRuleTemplateContentRequiredException = class _ApprovalRuleTemplateContentRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalRuleTemplateContentRequiredException");
  }
  name = "ApprovalRuleTemplateContentRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalRuleTemplateContentRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalRuleTemplateContentRequiredException.prototype);
  }
};
var ApprovalRuleTemplateDoesNotExistException = class _ApprovalRuleTemplateDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalRuleTemplateDoesNotExistException");
  }
  name = "ApprovalRuleTemplateDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalRuleTemplateDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalRuleTemplateDoesNotExistException.prototype);
  }
};
var ApprovalRuleTemplateInUseException = class _ApprovalRuleTemplateInUseException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalRuleTemplateInUseException");
  }
  name = "ApprovalRuleTemplateInUseException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalRuleTemplateInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalRuleTemplateInUseException.prototype);
  }
};
var ApprovalRuleTemplateNameAlreadyExistsException = class _ApprovalRuleTemplateNameAlreadyExistsException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalRuleTemplateNameAlreadyExistsException");
  }
  name = "ApprovalRuleTemplateNameAlreadyExistsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalRuleTemplateNameAlreadyExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalRuleTemplateNameAlreadyExistsException.prototype);
  }
};
var ApprovalRuleTemplateNameRequiredException = class _ApprovalRuleTemplateNameRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalRuleTemplateNameRequiredException");
  }
  name = "ApprovalRuleTemplateNameRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalRuleTemplateNameRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalRuleTemplateNameRequiredException.prototype);
  }
};
var ApprovalStateRequiredException = class _ApprovalStateRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ApprovalStateRequiredException");
  }
  name = "ApprovalStateRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ApprovalStateRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ApprovalStateRequiredException.prototype);
  }
};
var EncryptionIntegrityChecksFailedException = class _EncryptionIntegrityChecksFailedException extends CodeCommitServiceException {
  static {
    __name(this, "EncryptionIntegrityChecksFailedException");
  }
  name = "EncryptionIntegrityChecksFailedException";
  $fault = "server";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EncryptionIntegrityChecksFailedException",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _EncryptionIntegrityChecksFailedException.prototype);
  }
};
var EncryptionKeyAccessDeniedException = class _EncryptionKeyAccessDeniedException extends CodeCommitServiceException {
  static {
    __name(this, "EncryptionKeyAccessDeniedException");
  }
  name = "EncryptionKeyAccessDeniedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EncryptionKeyAccessDeniedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EncryptionKeyAccessDeniedException.prototype);
  }
};
var EncryptionKeyDisabledException = class _EncryptionKeyDisabledException extends CodeCommitServiceException {
  static {
    __name(this, "EncryptionKeyDisabledException");
  }
  name = "EncryptionKeyDisabledException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EncryptionKeyDisabledException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EncryptionKeyDisabledException.prototype);
  }
};
var EncryptionKeyNotFoundException = class _EncryptionKeyNotFoundException extends CodeCommitServiceException {
  static {
    __name(this, "EncryptionKeyNotFoundException");
  }
  name = "EncryptionKeyNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EncryptionKeyNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EncryptionKeyNotFoundException.prototype);
  }
};
var EncryptionKeyUnavailableException = class _EncryptionKeyUnavailableException extends CodeCommitServiceException {
  static {
    __name(this, "EncryptionKeyUnavailableException");
  }
  name = "EncryptionKeyUnavailableException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EncryptionKeyUnavailableException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EncryptionKeyUnavailableException.prototype);
  }
};
var InvalidApprovalRuleTemplateNameException = class _InvalidApprovalRuleTemplateNameException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidApprovalRuleTemplateNameException");
  }
  name = "InvalidApprovalRuleTemplateNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidApprovalRuleTemplateNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidApprovalRuleTemplateNameException.prototype);
  }
};
var InvalidRepositoryNameException = class _InvalidRepositoryNameException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRepositoryNameException");
  }
  name = "InvalidRepositoryNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRepositoryNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRepositoryNameException.prototype);
  }
};
var MaximumRuleTemplatesAssociatedWithRepositoryException = class _MaximumRuleTemplatesAssociatedWithRepositoryException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumRuleTemplatesAssociatedWithRepositoryException");
  }
  name = "MaximumRuleTemplatesAssociatedWithRepositoryException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumRuleTemplatesAssociatedWithRepositoryException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumRuleTemplatesAssociatedWithRepositoryException.prototype);
  }
};
var RepositoryDoesNotExistException = class _RepositoryDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryDoesNotExistException");
  }
  name = "RepositoryDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryDoesNotExistException.prototype);
  }
};
var RepositoryNameRequiredException = class _RepositoryNameRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryNameRequiredException");
  }
  name = "RepositoryNameRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryNameRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryNameRequiredException.prototype);
  }
};
var AuthorDoesNotExistException = class _AuthorDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "AuthorDoesNotExistException");
  }
  name = "AuthorDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AuthorDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AuthorDoesNotExistException.prototype);
  }
};
var MaximumRepositoryNamesExceededException = class _MaximumRepositoryNamesExceededException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumRepositoryNamesExceededException");
  }
  name = "MaximumRepositoryNamesExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumRepositoryNamesExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumRepositoryNamesExceededException.prototype);
  }
};
var RepositoryNamesRequiredException = class _RepositoryNamesRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryNamesRequiredException");
  }
  name = "RepositoryNamesRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryNamesRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryNamesRequiredException.prototype);
  }
};
var ConflictDetailLevelTypeEnum = {
  FILE_LEVEL: "FILE_LEVEL",
  LINE_LEVEL: "LINE_LEVEL"
};
var ConflictResolutionStrategyTypeEnum = {
  ACCEPT_DESTINATION: "ACCEPT_DESTINATION",
  ACCEPT_SOURCE: "ACCEPT_SOURCE",
  AUTOMERGE: "AUTOMERGE",
  NONE: "NONE"
};
var MergeOptionTypeEnum = {
  FAST_FORWARD_MERGE: "FAST_FORWARD_MERGE",
  SQUASH_MERGE: "SQUASH_MERGE",
  THREE_WAY_MERGE: "THREE_WAY_MERGE"
};
var FileModeTypeEnum = {
  EXECUTABLE: "EXECUTABLE",
  NORMAL: "NORMAL",
  SYMLINK: "SYMLINK"
};
var ChangeTypeEnum = {
  ADDED: "A",
  DELETED: "D",
  MODIFIED: "M"
};
var ObjectTypeEnum = {
  DIRECTORY: "DIRECTORY",
  FILE: "FILE",
  GIT_LINK: "GIT_LINK",
  SYMBOLIC_LINK: "SYMBOLIC_LINK"
};
var CommitDoesNotExistException = class _CommitDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "CommitDoesNotExistException");
  }
  name = "CommitDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommitDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommitDoesNotExistException.prototype);
  }
};
var CommitRequiredException = class _CommitRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "CommitRequiredException");
  }
  name = "CommitRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommitRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommitRequiredException.prototype);
  }
};
var InvalidCommitException = class _InvalidCommitException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidCommitException");
  }
  name = "InvalidCommitException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidCommitException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidCommitException.prototype);
  }
};
var InvalidConflictDetailLevelException = class _InvalidConflictDetailLevelException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidConflictDetailLevelException");
  }
  name = "InvalidConflictDetailLevelException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidConflictDetailLevelException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidConflictDetailLevelException.prototype);
  }
};
var InvalidConflictResolutionStrategyException = class _InvalidConflictResolutionStrategyException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidConflictResolutionStrategyException");
  }
  name = "InvalidConflictResolutionStrategyException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidConflictResolutionStrategyException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidConflictResolutionStrategyException.prototype);
  }
};
var InvalidContinuationTokenException = class _InvalidContinuationTokenException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidContinuationTokenException");
  }
  name = "InvalidContinuationTokenException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidContinuationTokenException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidContinuationTokenException.prototype);
  }
};
var InvalidMaxConflictFilesException = class _InvalidMaxConflictFilesException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidMaxConflictFilesException");
  }
  name = "InvalidMaxConflictFilesException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidMaxConflictFilesException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidMaxConflictFilesException.prototype);
  }
};
var InvalidMaxMergeHunksException = class _InvalidMaxMergeHunksException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidMaxMergeHunksException");
  }
  name = "InvalidMaxMergeHunksException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidMaxMergeHunksException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidMaxMergeHunksException.prototype);
  }
};
var InvalidMergeOptionException = class _InvalidMergeOptionException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidMergeOptionException");
  }
  name = "InvalidMergeOptionException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidMergeOptionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidMergeOptionException.prototype);
  }
};
var MaximumFileContentToLoadExceededException = class _MaximumFileContentToLoadExceededException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumFileContentToLoadExceededException");
  }
  name = "MaximumFileContentToLoadExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumFileContentToLoadExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumFileContentToLoadExceededException.prototype);
  }
};
var MaximumItemsToCompareExceededException = class _MaximumItemsToCompareExceededException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumItemsToCompareExceededException");
  }
  name = "MaximumItemsToCompareExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumItemsToCompareExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumItemsToCompareExceededException.prototype);
  }
};
var MergeOptionRequiredException = class _MergeOptionRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "MergeOptionRequiredException");
  }
  name = "MergeOptionRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MergeOptionRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MergeOptionRequiredException.prototype);
  }
};
var TipsDivergenceExceededException = class _TipsDivergenceExceededException extends CodeCommitServiceException {
  static {
    __name(this, "TipsDivergenceExceededException");
  }
  name = "TipsDivergenceExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TipsDivergenceExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TipsDivergenceExceededException.prototype);
  }
};
var CommitIdsLimitExceededException = class _CommitIdsLimitExceededException extends CodeCommitServiceException {
  static {
    __name(this, "CommitIdsLimitExceededException");
  }
  name = "CommitIdsLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommitIdsLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommitIdsLimitExceededException.prototype);
  }
};
var CommitIdsListRequiredException = class _CommitIdsListRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "CommitIdsListRequiredException");
  }
  name = "CommitIdsListRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommitIdsListRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommitIdsListRequiredException.prototype);
  }
};
var BatchGetRepositoriesErrorCodeEnum = {
  ENCRYPTION_INTEGRITY_CHECKS_FAILED_EXCEPTION: "EncryptionIntegrityChecksFailedException",
  ENCRYPTION_KEY_ACCESS_DENIED_EXCEPTION: "EncryptionKeyAccessDeniedException",
  ENCRYPTION_KEY_DISABLED_EXCEPTION: "EncryptionKeyDisabledException",
  ENCRYPTION_KEY_NOT_FOUND_EXCEPTION: "EncryptionKeyNotFoundException",
  ENCRYPTION_KEY_UNAVAILABLE_EXCEPTION: "EncryptionKeyUnavailableException",
  REPOSITORY_DOES_NOT_EXIST_EXCEPTION: "RepositoryDoesNotExistException"
};
var BeforeCommitIdAndAfterCommitIdAreSameException = class _BeforeCommitIdAndAfterCommitIdAreSameException extends CodeCommitServiceException {
  static {
    __name(this, "BeforeCommitIdAndAfterCommitIdAreSameException");
  }
  name = "BeforeCommitIdAndAfterCommitIdAreSameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BeforeCommitIdAndAfterCommitIdAreSameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BeforeCommitIdAndAfterCommitIdAreSameException.prototype);
  }
};
var BlobIdDoesNotExistException = class _BlobIdDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "BlobIdDoesNotExistException");
  }
  name = "BlobIdDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BlobIdDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BlobIdDoesNotExistException.prototype);
  }
};
var BlobIdRequiredException = class _BlobIdRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "BlobIdRequiredException");
  }
  name = "BlobIdRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BlobIdRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BlobIdRequiredException.prototype);
  }
};
var BranchDoesNotExistException = class _BranchDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "BranchDoesNotExistException");
  }
  name = "BranchDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BranchDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BranchDoesNotExistException.prototype);
  }
};
var BranchNameExistsException = class _BranchNameExistsException extends CodeCommitServiceException {
  static {
    __name(this, "BranchNameExistsException");
  }
  name = "BranchNameExistsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BranchNameExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BranchNameExistsException.prototype);
  }
};
var BranchNameIsTagNameException = class _BranchNameIsTagNameException extends CodeCommitServiceException {
  static {
    __name(this, "BranchNameIsTagNameException");
  }
  name = "BranchNameIsTagNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BranchNameIsTagNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BranchNameIsTagNameException.prototype);
  }
};
var BranchNameRequiredException = class _BranchNameRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "BranchNameRequiredException");
  }
  name = "BranchNameRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BranchNameRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BranchNameRequiredException.prototype);
  }
};
var CannotDeleteApprovalRuleFromTemplateException = class _CannotDeleteApprovalRuleFromTemplateException extends CodeCommitServiceException {
  static {
    __name(this, "CannotDeleteApprovalRuleFromTemplateException");
  }
  name = "CannotDeleteApprovalRuleFromTemplateException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CannotDeleteApprovalRuleFromTemplateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CannotDeleteApprovalRuleFromTemplateException.prototype);
  }
};
var CannotModifyApprovalRuleFromTemplateException = class _CannotModifyApprovalRuleFromTemplateException extends CodeCommitServiceException {
  static {
    __name(this, "CannotModifyApprovalRuleFromTemplateException");
  }
  name = "CannotModifyApprovalRuleFromTemplateException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CannotModifyApprovalRuleFromTemplateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CannotModifyApprovalRuleFromTemplateException.prototype);
  }
};
var ClientRequestTokenRequiredException = class _ClientRequestTokenRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ClientRequestTokenRequiredException");
  }
  name = "ClientRequestTokenRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ClientRequestTokenRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ClientRequestTokenRequiredException.prototype);
  }
};
var InvalidApprovalRuleTemplateContentException = class _InvalidApprovalRuleTemplateContentException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidApprovalRuleTemplateContentException");
  }
  name = "InvalidApprovalRuleTemplateContentException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidApprovalRuleTemplateContentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidApprovalRuleTemplateContentException.prototype);
  }
};
var InvalidApprovalRuleTemplateDescriptionException = class _InvalidApprovalRuleTemplateDescriptionException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidApprovalRuleTemplateDescriptionException");
  }
  name = "InvalidApprovalRuleTemplateDescriptionException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidApprovalRuleTemplateDescriptionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidApprovalRuleTemplateDescriptionException.prototype);
  }
};
var NumberOfRuleTemplatesExceededException = class _NumberOfRuleTemplatesExceededException extends CodeCommitServiceException {
  static {
    __name(this, "NumberOfRuleTemplatesExceededException");
  }
  name = "NumberOfRuleTemplatesExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NumberOfRuleTemplatesExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NumberOfRuleTemplatesExceededException.prototype);
  }
};
var CommitIdRequiredException = class _CommitIdRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "CommitIdRequiredException");
  }
  name = "CommitIdRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommitIdRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommitIdRequiredException.prototype);
  }
};
var InvalidBranchNameException = class _InvalidBranchNameException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidBranchNameException");
  }
  name = "InvalidBranchNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidBranchNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidBranchNameException.prototype);
  }
};
var InvalidCommitIdException = class _InvalidCommitIdException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidCommitIdException");
  }
  name = "InvalidCommitIdException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidCommitIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidCommitIdException.prototype);
  }
};
var CommitMessageLengthExceededException = class _CommitMessageLengthExceededException extends CodeCommitServiceException {
  static {
    __name(this, "CommitMessageLengthExceededException");
  }
  name = "CommitMessageLengthExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommitMessageLengthExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommitMessageLengthExceededException.prototype);
  }
};
var DirectoryNameConflictsWithFileNameException = class _DirectoryNameConflictsWithFileNameException extends CodeCommitServiceException {
  static {
    __name(this, "DirectoryNameConflictsWithFileNameException");
  }
  name = "DirectoryNameConflictsWithFileNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DirectoryNameConflictsWithFileNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DirectoryNameConflictsWithFileNameException.prototype);
  }
};
var FileContentAndSourceFileSpecifiedException = class _FileContentAndSourceFileSpecifiedException extends CodeCommitServiceException {
  static {
    __name(this, "FileContentAndSourceFileSpecifiedException");
  }
  name = "FileContentAndSourceFileSpecifiedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FileContentAndSourceFileSpecifiedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FileContentAndSourceFileSpecifiedException.prototype);
  }
};
var FileContentSizeLimitExceededException = class _FileContentSizeLimitExceededException extends CodeCommitServiceException {
  static {
    __name(this, "FileContentSizeLimitExceededException");
  }
  name = "FileContentSizeLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FileContentSizeLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FileContentSizeLimitExceededException.prototype);
  }
};
var FileDoesNotExistException = class _FileDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "FileDoesNotExistException");
  }
  name = "FileDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FileDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FileDoesNotExistException.prototype);
  }
};
var FileEntryRequiredException = class _FileEntryRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "FileEntryRequiredException");
  }
  name = "FileEntryRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FileEntryRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FileEntryRequiredException.prototype);
  }
};
var FileModeRequiredException = class _FileModeRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "FileModeRequiredException");
  }
  name = "FileModeRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FileModeRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FileModeRequiredException.prototype);
  }
};
var FileNameConflictsWithDirectoryNameException = class _FileNameConflictsWithDirectoryNameException extends CodeCommitServiceException {
  static {
    __name(this, "FileNameConflictsWithDirectoryNameException");
  }
  name = "FileNameConflictsWithDirectoryNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FileNameConflictsWithDirectoryNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FileNameConflictsWithDirectoryNameException.prototype);
  }
};
var FilePathConflictsWithSubmodulePathException = class _FilePathConflictsWithSubmodulePathException extends CodeCommitServiceException {
  static {
    __name(this, "FilePathConflictsWithSubmodulePathException");
  }
  name = "FilePathConflictsWithSubmodulePathException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FilePathConflictsWithSubmodulePathException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FilePathConflictsWithSubmodulePathException.prototype);
  }
};
var FolderContentSizeLimitExceededException = class _FolderContentSizeLimitExceededException extends CodeCommitServiceException {
  static {
    __name(this, "FolderContentSizeLimitExceededException");
  }
  name = "FolderContentSizeLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FolderContentSizeLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FolderContentSizeLimitExceededException.prototype);
  }
};
var InvalidDeletionParameterException = class _InvalidDeletionParameterException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidDeletionParameterException");
  }
  name = "InvalidDeletionParameterException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDeletionParameterException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDeletionParameterException.prototype);
  }
};
var InvalidEmailException = class _InvalidEmailException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidEmailException");
  }
  name = "InvalidEmailException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidEmailException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidEmailException.prototype);
  }
};
var InvalidFileModeException = class _InvalidFileModeException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidFileModeException");
  }
  name = "InvalidFileModeException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidFileModeException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidFileModeException.prototype);
  }
};
var InvalidParentCommitIdException = class _InvalidParentCommitIdException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidParentCommitIdException");
  }
  name = "InvalidParentCommitIdException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidParentCommitIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidParentCommitIdException.prototype);
  }
};
var InvalidPathException = class _InvalidPathException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidPathException");
  }
  name = "InvalidPathException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidPathException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidPathException.prototype);
  }
};
var MaximumFileEntriesExceededException = class _MaximumFileEntriesExceededException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumFileEntriesExceededException");
  }
  name = "MaximumFileEntriesExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumFileEntriesExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumFileEntriesExceededException.prototype);
  }
};
var NameLengthExceededException = class _NameLengthExceededException extends CodeCommitServiceException {
  static {
    __name(this, "NameLengthExceededException");
  }
  name = "NameLengthExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NameLengthExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NameLengthExceededException.prototype);
  }
};
var NoChangeException = class _NoChangeException extends CodeCommitServiceException {
  static {
    __name(this, "NoChangeException");
  }
  name = "NoChangeException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoChangeException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoChangeException.prototype);
  }
};
var ParentCommitDoesNotExistException = class _ParentCommitDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "ParentCommitDoesNotExistException");
  }
  name = "ParentCommitDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParentCommitDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParentCommitDoesNotExistException.prototype);
  }
};
var ParentCommitIdOutdatedException = class _ParentCommitIdOutdatedException extends CodeCommitServiceException {
  static {
    __name(this, "ParentCommitIdOutdatedException");
  }
  name = "ParentCommitIdOutdatedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParentCommitIdOutdatedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParentCommitIdOutdatedException.prototype);
  }
};
var ParentCommitIdRequiredException = class _ParentCommitIdRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ParentCommitIdRequiredException");
  }
  name = "ParentCommitIdRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParentCommitIdRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParentCommitIdRequiredException.prototype);
  }
};
var PathRequiredException = class _PathRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "PathRequiredException");
  }
  name = "PathRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PathRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PathRequiredException.prototype);
  }
};
var PutFileEntryConflictException = class _PutFileEntryConflictException extends CodeCommitServiceException {
  static {
    __name(this, "PutFileEntryConflictException");
  }
  name = "PutFileEntryConflictException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PutFileEntryConflictException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PutFileEntryConflictException.prototype);
  }
};
var RestrictedSourceFileException = class _RestrictedSourceFileException extends CodeCommitServiceException {
  static {
    __name(this, "RestrictedSourceFileException");
  }
  name = "RestrictedSourceFileException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RestrictedSourceFileException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RestrictedSourceFileException.prototype);
  }
};
var SamePathRequestException = class _SamePathRequestException extends CodeCommitServiceException {
  static {
    __name(this, "SamePathRequestException");
  }
  name = "SamePathRequestException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SamePathRequestException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SamePathRequestException.prototype);
  }
};
var SourceFileOrContentRequiredException = class _SourceFileOrContentRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "SourceFileOrContentRequiredException");
  }
  name = "SourceFileOrContentRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SourceFileOrContentRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SourceFileOrContentRequiredException.prototype);
  }
};
var PullRequestStatusEnum = {
  CLOSED: "CLOSED",
  OPEN: "OPEN"
};
var IdempotencyParameterMismatchException = class _IdempotencyParameterMismatchException extends CodeCommitServiceException {
  static {
    __name(this, "IdempotencyParameterMismatchException");
  }
  name = "IdempotencyParameterMismatchException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IdempotencyParameterMismatchException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IdempotencyParameterMismatchException.prototype);
  }
};
var InvalidClientRequestTokenException = class _InvalidClientRequestTokenException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidClientRequestTokenException");
  }
  name = "InvalidClientRequestTokenException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidClientRequestTokenException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidClientRequestTokenException.prototype);
  }
};
var InvalidDescriptionException = class _InvalidDescriptionException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidDescriptionException");
  }
  name = "InvalidDescriptionException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDescriptionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDescriptionException.prototype);
  }
};
var InvalidReferenceNameException = class _InvalidReferenceNameException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidReferenceNameException");
  }
  name = "InvalidReferenceNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidReferenceNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidReferenceNameException.prototype);
  }
};
var InvalidTargetException = class _InvalidTargetException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidTargetException");
  }
  name = "InvalidTargetException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTargetException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTargetException.prototype);
  }
};
var InvalidTargetsException = class _InvalidTargetsException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidTargetsException");
  }
  name = "InvalidTargetsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTargetsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTargetsException.prototype);
  }
};
var InvalidTitleException = class _InvalidTitleException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidTitleException");
  }
  name = "InvalidTitleException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTitleException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTitleException.prototype);
  }
};
var MaximumOpenPullRequestsExceededException = class _MaximumOpenPullRequestsExceededException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumOpenPullRequestsExceededException");
  }
  name = "MaximumOpenPullRequestsExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumOpenPullRequestsExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumOpenPullRequestsExceededException.prototype);
  }
};
var MultipleRepositoriesInPullRequestException = class _MultipleRepositoriesInPullRequestException extends CodeCommitServiceException {
  static {
    __name(this, "MultipleRepositoriesInPullRequestException");
  }
  name = "MultipleRepositoriesInPullRequestException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MultipleRepositoriesInPullRequestException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MultipleRepositoriesInPullRequestException.prototype);
  }
};
var ReferenceDoesNotExistException = class _ReferenceDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "ReferenceDoesNotExistException");
  }
  name = "ReferenceDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReferenceDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReferenceDoesNotExistException.prototype);
  }
};
var ReferenceNameRequiredException = class _ReferenceNameRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ReferenceNameRequiredException");
  }
  name = "ReferenceNameRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReferenceNameRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReferenceNameRequiredException.prototype);
  }
};
var ReferenceTypeNotSupportedException = class _ReferenceTypeNotSupportedException extends CodeCommitServiceException {
  static {
    __name(this, "ReferenceTypeNotSupportedException");
  }
  name = "ReferenceTypeNotSupportedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReferenceTypeNotSupportedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReferenceTypeNotSupportedException.prototype);
  }
};
var SourceAndDestinationAreSameException = class _SourceAndDestinationAreSameException extends CodeCommitServiceException {
  static {
    __name(this, "SourceAndDestinationAreSameException");
  }
  name = "SourceAndDestinationAreSameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SourceAndDestinationAreSameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SourceAndDestinationAreSameException.prototype);
  }
};
var TargetRequiredException = class _TargetRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "TargetRequiredException");
  }
  name = "TargetRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TargetRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TargetRequiredException.prototype);
  }
};
var TargetsRequiredException = class _TargetsRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "TargetsRequiredException");
  }
  name = "TargetsRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TargetsRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TargetsRequiredException.prototype);
  }
};
var TitleRequiredException = class _TitleRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "TitleRequiredException");
  }
  name = "TitleRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TitleRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TitleRequiredException.prototype);
  }
};
var InvalidApprovalRuleContentException = class _InvalidApprovalRuleContentException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidApprovalRuleContentException");
  }
  name = "InvalidApprovalRuleContentException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidApprovalRuleContentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidApprovalRuleContentException.prototype);
  }
};
var InvalidApprovalRuleNameException = class _InvalidApprovalRuleNameException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidApprovalRuleNameException");
  }
  name = "InvalidApprovalRuleNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidApprovalRuleNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidApprovalRuleNameException.prototype);
  }
};
var InvalidPullRequestIdException = class _InvalidPullRequestIdException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidPullRequestIdException");
  }
  name = "InvalidPullRequestIdException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidPullRequestIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidPullRequestIdException.prototype);
  }
};
var NumberOfRulesExceededException = class _NumberOfRulesExceededException extends CodeCommitServiceException {
  static {
    __name(this, "NumberOfRulesExceededException");
  }
  name = "NumberOfRulesExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NumberOfRulesExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NumberOfRulesExceededException.prototype);
  }
};
var PullRequestAlreadyClosedException = class _PullRequestAlreadyClosedException extends CodeCommitServiceException {
  static {
    __name(this, "PullRequestAlreadyClosedException");
  }
  name = "PullRequestAlreadyClosedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PullRequestAlreadyClosedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PullRequestAlreadyClosedException.prototype);
  }
};
var PullRequestDoesNotExistException = class _PullRequestDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "PullRequestDoesNotExistException");
  }
  name = "PullRequestDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PullRequestDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PullRequestDoesNotExistException.prototype);
  }
};
var PullRequestIdRequiredException = class _PullRequestIdRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "PullRequestIdRequiredException");
  }
  name = "PullRequestIdRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PullRequestIdRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PullRequestIdRequiredException.prototype);
  }
};
var EncryptionKeyInvalidIdException = class _EncryptionKeyInvalidIdException extends CodeCommitServiceException {
  static {
    __name(this, "EncryptionKeyInvalidIdException");
  }
  name = "EncryptionKeyInvalidIdException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EncryptionKeyInvalidIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EncryptionKeyInvalidIdException.prototype);
  }
};
var EncryptionKeyInvalidUsageException = class _EncryptionKeyInvalidUsageException extends CodeCommitServiceException {
  static {
    __name(this, "EncryptionKeyInvalidUsageException");
  }
  name = "EncryptionKeyInvalidUsageException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EncryptionKeyInvalidUsageException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EncryptionKeyInvalidUsageException.prototype);
  }
};
var InvalidRepositoryDescriptionException = class _InvalidRepositoryDescriptionException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRepositoryDescriptionException");
  }
  name = "InvalidRepositoryDescriptionException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRepositoryDescriptionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRepositoryDescriptionException.prototype);
  }
};
var InvalidSystemTagUsageException = class _InvalidSystemTagUsageException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidSystemTagUsageException");
  }
  name = "InvalidSystemTagUsageException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidSystemTagUsageException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidSystemTagUsageException.prototype);
  }
};
var InvalidTagsMapException = class _InvalidTagsMapException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidTagsMapException");
  }
  name = "InvalidTagsMapException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTagsMapException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTagsMapException.prototype);
  }
};
var OperationNotAllowedException = class _OperationNotAllowedException extends CodeCommitServiceException {
  static {
    __name(this, "OperationNotAllowedException");
  }
  name = "OperationNotAllowedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OperationNotAllowedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OperationNotAllowedException.prototype);
  }
};
var RepositoryLimitExceededException = class _RepositoryLimitExceededException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryLimitExceededException");
  }
  name = "RepositoryLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryLimitExceededException.prototype);
  }
};
var RepositoryNameExistsException = class _RepositoryNameExistsException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryNameExistsException");
  }
  name = "RepositoryNameExistsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryNameExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryNameExistsException.prototype);
  }
};
var TagPolicyException = class _TagPolicyException extends CodeCommitServiceException {
  static {
    __name(this, "TagPolicyException");
  }
  name = "TagPolicyException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TagPolicyException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TagPolicyException.prototype);
  }
};
var TooManyTagsException = class _TooManyTagsException extends CodeCommitServiceException {
  static {
    __name(this, "TooManyTagsException");
  }
  name = "TooManyTagsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyTagsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyTagsException.prototype);
  }
};
var ConcurrentReferenceUpdateException = class _ConcurrentReferenceUpdateException extends CodeCommitServiceException {
  static {
    __name(this, "ConcurrentReferenceUpdateException");
  }
  name = "ConcurrentReferenceUpdateException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ConcurrentReferenceUpdateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ConcurrentReferenceUpdateException.prototype);
  }
};
var ReplacementTypeEnum = {
  KEEP_BASE: "KEEP_BASE",
  KEEP_DESTINATION: "KEEP_DESTINATION",
  KEEP_SOURCE: "KEEP_SOURCE",
  USE_NEW_CONTENT: "USE_NEW_CONTENT"
};
var InvalidConflictResolutionException = class _InvalidConflictResolutionException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidConflictResolutionException");
  }
  name = "InvalidConflictResolutionException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidConflictResolutionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidConflictResolutionException.prototype);
  }
};
var InvalidReplacementContentException = class _InvalidReplacementContentException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidReplacementContentException");
  }
  name = "InvalidReplacementContentException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidReplacementContentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidReplacementContentException.prototype);
  }
};
var InvalidReplacementTypeException = class _InvalidReplacementTypeException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidReplacementTypeException");
  }
  name = "InvalidReplacementTypeException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidReplacementTypeException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidReplacementTypeException.prototype);
  }
};
var ManualMergeRequiredException = class _ManualMergeRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ManualMergeRequiredException");
  }
  name = "ManualMergeRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ManualMergeRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ManualMergeRequiredException.prototype);
  }
};
var MaximumConflictResolutionEntriesExceededException = class _MaximumConflictResolutionEntriesExceededException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumConflictResolutionEntriesExceededException");
  }
  name = "MaximumConflictResolutionEntriesExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumConflictResolutionEntriesExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumConflictResolutionEntriesExceededException.prototype);
  }
};
var MultipleConflictResolutionEntriesException = class _MultipleConflictResolutionEntriesException extends CodeCommitServiceException {
  static {
    __name(this, "MultipleConflictResolutionEntriesException");
  }
  name = "MultipleConflictResolutionEntriesException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MultipleConflictResolutionEntriesException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MultipleConflictResolutionEntriesException.prototype);
  }
};
var ReplacementContentRequiredException = class _ReplacementContentRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ReplacementContentRequiredException");
  }
  name = "ReplacementContentRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReplacementContentRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReplacementContentRequiredException.prototype);
  }
};
var ReplacementTypeRequiredException = class _ReplacementTypeRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ReplacementTypeRequiredException");
  }
  name = "ReplacementTypeRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReplacementTypeRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReplacementTypeRequiredException.prototype);
  }
};
var DefaultBranchCannotBeDeletedException = class _DefaultBranchCannotBeDeletedException extends CodeCommitServiceException {
  static {
    __name(this, "DefaultBranchCannotBeDeletedException");
  }
  name = "DefaultBranchCannotBeDeletedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DefaultBranchCannotBeDeletedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DefaultBranchCannotBeDeletedException.prototype);
  }
};
var CommentDeletedException = class _CommentDeletedException extends CodeCommitServiceException {
  static {
    __name(this, "CommentDeletedException");
  }
  name = "CommentDeletedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommentDeletedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommentDeletedException.prototype);
  }
};
var CommentDoesNotExistException = class _CommentDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "CommentDoesNotExistException");
  }
  name = "CommentDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommentDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommentDoesNotExistException.prototype);
  }
};
var CommentIdRequiredException = class _CommentIdRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "CommentIdRequiredException");
  }
  name = "CommentIdRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommentIdRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommentIdRequiredException.prototype);
  }
};
var InvalidCommentIdException = class _InvalidCommentIdException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidCommentIdException");
  }
  name = "InvalidCommentIdException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidCommentIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidCommentIdException.prototype);
  }
};
var PullRequestEventType = {
  PULL_REQUEST_APPROVAL_RULE_CREATED: "PULL_REQUEST_APPROVAL_RULE_CREATED",
  PULL_REQUEST_APPROVAL_RULE_DELETED: "PULL_REQUEST_APPROVAL_RULE_DELETED",
  PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN: "PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN",
  PULL_REQUEST_APPROVAL_RULE_UPDATED: "PULL_REQUEST_APPROVAL_RULE_UPDATED",
  PULL_REQUEST_APPROVAL_STATE_CHANGED: "PULL_REQUEST_APPROVAL_STATE_CHANGED",
  PULL_REQUEST_CREATED: "PULL_REQUEST_CREATED",
  PULL_REQUEST_MERGE_STATE_CHANGED: "PULL_REQUEST_MERGE_STATE_CHANGED",
  PULL_REQUEST_SOURCE_REFERENCE_UPDATED: "PULL_REQUEST_SOURCE_REFERENCE_UPDATED",
  PULL_REQUEST_STATUS_CHANGED: "PULL_REQUEST_STATUS_CHANGED"
};
var InvalidActorArnException = class _InvalidActorArnException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidActorArnException");
  }
  name = "InvalidActorArnException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidActorArnException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidActorArnException.prototype);
  }
};
var InvalidMaxResultsException = class _InvalidMaxResultsException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidMaxResultsException");
  }
  name = "InvalidMaxResultsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidMaxResultsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidMaxResultsException.prototype);
  }
};
var InvalidPullRequestEventTypeException = class _InvalidPullRequestEventTypeException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidPullRequestEventTypeException");
  }
  name = "InvalidPullRequestEventTypeException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidPullRequestEventTypeException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidPullRequestEventTypeException.prototype);
  }
};
var InvalidRevisionIdException = class _InvalidRevisionIdException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRevisionIdException");
  }
  name = "InvalidRevisionIdException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRevisionIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRevisionIdException.prototype);
  }
};
var RevisionIdRequiredException = class _RevisionIdRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "RevisionIdRequiredException");
  }
  name = "RevisionIdRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RevisionIdRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RevisionIdRequiredException.prototype);
  }
};
var RevisionNotCurrentException = class _RevisionNotCurrentException extends CodeCommitServiceException {
  static {
    __name(this, "RevisionNotCurrentException");
  }
  name = "RevisionNotCurrentException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RevisionNotCurrentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RevisionNotCurrentException.prototype);
  }
};
var FileTooLargeException = class _FileTooLargeException extends CodeCommitServiceException {
  static {
    __name(this, "FileTooLargeException");
  }
  name = "FileTooLargeException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FileTooLargeException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FileTooLargeException.prototype);
  }
};
var InvalidBlobIdException = class _InvalidBlobIdException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidBlobIdException");
  }
  name = "InvalidBlobIdException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidBlobIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidBlobIdException.prototype);
  }
};
var InvalidReactionUserArnException = class _InvalidReactionUserArnException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidReactionUserArnException");
  }
  name = "InvalidReactionUserArnException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidReactionUserArnException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidReactionUserArnException.prototype);
  }
};
var RelativeFileVersionEnum = {
  AFTER: "AFTER",
  BEFORE: "BEFORE"
};
var RepositoryNotAssociatedWithPullRequestException = class _RepositoryNotAssociatedWithPullRequestException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryNotAssociatedWithPullRequestException");
  }
  name = "RepositoryNotAssociatedWithPullRequestException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryNotAssociatedWithPullRequestException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryNotAssociatedWithPullRequestException.prototype);
  }
};
var CommitIdDoesNotExistException = class _CommitIdDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "CommitIdDoesNotExistException");
  }
  name = "CommitIdDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommitIdDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommitIdDoesNotExistException.prototype);
  }
};
var PathDoesNotExistException = class _PathDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "PathDoesNotExistException");
  }
  name = "PathDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PathDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PathDoesNotExistException.prototype);
  }
};
var FolderDoesNotExistException = class _FolderDoesNotExistException extends CodeCommitServiceException {
  static {
    __name(this, "FolderDoesNotExistException");
  }
  name = "FolderDoesNotExistException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FolderDoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FolderDoesNotExistException.prototype);
  }
};
var InvalidDestinationCommitSpecifierException = class _InvalidDestinationCommitSpecifierException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidDestinationCommitSpecifierException");
  }
  name = "InvalidDestinationCommitSpecifierException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDestinationCommitSpecifierException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDestinationCommitSpecifierException.prototype);
  }
};
var InvalidSourceCommitSpecifierException = class _InvalidSourceCommitSpecifierException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidSourceCommitSpecifierException");
  }
  name = "InvalidSourceCommitSpecifierException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidSourceCommitSpecifierException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidSourceCommitSpecifierException.prototype);
  }
};
var RepositoryTriggerEventEnum = {
  ALL: "all",
  CREATE_REFERENCE: "createReference",
  DELETE_REFERENCE: "deleteReference",
  UPDATE_REFERENCE: "updateReference"
};

// src/models/models_1.ts
var InvalidAuthorArnException = class _InvalidAuthorArnException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidAuthorArnException");
  }
  name = "InvalidAuthorArnException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAuthorArnException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAuthorArnException.prototype);
  }
};
var InvalidPullRequestStatusException = class _InvalidPullRequestStatusException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidPullRequestStatusException");
  }
  name = "InvalidPullRequestStatusException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidPullRequestStatusException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidPullRequestStatusException.prototype);
  }
};
var InvalidOrderException = class _InvalidOrderException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidOrderException");
  }
  name = "InvalidOrderException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOrderException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOrderException.prototype);
  }
};
var InvalidSortByException = class _InvalidSortByException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidSortByException");
  }
  name = "InvalidSortByException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidSortByException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidSortByException.prototype);
  }
};
var OrderEnum = {
  ASCENDING: "ascending",
  DESCENDING: "descending"
};
var SortByEnum = {
  MODIFIED_DATE: "lastModifiedDate",
  REPOSITORY_NAME: "repositoryName"
};
var InvalidResourceArnException = class _InvalidResourceArnException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidResourceArnException");
  }
  name = "InvalidResourceArnException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidResourceArnException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidResourceArnException.prototype);
  }
};
var ResourceArnRequiredException = class _ResourceArnRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ResourceArnRequiredException");
  }
  name = "ResourceArnRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceArnRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceArnRequiredException.prototype);
  }
};
var InvalidTargetBranchException = class _InvalidTargetBranchException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidTargetBranchException");
  }
  name = "InvalidTargetBranchException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTargetBranchException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTargetBranchException.prototype);
  }
};
var PullRequestApprovalRulesNotSatisfiedException = class _PullRequestApprovalRulesNotSatisfiedException extends CodeCommitServiceException {
  static {
    __name(this, "PullRequestApprovalRulesNotSatisfiedException");
  }
  name = "PullRequestApprovalRulesNotSatisfiedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PullRequestApprovalRulesNotSatisfiedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PullRequestApprovalRulesNotSatisfiedException.prototype);
  }
};
var TipOfSourceReferenceIsDifferentException = class _TipOfSourceReferenceIsDifferentException extends CodeCommitServiceException {
  static {
    __name(this, "TipOfSourceReferenceIsDifferentException");
  }
  name = "TipOfSourceReferenceIsDifferentException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TipOfSourceReferenceIsDifferentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TipOfSourceReferenceIsDifferentException.prototype);
  }
};
var InvalidOverrideStatusException = class _InvalidOverrideStatusException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidOverrideStatusException");
  }
  name = "InvalidOverrideStatusException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOverrideStatusException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOverrideStatusException.prototype);
  }
};
var OverrideAlreadySetException = class _OverrideAlreadySetException extends CodeCommitServiceException {
  static {
    __name(this, "OverrideAlreadySetException");
  }
  name = "OverrideAlreadySetException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OverrideAlreadySetException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OverrideAlreadySetException.prototype);
  }
};
var OverrideStatusRequiredException = class _OverrideStatusRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "OverrideStatusRequiredException");
  }
  name = "OverrideStatusRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OverrideStatusRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OverrideStatusRequiredException.prototype);
  }
};
var CommentContentRequiredException = class _CommentContentRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "CommentContentRequiredException");
  }
  name = "CommentContentRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommentContentRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommentContentRequiredException.prototype);
  }
};
var CommentContentSizeLimitExceededException = class _CommentContentSizeLimitExceededException extends CodeCommitServiceException {
  static {
    __name(this, "CommentContentSizeLimitExceededException");
  }
  name = "CommentContentSizeLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommentContentSizeLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommentContentSizeLimitExceededException.prototype);
  }
};
var InvalidFileLocationException = class _InvalidFileLocationException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidFileLocationException");
  }
  name = "InvalidFileLocationException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidFileLocationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidFileLocationException.prototype);
  }
};
var InvalidFilePositionException = class _InvalidFilePositionException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidFilePositionException");
  }
  name = "InvalidFilePositionException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidFilePositionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidFilePositionException.prototype);
  }
};
var InvalidRelativeFileVersionEnumException = class _InvalidRelativeFileVersionEnumException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRelativeFileVersionEnumException");
  }
  name = "InvalidRelativeFileVersionEnumException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRelativeFileVersionEnumException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRelativeFileVersionEnumException.prototype);
  }
};
var InvalidReactionValueException = class _InvalidReactionValueException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidReactionValueException");
  }
  name = "InvalidReactionValueException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidReactionValueException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidReactionValueException.prototype);
  }
};
var ReactionLimitExceededException = class _ReactionLimitExceededException extends CodeCommitServiceException {
  static {
    __name(this, "ReactionLimitExceededException");
  }
  name = "ReactionLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReactionLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReactionLimitExceededException.prototype);
  }
};
var ReactionValueRequiredException = class _ReactionValueRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "ReactionValueRequiredException");
  }
  name = "ReactionValueRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReactionValueRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReactionValueRequiredException.prototype);
  }
};
var FileContentRequiredException = class _FileContentRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "FileContentRequiredException");
  }
  name = "FileContentRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FileContentRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FileContentRequiredException.prototype);
  }
};
var SameFileContentException = class _SameFileContentException extends CodeCommitServiceException {
  static {
    __name(this, "SameFileContentException");
  }
  name = "SameFileContentException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SameFileContentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SameFileContentException.prototype);
  }
};
var InvalidRepositoryTriggerBranchNameException = class _InvalidRepositoryTriggerBranchNameException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRepositoryTriggerBranchNameException");
  }
  name = "InvalidRepositoryTriggerBranchNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRepositoryTriggerBranchNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRepositoryTriggerBranchNameException.prototype);
  }
};
var InvalidRepositoryTriggerCustomDataException = class _InvalidRepositoryTriggerCustomDataException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRepositoryTriggerCustomDataException");
  }
  name = "InvalidRepositoryTriggerCustomDataException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRepositoryTriggerCustomDataException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRepositoryTriggerCustomDataException.prototype);
  }
};
var InvalidRepositoryTriggerDestinationArnException = class _InvalidRepositoryTriggerDestinationArnException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRepositoryTriggerDestinationArnException");
  }
  name = "InvalidRepositoryTriggerDestinationArnException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRepositoryTriggerDestinationArnException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRepositoryTriggerDestinationArnException.prototype);
  }
};
var InvalidRepositoryTriggerEventsException = class _InvalidRepositoryTriggerEventsException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRepositoryTriggerEventsException");
  }
  name = "InvalidRepositoryTriggerEventsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRepositoryTriggerEventsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRepositoryTriggerEventsException.prototype);
  }
};
var InvalidRepositoryTriggerNameException = class _InvalidRepositoryTriggerNameException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRepositoryTriggerNameException");
  }
  name = "InvalidRepositoryTriggerNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRepositoryTriggerNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRepositoryTriggerNameException.prototype);
  }
};
var InvalidRepositoryTriggerRegionException = class _InvalidRepositoryTriggerRegionException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRepositoryTriggerRegionException");
  }
  name = "InvalidRepositoryTriggerRegionException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRepositoryTriggerRegionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRepositoryTriggerRegionException.prototype);
  }
};
var MaximumBranchesExceededException = class _MaximumBranchesExceededException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumBranchesExceededException");
  }
  name = "MaximumBranchesExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumBranchesExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumBranchesExceededException.prototype);
  }
};
var MaximumRepositoryTriggersExceededException = class _MaximumRepositoryTriggersExceededException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumRepositoryTriggersExceededException");
  }
  name = "MaximumRepositoryTriggersExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumRepositoryTriggersExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumRepositoryTriggersExceededException.prototype);
  }
};
var RepositoryTriggerBranchNameListRequiredException = class _RepositoryTriggerBranchNameListRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryTriggerBranchNameListRequiredException");
  }
  name = "RepositoryTriggerBranchNameListRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryTriggerBranchNameListRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryTriggerBranchNameListRequiredException.prototype);
  }
};
var RepositoryTriggerDestinationArnRequiredException = class _RepositoryTriggerDestinationArnRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryTriggerDestinationArnRequiredException");
  }
  name = "RepositoryTriggerDestinationArnRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryTriggerDestinationArnRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryTriggerDestinationArnRequiredException.prototype);
  }
};
var RepositoryTriggerEventsListRequiredException = class _RepositoryTriggerEventsListRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryTriggerEventsListRequiredException");
  }
  name = "RepositoryTriggerEventsListRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryTriggerEventsListRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryTriggerEventsListRequiredException.prototype);
  }
};
var RepositoryTriggerNameRequiredException = class _RepositoryTriggerNameRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryTriggerNameRequiredException");
  }
  name = "RepositoryTriggerNameRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryTriggerNameRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryTriggerNameRequiredException.prototype);
  }
};
var RepositoryTriggersListRequiredException = class _RepositoryTriggersListRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "RepositoryTriggersListRequiredException");
  }
  name = "RepositoryTriggersListRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "RepositoryTriggersListRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _RepositoryTriggersListRequiredException.prototype);
  }
};
var TagsMapRequiredException = class _TagsMapRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "TagsMapRequiredException");
  }
  name = "TagsMapRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TagsMapRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TagsMapRequiredException.prototype);
  }
};
var InvalidTagKeysListException = class _InvalidTagKeysListException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidTagKeysListException");
  }
  name = "InvalidTagKeysListException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTagKeysListException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTagKeysListException.prototype);
  }
};
var TagKeysListRequiredException = class _TagKeysListRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "TagKeysListRequiredException");
  }
  name = "TagKeysListRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TagKeysListRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TagKeysListRequiredException.prototype);
  }
};
var InvalidRuleContentSha256Exception = class _InvalidRuleContentSha256Exception extends CodeCommitServiceException {
  static {
    __name(this, "InvalidRuleContentSha256Exception");
  }
  name = "InvalidRuleContentSha256Exception";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRuleContentSha256Exception",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRuleContentSha256Exception.prototype);
  }
};
var CommentNotCreatedByCallerException = class _CommentNotCreatedByCallerException extends CodeCommitServiceException {
  static {
    __name(this, "CommentNotCreatedByCallerException");
  }
  name = "CommentNotCreatedByCallerException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CommentNotCreatedByCallerException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CommentNotCreatedByCallerException.prototype);
  }
};
var InvalidApprovalStateException = class _InvalidApprovalStateException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidApprovalStateException");
  }
  name = "InvalidApprovalStateException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidApprovalStateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidApprovalStateException.prototype);
  }
};
var MaximumNumberOfApprovalsExceededException = class _MaximumNumberOfApprovalsExceededException extends CodeCommitServiceException {
  static {
    __name(this, "MaximumNumberOfApprovalsExceededException");
  }
  name = "MaximumNumberOfApprovalsExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaximumNumberOfApprovalsExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaximumNumberOfApprovalsExceededException.prototype);
  }
};
var PullRequestCannotBeApprovedByAuthorException = class _PullRequestCannotBeApprovedByAuthorException extends CodeCommitServiceException {
  static {
    __name(this, "PullRequestCannotBeApprovedByAuthorException");
  }
  name = "PullRequestCannotBeApprovedByAuthorException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PullRequestCannotBeApprovedByAuthorException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PullRequestCannotBeApprovedByAuthorException.prototype);
  }
};
var InvalidPullRequestStatusUpdateException = class _InvalidPullRequestStatusUpdateException extends CodeCommitServiceException {
  static {
    __name(this, "InvalidPullRequestStatusUpdateException");
  }
  name = "InvalidPullRequestStatusUpdateException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidPullRequestStatusUpdateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidPullRequestStatusUpdateException.prototype);
  }
};
var PullRequestStatusRequiredException = class _PullRequestStatusRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "PullRequestStatusRequiredException");
  }
  name = "PullRequestStatusRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PullRequestStatusRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PullRequestStatusRequiredException.prototype);
  }
};
var EncryptionKeyRequiredException = class _EncryptionKeyRequiredException extends CodeCommitServiceException {
  static {
    __name(this, "EncryptionKeyRequiredException");
  }
  name = "EncryptionKeyRequiredException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EncryptionKeyRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EncryptionKeyRequiredException.prototype);
  }
};

// src/protocols/Aws_json1_1.ts
var se_AssociateApprovalRuleTemplateWithRepositoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("AssociateApprovalRuleTemplateWithRepository");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AssociateApprovalRuleTemplateWithRepositoryCommand");
var se_BatchAssociateApprovalRuleTemplateWithRepositoriesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchAssociateApprovalRuleTemplateWithRepositories");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchAssociateApprovalRuleTemplateWithRepositoriesCommand");
var se_BatchDescribeMergeConflictsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchDescribeMergeConflicts");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchDescribeMergeConflictsCommand");
var se_BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchDisassociateApprovalRuleTemplateFromRepositories");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand");
var se_BatchGetCommitsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchGetCommits");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchGetCommitsCommand");
var se_BatchGetRepositoriesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("BatchGetRepositories");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchGetRepositoriesCommand");
var se_CreateApprovalRuleTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateApprovalRuleTemplate");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateApprovalRuleTemplateCommand");
var se_CreateBranchCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateBranch");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateBranchCommand");
var se_CreateCommitCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateCommit");
  let body;
  body = JSON.stringify(se_CreateCommitInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateCommitCommand");
var se_CreatePullRequestCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreatePullRequest");
  let body;
  body = JSON.stringify(se_CreatePullRequestInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreatePullRequestCommand");
var se_CreatePullRequestApprovalRuleCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreatePullRequestApprovalRule");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreatePullRequestApprovalRuleCommand");
var se_CreateRepositoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateRepository");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateRepositoryCommand");
var se_CreateUnreferencedMergeCommitCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateUnreferencedMergeCommit");
  let body;
  body = JSON.stringify(se_CreateUnreferencedMergeCommitInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateUnreferencedMergeCommitCommand");
var se_DeleteApprovalRuleTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteApprovalRuleTemplate");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteApprovalRuleTemplateCommand");
var se_DeleteBranchCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteBranch");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteBranchCommand");
var se_DeleteCommentContentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteCommentContent");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteCommentContentCommand");
var se_DeleteFileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteFile");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteFileCommand");
var se_DeletePullRequestApprovalRuleCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeletePullRequestApprovalRule");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeletePullRequestApprovalRuleCommand");
var se_DeleteRepositoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteRepository");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteRepositoryCommand");
var se_DescribeMergeConflictsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMergeConflicts");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMergeConflictsCommand");
var se_DescribePullRequestEventsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribePullRequestEvents");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribePullRequestEventsCommand");
var se_DisassociateApprovalRuleTemplateFromRepositoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DisassociateApprovalRuleTemplateFromRepository");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DisassociateApprovalRuleTemplateFromRepositoryCommand");
var se_EvaluatePullRequestApprovalRulesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("EvaluatePullRequestApprovalRules");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_EvaluatePullRequestApprovalRulesCommand");
var se_GetApprovalRuleTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetApprovalRuleTemplate");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetApprovalRuleTemplateCommand");
var se_GetBlobCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetBlob");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetBlobCommand");
var se_GetBranchCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetBranch");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetBranchCommand");
var se_GetCommentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetComment");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetCommentCommand");
var se_GetCommentReactionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetCommentReactions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetCommentReactionsCommand");
var se_GetCommentsForComparedCommitCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetCommentsForComparedCommit");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetCommentsForComparedCommitCommand");
var se_GetCommentsForPullRequestCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetCommentsForPullRequest");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetCommentsForPullRequestCommand");
var se_GetCommitCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetCommit");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetCommitCommand");
var se_GetDifferencesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetDifferences");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetDifferencesCommand");
var se_GetFileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetFile");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetFileCommand");
var se_GetFolderCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetFolder");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetFolderCommand");
var se_GetMergeCommitCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetMergeCommit");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetMergeCommitCommand");
var se_GetMergeConflictsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetMergeConflicts");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetMergeConflictsCommand");
var se_GetMergeOptionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetMergeOptions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetMergeOptionsCommand");
var se_GetPullRequestCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetPullRequest");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetPullRequestCommand");
var se_GetPullRequestApprovalStatesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetPullRequestApprovalStates");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetPullRequestApprovalStatesCommand");
var se_GetPullRequestOverrideStateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetPullRequestOverrideState");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetPullRequestOverrideStateCommand");
var se_GetRepositoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetRepository");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetRepositoryCommand");
var se_GetRepositoryTriggersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetRepositoryTriggers");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetRepositoryTriggersCommand");
var se_ListApprovalRuleTemplatesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListApprovalRuleTemplates");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListApprovalRuleTemplatesCommand");
var se_ListAssociatedApprovalRuleTemplatesForRepositoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListAssociatedApprovalRuleTemplatesForRepository");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListAssociatedApprovalRuleTemplatesForRepositoryCommand");
var se_ListBranchesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListBranches");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListBranchesCommand");
var se_ListFileCommitHistoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListFileCommitHistory");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListFileCommitHistoryCommand");
var se_ListPullRequestsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListPullRequests");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListPullRequestsCommand");
var se_ListRepositoriesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListRepositories");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListRepositoriesCommand");
var se_ListRepositoriesForApprovalRuleTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListRepositoriesForApprovalRuleTemplate");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListRepositoriesForApprovalRuleTemplateCommand");
var se_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListTagsForResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTagsForResourceCommand");
var se_MergeBranchesByFastForwardCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("MergeBranchesByFastForward");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_MergeBranchesByFastForwardCommand");
var se_MergeBranchesBySquashCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("MergeBranchesBySquash");
  let body;
  body = JSON.stringify(se_MergeBranchesBySquashInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_MergeBranchesBySquashCommand");
var se_MergeBranchesByThreeWayCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("MergeBranchesByThreeWay");
  let body;
  body = JSON.stringify(se_MergeBranchesByThreeWayInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_MergeBranchesByThreeWayCommand");
var se_MergePullRequestByFastForwardCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("MergePullRequestByFastForward");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_MergePullRequestByFastForwardCommand");
var se_MergePullRequestBySquashCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("MergePullRequestBySquash");
  let body;
  body = JSON.stringify(se_MergePullRequestBySquashInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_MergePullRequestBySquashCommand");
var se_MergePullRequestByThreeWayCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("MergePullRequestByThreeWay");
  let body;
  body = JSON.stringify(se_MergePullRequestByThreeWayInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_MergePullRequestByThreeWayCommand");
var se_OverridePullRequestApprovalRulesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("OverridePullRequestApprovalRules");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_OverridePullRequestApprovalRulesCommand");
var se_PostCommentForComparedCommitCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PostCommentForComparedCommit");
  let body;
  body = JSON.stringify(se_PostCommentForComparedCommitInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PostCommentForComparedCommitCommand");
var se_PostCommentForPullRequestCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PostCommentForPullRequest");
  let body;
  body = JSON.stringify(se_PostCommentForPullRequestInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PostCommentForPullRequestCommand");
var se_PostCommentReplyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PostCommentReply");
  let body;
  body = JSON.stringify(se_PostCommentReplyInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PostCommentReplyCommand");
var se_PutCommentReactionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutCommentReaction");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutCommentReactionCommand");
var se_PutFileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutFile");
  let body;
  body = JSON.stringify(se_PutFileInput(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutFileCommand");
var se_PutRepositoryTriggersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutRepositoryTriggers");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutRepositoryTriggersCommand");
var se_TagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("TagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TagResourceCommand");
var se_TestRepositoryTriggersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("TestRepositoryTriggers");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TestRepositoryTriggersCommand");
var se_UntagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UntagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UntagResourceCommand");
var se_UpdateApprovalRuleTemplateContentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateApprovalRuleTemplateContent");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateApprovalRuleTemplateContentCommand");
var se_UpdateApprovalRuleTemplateDescriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateApprovalRuleTemplateDescription");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateApprovalRuleTemplateDescriptionCommand");
var se_UpdateApprovalRuleTemplateNameCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateApprovalRuleTemplateName");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateApprovalRuleTemplateNameCommand");
var se_UpdateCommentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateComment");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateCommentCommand");
var se_UpdateDefaultBranchCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateDefaultBranch");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateDefaultBranchCommand");
var se_UpdatePullRequestApprovalRuleContentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdatePullRequestApprovalRuleContent");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdatePullRequestApprovalRuleContentCommand");
var se_UpdatePullRequestApprovalStateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdatePullRequestApprovalState");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdatePullRequestApprovalStateCommand");
var se_UpdatePullRequestDescriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdatePullRequestDescription");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdatePullRequestDescriptionCommand");
var se_UpdatePullRequestStatusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdatePullRequestStatus");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdatePullRequestStatusCommand");
var se_UpdatePullRequestTitleCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdatePullRequestTitle");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdatePullRequestTitleCommand");
var se_UpdateRepositoryDescriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateRepositoryDescription");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateRepositoryDescriptionCommand");
var se_UpdateRepositoryEncryptionKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateRepositoryEncryptionKey");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateRepositoryEncryptionKeyCommand");
var se_UpdateRepositoryNameCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateRepositoryName");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateRepositoryNameCommand");
var de_AssociateApprovalRuleTemplateWithRepositoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_AssociateApprovalRuleTemplateWithRepositoryCommand");
var de_BatchAssociateApprovalRuleTemplateWithRepositoriesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchAssociateApprovalRuleTemplateWithRepositoriesCommand");
var de_BatchDescribeMergeConflictsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchDescribeMergeConflictsCommand");
var de_BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand");
var de_BatchGetCommitsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchGetCommitsCommand");
var de_BatchGetRepositoriesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_BatchGetRepositoriesOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchGetRepositoriesCommand");
var de_CreateApprovalRuleTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateApprovalRuleTemplateOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateApprovalRuleTemplateCommand");
var de_CreateBranchCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_CreateBranchCommand");
var de_CreateCommitCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateCommitCommand");
var de_CreatePullRequestCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreatePullRequestOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreatePullRequestCommand");
var de_CreatePullRequestApprovalRuleCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreatePullRequestApprovalRuleOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreatePullRequestApprovalRuleCommand");
var de_CreateRepositoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateRepositoryOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateRepositoryCommand");
var de_CreateUnreferencedMergeCommitCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateUnreferencedMergeCommitCommand");
var de_DeleteApprovalRuleTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteApprovalRuleTemplateCommand");
var de_DeleteBranchCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteBranchCommand");
var de_DeleteCommentContentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DeleteCommentContentOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteCommentContentCommand");
var de_DeleteFileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteFileCommand");
var de_DeletePullRequestApprovalRuleCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeletePullRequestApprovalRuleCommand");
var de_DeleteRepositoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteRepositoryCommand");
var de_DescribeMergeConflictsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMergeConflictsCommand");
var de_DescribePullRequestEventsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribePullRequestEventsOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribePullRequestEventsCommand");
var de_DisassociateApprovalRuleTemplateFromRepositoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DisassociateApprovalRuleTemplateFromRepositoryCommand");
var de_EvaluatePullRequestApprovalRulesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_EvaluatePullRequestApprovalRulesCommand");
var de_GetApprovalRuleTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetApprovalRuleTemplateOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetApprovalRuleTemplateCommand");
var de_GetBlobCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetBlobOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetBlobCommand");
var de_GetBranchCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetBranchCommand");
var de_GetCommentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetCommentOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetCommentCommand");
var de_GetCommentReactionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetCommentReactionsCommand");
var de_GetCommentsForComparedCommitCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetCommentsForComparedCommitOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetCommentsForComparedCommitCommand");
var de_GetCommentsForPullRequestCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetCommentsForPullRequestOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetCommentsForPullRequestCommand");
var de_GetCommitCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetCommitCommand");
var de_GetDifferencesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetDifferencesCommand");
var de_GetFileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetFileOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetFileCommand");
var de_GetFolderCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetFolderCommand");
var de_GetMergeCommitCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetMergeCommitCommand");
var de_GetMergeConflictsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetMergeConflictsCommand");
var de_GetMergeOptionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetMergeOptionsCommand");
var de_GetPullRequestCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetPullRequestOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetPullRequestCommand");
var de_GetPullRequestApprovalStatesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetPullRequestApprovalStatesCommand");
var de_GetPullRequestOverrideStateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetPullRequestOverrideStateCommand");
var de_GetRepositoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetRepositoryOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetRepositoryCommand");
var de_GetRepositoryTriggersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetRepositoryTriggersCommand");
var de_ListApprovalRuleTemplatesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListApprovalRuleTemplatesCommand");
var de_ListAssociatedApprovalRuleTemplatesForRepositoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListAssociatedApprovalRuleTemplatesForRepositoryCommand");
var de_ListBranchesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListBranchesCommand");
var de_ListFileCommitHistoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListFileCommitHistoryCommand");
var de_ListPullRequestsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListPullRequestsCommand");
var de_ListRepositoriesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListRepositoriesCommand");
var de_ListRepositoriesForApprovalRuleTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListRepositoriesForApprovalRuleTemplateCommand");
var de_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTagsForResourceCommand");
var de_MergeBranchesByFastForwardCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_MergeBranchesByFastForwardCommand");
var de_MergeBranchesBySquashCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_MergeBranchesBySquashCommand");
var de_MergeBranchesByThreeWayCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_MergeBranchesByThreeWayCommand");
var de_MergePullRequestByFastForwardCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_MergePullRequestByFastForwardOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_MergePullRequestByFastForwardCommand");
var de_MergePullRequestBySquashCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_MergePullRequestBySquashOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_MergePullRequestBySquashCommand");
var de_MergePullRequestByThreeWayCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_MergePullRequestByThreeWayOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_MergePullRequestByThreeWayCommand");
var de_OverridePullRequestApprovalRulesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_OverridePullRequestApprovalRulesCommand");
var de_PostCommentForComparedCommitCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_PostCommentForComparedCommitOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PostCommentForComparedCommitCommand");
var de_PostCommentForPullRequestCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_PostCommentForPullRequestOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PostCommentForPullRequestCommand");
var de_PostCommentReplyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_PostCommentReplyOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PostCommentReplyCommand");
var de_PutCommentReactionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_PutCommentReactionCommand");
var de_PutFileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutFileCommand");
var de_PutRepositoryTriggersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutRepositoryTriggersCommand");
var de_TagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_TagResourceCommand");
var de_TestRepositoryTriggersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_TestRepositoryTriggersCommand");
var de_UntagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UntagResourceCommand");
var de_UpdateApprovalRuleTemplateContentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateApprovalRuleTemplateContentOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateApprovalRuleTemplateContentCommand");
var de_UpdateApprovalRuleTemplateDescriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateApprovalRuleTemplateDescriptionOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateApprovalRuleTemplateDescriptionCommand");
var de_UpdateApprovalRuleTemplateNameCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateApprovalRuleTemplateNameOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateApprovalRuleTemplateNameCommand");
var de_UpdateCommentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateCommentOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateCommentCommand");
var de_UpdateDefaultBranchCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateDefaultBranchCommand");
var de_UpdatePullRequestApprovalRuleContentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdatePullRequestApprovalRuleContentOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdatePullRequestApprovalRuleContentCommand");
var de_UpdatePullRequestApprovalStateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdatePullRequestApprovalStateCommand");
var de_UpdatePullRequestDescriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdatePullRequestDescriptionOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdatePullRequestDescriptionCommand");
var de_UpdatePullRequestStatusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdatePullRequestStatusOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdatePullRequestStatusCommand");
var de_UpdatePullRequestTitleCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdatePullRequestTitleOutput(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdatePullRequestTitleCommand");
var de_UpdateRepositoryDescriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateRepositoryDescriptionCommand");
var de_UpdateRepositoryEncryptionKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateRepositoryEncryptionKeyCommand");
var de_UpdateRepositoryNameCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateRepositoryNameCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseJsonErrorBody)(output.body, context)
  };
  const errorCode = (0, import_core2.loadRestJsonErrorCode)(output, parsedOutput.body);
  switch (errorCode) {
    case "ApprovalRuleTemplateDoesNotExistException":
    case "com.amazonaws.codecommit#ApprovalRuleTemplateDoesNotExistException":
      throw await de_ApprovalRuleTemplateDoesNotExistExceptionRes(parsedOutput, context);
    case "ApprovalRuleTemplateNameRequiredException":
    case "com.amazonaws.codecommit#ApprovalRuleTemplateNameRequiredException":
      throw await de_ApprovalRuleTemplateNameRequiredExceptionRes(parsedOutput, context);
    case "EncryptionIntegrityChecksFailedException":
    case "com.amazonaws.codecommit#EncryptionIntegrityChecksFailedException":
      throw await de_EncryptionIntegrityChecksFailedExceptionRes(parsedOutput, context);
    case "EncryptionKeyAccessDeniedException":
    case "com.amazonaws.codecommit#EncryptionKeyAccessDeniedException":
      throw await de_EncryptionKeyAccessDeniedExceptionRes(parsedOutput, context);
    case "EncryptionKeyDisabledException":
    case "com.amazonaws.codecommit#EncryptionKeyDisabledException":
      throw await de_EncryptionKeyDisabledExceptionRes(parsedOutput, context);
    case "EncryptionKeyNotFoundException":
    case "com.amazonaws.codecommit#EncryptionKeyNotFoundException":
      throw await de_EncryptionKeyNotFoundExceptionRes(parsedOutput, context);
    case "EncryptionKeyUnavailableException":
    case "com.amazonaws.codecommit#EncryptionKeyUnavailableException":
      throw await de_EncryptionKeyUnavailableExceptionRes(parsedOutput, context);
    case "InvalidApprovalRuleTemplateNameException":
    case "com.amazonaws.codecommit#InvalidApprovalRuleTemplateNameException":
      throw await de_InvalidApprovalRuleTemplateNameExceptionRes(parsedOutput, context);
    case "InvalidRepositoryNameException":
    case "com.amazonaws.codecommit#InvalidRepositoryNameException":
      throw await de_InvalidRepositoryNameExceptionRes(parsedOutput, context);
    case "MaximumRuleTemplatesAssociatedWithRepositoryException":
    case "com.amazonaws.codecommit#MaximumRuleTemplatesAssociatedWithRepositoryException":
      throw await de_MaximumRuleTemplatesAssociatedWithRepositoryExceptionRes(parsedOutput, context);
    case "RepositoryDoesNotExistException":
    case "com.amazonaws.codecommit#RepositoryDoesNotExistException":
      throw await de_RepositoryDoesNotExistExceptionRes(parsedOutput, context);
    case "RepositoryNameRequiredException":
    case "com.amazonaws.codecommit#RepositoryNameRequiredException":
      throw await de_RepositoryNameRequiredExceptionRes(parsedOutput, context);
    case "MaximumRepositoryNamesExceededException":
    case "com.amazonaws.codecommit#MaximumRepositoryNamesExceededException":
      throw await de_MaximumRepositoryNamesExceededExceptionRes(parsedOutput, context);
    case "RepositoryNamesRequiredException":
    case "com.amazonaws.codecommit#RepositoryNamesRequiredException":
      throw await de_RepositoryNamesRequiredExceptionRes(parsedOutput, context);
    case "CommitDoesNotExistException":
    case "com.amazonaws.codecommit#CommitDoesNotExistException":
      throw await de_CommitDoesNotExistExceptionRes(parsedOutput, context);
    case "CommitRequiredException":
    case "com.amazonaws.codecommit#CommitRequiredException":
      throw await de_CommitRequiredExceptionRes(parsedOutput, context);
    case "InvalidCommitException":
    case "com.amazonaws.codecommit#InvalidCommitException":
      throw await de_InvalidCommitExceptionRes(parsedOutput, context);
    case "InvalidConflictDetailLevelException":
    case "com.amazonaws.codecommit#InvalidConflictDetailLevelException":
      throw await de_InvalidConflictDetailLevelExceptionRes(parsedOutput, context);
    case "InvalidConflictResolutionStrategyException":
    case "com.amazonaws.codecommit#InvalidConflictResolutionStrategyException":
      throw await de_InvalidConflictResolutionStrategyExceptionRes(parsedOutput, context);
    case "InvalidContinuationTokenException":
    case "com.amazonaws.codecommit#InvalidContinuationTokenException":
      throw await de_InvalidContinuationTokenExceptionRes(parsedOutput, context);
    case "InvalidMaxConflictFilesException":
    case "com.amazonaws.codecommit#InvalidMaxConflictFilesException":
      throw await de_InvalidMaxConflictFilesExceptionRes(parsedOutput, context);
    case "InvalidMaxMergeHunksException":
    case "com.amazonaws.codecommit#InvalidMaxMergeHunksException":
      throw await de_InvalidMaxMergeHunksExceptionRes(parsedOutput, context);
    case "InvalidMergeOptionException":
    case "com.amazonaws.codecommit#InvalidMergeOptionException":
      throw await de_InvalidMergeOptionExceptionRes(parsedOutput, context);
    case "MaximumFileContentToLoadExceededException":
    case "com.amazonaws.codecommit#MaximumFileContentToLoadExceededException":
      throw await de_MaximumFileContentToLoadExceededExceptionRes(parsedOutput, context);
    case "MaximumItemsToCompareExceededException":
    case "com.amazonaws.codecommit#MaximumItemsToCompareExceededException":
      throw await de_MaximumItemsToCompareExceededExceptionRes(parsedOutput, context);
    case "MergeOptionRequiredException":
    case "com.amazonaws.codecommit#MergeOptionRequiredException":
      throw await de_MergeOptionRequiredExceptionRes(parsedOutput, context);
    case "TipsDivergenceExceededException":
    case "com.amazonaws.codecommit#TipsDivergenceExceededException":
      throw await de_TipsDivergenceExceededExceptionRes(parsedOutput, context);
    case "CommitIdsLimitExceededException":
    case "com.amazonaws.codecommit#CommitIdsLimitExceededException":
      throw await de_CommitIdsLimitExceededExceptionRes(parsedOutput, context);
    case "CommitIdsListRequiredException":
    case "com.amazonaws.codecommit#CommitIdsListRequiredException":
      throw await de_CommitIdsListRequiredExceptionRes(parsedOutput, context);
    case "ApprovalRuleTemplateContentRequiredException":
    case "com.amazonaws.codecommit#ApprovalRuleTemplateContentRequiredException":
      throw await de_ApprovalRuleTemplateContentRequiredExceptionRes(parsedOutput, context);
    case "ApprovalRuleTemplateNameAlreadyExistsException":
    case "com.amazonaws.codecommit#ApprovalRuleTemplateNameAlreadyExistsException":
      throw await de_ApprovalRuleTemplateNameAlreadyExistsExceptionRes(parsedOutput, context);
    case "InvalidApprovalRuleTemplateContentException":
    case "com.amazonaws.codecommit#InvalidApprovalRuleTemplateContentException":
      throw await de_InvalidApprovalRuleTemplateContentExceptionRes(parsedOutput, context);
    case "InvalidApprovalRuleTemplateDescriptionException":
    case "com.amazonaws.codecommit#InvalidApprovalRuleTemplateDescriptionException":
      throw await de_InvalidApprovalRuleTemplateDescriptionExceptionRes(parsedOutput, context);
    case "NumberOfRuleTemplatesExceededException":
    case "com.amazonaws.codecommit#NumberOfRuleTemplatesExceededException":
      throw await de_NumberOfRuleTemplatesExceededExceptionRes(parsedOutput, context);
    case "BranchNameExistsException":
    case "com.amazonaws.codecommit#BranchNameExistsException":
      throw await de_BranchNameExistsExceptionRes(parsedOutput, context);
    case "BranchNameRequiredException":
    case "com.amazonaws.codecommit#BranchNameRequiredException":
      throw await de_BranchNameRequiredExceptionRes(parsedOutput, context);
    case "CommitIdRequiredException":
    case "com.amazonaws.codecommit#CommitIdRequiredException":
      throw await de_CommitIdRequiredExceptionRes(parsedOutput, context);
    case "InvalidBranchNameException":
    case "com.amazonaws.codecommit#InvalidBranchNameException":
      throw await de_InvalidBranchNameExceptionRes(parsedOutput, context);
    case "InvalidCommitIdException":
    case "com.amazonaws.codecommit#InvalidCommitIdException":
      throw await de_InvalidCommitIdExceptionRes(parsedOutput, context);
    case "BranchDoesNotExistException":
    case "com.amazonaws.codecommit#BranchDoesNotExistException":
      throw await de_BranchDoesNotExistExceptionRes(parsedOutput, context);
    case "BranchNameIsTagNameException":
    case "com.amazonaws.codecommit#BranchNameIsTagNameException":
      throw await de_BranchNameIsTagNameExceptionRes(parsedOutput, context);
    case "CommitMessageLengthExceededException":
    case "com.amazonaws.codecommit#CommitMessageLengthExceededException":
      throw await de_CommitMessageLengthExceededExceptionRes(parsedOutput, context);
    case "DirectoryNameConflictsWithFileNameException":
    case "com.amazonaws.codecommit#DirectoryNameConflictsWithFileNameException":
      throw await de_DirectoryNameConflictsWithFileNameExceptionRes(parsedOutput, context);
    case "FileContentAndSourceFileSpecifiedException":
    case "com.amazonaws.codecommit#FileContentAndSourceFileSpecifiedException":
      throw await de_FileContentAndSourceFileSpecifiedExceptionRes(parsedOutput, context);
    case "FileContentSizeLimitExceededException":
    case "com.amazonaws.codecommit#FileContentSizeLimitExceededException":
      throw await de_FileContentSizeLimitExceededExceptionRes(parsedOutput, context);
    case "FileDoesNotExistException":
    case "com.amazonaws.codecommit#FileDoesNotExistException":
      throw await de_FileDoesNotExistExceptionRes(parsedOutput, context);
    case "FileEntryRequiredException":
    case "com.amazonaws.codecommit#FileEntryRequiredException":
      throw await de_FileEntryRequiredExceptionRes(parsedOutput, context);
    case "FileModeRequiredException":
    case "com.amazonaws.codecommit#FileModeRequiredException":
      throw await de_FileModeRequiredExceptionRes(parsedOutput, context);
    case "FileNameConflictsWithDirectoryNameException":
    case "com.amazonaws.codecommit#FileNameConflictsWithDirectoryNameException":
      throw await de_FileNameConflictsWithDirectoryNameExceptionRes(parsedOutput, context);
    case "FilePathConflictsWithSubmodulePathException":
    case "com.amazonaws.codecommit#FilePathConflictsWithSubmodulePathException":
      throw await de_FilePathConflictsWithSubmodulePathExceptionRes(parsedOutput, context);
    case "FolderContentSizeLimitExceededException":
    case "com.amazonaws.codecommit#FolderContentSizeLimitExceededException":
      throw await de_FolderContentSizeLimitExceededExceptionRes(parsedOutput, context);
    case "InvalidDeletionParameterException":
    case "com.amazonaws.codecommit#InvalidDeletionParameterException":
      throw await de_InvalidDeletionParameterExceptionRes(parsedOutput, context);
    case "InvalidEmailException":
    case "com.amazonaws.codecommit#InvalidEmailException":
      throw await de_InvalidEmailExceptionRes(parsedOutput, context);
    case "InvalidFileModeException":
    case "com.amazonaws.codecommit#InvalidFileModeException":
      throw await de_InvalidFileModeExceptionRes(parsedOutput, context);
    case "InvalidParentCommitIdException":
    case "com.amazonaws.codecommit#InvalidParentCommitIdException":
      throw await de_InvalidParentCommitIdExceptionRes(parsedOutput, context);
    case "InvalidPathException":
    case "com.amazonaws.codecommit#InvalidPathException":
      throw await de_InvalidPathExceptionRes(parsedOutput, context);
    case "MaximumFileEntriesExceededException":
    case "com.amazonaws.codecommit#MaximumFileEntriesExceededException":
      throw await de_MaximumFileEntriesExceededExceptionRes(parsedOutput, context);
    case "NameLengthExceededException":
    case "com.amazonaws.codecommit#NameLengthExceededException":
      throw await de_NameLengthExceededExceptionRes(parsedOutput, context);
    case "NoChangeException":
    case "com.amazonaws.codecommit#NoChangeException":
      throw await de_NoChangeExceptionRes(parsedOutput, context);
    case "ParentCommitDoesNotExistException":
    case "com.amazonaws.codecommit#ParentCommitDoesNotExistException":
      throw await de_ParentCommitDoesNotExistExceptionRes(parsedOutput, context);
    case "ParentCommitIdOutdatedException":
    case "com.amazonaws.codecommit#ParentCommitIdOutdatedException":
      throw await de_ParentCommitIdOutdatedExceptionRes(parsedOutput, context);
    case "ParentCommitIdRequiredException":
    case "com.amazonaws.codecommit#ParentCommitIdRequiredException":
      throw await de_ParentCommitIdRequiredExceptionRes(parsedOutput, context);
    case "PathRequiredException":
    case "com.amazonaws.codecommit#PathRequiredException":
      throw await de_PathRequiredExceptionRes(parsedOutput, context);
    case "PutFileEntryConflictException":
    case "com.amazonaws.codecommit#PutFileEntryConflictException":
      throw await de_PutFileEntryConflictExceptionRes(parsedOutput, context);
    case "RestrictedSourceFileException":
    case "com.amazonaws.codecommit#RestrictedSourceFileException":
      throw await de_RestrictedSourceFileExceptionRes(parsedOutput, context);
    case "SamePathRequestException":
    case "com.amazonaws.codecommit#SamePathRequestException":
      throw await de_SamePathRequestExceptionRes(parsedOutput, context);
    case "SourceFileOrContentRequiredException":
    case "com.amazonaws.codecommit#SourceFileOrContentRequiredException":
      throw await de_SourceFileOrContentRequiredExceptionRes(parsedOutput, context);
    case "ClientRequestTokenRequiredException":
    case "com.amazonaws.codecommit#ClientRequestTokenRequiredException":
      throw await de_ClientRequestTokenRequiredExceptionRes(parsedOutput, context);
    case "IdempotencyParameterMismatchException":
    case "com.amazonaws.codecommit#IdempotencyParameterMismatchException":
      throw await de_IdempotencyParameterMismatchExceptionRes(parsedOutput, context);
    case "InvalidClientRequestTokenException":
    case "com.amazonaws.codecommit#InvalidClientRequestTokenException":
      throw await de_InvalidClientRequestTokenExceptionRes(parsedOutput, context);
    case "InvalidDescriptionException":
    case "com.amazonaws.codecommit#InvalidDescriptionException":
      throw await de_InvalidDescriptionExceptionRes(parsedOutput, context);
    case "InvalidReferenceNameException":
    case "com.amazonaws.codecommit#InvalidReferenceNameException":
      throw await de_InvalidReferenceNameExceptionRes(parsedOutput, context);
    case "InvalidTargetException":
    case "com.amazonaws.codecommit#InvalidTargetException":
      throw await de_InvalidTargetExceptionRes(parsedOutput, context);
    case "InvalidTargetsException":
    case "com.amazonaws.codecommit#InvalidTargetsException":
      throw await de_InvalidTargetsExceptionRes(parsedOutput, context);
    case "InvalidTitleException":
    case "com.amazonaws.codecommit#InvalidTitleException":
      throw await de_InvalidTitleExceptionRes(parsedOutput, context);
    case "MaximumOpenPullRequestsExceededException":
    case "com.amazonaws.codecommit#MaximumOpenPullRequestsExceededException":
      throw await de_MaximumOpenPullRequestsExceededExceptionRes(parsedOutput, context);
    case "MultipleRepositoriesInPullRequestException":
    case "com.amazonaws.codecommit#MultipleRepositoriesInPullRequestException":
      throw await de_MultipleRepositoriesInPullRequestExceptionRes(parsedOutput, context);
    case "ReferenceDoesNotExistException":
    case "com.amazonaws.codecommit#ReferenceDoesNotExistException":
      throw await de_ReferenceDoesNotExistExceptionRes(parsedOutput, context);
    case "ReferenceNameRequiredException":
    case "com.amazonaws.codecommit#ReferenceNameRequiredException":
      throw await de_ReferenceNameRequiredExceptionRes(parsedOutput, context);
    case "ReferenceTypeNotSupportedException":
    case "com.amazonaws.codecommit#ReferenceTypeNotSupportedException":
      throw await de_ReferenceTypeNotSupportedExceptionRes(parsedOutput, context);
    case "SourceAndDestinationAreSameException":
    case "com.amazonaws.codecommit#SourceAndDestinationAreSameException":
      throw await de_SourceAndDestinationAreSameExceptionRes(parsedOutput, context);
    case "TargetRequiredException":
    case "com.amazonaws.codecommit#TargetRequiredException":
      throw await de_TargetRequiredExceptionRes(parsedOutput, context);
    case "TargetsRequiredException":
    case "com.amazonaws.codecommit#TargetsRequiredException":
      throw await de_TargetsRequiredExceptionRes(parsedOutput, context);
    case "TitleRequiredException":
    case "com.amazonaws.codecommit#TitleRequiredException":
      throw await de_TitleRequiredExceptionRes(parsedOutput, context);
    case "ApprovalRuleContentRequiredException":
    case "com.amazonaws.codecommit#ApprovalRuleContentRequiredException":
      throw await de_ApprovalRuleContentRequiredExceptionRes(parsedOutput, context);
    case "ApprovalRuleNameAlreadyExistsException":
    case "com.amazonaws.codecommit#ApprovalRuleNameAlreadyExistsException":
      throw await de_ApprovalRuleNameAlreadyExistsExceptionRes(parsedOutput, context);
    case "ApprovalRuleNameRequiredException":
    case "com.amazonaws.codecommit#ApprovalRuleNameRequiredException":
      throw await de_ApprovalRuleNameRequiredExceptionRes(parsedOutput, context);
    case "InvalidApprovalRuleContentException":
    case "com.amazonaws.codecommit#InvalidApprovalRuleContentException":
      throw await de_InvalidApprovalRuleContentExceptionRes(parsedOutput, context);
    case "InvalidApprovalRuleNameException":
    case "com.amazonaws.codecommit#InvalidApprovalRuleNameException":
      throw await de_InvalidApprovalRuleNameExceptionRes(parsedOutput, context);
    case "InvalidPullRequestIdException":
    case "com.amazonaws.codecommit#InvalidPullRequestIdException":
      throw await de_InvalidPullRequestIdExceptionRes(parsedOutput, context);
    case "NumberOfRulesExceededException":
    case "com.amazonaws.codecommit#NumberOfRulesExceededException":
      throw await de_NumberOfRulesExceededExceptionRes(parsedOutput, context);
    case "PullRequestAlreadyClosedException":
    case "com.amazonaws.codecommit#PullRequestAlreadyClosedException":
      throw await de_PullRequestAlreadyClosedExceptionRes(parsedOutput, context);
    case "PullRequestDoesNotExistException":
    case "com.amazonaws.codecommit#PullRequestDoesNotExistException":
      throw await de_PullRequestDoesNotExistExceptionRes(parsedOutput, context);
    case "PullRequestIdRequiredException":
    case "com.amazonaws.codecommit#PullRequestIdRequiredException":
      throw await de_PullRequestIdRequiredExceptionRes(parsedOutput, context);
    case "EncryptionKeyInvalidIdException":
    case "com.amazonaws.codecommit#EncryptionKeyInvalidIdException":
      throw await de_EncryptionKeyInvalidIdExceptionRes(parsedOutput, context);
    case "EncryptionKeyInvalidUsageException":
    case "com.amazonaws.codecommit#EncryptionKeyInvalidUsageException":
      throw await de_EncryptionKeyInvalidUsageExceptionRes(parsedOutput, context);
    case "InvalidRepositoryDescriptionException":
    case "com.amazonaws.codecommit#InvalidRepositoryDescriptionException":
      throw await de_InvalidRepositoryDescriptionExceptionRes(parsedOutput, context);
    case "InvalidSystemTagUsageException":
    case "com.amazonaws.codecommit#InvalidSystemTagUsageException":
      throw await de_InvalidSystemTagUsageExceptionRes(parsedOutput, context);
    case "InvalidTagsMapException":
    case "com.amazonaws.codecommit#InvalidTagsMapException":
      throw await de_InvalidTagsMapExceptionRes(parsedOutput, context);
    case "OperationNotAllowedException":
    case "com.amazonaws.codecommit#OperationNotAllowedException":
      throw await de_OperationNotAllowedExceptionRes(parsedOutput, context);
    case "RepositoryLimitExceededException":
    case "com.amazonaws.codecommit#RepositoryLimitExceededException":
      throw await de_RepositoryLimitExceededExceptionRes(parsedOutput, context);
    case "RepositoryNameExistsException":
    case "com.amazonaws.codecommit#RepositoryNameExistsException":
      throw await de_RepositoryNameExistsExceptionRes(parsedOutput, context);
    case "TagPolicyException":
    case "com.amazonaws.codecommit#TagPolicyException":
      throw await de_TagPolicyExceptionRes(parsedOutput, context);
    case "TooManyTagsException":
    case "com.amazonaws.codecommit#TooManyTagsException":
      throw await de_TooManyTagsExceptionRes(parsedOutput, context);
    case "ConcurrentReferenceUpdateException":
    case "com.amazonaws.codecommit#ConcurrentReferenceUpdateException":
      throw await de_ConcurrentReferenceUpdateExceptionRes(parsedOutput, context);
    case "InvalidConflictResolutionException":
    case "com.amazonaws.codecommit#InvalidConflictResolutionException":
      throw await de_InvalidConflictResolutionExceptionRes(parsedOutput, context);
    case "InvalidReplacementContentException":
    case "com.amazonaws.codecommit#InvalidReplacementContentException":
      throw await de_InvalidReplacementContentExceptionRes(parsedOutput, context);
    case "InvalidReplacementTypeException":
    case "com.amazonaws.codecommit#InvalidReplacementTypeException":
      throw await de_InvalidReplacementTypeExceptionRes(parsedOutput, context);
    case "ManualMergeRequiredException":
    case "com.amazonaws.codecommit#ManualMergeRequiredException":
      throw await de_ManualMergeRequiredExceptionRes(parsedOutput, context);
    case "MaximumConflictResolutionEntriesExceededException":
    case "com.amazonaws.codecommit#MaximumConflictResolutionEntriesExceededException":
      throw await de_MaximumConflictResolutionEntriesExceededExceptionRes(parsedOutput, context);
    case "MultipleConflictResolutionEntriesException":
    case "com.amazonaws.codecommit#MultipleConflictResolutionEntriesException":
      throw await de_MultipleConflictResolutionEntriesExceptionRes(parsedOutput, context);
    case "ReplacementContentRequiredException":
    case "com.amazonaws.codecommit#ReplacementContentRequiredException":
      throw await de_ReplacementContentRequiredExceptionRes(parsedOutput, context);
    case "ReplacementTypeRequiredException":
    case "com.amazonaws.codecommit#ReplacementTypeRequiredException":
      throw await de_ReplacementTypeRequiredExceptionRes(parsedOutput, context);
    case "ApprovalRuleTemplateInUseException":
    case "com.amazonaws.codecommit#ApprovalRuleTemplateInUseException":
      throw await de_ApprovalRuleTemplateInUseExceptionRes(parsedOutput, context);
    case "DefaultBranchCannotBeDeletedException":
    case "com.amazonaws.codecommit#DefaultBranchCannotBeDeletedException":
      throw await de_DefaultBranchCannotBeDeletedExceptionRes(parsedOutput, context);
    case "CommentDeletedException":
    case "com.amazonaws.codecommit#CommentDeletedException":
      throw await de_CommentDeletedExceptionRes(parsedOutput, context);
    case "CommentDoesNotExistException":
    case "com.amazonaws.codecommit#CommentDoesNotExistException":
      throw await de_CommentDoesNotExistExceptionRes(parsedOutput, context);
    case "CommentIdRequiredException":
    case "com.amazonaws.codecommit#CommentIdRequiredException":
      throw await de_CommentIdRequiredExceptionRes(parsedOutput, context);
    case "InvalidCommentIdException":
    case "com.amazonaws.codecommit#InvalidCommentIdException":
      throw await de_InvalidCommentIdExceptionRes(parsedOutput, context);
    case "CannotDeleteApprovalRuleFromTemplateException":
    case "com.amazonaws.codecommit#CannotDeleteApprovalRuleFromTemplateException":
      throw await de_CannotDeleteApprovalRuleFromTemplateExceptionRes(parsedOutput, context);
    case "ActorDoesNotExistException":
    case "com.amazonaws.codecommit#ActorDoesNotExistException":
      throw await de_ActorDoesNotExistExceptionRes(parsedOutput, context);
    case "InvalidActorArnException":
    case "com.amazonaws.codecommit#InvalidActorArnException":
      throw await de_InvalidActorArnExceptionRes(parsedOutput, context);
    case "InvalidMaxResultsException":
    case "com.amazonaws.codecommit#InvalidMaxResultsException":
      throw await de_InvalidMaxResultsExceptionRes(parsedOutput, context);
    case "InvalidPullRequestEventTypeException":
    case "com.amazonaws.codecommit#InvalidPullRequestEventTypeException":
      throw await de_InvalidPullRequestEventTypeExceptionRes(parsedOutput, context);
    case "InvalidRevisionIdException":
    case "com.amazonaws.codecommit#InvalidRevisionIdException":
      throw await de_InvalidRevisionIdExceptionRes(parsedOutput, context);
    case "RevisionIdRequiredException":
    case "com.amazonaws.codecommit#RevisionIdRequiredException":
      throw await de_RevisionIdRequiredExceptionRes(parsedOutput, context);
    case "RevisionNotCurrentException":
    case "com.amazonaws.codecommit#RevisionNotCurrentException":
      throw await de_RevisionNotCurrentExceptionRes(parsedOutput, context);
    case "BlobIdDoesNotExistException":
    case "com.amazonaws.codecommit#BlobIdDoesNotExistException":
      throw await de_BlobIdDoesNotExistExceptionRes(parsedOutput, context);
    case "BlobIdRequiredException":
    case "com.amazonaws.codecommit#BlobIdRequiredException":
      throw await de_BlobIdRequiredExceptionRes(parsedOutput, context);
    case "FileTooLargeException":
    case "com.amazonaws.codecommit#FileTooLargeException":
      throw await de_FileTooLargeExceptionRes(parsedOutput, context);
    case "InvalidBlobIdException":
    case "com.amazonaws.codecommit#InvalidBlobIdException":
      throw await de_InvalidBlobIdExceptionRes(parsedOutput, context);
    case "InvalidReactionUserArnException":
    case "com.amazonaws.codecommit#InvalidReactionUserArnException":
      throw await de_InvalidReactionUserArnExceptionRes(parsedOutput, context);
    case "RepositoryNotAssociatedWithPullRequestException":
    case "com.amazonaws.codecommit#RepositoryNotAssociatedWithPullRequestException":
      throw await de_RepositoryNotAssociatedWithPullRequestExceptionRes(parsedOutput, context);
    case "CommitIdDoesNotExistException":
    case "com.amazonaws.codecommit#CommitIdDoesNotExistException":
      throw await de_CommitIdDoesNotExistExceptionRes(parsedOutput, context);
    case "PathDoesNotExistException":
    case "com.amazonaws.codecommit#PathDoesNotExistException":
      throw await de_PathDoesNotExistExceptionRes(parsedOutput, context);
    case "FolderDoesNotExistException":
    case "com.amazonaws.codecommit#FolderDoesNotExistException":
      throw await de_FolderDoesNotExistExceptionRes(parsedOutput, context);
    case "InvalidDestinationCommitSpecifierException":
    case "com.amazonaws.codecommit#InvalidDestinationCommitSpecifierException":
      throw await de_InvalidDestinationCommitSpecifierExceptionRes(parsedOutput, context);
    case "InvalidSourceCommitSpecifierException":
    case "com.amazonaws.codecommit#InvalidSourceCommitSpecifierException":
      throw await de_InvalidSourceCommitSpecifierExceptionRes(parsedOutput, context);
    case "AuthorDoesNotExistException":
    case "com.amazonaws.codecommit#AuthorDoesNotExistException":
      throw await de_AuthorDoesNotExistExceptionRes(parsedOutput, context);
    case "InvalidAuthorArnException":
    case "com.amazonaws.codecommit#InvalidAuthorArnException":
      throw await de_InvalidAuthorArnExceptionRes(parsedOutput, context);
    case "InvalidPullRequestStatusException":
    case "com.amazonaws.codecommit#InvalidPullRequestStatusException":
      throw await de_InvalidPullRequestStatusExceptionRes(parsedOutput, context);
    case "InvalidOrderException":
    case "com.amazonaws.codecommit#InvalidOrderException":
      throw await de_InvalidOrderExceptionRes(parsedOutput, context);
    case "InvalidSortByException":
    case "com.amazonaws.codecommit#InvalidSortByException":
      throw await de_InvalidSortByExceptionRes(parsedOutput, context);
    case "InvalidResourceArnException":
    case "com.amazonaws.codecommit#InvalidResourceArnException":
      throw await de_InvalidResourceArnExceptionRes(parsedOutput, context);
    case "ResourceArnRequiredException":
    case "com.amazonaws.codecommit#ResourceArnRequiredException":
      throw await de_ResourceArnRequiredExceptionRes(parsedOutput, context);
    case "InvalidTargetBranchException":
    case "com.amazonaws.codecommit#InvalidTargetBranchException":
      throw await de_InvalidTargetBranchExceptionRes(parsedOutput, context);
    case "PullRequestApprovalRulesNotSatisfiedException":
    case "com.amazonaws.codecommit#PullRequestApprovalRulesNotSatisfiedException":
      throw await de_PullRequestApprovalRulesNotSatisfiedExceptionRes(parsedOutput, context);
    case "TipOfSourceReferenceIsDifferentException":
    case "com.amazonaws.codecommit#TipOfSourceReferenceIsDifferentException":
      throw await de_TipOfSourceReferenceIsDifferentExceptionRes(parsedOutput, context);
    case "InvalidOverrideStatusException":
    case "com.amazonaws.codecommit#InvalidOverrideStatusException":
      throw await de_InvalidOverrideStatusExceptionRes(parsedOutput, context);
    case "OverrideAlreadySetException":
    case "com.amazonaws.codecommit#OverrideAlreadySetException":
      throw await de_OverrideAlreadySetExceptionRes(parsedOutput, context);
    case "OverrideStatusRequiredException":
    case "com.amazonaws.codecommit#OverrideStatusRequiredException":
      throw await de_OverrideStatusRequiredExceptionRes(parsedOutput, context);
    case "BeforeCommitIdAndAfterCommitIdAreSameException":
    case "com.amazonaws.codecommit#BeforeCommitIdAndAfterCommitIdAreSameException":
      throw await de_BeforeCommitIdAndAfterCommitIdAreSameExceptionRes(parsedOutput, context);
    case "CommentContentRequiredException":
    case "com.amazonaws.codecommit#CommentContentRequiredException":
      throw await de_CommentContentRequiredExceptionRes(parsedOutput, context);
    case "CommentContentSizeLimitExceededException":
    case "com.amazonaws.codecommit#CommentContentSizeLimitExceededException":
      throw await de_CommentContentSizeLimitExceededExceptionRes(parsedOutput, context);
    case "InvalidFileLocationException":
    case "com.amazonaws.codecommit#InvalidFileLocationException":
      throw await de_InvalidFileLocationExceptionRes(parsedOutput, context);
    case "InvalidFilePositionException":
    case "com.amazonaws.codecommit#InvalidFilePositionException":
      throw await de_InvalidFilePositionExceptionRes(parsedOutput, context);
    case "InvalidRelativeFileVersionEnumException":
    case "com.amazonaws.codecommit#InvalidRelativeFileVersionEnumException":
      throw await de_InvalidRelativeFileVersionEnumExceptionRes(parsedOutput, context);
    case "InvalidReactionValueException":
    case "com.amazonaws.codecommit#InvalidReactionValueException":
      throw await de_InvalidReactionValueExceptionRes(parsedOutput, context);
    case "ReactionLimitExceededException":
    case "com.amazonaws.codecommit#ReactionLimitExceededException":
      throw await de_ReactionLimitExceededExceptionRes(parsedOutput, context);
    case "ReactionValueRequiredException":
    case "com.amazonaws.codecommit#ReactionValueRequiredException":
      throw await de_ReactionValueRequiredExceptionRes(parsedOutput, context);
    case "FileContentRequiredException":
    case "com.amazonaws.codecommit#FileContentRequiredException":
      throw await de_FileContentRequiredExceptionRes(parsedOutput, context);
    case "SameFileContentException":
    case "com.amazonaws.codecommit#SameFileContentException":
      throw await de_SameFileContentExceptionRes(parsedOutput, context);
    case "InvalidRepositoryTriggerBranchNameException":
    case "com.amazonaws.codecommit#InvalidRepositoryTriggerBranchNameException":
      throw await de_InvalidRepositoryTriggerBranchNameExceptionRes(parsedOutput, context);
    case "InvalidRepositoryTriggerCustomDataException":
    case "com.amazonaws.codecommit#InvalidRepositoryTriggerCustomDataException":
      throw await de_InvalidRepositoryTriggerCustomDataExceptionRes(parsedOutput, context);
    case "InvalidRepositoryTriggerDestinationArnException":
    case "com.amazonaws.codecommit#InvalidRepositoryTriggerDestinationArnException":
      throw await de_InvalidRepositoryTriggerDestinationArnExceptionRes(parsedOutput, context);
    case "InvalidRepositoryTriggerEventsException":
    case "com.amazonaws.codecommit#InvalidRepositoryTriggerEventsException":
      throw await de_InvalidRepositoryTriggerEventsExceptionRes(parsedOutput, context);
    case "InvalidRepositoryTriggerNameException":
    case "com.amazonaws.codecommit#InvalidRepositoryTriggerNameException":
      throw await de_InvalidRepositoryTriggerNameExceptionRes(parsedOutput, context);
    case "InvalidRepositoryTriggerRegionException":
    case "com.amazonaws.codecommit#InvalidRepositoryTriggerRegionException":
      throw await de_InvalidRepositoryTriggerRegionExceptionRes(parsedOutput, context);
    case "MaximumBranchesExceededException":
    case "com.amazonaws.codecommit#MaximumBranchesExceededException":
      throw await de_MaximumBranchesExceededExceptionRes(parsedOutput, context);
    case "MaximumRepositoryTriggersExceededException":
    case "com.amazonaws.codecommit#MaximumRepositoryTriggersExceededException":
      throw await de_MaximumRepositoryTriggersExceededExceptionRes(parsedOutput, context);
    case "RepositoryTriggerBranchNameListRequiredException":
    case "com.amazonaws.codecommit#RepositoryTriggerBranchNameListRequiredException":
      throw await de_RepositoryTriggerBranchNameListRequiredExceptionRes(parsedOutput, context);
    case "RepositoryTriggerDestinationArnRequiredException":
    case "com.amazonaws.codecommit#RepositoryTriggerDestinationArnRequiredException":
      throw await de_RepositoryTriggerDestinationArnRequiredExceptionRes(parsedOutput, context);
    case "RepositoryTriggerEventsListRequiredException":
    case "com.amazonaws.codecommit#RepositoryTriggerEventsListRequiredException":
      throw await de_RepositoryTriggerEventsListRequiredExceptionRes(parsedOutput, context);
    case "RepositoryTriggerNameRequiredException":
    case "com.amazonaws.codecommit#RepositoryTriggerNameRequiredException":
      throw await de_RepositoryTriggerNameRequiredExceptionRes(parsedOutput, context);
    case "RepositoryTriggersListRequiredException":
    case "com.amazonaws.codecommit#RepositoryTriggersListRequiredException":
      throw await de_RepositoryTriggersListRequiredExceptionRes(parsedOutput, context);
    case "TagsMapRequiredException":
    case "com.amazonaws.codecommit#TagsMapRequiredException":
      throw await de_TagsMapRequiredExceptionRes(parsedOutput, context);
    case "InvalidTagKeysListException":
    case "com.amazonaws.codecommit#InvalidTagKeysListException":
      throw await de_InvalidTagKeysListExceptionRes(parsedOutput, context);
    case "TagKeysListRequiredException":
    case "com.amazonaws.codecommit#TagKeysListRequiredException":
      throw await de_TagKeysListRequiredExceptionRes(parsedOutput, context);
    case "InvalidRuleContentSha256Exception":
    case "com.amazonaws.codecommit#InvalidRuleContentSha256Exception":
      throw await de_InvalidRuleContentSha256ExceptionRes(parsedOutput, context);
    case "CommentNotCreatedByCallerException":
    case "com.amazonaws.codecommit#CommentNotCreatedByCallerException":
      throw await de_CommentNotCreatedByCallerExceptionRes(parsedOutput, context);
    case "ApprovalRuleDoesNotExistException":
    case "com.amazonaws.codecommit#ApprovalRuleDoesNotExistException":
      throw await de_ApprovalRuleDoesNotExistExceptionRes(parsedOutput, context);
    case "CannotModifyApprovalRuleFromTemplateException":
    case "com.amazonaws.codecommit#CannotModifyApprovalRuleFromTemplateException":
      throw await de_CannotModifyApprovalRuleFromTemplateExceptionRes(parsedOutput, context);
    case "ApprovalStateRequiredException":
    case "com.amazonaws.codecommit#ApprovalStateRequiredException":
      throw await de_ApprovalStateRequiredExceptionRes(parsedOutput, context);
    case "InvalidApprovalStateException":
    case "com.amazonaws.codecommit#InvalidApprovalStateException":
      throw await de_InvalidApprovalStateExceptionRes(parsedOutput, context);
    case "MaximumNumberOfApprovalsExceededException":
    case "com.amazonaws.codecommit#MaximumNumberOfApprovalsExceededException":
      throw await de_MaximumNumberOfApprovalsExceededExceptionRes(parsedOutput, context);
    case "PullRequestCannotBeApprovedByAuthorException":
    case "com.amazonaws.codecommit#PullRequestCannotBeApprovedByAuthorException":
      throw await de_PullRequestCannotBeApprovedByAuthorExceptionRes(parsedOutput, context);
    case "InvalidPullRequestStatusUpdateException":
    case "com.amazonaws.codecommit#InvalidPullRequestStatusUpdateException":
      throw await de_InvalidPullRequestStatusUpdateExceptionRes(parsedOutput, context);
    case "PullRequestStatusRequiredException":
    case "com.amazonaws.codecommit#PullRequestStatusRequiredException":
      throw await de_PullRequestStatusRequiredExceptionRes(parsedOutput, context);
    case "EncryptionKeyRequiredException":
    case "com.amazonaws.codecommit#EncryptionKeyRequiredException":
      throw await de_EncryptionKeyRequiredExceptionRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody,
        errorCode
      });
  }
}, "de_CommandError");
var de_ActorDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ActorDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ActorDoesNotExistExceptionRes");
var de_ApprovalRuleContentRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalRuleContentRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalRuleContentRequiredExceptionRes");
var de_ApprovalRuleDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalRuleDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalRuleDoesNotExistExceptionRes");
var de_ApprovalRuleNameAlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalRuleNameAlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalRuleNameAlreadyExistsExceptionRes");
var de_ApprovalRuleNameRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalRuleNameRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalRuleNameRequiredExceptionRes");
var de_ApprovalRuleTemplateContentRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalRuleTemplateContentRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalRuleTemplateContentRequiredExceptionRes");
var de_ApprovalRuleTemplateDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalRuleTemplateDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalRuleTemplateDoesNotExistExceptionRes");
var de_ApprovalRuleTemplateInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalRuleTemplateInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalRuleTemplateInUseExceptionRes");
var de_ApprovalRuleTemplateNameAlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalRuleTemplateNameAlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalRuleTemplateNameAlreadyExistsExceptionRes");
var de_ApprovalRuleTemplateNameRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalRuleTemplateNameRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalRuleTemplateNameRequiredExceptionRes");
var de_ApprovalStateRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ApprovalStateRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ApprovalStateRequiredExceptionRes");
var de_AuthorDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AuthorDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AuthorDoesNotExistExceptionRes");
var de_BeforeCommitIdAndAfterCommitIdAreSameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new BeforeCommitIdAndAfterCommitIdAreSameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BeforeCommitIdAndAfterCommitIdAreSameExceptionRes");
var de_BlobIdDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new BlobIdDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BlobIdDoesNotExistExceptionRes");
var de_BlobIdRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new BlobIdRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BlobIdRequiredExceptionRes");
var de_BranchDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new BranchDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BranchDoesNotExistExceptionRes");
var de_BranchNameExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new BranchNameExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BranchNameExistsExceptionRes");
var de_BranchNameIsTagNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new BranchNameIsTagNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BranchNameIsTagNameExceptionRes");
var de_BranchNameRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new BranchNameRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BranchNameRequiredExceptionRes");
var de_CannotDeleteApprovalRuleFromTemplateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CannotDeleteApprovalRuleFromTemplateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CannotDeleteApprovalRuleFromTemplateExceptionRes");
var de_CannotModifyApprovalRuleFromTemplateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CannotModifyApprovalRuleFromTemplateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CannotModifyApprovalRuleFromTemplateExceptionRes");
var de_ClientRequestTokenRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ClientRequestTokenRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ClientRequestTokenRequiredExceptionRes");
var de_CommentContentRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommentContentRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommentContentRequiredExceptionRes");
var de_CommentContentSizeLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommentContentSizeLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommentContentSizeLimitExceededExceptionRes");
var de_CommentDeletedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommentDeletedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommentDeletedExceptionRes");
var de_CommentDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommentDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommentDoesNotExistExceptionRes");
var de_CommentIdRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommentIdRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommentIdRequiredExceptionRes");
var de_CommentNotCreatedByCallerExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommentNotCreatedByCallerException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommentNotCreatedByCallerExceptionRes");
var de_CommitDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommitDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommitDoesNotExistExceptionRes");
var de_CommitIdDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommitIdDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommitIdDoesNotExistExceptionRes");
var de_CommitIdRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommitIdRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommitIdRequiredExceptionRes");
var de_CommitIdsLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommitIdsLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommitIdsLimitExceededExceptionRes");
var de_CommitIdsListRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommitIdsListRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommitIdsListRequiredExceptionRes");
var de_CommitMessageLengthExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommitMessageLengthExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommitMessageLengthExceededExceptionRes");
var de_CommitRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CommitRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CommitRequiredExceptionRes");
var de_ConcurrentReferenceUpdateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ConcurrentReferenceUpdateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ConcurrentReferenceUpdateExceptionRes");
var de_DefaultBranchCannotBeDeletedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DefaultBranchCannotBeDeletedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DefaultBranchCannotBeDeletedExceptionRes");
var de_DirectoryNameConflictsWithFileNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DirectoryNameConflictsWithFileNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DirectoryNameConflictsWithFileNameExceptionRes");
var de_EncryptionIntegrityChecksFailedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new EncryptionIntegrityChecksFailedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EncryptionIntegrityChecksFailedExceptionRes");
var de_EncryptionKeyAccessDeniedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new EncryptionKeyAccessDeniedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EncryptionKeyAccessDeniedExceptionRes");
var de_EncryptionKeyDisabledExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new EncryptionKeyDisabledException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EncryptionKeyDisabledExceptionRes");
var de_EncryptionKeyInvalidIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new EncryptionKeyInvalidIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EncryptionKeyInvalidIdExceptionRes");
var de_EncryptionKeyInvalidUsageExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new EncryptionKeyInvalidUsageException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EncryptionKeyInvalidUsageExceptionRes");
var de_EncryptionKeyNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new EncryptionKeyNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EncryptionKeyNotFoundExceptionRes");
var de_EncryptionKeyRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new EncryptionKeyRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EncryptionKeyRequiredExceptionRes");
var de_EncryptionKeyUnavailableExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new EncryptionKeyUnavailableException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EncryptionKeyUnavailableExceptionRes");
var de_FileContentAndSourceFileSpecifiedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FileContentAndSourceFileSpecifiedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FileContentAndSourceFileSpecifiedExceptionRes");
var de_FileContentRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FileContentRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FileContentRequiredExceptionRes");
var de_FileContentSizeLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FileContentSizeLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FileContentSizeLimitExceededExceptionRes");
var de_FileDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FileDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FileDoesNotExistExceptionRes");
var de_FileEntryRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FileEntryRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FileEntryRequiredExceptionRes");
var de_FileModeRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FileModeRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FileModeRequiredExceptionRes");
var de_FileNameConflictsWithDirectoryNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FileNameConflictsWithDirectoryNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FileNameConflictsWithDirectoryNameExceptionRes");
var de_FilePathConflictsWithSubmodulePathExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FilePathConflictsWithSubmodulePathException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FilePathConflictsWithSubmodulePathExceptionRes");
var de_FileTooLargeExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FileTooLargeException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FileTooLargeExceptionRes");
var de_FolderContentSizeLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FolderContentSizeLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FolderContentSizeLimitExceededExceptionRes");
var de_FolderDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FolderDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FolderDoesNotExistExceptionRes");
var de_IdempotencyParameterMismatchExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new IdempotencyParameterMismatchException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IdempotencyParameterMismatchExceptionRes");
var de_InvalidActorArnExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidActorArnException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidActorArnExceptionRes");
var de_InvalidApprovalRuleContentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidApprovalRuleContentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidApprovalRuleContentExceptionRes");
var de_InvalidApprovalRuleNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidApprovalRuleNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidApprovalRuleNameExceptionRes");
var de_InvalidApprovalRuleTemplateContentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidApprovalRuleTemplateContentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidApprovalRuleTemplateContentExceptionRes");
var de_InvalidApprovalRuleTemplateDescriptionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidApprovalRuleTemplateDescriptionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidApprovalRuleTemplateDescriptionExceptionRes");
var de_InvalidApprovalRuleTemplateNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidApprovalRuleTemplateNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidApprovalRuleTemplateNameExceptionRes");
var de_InvalidApprovalStateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidApprovalStateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidApprovalStateExceptionRes");
var de_InvalidAuthorArnExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidAuthorArnException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidAuthorArnExceptionRes");
var de_InvalidBlobIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidBlobIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidBlobIdExceptionRes");
var de_InvalidBranchNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidBranchNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidBranchNameExceptionRes");
var de_InvalidClientRequestTokenExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidClientRequestTokenException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidClientRequestTokenExceptionRes");
var de_InvalidCommentIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidCommentIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidCommentIdExceptionRes");
var de_InvalidCommitExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidCommitException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidCommitExceptionRes");
var de_InvalidCommitIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidCommitIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidCommitIdExceptionRes");
var de_InvalidConflictDetailLevelExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidConflictDetailLevelException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidConflictDetailLevelExceptionRes");
var de_InvalidConflictResolutionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidConflictResolutionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidConflictResolutionExceptionRes");
var de_InvalidConflictResolutionStrategyExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidConflictResolutionStrategyException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidConflictResolutionStrategyExceptionRes");
var de_InvalidContinuationTokenExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidContinuationTokenException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidContinuationTokenExceptionRes");
var de_InvalidDeletionParameterExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDeletionParameterException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDeletionParameterExceptionRes");
var de_InvalidDescriptionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDescriptionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDescriptionExceptionRes");
var de_InvalidDestinationCommitSpecifierExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDestinationCommitSpecifierException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDestinationCommitSpecifierExceptionRes");
var de_InvalidEmailExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidEmailException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidEmailExceptionRes");
var de_InvalidFileLocationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidFileLocationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidFileLocationExceptionRes");
var de_InvalidFileModeExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidFileModeException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidFileModeExceptionRes");
var de_InvalidFilePositionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidFilePositionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidFilePositionExceptionRes");
var de_InvalidMaxConflictFilesExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidMaxConflictFilesException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidMaxConflictFilesExceptionRes");
var de_InvalidMaxMergeHunksExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidMaxMergeHunksException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidMaxMergeHunksExceptionRes");
var de_InvalidMaxResultsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidMaxResultsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidMaxResultsExceptionRes");
var de_InvalidMergeOptionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidMergeOptionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidMergeOptionExceptionRes");
var de_InvalidOrderExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidOrderException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidOrderExceptionRes");
var de_InvalidOverrideStatusExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidOverrideStatusException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidOverrideStatusExceptionRes");
var de_InvalidParentCommitIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidParentCommitIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidParentCommitIdExceptionRes");
var de_InvalidPathExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidPathException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidPathExceptionRes");
var de_InvalidPullRequestEventTypeExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidPullRequestEventTypeException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidPullRequestEventTypeExceptionRes");
var de_InvalidPullRequestIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidPullRequestIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidPullRequestIdExceptionRes");
var de_InvalidPullRequestStatusExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidPullRequestStatusException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidPullRequestStatusExceptionRes");
var de_InvalidPullRequestStatusUpdateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidPullRequestStatusUpdateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidPullRequestStatusUpdateExceptionRes");
var de_InvalidReactionUserArnExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidReactionUserArnException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidReactionUserArnExceptionRes");
var de_InvalidReactionValueExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidReactionValueException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidReactionValueExceptionRes");
var de_InvalidReferenceNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidReferenceNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidReferenceNameExceptionRes");
var de_InvalidRelativeFileVersionEnumExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRelativeFileVersionEnumException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRelativeFileVersionEnumExceptionRes");
var de_InvalidReplacementContentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidReplacementContentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidReplacementContentExceptionRes");
var de_InvalidReplacementTypeExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidReplacementTypeException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidReplacementTypeExceptionRes");
var de_InvalidRepositoryDescriptionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRepositoryDescriptionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRepositoryDescriptionExceptionRes");
var de_InvalidRepositoryNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRepositoryNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRepositoryNameExceptionRes");
var de_InvalidRepositoryTriggerBranchNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRepositoryTriggerBranchNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRepositoryTriggerBranchNameExceptionRes");
var de_InvalidRepositoryTriggerCustomDataExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRepositoryTriggerCustomDataException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRepositoryTriggerCustomDataExceptionRes");
var de_InvalidRepositoryTriggerDestinationArnExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRepositoryTriggerDestinationArnException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRepositoryTriggerDestinationArnExceptionRes");
var de_InvalidRepositoryTriggerEventsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRepositoryTriggerEventsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRepositoryTriggerEventsExceptionRes");
var de_InvalidRepositoryTriggerNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRepositoryTriggerNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRepositoryTriggerNameExceptionRes");
var de_InvalidRepositoryTriggerRegionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRepositoryTriggerRegionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRepositoryTriggerRegionExceptionRes");
var de_InvalidResourceArnExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidResourceArnException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidResourceArnExceptionRes");
var de_InvalidRevisionIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRevisionIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRevisionIdExceptionRes");
var de_InvalidRuleContentSha256ExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRuleContentSha256Exception({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRuleContentSha256ExceptionRes");
var de_InvalidSortByExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidSortByException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidSortByExceptionRes");
var de_InvalidSourceCommitSpecifierExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidSourceCommitSpecifierException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidSourceCommitSpecifierExceptionRes");
var de_InvalidSystemTagUsageExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidSystemTagUsageException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidSystemTagUsageExceptionRes");
var de_InvalidTagKeysListExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTagKeysListException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTagKeysListExceptionRes");
var de_InvalidTagsMapExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTagsMapException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTagsMapExceptionRes");
var de_InvalidTargetBranchExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTargetBranchException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTargetBranchExceptionRes");
var de_InvalidTargetExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTargetException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTargetExceptionRes");
var de_InvalidTargetsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTargetsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTargetsExceptionRes");
var de_InvalidTitleExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTitleException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTitleExceptionRes");
var de_ManualMergeRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ManualMergeRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ManualMergeRequiredExceptionRes");
var de_MaximumBranchesExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumBranchesExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumBranchesExceededExceptionRes");
var de_MaximumConflictResolutionEntriesExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumConflictResolutionEntriesExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumConflictResolutionEntriesExceededExceptionRes");
var de_MaximumFileContentToLoadExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumFileContentToLoadExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumFileContentToLoadExceededExceptionRes");
var de_MaximumFileEntriesExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumFileEntriesExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumFileEntriesExceededExceptionRes");
var de_MaximumItemsToCompareExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumItemsToCompareExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumItemsToCompareExceededExceptionRes");
var de_MaximumNumberOfApprovalsExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumNumberOfApprovalsExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumNumberOfApprovalsExceededExceptionRes");
var de_MaximumOpenPullRequestsExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumOpenPullRequestsExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumOpenPullRequestsExceededExceptionRes");
var de_MaximumRepositoryNamesExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumRepositoryNamesExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumRepositoryNamesExceededExceptionRes");
var de_MaximumRepositoryTriggersExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumRepositoryTriggersExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumRepositoryTriggersExceededExceptionRes");
var de_MaximumRuleTemplatesAssociatedWithRepositoryExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaximumRuleTemplatesAssociatedWithRepositoryException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaximumRuleTemplatesAssociatedWithRepositoryExceptionRes");
var de_MergeOptionRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MergeOptionRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MergeOptionRequiredExceptionRes");
var de_MultipleConflictResolutionEntriesExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MultipleConflictResolutionEntriesException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MultipleConflictResolutionEntriesExceptionRes");
var de_MultipleRepositoriesInPullRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MultipleRepositoriesInPullRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MultipleRepositoriesInPullRequestExceptionRes");
var de_NameLengthExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new NameLengthExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NameLengthExceededExceptionRes");
var de_NoChangeExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new NoChangeException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NoChangeExceptionRes");
var de_NumberOfRulesExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new NumberOfRulesExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NumberOfRulesExceededExceptionRes");
var de_NumberOfRuleTemplatesExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new NumberOfRuleTemplatesExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NumberOfRuleTemplatesExceededExceptionRes");
var de_OperationNotAllowedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OperationNotAllowedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OperationNotAllowedExceptionRes");
var de_OverrideAlreadySetExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OverrideAlreadySetException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OverrideAlreadySetExceptionRes");
var de_OverrideStatusRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OverrideStatusRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OverrideStatusRequiredExceptionRes");
var de_ParentCommitDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParentCommitDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParentCommitDoesNotExistExceptionRes");
var de_ParentCommitIdOutdatedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParentCommitIdOutdatedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParentCommitIdOutdatedExceptionRes");
var de_ParentCommitIdRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParentCommitIdRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParentCommitIdRequiredExceptionRes");
var de_PathDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PathDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PathDoesNotExistExceptionRes");
var de_PathRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PathRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PathRequiredExceptionRes");
var de_PullRequestAlreadyClosedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PullRequestAlreadyClosedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PullRequestAlreadyClosedExceptionRes");
var de_PullRequestApprovalRulesNotSatisfiedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PullRequestApprovalRulesNotSatisfiedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PullRequestApprovalRulesNotSatisfiedExceptionRes");
var de_PullRequestCannotBeApprovedByAuthorExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PullRequestCannotBeApprovedByAuthorException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PullRequestCannotBeApprovedByAuthorExceptionRes");
var de_PullRequestDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PullRequestDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PullRequestDoesNotExistExceptionRes");
var de_PullRequestIdRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PullRequestIdRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PullRequestIdRequiredExceptionRes");
var de_PullRequestStatusRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PullRequestStatusRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PullRequestStatusRequiredExceptionRes");
var de_PutFileEntryConflictExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PutFileEntryConflictException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PutFileEntryConflictExceptionRes");
var de_ReactionLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ReactionLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReactionLimitExceededExceptionRes");
var de_ReactionValueRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ReactionValueRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReactionValueRequiredExceptionRes");
var de_ReferenceDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ReferenceDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReferenceDoesNotExistExceptionRes");
var de_ReferenceNameRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ReferenceNameRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReferenceNameRequiredExceptionRes");
var de_ReferenceTypeNotSupportedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ReferenceTypeNotSupportedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReferenceTypeNotSupportedExceptionRes");
var de_ReplacementContentRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ReplacementContentRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReplacementContentRequiredExceptionRes");
var de_ReplacementTypeRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ReplacementTypeRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReplacementTypeRequiredExceptionRes");
var de_RepositoryDoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryDoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryDoesNotExistExceptionRes");
var de_RepositoryLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryLimitExceededExceptionRes");
var de_RepositoryNameExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryNameExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryNameExistsExceptionRes");
var de_RepositoryNameRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryNameRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryNameRequiredExceptionRes");
var de_RepositoryNamesRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryNamesRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryNamesRequiredExceptionRes");
var de_RepositoryNotAssociatedWithPullRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryNotAssociatedWithPullRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryNotAssociatedWithPullRequestExceptionRes");
var de_RepositoryTriggerBranchNameListRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryTriggerBranchNameListRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryTriggerBranchNameListRequiredExceptionRes");
var de_RepositoryTriggerDestinationArnRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryTriggerDestinationArnRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryTriggerDestinationArnRequiredExceptionRes");
var de_RepositoryTriggerEventsListRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryTriggerEventsListRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryTriggerEventsListRequiredExceptionRes");
var de_RepositoryTriggerNameRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryTriggerNameRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryTriggerNameRequiredExceptionRes");
var de_RepositoryTriggersListRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RepositoryTriggersListRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RepositoryTriggersListRequiredExceptionRes");
var de_ResourceArnRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceArnRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceArnRequiredExceptionRes");
var de_RestrictedSourceFileExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RestrictedSourceFileException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RestrictedSourceFileExceptionRes");
var de_RevisionIdRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RevisionIdRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RevisionIdRequiredExceptionRes");
var de_RevisionNotCurrentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new RevisionNotCurrentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_RevisionNotCurrentExceptionRes");
var de_SameFileContentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new SameFileContentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SameFileContentExceptionRes");
var de_SamePathRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new SamePathRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SamePathRequestExceptionRes");
var de_SourceAndDestinationAreSameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new SourceAndDestinationAreSameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SourceAndDestinationAreSameExceptionRes");
var de_SourceFileOrContentRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new SourceFileOrContentRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SourceFileOrContentRequiredExceptionRes");
var de_TagKeysListRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TagKeysListRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TagKeysListRequiredExceptionRes");
var de_TagPolicyExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TagPolicyException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TagPolicyExceptionRes");
var de_TagsMapRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TagsMapRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TagsMapRequiredExceptionRes");
var de_TargetRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TargetRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TargetRequiredExceptionRes");
var de_TargetsRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TargetsRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TargetsRequiredExceptionRes");
var de_TipOfSourceReferenceIsDifferentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TipOfSourceReferenceIsDifferentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TipOfSourceReferenceIsDifferentExceptionRes");
var de_TipsDivergenceExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TipsDivergenceExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TipsDivergenceExceededExceptionRes");
var de_TitleRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TitleRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TitleRequiredExceptionRes");
var de_TooManyTagsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TooManyTagsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TooManyTagsExceptionRes");
var se_ConflictResolution = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    deleteFiles: import_smithy_client._json,
    replaceContents: /* @__PURE__ */ __name((_) => se_ReplaceContentEntries(_, context), "replaceContents"),
    setFileModes: import_smithy_client._json
  });
}, "se_ConflictResolution");
var se_CreateCommitInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    authorName: [],
    branchName: [],
    commitMessage: [],
    deleteFiles: import_smithy_client._json,
    email: [],
    keepEmptyFolders: [],
    parentCommitId: [],
    putFiles: /* @__PURE__ */ __name((_) => se_PutFileEntries(_, context), "putFiles"),
    repositoryName: [],
    setFileModes: import_smithy_client._json
  });
}, "se_CreateCommitInput");
var se_CreatePullRequestInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    description: [],
    targets: import_smithy_client._json,
    title: []
  });
}, "se_CreatePullRequestInput");
var se_CreateUnreferencedMergeCommitInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    authorName: [],
    commitMessage: [],
    conflictDetailLevel: [],
    conflictResolution: /* @__PURE__ */ __name((_) => se_ConflictResolution(_, context), "conflictResolution"),
    conflictResolutionStrategy: [],
    destinationCommitSpecifier: [],
    email: [],
    keepEmptyFolders: [],
    mergeOption: [],
    repositoryName: [],
    sourceCommitSpecifier: []
  });
}, "se_CreateUnreferencedMergeCommitInput");
var se_MergeBranchesBySquashInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    authorName: [],
    commitMessage: [],
    conflictDetailLevel: [],
    conflictResolution: /* @__PURE__ */ __name((_) => se_ConflictResolution(_, context), "conflictResolution"),
    conflictResolutionStrategy: [],
    destinationCommitSpecifier: [],
    email: [],
    keepEmptyFolders: [],
    repositoryName: [],
    sourceCommitSpecifier: [],
    targetBranch: []
  });
}, "se_MergeBranchesBySquashInput");
var se_MergeBranchesByThreeWayInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    authorName: [],
    commitMessage: [],
    conflictDetailLevel: [],
    conflictResolution: /* @__PURE__ */ __name((_) => se_ConflictResolution(_, context), "conflictResolution"),
    conflictResolutionStrategy: [],
    destinationCommitSpecifier: [],
    email: [],
    keepEmptyFolders: [],
    repositoryName: [],
    sourceCommitSpecifier: [],
    targetBranch: []
  });
}, "se_MergeBranchesByThreeWayInput");
var se_MergePullRequestBySquashInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    authorName: [],
    commitMessage: [],
    conflictDetailLevel: [],
    conflictResolution: /* @__PURE__ */ __name((_) => se_ConflictResolution(_, context), "conflictResolution"),
    conflictResolutionStrategy: [],
    email: [],
    keepEmptyFolders: [],
    pullRequestId: [],
    repositoryName: [],
    sourceCommitId: []
  });
}, "se_MergePullRequestBySquashInput");
var se_MergePullRequestByThreeWayInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    authorName: [],
    commitMessage: [],
    conflictDetailLevel: [],
    conflictResolution: /* @__PURE__ */ __name((_) => se_ConflictResolution(_, context), "conflictResolution"),
    conflictResolutionStrategy: [],
    email: [],
    keepEmptyFolders: [],
    pullRequestId: [],
    repositoryName: [],
    sourceCommitId: []
  });
}, "se_MergePullRequestByThreeWayInput");
var se_PostCommentForComparedCommitInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    afterCommitId: [],
    beforeCommitId: [],
    clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    content: [],
    location: import_smithy_client._json,
    repositoryName: []
  });
}, "se_PostCommentForComparedCommitInput");
var se_PostCommentForPullRequestInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    afterCommitId: [],
    beforeCommitId: [],
    clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    content: [],
    location: import_smithy_client._json,
    pullRequestId: [],
    repositoryName: []
  });
}, "se_PostCommentForPullRequestInput");
var se_PostCommentReplyInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    content: [],
    inReplyTo: []
  });
}, "se_PostCommentReplyInput");
var se_PutFileEntries = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_PutFileEntry(entry, context);
  });
}, "se_PutFileEntries");
var se_PutFileEntry = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    fileContent: context.base64Encoder,
    fileMode: [],
    filePath: [],
    sourceFile: import_smithy_client._json
  });
}, "se_PutFileEntry");
var se_PutFileInput = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    branchName: [],
    commitMessage: [],
    email: [],
    fileContent: context.base64Encoder,
    fileMode: [],
    filePath: [],
    name: [],
    parentCommitId: [],
    repositoryName: []
  });
}, "se_PutFileInput");
var se_ReplaceContentEntries = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_ReplaceContentEntry(entry, context);
  });
}, "se_ReplaceContentEntries");
var se_ReplaceContentEntry = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    content: context.base64Encoder,
    fileMode: [],
    filePath: [],
    replacementType: []
  });
}, "se_ReplaceContentEntry");
var de_ApprovalRule = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRuleContent: import_smithy_client.expectString,
    approvalRuleId: import_smithy_client.expectString,
    approvalRuleName: import_smithy_client.expectString,
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    lastModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastModifiedDate"),
    lastModifiedUser: import_smithy_client.expectString,
    originApprovalRuleTemplate: import_smithy_client._json,
    ruleContentSha256: import_smithy_client.expectString
  });
}, "de_ApprovalRule");
var de_ApprovalRulesList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ApprovalRule(entry, context);
  });
  return retVal;
}, "de_ApprovalRulesList");
var de_ApprovalRuleTemplate = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRuleTemplateContent: import_smithy_client.expectString,
    approvalRuleTemplateDescription: import_smithy_client.expectString,
    approvalRuleTemplateId: import_smithy_client.expectString,
    approvalRuleTemplateName: import_smithy_client.expectString,
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    lastModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastModifiedDate"),
    lastModifiedUser: import_smithy_client.expectString,
    ruleContentSha256: import_smithy_client.expectString
  });
}, "de_ApprovalRuleTemplate");
var de_BatchGetRepositoriesOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    errors: import_smithy_client._json,
    repositories: /* @__PURE__ */ __name((_) => de_RepositoryMetadataList(_, context), "repositories"),
    repositoriesNotFound: import_smithy_client._json
  });
}, "de_BatchGetRepositoriesOutput");
var de_Comment = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    authorArn: import_smithy_client.expectString,
    callerReactions: import_smithy_client._json,
    clientRequestToken: import_smithy_client.expectString,
    commentId: import_smithy_client.expectString,
    content: import_smithy_client.expectString,
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    deleted: import_smithy_client.expectBoolean,
    inReplyTo: import_smithy_client.expectString,
    lastModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastModifiedDate"),
    reactionCounts: import_smithy_client._json
  });
}, "de_Comment");
var de_Comments = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Comment(entry, context);
  });
  return retVal;
}, "de_Comments");
var de_CommentsForComparedCommit = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    afterBlobId: import_smithy_client.expectString,
    afterCommitId: import_smithy_client.expectString,
    beforeBlobId: import_smithy_client.expectString,
    beforeCommitId: import_smithy_client.expectString,
    comments: /* @__PURE__ */ __name((_) => de_Comments(_, context), "comments"),
    location: import_smithy_client._json,
    repositoryName: import_smithy_client.expectString
  });
}, "de_CommentsForComparedCommit");
var de_CommentsForComparedCommitData = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_CommentsForComparedCommit(entry, context);
  });
  return retVal;
}, "de_CommentsForComparedCommitData");
var de_CommentsForPullRequest = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    afterBlobId: import_smithy_client.expectString,
    afterCommitId: import_smithy_client.expectString,
    beforeBlobId: import_smithy_client.expectString,
    beforeCommitId: import_smithy_client.expectString,
    comments: /* @__PURE__ */ __name((_) => de_Comments(_, context), "comments"),
    location: import_smithy_client._json,
    pullRequestId: import_smithy_client.expectString,
    repositoryName: import_smithy_client.expectString
  });
}, "de_CommentsForPullRequest");
var de_CommentsForPullRequestData = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_CommentsForPullRequest(entry, context);
  });
  return retVal;
}, "de_CommentsForPullRequestData");
var de_CreateApprovalRuleTemplateOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRuleTemplate: /* @__PURE__ */ __name((_) => de_ApprovalRuleTemplate(_, context), "approvalRuleTemplate")
  });
}, "de_CreateApprovalRuleTemplateOutput");
var de_CreatePullRequestApprovalRuleOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRule: /* @__PURE__ */ __name((_) => de_ApprovalRule(_, context), "approvalRule")
  });
}, "de_CreatePullRequestApprovalRuleOutput");
var de_CreatePullRequestOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    pullRequest: /* @__PURE__ */ __name((_) => de_PullRequest(_, context), "pullRequest")
  });
}, "de_CreatePullRequestOutput");
var de_CreateRepositoryOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    repositoryMetadata: /* @__PURE__ */ __name((_) => de_RepositoryMetadata(_, context), "repositoryMetadata")
  });
}, "de_CreateRepositoryOutput");
var de_DeleteCommentContentOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    comment: /* @__PURE__ */ __name((_) => de_Comment(_, context), "comment")
  });
}, "de_DeleteCommentContentOutput");
var de_DescribePullRequestEventsOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    nextToken: import_smithy_client.expectString,
    pullRequestEvents: /* @__PURE__ */ __name((_) => de_PullRequestEventList(_, context), "pullRequestEvents")
  });
}, "de_DescribePullRequestEventsOutput");
var de_GetApprovalRuleTemplateOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRuleTemplate: /* @__PURE__ */ __name((_) => de_ApprovalRuleTemplate(_, context), "approvalRuleTemplate")
  });
}, "de_GetApprovalRuleTemplateOutput");
var de_GetBlobOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    content: context.base64Decoder
  });
}, "de_GetBlobOutput");
var de_GetCommentOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    comment: /* @__PURE__ */ __name((_) => de_Comment(_, context), "comment")
  });
}, "de_GetCommentOutput");
var de_GetCommentsForComparedCommitOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    commentsForComparedCommitData: /* @__PURE__ */ __name((_) => de_CommentsForComparedCommitData(_, context), "commentsForComparedCommitData"),
    nextToken: import_smithy_client.expectString
  });
}, "de_GetCommentsForComparedCommitOutput");
var de_GetCommentsForPullRequestOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    commentsForPullRequestData: /* @__PURE__ */ __name((_) => de_CommentsForPullRequestData(_, context), "commentsForPullRequestData"),
    nextToken: import_smithy_client.expectString
  });
}, "de_GetCommentsForPullRequestOutput");
var de_GetFileOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    blobId: import_smithy_client.expectString,
    commitId: import_smithy_client.expectString,
    fileContent: context.base64Decoder,
    fileMode: import_smithy_client.expectString,
    filePath: import_smithy_client.expectString,
    fileSize: import_smithy_client.expectLong
  });
}, "de_GetFileOutput");
var de_GetPullRequestOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    pullRequest: /* @__PURE__ */ __name((_) => de_PullRequest(_, context), "pullRequest")
  });
}, "de_GetPullRequestOutput");
var de_GetRepositoryOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    repositoryMetadata: /* @__PURE__ */ __name((_) => de_RepositoryMetadata(_, context), "repositoryMetadata")
  });
}, "de_GetRepositoryOutput");
var de_MergePullRequestByFastForwardOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    pullRequest: /* @__PURE__ */ __name((_) => de_PullRequest(_, context), "pullRequest")
  });
}, "de_MergePullRequestByFastForwardOutput");
var de_MergePullRequestBySquashOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    pullRequest: /* @__PURE__ */ __name((_) => de_PullRequest(_, context), "pullRequest")
  });
}, "de_MergePullRequestBySquashOutput");
var de_MergePullRequestByThreeWayOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    pullRequest: /* @__PURE__ */ __name((_) => de_PullRequest(_, context), "pullRequest")
  });
}, "de_MergePullRequestByThreeWayOutput");
var de_PostCommentForComparedCommitOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    afterBlobId: import_smithy_client.expectString,
    afterCommitId: import_smithy_client.expectString,
    beforeBlobId: import_smithy_client.expectString,
    beforeCommitId: import_smithy_client.expectString,
    comment: /* @__PURE__ */ __name((_) => de_Comment(_, context), "comment"),
    location: import_smithy_client._json,
    repositoryName: import_smithy_client.expectString
  });
}, "de_PostCommentForComparedCommitOutput");
var de_PostCommentForPullRequestOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    afterBlobId: import_smithy_client.expectString,
    afterCommitId: import_smithy_client.expectString,
    beforeBlobId: import_smithy_client.expectString,
    beforeCommitId: import_smithy_client.expectString,
    comment: /* @__PURE__ */ __name((_) => de_Comment(_, context), "comment"),
    location: import_smithy_client._json,
    pullRequestId: import_smithy_client.expectString,
    repositoryName: import_smithy_client.expectString
  });
}, "de_PostCommentForPullRequestOutput");
var de_PostCommentReplyOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    comment: /* @__PURE__ */ __name((_) => de_Comment(_, context), "comment")
  });
}, "de_PostCommentReplyOutput");
var de_PullRequest = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRules: /* @__PURE__ */ __name((_) => de_ApprovalRulesList(_, context), "approvalRules"),
    authorArn: import_smithy_client.expectString,
    clientRequestToken: import_smithy_client.expectString,
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    description: import_smithy_client.expectString,
    lastActivityDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastActivityDate"),
    pullRequestId: import_smithy_client.expectString,
    pullRequestStatus: import_smithy_client.expectString,
    pullRequestTargets: import_smithy_client._json,
    revisionId: import_smithy_client.expectString,
    title: import_smithy_client.expectString
  });
}, "de_PullRequest");
var de_PullRequestEvent = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    actorArn: import_smithy_client.expectString,
    approvalRuleEventMetadata: import_smithy_client._json,
    approvalRuleOverriddenEventMetadata: import_smithy_client._json,
    approvalStateChangedEventMetadata: import_smithy_client._json,
    eventDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "eventDate"),
    pullRequestCreatedEventMetadata: import_smithy_client._json,
    pullRequestEventType: import_smithy_client.expectString,
    pullRequestId: import_smithy_client.expectString,
    pullRequestMergedStateChangedEventMetadata: import_smithy_client._json,
    pullRequestSourceReferenceUpdatedEventMetadata: import_smithy_client._json,
    pullRequestStatusChangedEventMetadata: import_smithy_client._json
  });
}, "de_PullRequestEvent");
var de_PullRequestEventList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_PullRequestEvent(entry, context);
  });
  return retVal;
}, "de_PullRequestEventList");
var de_RepositoryMetadata = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Arn: import_smithy_client.expectString,
    accountId: import_smithy_client.expectString,
    cloneUrlHttp: import_smithy_client.expectString,
    cloneUrlSsh: import_smithy_client.expectString,
    creationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "creationDate"),
    defaultBranch: import_smithy_client.expectString,
    kmsKeyId: import_smithy_client.expectString,
    lastModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastModifiedDate"),
    repositoryDescription: import_smithy_client.expectString,
    repositoryId: import_smithy_client.expectString,
    repositoryName: import_smithy_client.expectString
  });
}, "de_RepositoryMetadata");
var de_RepositoryMetadataList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_RepositoryMetadata(entry, context);
  });
  return retVal;
}, "de_RepositoryMetadataList");
var de_UpdateApprovalRuleTemplateContentOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRuleTemplate: /* @__PURE__ */ __name((_) => de_ApprovalRuleTemplate(_, context), "approvalRuleTemplate")
  });
}, "de_UpdateApprovalRuleTemplateContentOutput");
var de_UpdateApprovalRuleTemplateDescriptionOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRuleTemplate: /* @__PURE__ */ __name((_) => de_ApprovalRuleTemplate(_, context), "approvalRuleTemplate")
  });
}, "de_UpdateApprovalRuleTemplateDescriptionOutput");
var de_UpdateApprovalRuleTemplateNameOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRuleTemplate: /* @__PURE__ */ __name((_) => de_ApprovalRuleTemplate(_, context), "approvalRuleTemplate")
  });
}, "de_UpdateApprovalRuleTemplateNameOutput");
var de_UpdateCommentOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    comment: /* @__PURE__ */ __name((_) => de_Comment(_, context), "comment")
  });
}, "de_UpdateCommentOutput");
var de_UpdatePullRequestApprovalRuleContentOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    approvalRule: /* @__PURE__ */ __name((_) => de_ApprovalRule(_, context), "approvalRule")
  });
}, "de_UpdatePullRequestApprovalRuleContentOutput");
var de_UpdatePullRequestDescriptionOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    pullRequest: /* @__PURE__ */ __name((_) => de_PullRequest(_, context), "pullRequest")
  });
}, "de_UpdatePullRequestDescriptionOutput");
var de_UpdatePullRequestStatusOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    pullRequest: /* @__PURE__ */ __name((_) => de_PullRequest(_, context), "pullRequest")
  });
}, "de_UpdatePullRequestStatusOutput");
var de_UpdatePullRequestTitleOutput = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    pullRequest: /* @__PURE__ */ __name((_) => de_PullRequest(_, context), "pullRequest")
  });
}, "de_UpdatePullRequestTitleOutput");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(CodeCommitServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
function sharedHeaders(operation) {
  return {
    "content-type": "application/x-amz-json-1.1",
    "x-amz-target": `CodeCommit_20150413.${operation}`
  };
}
__name(sharedHeaders, "sharedHeaders");

// src/commands/AssociateApprovalRuleTemplateWithRepositoryCommand.ts
var AssociateApprovalRuleTemplateWithRepositoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "AssociateApprovalRuleTemplateWithRepository", {}).n("CodeCommitClient", "AssociateApprovalRuleTemplateWithRepositoryCommand").f(void 0, void 0).ser(se_AssociateApprovalRuleTemplateWithRepositoryCommand).de(de_AssociateApprovalRuleTemplateWithRepositoryCommand).build() {
  static {
    __name(this, "AssociateApprovalRuleTemplateWithRepositoryCommand");
  }
};

// src/commands/BatchAssociateApprovalRuleTemplateWithRepositoriesCommand.ts



var BatchAssociateApprovalRuleTemplateWithRepositoriesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "BatchAssociateApprovalRuleTemplateWithRepositories", {}).n("CodeCommitClient", "BatchAssociateApprovalRuleTemplateWithRepositoriesCommand").f(void 0, void 0).ser(se_BatchAssociateApprovalRuleTemplateWithRepositoriesCommand).de(de_BatchAssociateApprovalRuleTemplateWithRepositoriesCommand).build() {
  static {
    __name(this, "BatchAssociateApprovalRuleTemplateWithRepositoriesCommand");
  }
};

// src/commands/BatchDescribeMergeConflictsCommand.ts



var BatchDescribeMergeConflictsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "BatchDescribeMergeConflicts", {}).n("CodeCommitClient", "BatchDescribeMergeConflictsCommand").f(void 0, void 0).ser(se_BatchDescribeMergeConflictsCommand).de(de_BatchDescribeMergeConflictsCommand).build() {
  static {
    __name(this, "BatchDescribeMergeConflictsCommand");
  }
};

// src/commands/BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand.ts



var BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "BatchDisassociateApprovalRuleTemplateFromRepositories", {}).n("CodeCommitClient", "BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand").f(void 0, void 0).ser(se_BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand).de(de_BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand).build() {
  static {
    __name(this, "BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand");
  }
};

// src/commands/BatchGetCommitsCommand.ts



var BatchGetCommitsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "BatchGetCommits", {}).n("CodeCommitClient", "BatchGetCommitsCommand").f(void 0, void 0).ser(se_BatchGetCommitsCommand).de(de_BatchGetCommitsCommand).build() {
  static {
    __name(this, "BatchGetCommitsCommand");
  }
};

// src/commands/BatchGetRepositoriesCommand.ts



var BatchGetRepositoriesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "BatchGetRepositories", {}).n("CodeCommitClient", "BatchGetRepositoriesCommand").f(void 0, void 0).ser(se_BatchGetRepositoriesCommand).de(de_BatchGetRepositoriesCommand).build() {
  static {
    __name(this, "BatchGetRepositoriesCommand");
  }
};

// src/commands/CreateApprovalRuleTemplateCommand.ts



var CreateApprovalRuleTemplateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "CreateApprovalRuleTemplate", {}).n("CodeCommitClient", "CreateApprovalRuleTemplateCommand").f(void 0, void 0).ser(se_CreateApprovalRuleTemplateCommand).de(de_CreateApprovalRuleTemplateCommand).build() {
  static {
    __name(this, "CreateApprovalRuleTemplateCommand");
  }
};

// src/commands/CreateBranchCommand.ts



var CreateBranchCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "CreateBranch", {}).n("CodeCommitClient", "CreateBranchCommand").f(void 0, void 0).ser(se_CreateBranchCommand).de(de_CreateBranchCommand).build() {
  static {
    __name(this, "CreateBranchCommand");
  }
};

// src/commands/CreateCommitCommand.ts



var CreateCommitCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "CreateCommit", {}).n("CodeCommitClient", "CreateCommitCommand").f(void 0, void 0).ser(se_CreateCommitCommand).de(de_CreateCommitCommand).build() {
  static {
    __name(this, "CreateCommitCommand");
  }
};

// src/commands/CreatePullRequestApprovalRuleCommand.ts



var CreatePullRequestApprovalRuleCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "CreatePullRequestApprovalRule", {}).n("CodeCommitClient", "CreatePullRequestApprovalRuleCommand").f(void 0, void 0).ser(se_CreatePullRequestApprovalRuleCommand).de(de_CreatePullRequestApprovalRuleCommand).build() {
  static {
    __name(this, "CreatePullRequestApprovalRuleCommand");
  }
};

// src/commands/CreatePullRequestCommand.ts



var CreatePullRequestCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "CreatePullRequest", {}).n("CodeCommitClient", "CreatePullRequestCommand").f(void 0, void 0).ser(se_CreatePullRequestCommand).de(de_CreatePullRequestCommand).build() {
  static {
    __name(this, "CreatePullRequestCommand");
  }
};

// src/commands/CreateRepositoryCommand.ts



var CreateRepositoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "CreateRepository", {}).n("CodeCommitClient", "CreateRepositoryCommand").f(void 0, void 0).ser(se_CreateRepositoryCommand).de(de_CreateRepositoryCommand).build() {
  static {
    __name(this, "CreateRepositoryCommand");
  }
};

// src/commands/CreateUnreferencedMergeCommitCommand.ts



var CreateUnreferencedMergeCommitCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "CreateUnreferencedMergeCommit", {}).n("CodeCommitClient", "CreateUnreferencedMergeCommitCommand").f(void 0, void 0).ser(se_CreateUnreferencedMergeCommitCommand).de(de_CreateUnreferencedMergeCommitCommand).build() {
  static {
    __name(this, "CreateUnreferencedMergeCommitCommand");
  }
};

// src/commands/DeleteApprovalRuleTemplateCommand.ts



var DeleteApprovalRuleTemplateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "DeleteApprovalRuleTemplate", {}).n("CodeCommitClient", "DeleteApprovalRuleTemplateCommand").f(void 0, void 0).ser(se_DeleteApprovalRuleTemplateCommand).de(de_DeleteApprovalRuleTemplateCommand).build() {
  static {
    __name(this, "DeleteApprovalRuleTemplateCommand");
  }
};

// src/commands/DeleteBranchCommand.ts



var DeleteBranchCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "DeleteBranch", {}).n("CodeCommitClient", "DeleteBranchCommand").f(void 0, void 0).ser(se_DeleteBranchCommand).de(de_DeleteBranchCommand).build() {
  static {
    __name(this, "DeleteBranchCommand");
  }
};

// src/commands/DeleteCommentContentCommand.ts



var DeleteCommentContentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "DeleteCommentContent", {}).n("CodeCommitClient", "DeleteCommentContentCommand").f(void 0, void 0).ser(se_DeleteCommentContentCommand).de(de_DeleteCommentContentCommand).build() {
  static {
    __name(this, "DeleteCommentContentCommand");
  }
};

// src/commands/DeleteFileCommand.ts



var DeleteFileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "DeleteFile", {}).n("CodeCommitClient", "DeleteFileCommand").f(void 0, void 0).ser(se_DeleteFileCommand).de(de_DeleteFileCommand).build() {
  static {
    __name(this, "DeleteFileCommand");
  }
};

// src/commands/DeletePullRequestApprovalRuleCommand.ts



var DeletePullRequestApprovalRuleCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "DeletePullRequestApprovalRule", {}).n("CodeCommitClient", "DeletePullRequestApprovalRuleCommand").f(void 0, void 0).ser(se_DeletePullRequestApprovalRuleCommand).de(de_DeletePullRequestApprovalRuleCommand).build() {
  static {
    __name(this, "DeletePullRequestApprovalRuleCommand");
  }
};

// src/commands/DeleteRepositoryCommand.ts



var DeleteRepositoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "DeleteRepository", {}).n("CodeCommitClient", "DeleteRepositoryCommand").f(void 0, void 0).ser(se_DeleteRepositoryCommand).de(de_DeleteRepositoryCommand).build() {
  static {
    __name(this, "DeleteRepositoryCommand");
  }
};

// src/commands/DescribeMergeConflictsCommand.ts



var DescribeMergeConflictsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "DescribeMergeConflicts", {}).n("CodeCommitClient", "DescribeMergeConflictsCommand").f(void 0, void 0).ser(se_DescribeMergeConflictsCommand).de(de_DescribeMergeConflictsCommand).build() {
  static {
    __name(this, "DescribeMergeConflictsCommand");
  }
};

// src/commands/DescribePullRequestEventsCommand.ts



var DescribePullRequestEventsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "DescribePullRequestEvents", {}).n("CodeCommitClient", "DescribePullRequestEventsCommand").f(void 0, void 0).ser(se_DescribePullRequestEventsCommand).de(de_DescribePullRequestEventsCommand).build() {
  static {
    __name(this, "DescribePullRequestEventsCommand");
  }
};

// src/commands/DisassociateApprovalRuleTemplateFromRepositoryCommand.ts



var DisassociateApprovalRuleTemplateFromRepositoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "DisassociateApprovalRuleTemplateFromRepository", {}).n("CodeCommitClient", "DisassociateApprovalRuleTemplateFromRepositoryCommand").f(void 0, void 0).ser(se_DisassociateApprovalRuleTemplateFromRepositoryCommand).de(de_DisassociateApprovalRuleTemplateFromRepositoryCommand).build() {
  static {
    __name(this, "DisassociateApprovalRuleTemplateFromRepositoryCommand");
  }
};

// src/commands/EvaluatePullRequestApprovalRulesCommand.ts



var EvaluatePullRequestApprovalRulesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "EvaluatePullRequestApprovalRules", {}).n("CodeCommitClient", "EvaluatePullRequestApprovalRulesCommand").f(void 0, void 0).ser(se_EvaluatePullRequestApprovalRulesCommand).de(de_EvaluatePullRequestApprovalRulesCommand).build() {
  static {
    __name(this, "EvaluatePullRequestApprovalRulesCommand");
  }
};

// src/commands/GetApprovalRuleTemplateCommand.ts



var GetApprovalRuleTemplateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetApprovalRuleTemplate", {}).n("CodeCommitClient", "GetApprovalRuleTemplateCommand").f(void 0, void 0).ser(se_GetApprovalRuleTemplateCommand).de(de_GetApprovalRuleTemplateCommand).build() {
  static {
    __name(this, "GetApprovalRuleTemplateCommand");
  }
};

// src/commands/GetBlobCommand.ts



var GetBlobCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetBlob", {}).n("CodeCommitClient", "GetBlobCommand").f(void 0, void 0).ser(se_GetBlobCommand).de(de_GetBlobCommand).build() {
  static {
    __name(this, "GetBlobCommand");
  }
};

// src/commands/GetBranchCommand.ts



var GetBranchCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetBranch", {}).n("CodeCommitClient", "GetBranchCommand").f(void 0, void 0).ser(se_GetBranchCommand).de(de_GetBranchCommand).build() {
  static {
    __name(this, "GetBranchCommand");
  }
};

// src/commands/GetCommentCommand.ts



var GetCommentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetComment", {}).n("CodeCommitClient", "GetCommentCommand").f(void 0, void 0).ser(se_GetCommentCommand).de(de_GetCommentCommand).build() {
  static {
    __name(this, "GetCommentCommand");
  }
};

// src/commands/GetCommentReactionsCommand.ts



var GetCommentReactionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetCommentReactions", {}).n("CodeCommitClient", "GetCommentReactionsCommand").f(void 0, void 0).ser(se_GetCommentReactionsCommand).de(de_GetCommentReactionsCommand).build() {
  static {
    __name(this, "GetCommentReactionsCommand");
  }
};

// src/commands/GetCommentsForComparedCommitCommand.ts



var GetCommentsForComparedCommitCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetCommentsForComparedCommit", {}).n("CodeCommitClient", "GetCommentsForComparedCommitCommand").f(void 0, void 0).ser(se_GetCommentsForComparedCommitCommand).de(de_GetCommentsForComparedCommitCommand).build() {
  static {
    __name(this, "GetCommentsForComparedCommitCommand");
  }
};

// src/commands/GetCommentsForPullRequestCommand.ts



var GetCommentsForPullRequestCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetCommentsForPullRequest", {}).n("CodeCommitClient", "GetCommentsForPullRequestCommand").f(void 0, void 0).ser(se_GetCommentsForPullRequestCommand).de(de_GetCommentsForPullRequestCommand).build() {
  static {
    __name(this, "GetCommentsForPullRequestCommand");
  }
};

// src/commands/GetCommitCommand.ts



var GetCommitCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetCommit", {}).n("CodeCommitClient", "GetCommitCommand").f(void 0, void 0).ser(se_GetCommitCommand).de(de_GetCommitCommand).build() {
  static {
    __name(this, "GetCommitCommand");
  }
};

// src/commands/GetDifferencesCommand.ts



var GetDifferencesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetDifferences", {}).n("CodeCommitClient", "GetDifferencesCommand").f(void 0, void 0).ser(se_GetDifferencesCommand).de(de_GetDifferencesCommand).build() {
  static {
    __name(this, "GetDifferencesCommand");
  }
};

// src/commands/GetFileCommand.ts



var GetFileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetFile", {}).n("CodeCommitClient", "GetFileCommand").f(void 0, void 0).ser(se_GetFileCommand).de(de_GetFileCommand).build() {
  static {
    __name(this, "GetFileCommand");
  }
};

// src/commands/GetFolderCommand.ts



var GetFolderCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetFolder", {}).n("CodeCommitClient", "GetFolderCommand").f(void 0, void 0).ser(se_GetFolderCommand).de(de_GetFolderCommand).build() {
  static {
    __name(this, "GetFolderCommand");
  }
};

// src/commands/GetMergeCommitCommand.ts



var GetMergeCommitCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetMergeCommit", {}).n("CodeCommitClient", "GetMergeCommitCommand").f(void 0, void 0).ser(se_GetMergeCommitCommand).de(de_GetMergeCommitCommand).build() {
  static {
    __name(this, "GetMergeCommitCommand");
  }
};

// src/commands/GetMergeConflictsCommand.ts



var GetMergeConflictsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetMergeConflicts", {}).n("CodeCommitClient", "GetMergeConflictsCommand").f(void 0, void 0).ser(se_GetMergeConflictsCommand).de(de_GetMergeConflictsCommand).build() {
  static {
    __name(this, "GetMergeConflictsCommand");
  }
};

// src/commands/GetMergeOptionsCommand.ts



var GetMergeOptionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetMergeOptions", {}).n("CodeCommitClient", "GetMergeOptionsCommand").f(void 0, void 0).ser(se_GetMergeOptionsCommand).de(de_GetMergeOptionsCommand).build() {
  static {
    __name(this, "GetMergeOptionsCommand");
  }
};

// src/commands/GetPullRequestApprovalStatesCommand.ts



var GetPullRequestApprovalStatesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetPullRequestApprovalStates", {}).n("CodeCommitClient", "GetPullRequestApprovalStatesCommand").f(void 0, void 0).ser(se_GetPullRequestApprovalStatesCommand).de(de_GetPullRequestApprovalStatesCommand).build() {
  static {
    __name(this, "GetPullRequestApprovalStatesCommand");
  }
};

// src/commands/GetPullRequestCommand.ts



var GetPullRequestCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetPullRequest", {}).n("CodeCommitClient", "GetPullRequestCommand").f(void 0, void 0).ser(se_GetPullRequestCommand).de(de_GetPullRequestCommand).build() {
  static {
    __name(this, "GetPullRequestCommand");
  }
};

// src/commands/GetPullRequestOverrideStateCommand.ts



var GetPullRequestOverrideStateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetPullRequestOverrideState", {}).n("CodeCommitClient", "GetPullRequestOverrideStateCommand").f(void 0, void 0).ser(se_GetPullRequestOverrideStateCommand).de(de_GetPullRequestOverrideStateCommand).build() {
  static {
    __name(this, "GetPullRequestOverrideStateCommand");
  }
};

// src/commands/GetRepositoryCommand.ts



var GetRepositoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetRepository", {}).n("CodeCommitClient", "GetRepositoryCommand").f(void 0, void 0).ser(se_GetRepositoryCommand).de(de_GetRepositoryCommand).build() {
  static {
    __name(this, "GetRepositoryCommand");
  }
};

// src/commands/GetRepositoryTriggersCommand.ts



var GetRepositoryTriggersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "GetRepositoryTriggers", {}).n("CodeCommitClient", "GetRepositoryTriggersCommand").f(void 0, void 0).ser(se_GetRepositoryTriggersCommand).de(de_GetRepositoryTriggersCommand).build() {
  static {
    __name(this, "GetRepositoryTriggersCommand");
  }
};

// src/commands/ListApprovalRuleTemplatesCommand.ts



var ListApprovalRuleTemplatesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "ListApprovalRuleTemplates", {}).n("CodeCommitClient", "ListApprovalRuleTemplatesCommand").f(void 0, void 0).ser(se_ListApprovalRuleTemplatesCommand).de(de_ListApprovalRuleTemplatesCommand).build() {
  static {
    __name(this, "ListApprovalRuleTemplatesCommand");
  }
};

// src/commands/ListAssociatedApprovalRuleTemplatesForRepositoryCommand.ts



var ListAssociatedApprovalRuleTemplatesForRepositoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "ListAssociatedApprovalRuleTemplatesForRepository", {}).n("CodeCommitClient", "ListAssociatedApprovalRuleTemplatesForRepositoryCommand").f(void 0, void 0).ser(se_ListAssociatedApprovalRuleTemplatesForRepositoryCommand).de(de_ListAssociatedApprovalRuleTemplatesForRepositoryCommand).build() {
  static {
    __name(this, "ListAssociatedApprovalRuleTemplatesForRepositoryCommand");
  }
};

// src/commands/ListBranchesCommand.ts



var ListBranchesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "ListBranches", {}).n("CodeCommitClient", "ListBranchesCommand").f(void 0, void 0).ser(se_ListBranchesCommand).de(de_ListBranchesCommand).build() {
  static {
    __name(this, "ListBranchesCommand");
  }
};

// src/commands/ListFileCommitHistoryCommand.ts



var ListFileCommitHistoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "ListFileCommitHistory", {}).n("CodeCommitClient", "ListFileCommitHistoryCommand").f(void 0, void 0).ser(se_ListFileCommitHistoryCommand).de(de_ListFileCommitHistoryCommand).build() {
  static {
    __name(this, "ListFileCommitHistoryCommand");
  }
};

// src/commands/ListPullRequestsCommand.ts



var ListPullRequestsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "ListPullRequests", {}).n("CodeCommitClient", "ListPullRequestsCommand").f(void 0, void 0).ser(se_ListPullRequestsCommand).de(de_ListPullRequestsCommand).build() {
  static {
    __name(this, "ListPullRequestsCommand");
  }
};

// src/commands/ListRepositoriesCommand.ts



var ListRepositoriesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "ListRepositories", {}).n("CodeCommitClient", "ListRepositoriesCommand").f(void 0, void 0).ser(se_ListRepositoriesCommand).de(de_ListRepositoriesCommand).build() {
  static {
    __name(this, "ListRepositoriesCommand");
  }
};

// src/commands/ListRepositoriesForApprovalRuleTemplateCommand.ts



var ListRepositoriesForApprovalRuleTemplateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "ListRepositoriesForApprovalRuleTemplate", {}).n("CodeCommitClient", "ListRepositoriesForApprovalRuleTemplateCommand").f(void 0, void 0).ser(se_ListRepositoriesForApprovalRuleTemplateCommand).de(de_ListRepositoriesForApprovalRuleTemplateCommand).build() {
  static {
    __name(this, "ListRepositoriesForApprovalRuleTemplateCommand");
  }
};

// src/commands/ListTagsForResourceCommand.ts



var ListTagsForResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "ListTagsForResource", {}).n("CodeCommitClient", "ListTagsForResourceCommand").f(void 0, void 0).ser(se_ListTagsForResourceCommand).de(de_ListTagsForResourceCommand).build() {
  static {
    __name(this, "ListTagsForResourceCommand");
  }
};

// src/commands/MergeBranchesByFastForwardCommand.ts



var MergeBranchesByFastForwardCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "MergeBranchesByFastForward", {}).n("CodeCommitClient", "MergeBranchesByFastForwardCommand").f(void 0, void 0).ser(se_MergeBranchesByFastForwardCommand).de(de_MergeBranchesByFastForwardCommand).build() {
  static {
    __name(this, "MergeBranchesByFastForwardCommand");
  }
};

// src/commands/MergeBranchesBySquashCommand.ts



var MergeBranchesBySquashCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "MergeBranchesBySquash", {}).n("CodeCommitClient", "MergeBranchesBySquashCommand").f(void 0, void 0).ser(se_MergeBranchesBySquashCommand).de(de_MergeBranchesBySquashCommand).build() {
  static {
    __name(this, "MergeBranchesBySquashCommand");
  }
};

// src/commands/MergeBranchesByThreeWayCommand.ts



var MergeBranchesByThreeWayCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "MergeBranchesByThreeWay", {}).n("CodeCommitClient", "MergeBranchesByThreeWayCommand").f(void 0, void 0).ser(se_MergeBranchesByThreeWayCommand).de(de_MergeBranchesByThreeWayCommand).build() {
  static {
    __name(this, "MergeBranchesByThreeWayCommand");
  }
};

// src/commands/MergePullRequestByFastForwardCommand.ts



var MergePullRequestByFastForwardCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "MergePullRequestByFastForward", {}).n("CodeCommitClient", "MergePullRequestByFastForwardCommand").f(void 0, void 0).ser(se_MergePullRequestByFastForwardCommand).de(de_MergePullRequestByFastForwardCommand).build() {
  static {
    __name(this, "MergePullRequestByFastForwardCommand");
  }
};

// src/commands/MergePullRequestBySquashCommand.ts



var MergePullRequestBySquashCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "MergePullRequestBySquash", {}).n("CodeCommitClient", "MergePullRequestBySquashCommand").f(void 0, void 0).ser(se_MergePullRequestBySquashCommand).de(de_MergePullRequestBySquashCommand).build() {
  static {
    __name(this, "MergePullRequestBySquashCommand");
  }
};

// src/commands/MergePullRequestByThreeWayCommand.ts



var MergePullRequestByThreeWayCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "MergePullRequestByThreeWay", {}).n("CodeCommitClient", "MergePullRequestByThreeWayCommand").f(void 0, void 0).ser(se_MergePullRequestByThreeWayCommand).de(de_MergePullRequestByThreeWayCommand).build() {
  static {
    __name(this, "MergePullRequestByThreeWayCommand");
  }
};

// src/commands/OverridePullRequestApprovalRulesCommand.ts



var OverridePullRequestApprovalRulesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "OverridePullRequestApprovalRules", {}).n("CodeCommitClient", "OverridePullRequestApprovalRulesCommand").f(void 0, void 0).ser(se_OverridePullRequestApprovalRulesCommand).de(de_OverridePullRequestApprovalRulesCommand).build() {
  static {
    __name(this, "OverridePullRequestApprovalRulesCommand");
  }
};

// src/commands/PostCommentForComparedCommitCommand.ts



var PostCommentForComparedCommitCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "PostCommentForComparedCommit", {}).n("CodeCommitClient", "PostCommentForComparedCommitCommand").f(void 0, void 0).ser(se_PostCommentForComparedCommitCommand).de(de_PostCommentForComparedCommitCommand).build() {
  static {
    __name(this, "PostCommentForComparedCommitCommand");
  }
};

// src/commands/PostCommentForPullRequestCommand.ts



var PostCommentForPullRequestCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "PostCommentForPullRequest", {}).n("CodeCommitClient", "PostCommentForPullRequestCommand").f(void 0, void 0).ser(se_PostCommentForPullRequestCommand).de(de_PostCommentForPullRequestCommand).build() {
  static {
    __name(this, "PostCommentForPullRequestCommand");
  }
};

// src/commands/PostCommentReplyCommand.ts



var PostCommentReplyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "PostCommentReply", {}).n("CodeCommitClient", "PostCommentReplyCommand").f(void 0, void 0).ser(se_PostCommentReplyCommand).de(de_PostCommentReplyCommand).build() {
  static {
    __name(this, "PostCommentReplyCommand");
  }
};

// src/commands/PutCommentReactionCommand.ts



var PutCommentReactionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "PutCommentReaction", {}).n("CodeCommitClient", "PutCommentReactionCommand").f(void 0, void 0).ser(se_PutCommentReactionCommand).de(de_PutCommentReactionCommand).build() {
  static {
    __name(this, "PutCommentReactionCommand");
  }
};

// src/commands/PutFileCommand.ts



var PutFileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "PutFile", {}).n("CodeCommitClient", "PutFileCommand").f(void 0, void 0).ser(se_PutFileCommand).de(de_PutFileCommand).build() {
  static {
    __name(this, "PutFileCommand");
  }
};

// src/commands/PutRepositoryTriggersCommand.ts



var PutRepositoryTriggersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "PutRepositoryTriggers", {}).n("CodeCommitClient", "PutRepositoryTriggersCommand").f(void 0, void 0).ser(se_PutRepositoryTriggersCommand).de(de_PutRepositoryTriggersCommand).build() {
  static {
    __name(this, "PutRepositoryTriggersCommand");
  }
};

// src/commands/TagResourceCommand.ts



var TagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "TagResource", {}).n("CodeCommitClient", "TagResourceCommand").f(void 0, void 0).ser(se_TagResourceCommand).de(de_TagResourceCommand).build() {
  static {
    __name(this, "TagResourceCommand");
  }
};

// src/commands/TestRepositoryTriggersCommand.ts



var TestRepositoryTriggersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "TestRepositoryTriggers", {}).n("CodeCommitClient", "TestRepositoryTriggersCommand").f(void 0, void 0).ser(se_TestRepositoryTriggersCommand).de(de_TestRepositoryTriggersCommand).build() {
  static {
    __name(this, "TestRepositoryTriggersCommand");
  }
};

// src/commands/UntagResourceCommand.ts



var UntagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UntagResource", {}).n("CodeCommitClient", "UntagResourceCommand").f(void 0, void 0).ser(se_UntagResourceCommand).de(de_UntagResourceCommand).build() {
  static {
    __name(this, "UntagResourceCommand");
  }
};

// src/commands/UpdateApprovalRuleTemplateContentCommand.ts



var UpdateApprovalRuleTemplateContentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdateApprovalRuleTemplateContent", {}).n("CodeCommitClient", "UpdateApprovalRuleTemplateContentCommand").f(void 0, void 0).ser(se_UpdateApprovalRuleTemplateContentCommand).de(de_UpdateApprovalRuleTemplateContentCommand).build() {
  static {
    __name(this, "UpdateApprovalRuleTemplateContentCommand");
  }
};

// src/commands/UpdateApprovalRuleTemplateDescriptionCommand.ts



var UpdateApprovalRuleTemplateDescriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdateApprovalRuleTemplateDescription", {}).n("CodeCommitClient", "UpdateApprovalRuleTemplateDescriptionCommand").f(void 0, void 0).ser(se_UpdateApprovalRuleTemplateDescriptionCommand).de(de_UpdateApprovalRuleTemplateDescriptionCommand).build() {
  static {
    __name(this, "UpdateApprovalRuleTemplateDescriptionCommand");
  }
};

// src/commands/UpdateApprovalRuleTemplateNameCommand.ts



var UpdateApprovalRuleTemplateNameCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdateApprovalRuleTemplateName", {}).n("CodeCommitClient", "UpdateApprovalRuleTemplateNameCommand").f(void 0, void 0).ser(se_UpdateApprovalRuleTemplateNameCommand).de(de_UpdateApprovalRuleTemplateNameCommand).build() {
  static {
    __name(this, "UpdateApprovalRuleTemplateNameCommand");
  }
};

// src/commands/UpdateCommentCommand.ts



var UpdateCommentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdateComment", {}).n("CodeCommitClient", "UpdateCommentCommand").f(void 0, void 0).ser(se_UpdateCommentCommand).de(de_UpdateCommentCommand).build() {
  static {
    __name(this, "UpdateCommentCommand");
  }
};

// src/commands/UpdateDefaultBranchCommand.ts



var UpdateDefaultBranchCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdateDefaultBranch", {}).n("CodeCommitClient", "UpdateDefaultBranchCommand").f(void 0, void 0).ser(se_UpdateDefaultBranchCommand).de(de_UpdateDefaultBranchCommand).build() {
  static {
    __name(this, "UpdateDefaultBranchCommand");
  }
};

// src/commands/UpdatePullRequestApprovalRuleContentCommand.ts



var UpdatePullRequestApprovalRuleContentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdatePullRequestApprovalRuleContent", {}).n("CodeCommitClient", "UpdatePullRequestApprovalRuleContentCommand").f(void 0, void 0).ser(se_UpdatePullRequestApprovalRuleContentCommand).de(de_UpdatePullRequestApprovalRuleContentCommand).build() {
  static {
    __name(this, "UpdatePullRequestApprovalRuleContentCommand");
  }
};

// src/commands/UpdatePullRequestApprovalStateCommand.ts



var UpdatePullRequestApprovalStateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdatePullRequestApprovalState", {}).n("CodeCommitClient", "UpdatePullRequestApprovalStateCommand").f(void 0, void 0).ser(se_UpdatePullRequestApprovalStateCommand).de(de_UpdatePullRequestApprovalStateCommand).build() {
  static {
    __name(this, "UpdatePullRequestApprovalStateCommand");
  }
};

// src/commands/UpdatePullRequestDescriptionCommand.ts



var UpdatePullRequestDescriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdatePullRequestDescription", {}).n("CodeCommitClient", "UpdatePullRequestDescriptionCommand").f(void 0, void 0).ser(se_UpdatePullRequestDescriptionCommand).de(de_UpdatePullRequestDescriptionCommand).build() {
  static {
    __name(this, "UpdatePullRequestDescriptionCommand");
  }
};

// src/commands/UpdatePullRequestStatusCommand.ts



var UpdatePullRequestStatusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdatePullRequestStatus", {}).n("CodeCommitClient", "UpdatePullRequestStatusCommand").f(void 0, void 0).ser(se_UpdatePullRequestStatusCommand).de(de_UpdatePullRequestStatusCommand).build() {
  static {
    __name(this, "UpdatePullRequestStatusCommand");
  }
};

// src/commands/UpdatePullRequestTitleCommand.ts



var UpdatePullRequestTitleCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdatePullRequestTitle", {}).n("CodeCommitClient", "UpdatePullRequestTitleCommand").f(void 0, void 0).ser(se_UpdatePullRequestTitleCommand).de(de_UpdatePullRequestTitleCommand).build() {
  static {
    __name(this, "UpdatePullRequestTitleCommand");
  }
};

// src/commands/UpdateRepositoryDescriptionCommand.ts



var UpdateRepositoryDescriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdateRepositoryDescription", {}).n("CodeCommitClient", "UpdateRepositoryDescriptionCommand").f(void 0, void 0).ser(se_UpdateRepositoryDescriptionCommand).de(de_UpdateRepositoryDescriptionCommand).build() {
  static {
    __name(this, "UpdateRepositoryDescriptionCommand");
  }
};

// src/commands/UpdateRepositoryEncryptionKeyCommand.ts



var UpdateRepositoryEncryptionKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdateRepositoryEncryptionKey", {}).n("CodeCommitClient", "UpdateRepositoryEncryptionKeyCommand").f(void 0, void 0).ser(se_UpdateRepositoryEncryptionKeyCommand).de(de_UpdateRepositoryEncryptionKeyCommand).build() {
  static {
    __name(this, "UpdateRepositoryEncryptionKeyCommand");
  }
};

// src/commands/UpdateRepositoryNameCommand.ts



var UpdateRepositoryNameCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CodeCommit_20150413", "UpdateRepositoryName", {}).n("CodeCommitClient", "UpdateRepositoryNameCommand").f(void 0, void 0).ser(se_UpdateRepositoryNameCommand).de(de_UpdateRepositoryNameCommand).build() {
  static {
    __name(this, "UpdateRepositoryNameCommand");
  }
};

// src/CodeCommit.ts
var commands = {
  AssociateApprovalRuleTemplateWithRepositoryCommand,
  BatchAssociateApprovalRuleTemplateWithRepositoriesCommand,
  BatchDescribeMergeConflictsCommand,
  BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand,
  BatchGetCommitsCommand,
  BatchGetRepositoriesCommand,
  CreateApprovalRuleTemplateCommand,
  CreateBranchCommand,
  CreateCommitCommand,
  CreatePullRequestCommand,
  CreatePullRequestApprovalRuleCommand,
  CreateRepositoryCommand,
  CreateUnreferencedMergeCommitCommand,
  DeleteApprovalRuleTemplateCommand,
  DeleteBranchCommand,
  DeleteCommentContentCommand,
  DeleteFileCommand,
  DeletePullRequestApprovalRuleCommand,
  DeleteRepositoryCommand,
  DescribeMergeConflictsCommand,
  DescribePullRequestEventsCommand,
  DisassociateApprovalRuleTemplateFromRepositoryCommand,
  EvaluatePullRequestApprovalRulesCommand,
  GetApprovalRuleTemplateCommand,
  GetBlobCommand,
  GetBranchCommand,
  GetCommentCommand,
  GetCommentReactionsCommand,
  GetCommentsForComparedCommitCommand,
  GetCommentsForPullRequestCommand,
  GetCommitCommand,
  GetDifferencesCommand,
  GetFileCommand,
  GetFolderCommand,
  GetMergeCommitCommand,
  GetMergeConflictsCommand,
  GetMergeOptionsCommand,
  GetPullRequestCommand,
  GetPullRequestApprovalStatesCommand,
  GetPullRequestOverrideStateCommand,
  GetRepositoryCommand,
  GetRepositoryTriggersCommand,
  ListApprovalRuleTemplatesCommand,
  ListAssociatedApprovalRuleTemplatesForRepositoryCommand,
  ListBranchesCommand,
  ListFileCommitHistoryCommand,
  ListPullRequestsCommand,
  ListRepositoriesCommand,
  ListRepositoriesForApprovalRuleTemplateCommand,
  ListTagsForResourceCommand,
  MergeBranchesByFastForwardCommand,
  MergeBranchesBySquashCommand,
  MergeBranchesByThreeWayCommand,
  MergePullRequestByFastForwardCommand,
  MergePullRequestBySquashCommand,
  MergePullRequestByThreeWayCommand,
  OverridePullRequestApprovalRulesCommand,
  PostCommentForComparedCommitCommand,
  PostCommentForPullRequestCommand,
  PostCommentReplyCommand,
  PutCommentReactionCommand,
  PutFileCommand,
  PutRepositoryTriggersCommand,
  TagResourceCommand,
  TestRepositoryTriggersCommand,
  UntagResourceCommand,
  UpdateApprovalRuleTemplateContentCommand,
  UpdateApprovalRuleTemplateDescriptionCommand,
  UpdateApprovalRuleTemplateNameCommand,
  UpdateCommentCommand,
  UpdateDefaultBranchCommand,
  UpdatePullRequestApprovalRuleContentCommand,
  UpdatePullRequestApprovalStateCommand,
  UpdatePullRequestDescriptionCommand,
  UpdatePullRequestStatusCommand,
  UpdatePullRequestTitleCommand,
  UpdateRepositoryDescriptionCommand,
  UpdateRepositoryEncryptionKeyCommand,
  UpdateRepositoryNameCommand
};
var CodeCommit = class extends CodeCommitClient {
  static {
    __name(this, "CodeCommit");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, CodeCommit);

// src/pagination/DescribeMergeConflictsPaginator.ts

var paginateDescribeMergeConflicts = (0, import_core.createPaginator)(CodeCommitClient, DescribeMergeConflictsCommand, "nextToken", "nextToken", "maxMergeHunks");

// src/pagination/DescribePullRequestEventsPaginator.ts

var paginateDescribePullRequestEvents = (0, import_core.createPaginator)(CodeCommitClient, DescribePullRequestEventsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/GetCommentReactionsPaginator.ts

var paginateGetCommentReactions = (0, import_core.createPaginator)(CodeCommitClient, GetCommentReactionsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/GetCommentsForComparedCommitPaginator.ts

var paginateGetCommentsForComparedCommit = (0, import_core.createPaginator)(CodeCommitClient, GetCommentsForComparedCommitCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/GetCommentsForPullRequestPaginator.ts

var paginateGetCommentsForPullRequest = (0, import_core.createPaginator)(CodeCommitClient, GetCommentsForPullRequestCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/GetDifferencesPaginator.ts

var paginateGetDifferences = (0, import_core.createPaginator)(CodeCommitClient, GetDifferencesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/GetMergeConflictsPaginator.ts

var paginateGetMergeConflicts = (0, import_core.createPaginator)(CodeCommitClient, GetMergeConflictsCommand, "nextToken", "nextToken", "maxConflictFiles");

// src/pagination/ListApprovalRuleTemplatesPaginator.ts

var paginateListApprovalRuleTemplates = (0, import_core.createPaginator)(CodeCommitClient, ListApprovalRuleTemplatesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListAssociatedApprovalRuleTemplatesForRepositoryPaginator.ts

var paginateListAssociatedApprovalRuleTemplatesForRepository = (0, import_core.createPaginator)(CodeCommitClient, ListAssociatedApprovalRuleTemplatesForRepositoryCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListBranchesPaginator.ts

var paginateListBranches = (0, import_core.createPaginator)(CodeCommitClient, ListBranchesCommand, "nextToken", "nextToken", "");

// src/pagination/ListFileCommitHistoryPaginator.ts

var paginateListFileCommitHistory = (0, import_core.createPaginator)(CodeCommitClient, ListFileCommitHistoryCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListPullRequestsPaginator.ts

var paginateListPullRequests = (0, import_core.createPaginator)(CodeCommitClient, ListPullRequestsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListRepositoriesForApprovalRuleTemplatePaginator.ts

var paginateListRepositoriesForApprovalRuleTemplate = (0, import_core.createPaginator)(CodeCommitClient, ListRepositoriesForApprovalRuleTemplateCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListRepositoriesPaginator.ts

var paginateListRepositories = (0, import_core.createPaginator)(CodeCommitClient, ListRepositoriesCommand, "nextToken", "nextToken", "");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  CodeCommitServiceException,
  __Client,
  CodeCommitClient,
  CodeCommit,
  $Command,
  AssociateApprovalRuleTemplateWithRepositoryCommand,
  BatchAssociateApprovalRuleTemplateWithRepositoriesCommand,
  BatchDescribeMergeConflictsCommand,
  BatchDisassociateApprovalRuleTemplateFromRepositoriesCommand,
  BatchGetCommitsCommand,
  BatchGetRepositoriesCommand,
  CreateApprovalRuleTemplateCommand,
  CreateBranchCommand,
  CreateCommitCommand,
  CreatePullRequestApprovalRuleCommand,
  CreatePullRequestCommand,
  CreateRepositoryCommand,
  CreateUnreferencedMergeCommitCommand,
  DeleteApprovalRuleTemplateCommand,
  DeleteBranchCommand,
  DeleteCommentContentCommand,
  DeleteFileCommand,
  DeletePullRequestApprovalRuleCommand,
  DeleteRepositoryCommand,
  DescribeMergeConflictsCommand,
  DescribePullRequestEventsCommand,
  DisassociateApprovalRuleTemplateFromRepositoryCommand,
  EvaluatePullRequestApprovalRulesCommand,
  GetApprovalRuleTemplateCommand,
  GetBlobCommand,
  GetBranchCommand,
  GetCommentCommand,
  GetCommentReactionsCommand,
  GetCommentsForComparedCommitCommand,
  GetCommentsForPullRequestCommand,
  GetCommitCommand,
  GetDifferencesCommand,
  GetFileCommand,
  GetFolderCommand,
  GetMergeCommitCommand,
  GetMergeConflictsCommand,
  GetMergeOptionsCommand,
  GetPullRequestApprovalStatesCommand,
  GetPullRequestCommand,
  GetPullRequestOverrideStateCommand,
  GetRepositoryCommand,
  GetRepositoryTriggersCommand,
  ListApprovalRuleTemplatesCommand,
  ListAssociatedApprovalRuleTemplatesForRepositoryCommand,
  ListBranchesCommand,
  ListFileCommitHistoryCommand,
  ListPullRequestsCommand,
  ListRepositoriesCommand,
  ListRepositoriesForApprovalRuleTemplateCommand,
  ListTagsForResourceCommand,
  MergeBranchesByFastForwardCommand,
  MergeBranchesBySquashCommand,
  MergeBranchesByThreeWayCommand,
  MergePullRequestByFastForwardCommand,
  MergePullRequestBySquashCommand,
  MergePullRequestByThreeWayCommand,
  OverridePullRequestApprovalRulesCommand,
  PostCommentForComparedCommitCommand,
  PostCommentForPullRequestCommand,
  PostCommentReplyCommand,
  PutCommentReactionCommand,
  PutFileCommand,
  PutRepositoryTriggersCommand,
  TagResourceCommand,
  TestRepositoryTriggersCommand,
  UntagResourceCommand,
  UpdateApprovalRuleTemplateContentCommand,
  UpdateApprovalRuleTemplateDescriptionCommand,
  UpdateApprovalRuleTemplateNameCommand,
  UpdateCommentCommand,
  UpdateDefaultBranchCommand,
  UpdatePullRequestApprovalRuleContentCommand,
  UpdatePullRequestApprovalStateCommand,
  UpdatePullRequestDescriptionCommand,
  UpdatePullRequestStatusCommand,
  UpdatePullRequestTitleCommand,
  UpdateRepositoryDescriptionCommand,
  UpdateRepositoryEncryptionKeyCommand,
  UpdateRepositoryNameCommand,
  paginateDescribeMergeConflicts,
  paginateDescribePullRequestEvents,
  paginateGetCommentReactions,
  paginateGetCommentsForComparedCommit,
  paginateGetCommentsForPullRequest,
  paginateGetDifferences,
  paginateGetMergeConflicts,
  paginateListApprovalRuleTemplates,
  paginateListAssociatedApprovalRuleTemplatesForRepository,
  paginateListBranches,
  paginateListFileCommitHistory,
  paginateListPullRequests,
  paginateListRepositoriesForApprovalRuleTemplate,
  paginateListRepositories,
  ActorDoesNotExistException,
  ApprovalState,
  ApprovalRuleContentRequiredException,
  ApprovalRuleDoesNotExistException,
  ApprovalRuleNameAlreadyExistsException,
  ApprovalRuleNameRequiredException,
  OverrideStatus,
  ApprovalRuleTemplateContentRequiredException,
  ApprovalRuleTemplateDoesNotExistException,
  ApprovalRuleTemplateInUseException,
  ApprovalRuleTemplateNameAlreadyExistsException,
  ApprovalRuleTemplateNameRequiredException,
  ApprovalStateRequiredException,
  EncryptionIntegrityChecksFailedException,
  EncryptionKeyAccessDeniedException,
  EncryptionKeyDisabledException,
  EncryptionKeyNotFoundException,
  EncryptionKeyUnavailableException,
  InvalidApprovalRuleTemplateNameException,
  InvalidRepositoryNameException,
  MaximumRuleTemplatesAssociatedWithRepositoryException,
  RepositoryDoesNotExistException,
  RepositoryNameRequiredException,
  AuthorDoesNotExistException,
  MaximumRepositoryNamesExceededException,
  RepositoryNamesRequiredException,
  ConflictDetailLevelTypeEnum,
  ConflictResolutionStrategyTypeEnum,
  MergeOptionTypeEnum,
  FileModeTypeEnum,
  ChangeTypeEnum,
  ObjectTypeEnum,
  CommitDoesNotExistException,
  CommitRequiredException,
  InvalidCommitException,
  InvalidConflictDetailLevelException,
  InvalidConflictResolutionStrategyException,
  InvalidContinuationTokenException,
  InvalidMaxConflictFilesException,
  InvalidMaxMergeHunksException,
  InvalidMergeOptionException,
  MaximumFileContentToLoadExceededException,
  MaximumItemsToCompareExceededException,
  MergeOptionRequiredException,
  TipsDivergenceExceededException,
  CommitIdsLimitExceededException,
  CommitIdsListRequiredException,
  BatchGetRepositoriesErrorCodeEnum,
  BeforeCommitIdAndAfterCommitIdAreSameException,
  BlobIdDoesNotExistException,
  BlobIdRequiredException,
  BranchDoesNotExistException,
  BranchNameExistsException,
  BranchNameIsTagNameException,
  BranchNameRequiredException,
  CannotDeleteApprovalRuleFromTemplateException,
  CannotModifyApprovalRuleFromTemplateException,
  ClientRequestTokenRequiredException,
  InvalidApprovalRuleTemplateContentException,
  InvalidApprovalRuleTemplateDescriptionException,
  NumberOfRuleTemplatesExceededException,
  CommitIdRequiredException,
  InvalidBranchNameException,
  InvalidCommitIdException,
  CommitMessageLengthExceededException,
  DirectoryNameConflictsWithFileNameException,
  FileContentAndSourceFileSpecifiedException,
  FileContentSizeLimitExceededException,
  FileDoesNotExistException,
  FileEntryRequiredException,
  FileModeRequiredException,
  FileNameConflictsWithDirectoryNameException,
  FilePathConflictsWithSubmodulePathException,
  FolderContentSizeLimitExceededException,
  InvalidDeletionParameterException,
  InvalidEmailException,
  InvalidFileModeException,
  InvalidParentCommitIdException,
  InvalidPathException,
  MaximumFileEntriesExceededException,
  NameLengthExceededException,
  NoChangeException,
  ParentCommitDoesNotExistException,
  ParentCommitIdOutdatedException,
  ParentCommitIdRequiredException,
  PathRequiredException,
  PutFileEntryConflictException,
  RestrictedSourceFileException,
  SamePathRequestException,
  SourceFileOrContentRequiredException,
  PullRequestStatusEnum,
  IdempotencyParameterMismatchException,
  InvalidClientRequestTokenException,
  InvalidDescriptionException,
  InvalidReferenceNameException,
  InvalidTargetException,
  InvalidTargetsException,
  InvalidTitleException,
  MaximumOpenPullRequestsExceededException,
  MultipleRepositoriesInPullRequestException,
  ReferenceDoesNotExistException,
  ReferenceNameRequiredException,
  ReferenceTypeNotSupportedException,
  SourceAndDestinationAreSameException,
  TargetRequiredException,
  TargetsRequiredException,
  TitleRequiredException,
  InvalidApprovalRuleContentException,
  InvalidApprovalRuleNameException,
  InvalidPullRequestIdException,
  NumberOfRulesExceededException,
  PullRequestAlreadyClosedException,
  PullRequestDoesNotExistException,
  PullRequestIdRequiredException,
  EncryptionKeyInvalidIdException,
  EncryptionKeyInvalidUsageException,
  InvalidRepositoryDescriptionException,
  InvalidSystemTagUsageException,
  InvalidTagsMapException,
  OperationNotAllowedException,
  RepositoryLimitExceededException,
  RepositoryNameExistsException,
  TagPolicyException,
  TooManyTagsException,
  ConcurrentReferenceUpdateException,
  ReplacementTypeEnum,
  InvalidConflictResolutionException,
  InvalidReplacementContentException,
  InvalidReplacementTypeException,
  ManualMergeRequiredException,
  MaximumConflictResolutionEntriesExceededException,
  MultipleConflictResolutionEntriesException,
  ReplacementContentRequiredException,
  ReplacementTypeRequiredException,
  DefaultBranchCannotBeDeletedException,
  CommentDeletedException,
  CommentDoesNotExistException,
  CommentIdRequiredException,
  InvalidCommentIdException,
  PullRequestEventType,
  InvalidActorArnException,
  InvalidMaxResultsException,
  InvalidPullRequestEventTypeException,
  InvalidRevisionIdException,
  RevisionIdRequiredException,
  RevisionNotCurrentException,
  FileTooLargeException,
  InvalidBlobIdException,
  InvalidReactionUserArnException,
  RelativeFileVersionEnum,
  RepositoryNotAssociatedWithPullRequestException,
  CommitIdDoesNotExistException,
  PathDoesNotExistException,
  FolderDoesNotExistException,
  InvalidDestinationCommitSpecifierException,
  InvalidSourceCommitSpecifierException,
  RepositoryTriggerEventEnum,
  InvalidAuthorArnException,
  InvalidPullRequestStatusException,
  InvalidOrderException,
  InvalidSortByException,
  OrderEnum,
  SortByEnum,
  InvalidResourceArnException,
  ResourceArnRequiredException,
  InvalidTargetBranchException,
  PullRequestApprovalRulesNotSatisfiedException,
  TipOfSourceReferenceIsDifferentException,
  InvalidOverrideStatusException,
  OverrideAlreadySetException,
  OverrideStatusRequiredException,
  CommentContentRequiredException,
  CommentContentSizeLimitExceededException,
  InvalidFileLocationException,
  InvalidFilePositionException,
  InvalidRelativeFileVersionEnumException,
  InvalidReactionValueException,
  ReactionLimitExceededException,
  ReactionValueRequiredException,
  FileContentRequiredException,
  SameFileContentException,
  InvalidRepositoryTriggerBranchNameException,
  InvalidRepositoryTriggerCustomDataException,
  InvalidRepositoryTriggerDestinationArnException,
  InvalidRepositoryTriggerEventsException,
  InvalidRepositoryTriggerNameException,
  InvalidRepositoryTriggerRegionException,
  MaximumBranchesExceededException,
  MaximumRepositoryTriggersExceededException,
  RepositoryTriggerBranchNameListRequiredException,
  RepositoryTriggerDestinationArnRequiredException,
  RepositoryTriggerEventsListRequiredException,
  RepositoryTriggerNameRequiredException,
  RepositoryTriggersListRequiredException,
  TagsMapRequiredException,
  InvalidTagKeysListException,
  TagKeysListRequiredException,
  InvalidRuleContentSha256Exception,
  CommentNotCreatedByCallerException,
  InvalidApprovalStateException,
  MaximumNumberOfApprovalsExceededException,
  PullRequestCannotBeApprovedByAuthorException,
  InvalidPullRequestStatusUpdateException,
  PullRequestStatusRequiredException,
  EncryptionKeyRequiredException
});

