import type { RenovateConfig } from '../../../../config/types';
export declare function prepareLabels(config: RenovateConfig): string[];
/**
 * Determine changed labels between old and new label arrays.
 *
 * This function takes two arrays of labels, 'oldLabels' and 'newLabels', and calculates the labels
 * that need to be added and removed to transition from 'oldLabels' to 'newLabels'.
 */
export declare function getChangedLabels(oldLabels: string[] | undefined, newLabels: string[] | undefined): [string[] | undefined, string[] | undefined];
/**
 * Check if labels in the PR have been modified.
 *
 * This function compares two arrays of labels, 'prInitialLabels' and 'prCurrentLabels',
 * to determine if they are different, indicating that labels in the PR have been modified.
 */
export declare function areLabelsModified(prInitialLabels: string[], prCurrentLabels: string[]): boolean;
/**
 * Determine if labels should be updated in the Pull Request.
 */
export declare function shouldUpdateLabels(prInitialLabels: string[] | undefined, prCurrentLabels: string[] | undefined, configuredLabels: string[] | undefined): boolean;
