import type { RenovateConfig } from '../../../../config/types';
import type { PlatformPrOptions, Pr, PrDebugData } from '../../../../modules/platform';
import type { BranchConfig, PrBlockedBy } from '../../../types';
export declare function getPlatformPrOptions(config: RenovateConfig & PlatformPrOptions): PlatformPrOptions;
export interface ResultWithPr {
    type: 'with-pr';
    pr: Pr;
}
export interface ResultWithoutPr {
    type: 'without-pr';
    prBlockedBy: PrBlockedBy;
}
export type EnsurePrResult = ResultWithPr | ResultWithoutPr;
export declare function updatePrDebugData(targetBranch: string, labels: string[], debugData: PrDebugData | undefined): PrDebugData;
export declare function ensurePr(prConfig: BranchConfig): Promise<EnsurePrResult>;
