import type { BranchUpgradeConfig } from '../../../../types';
import type { ChangeLogError, ChangeLogPlatform, ChangeLogResult } from './types';
export declare abstract class ChangeLogSource {
    private readonly platform;
    private readonly datasource;
    private readonly cacheNamespace;
    constructor(platform: ChangeLogPlatform, datasource: 'bitbucket-tags' | 'bitbucket-server-tags' | 'gitea-tags' | 'github-tags' | 'gitlab-tags');
    abstract getCompareURL(baseUrl: string, repository: string, prevHead: string, nextHead: string): string;
    abstract getAPIBaseUrl(config: BranchUpgradeConfig): string;
    getAllTags(endpoint: string, repository: string): Promise<string[]>;
    getChangeLogJSON(config: BranchUpgradeConfig): Promise<ChangeLogResult | null>;
    private findTagOfRelease;
    private getRef;
    private getCacheKey;
    getBaseUrl(config: BranchUpgradeConfig): string;
    getRepositoryFromUrl(config: BranchUpgradeConfig): string;
    protected hasValidToken(config: BranchUpgradeConfig): {
        isValid: boolean;
        error?: ChangeLogError;
    };
    protected shouldSkipPackage(config: BranchUpgradeConfig): boolean;
    hasValidRepository(repository: string): boolean;
}
