"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChangeLogJSON = getChangeLogJSON;
exports.getChangeLogSourceFor = getChangeLogSourceFor;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../../../logger");
const allVersioning = tslib_1.__importStar(require("../../../../../modules/versioning"));
const common_1 = require("../../../../../util/common");
const api_1 = tslib_1.__importDefault(require("./api"));
tslib_1.__exportStar(require("./types"), exports);
async function getChangeLogJSON(config) {
    const { sourceUrl, versioning, currentVersion, newVersion } = config;
    try {
        if (!(sourceUrl && currentVersion && newVersion)) {
            return null;
        }
        const versioningApi = allVersioning.get(versioning);
        if (versioningApi.equals(currentVersion, newVersion)) {
            return null;
        }
        logger_1.logger.debug(`Fetching changelog: ${sourceUrl} (${currentVersion} -> ${newVersion})`);
        const platform = (0, common_1.detectPlatform)(sourceUrl);
        if (is_1.default.nullOrUndefined(platform)) {
            logger_1.logger.info({ sourceUrl, hostType: platform }, 'Unknown platform, skipping changelog fetching.');
            return null;
        }
        const changeLogSource = getChangeLogSourceFor(platform);
        if (is_1.default.nullOrUndefined(changeLogSource)) {
            logger_1.logger.info({ sourceUrl, hostType: platform }, 'Unknown changelog source, skipping changelog fetching.');
            return null;
        }
        return await changeLogSource.getChangeLogJSON(config);
    }
    catch (err) /* istanbul ignore next */ {
        logger_1.logger.error({ config, err }, 'getChangeLogJSON error');
        return null;
    }
}
function getChangeLogSourceFor(platform) {
    return api_1.default.get(platform) ?? null;
}
//# sourceMappingURL=index.js.map