"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.id = void 0;
exports.getReleaseNotesMd = getReleaseNotesMd;
exports.getReleaseList = getReleaseList;
const tslib_1 = require("tslib");
const changelog_filename_regex_1 = tslib_1.__importDefault(require("changelog-filename-regex"));
const logger_1 = require("../../../../../../logger");
const gitlab_1 = require("../../../../../../util/http/gitlab");
const common_1 = require("../common");
exports.id = 'gitlab-changelog';
const http = new gitlab_1.GitlabHttp(exports.id);
async function getReleaseNotesMd(repository, apiBaseUrl, sourceDirectory) {
    logger_1.logger.trace('gitlab.getReleaseNotesMd()');
    const urlEncodedRepo = encodeURIComponent(repository);
    const apiPrefix = `${apiBaseUrl}projects/${urlEncodedRepo}/repository/`;
    // https://docs.gitlab.com/13.2/ee/api/repositories.html#list-repository-tree
    const tree = (await http.getJsonUnchecked(`${apiPrefix}tree?per_page=100${sourceDirectory ? `&path=${sourceDirectory}` : ''}`, {
        paginate: true,
    })).body;
    const allFiles = tree.filter((f) => f.type === 'blob');
    let files = [];
    if (!files.length) {
        files = allFiles.filter((f) => changelog_filename_regex_1.default.test(f.name));
    }
    if (!files.length) {
        logger_1.logger.trace('no changelog file found');
        return null;
    }
    const { path: changelogFile, id } = files
        .sort((a, b) => (0, common_1.compareChangelogFilePath)(a.name, b.name))
        .shift();
    /* istanbul ignore if */
    if (files.length !== 0) {
        logger_1.logger.debug(`Multiple candidates for changelog file, using ${changelogFile}`);
    }
    // https://docs.gitlab.com/13.2/ee/api/repositories.html#raw-blob-content
    const fileRes = await http.getText(`${apiPrefix}blobs/${id}/raw`);
    const changelogMd = fileRes.body + '\n#\n##';
    return { changelogFile, changelogMd };
}
async function getReleaseList(project, _release) {
    logger_1.logger.trace('gitlab.getReleaseNotesMd()');
    const apiBaseUrl = project.apiBaseUrl;
    const repository = project.repository;
    const urlEncodedRepo = encodeURIComponent(repository);
    const apiUrl = `${apiBaseUrl}projects/${urlEncodedRepo}/releases`;
    const res = await http.getJsonUnchecked(`${apiUrl}?per_page=100`, {
        paginate: true,
    });
    return res.body.map((release) => ({
        url: `${project.baseUrl}${repository}/-/releases/${release.tag_name}`,
        notesSourceUrl: apiUrl,
        name: release.name,
        body: release.description,
        tag: release.tag_name,
    }));
}
//# sourceMappingURL=index.js.map