import type { BranchUpgradeConfig } from '../../../../../types';
import { ChangeLogSource } from '../source';
import type { ChangeLogError } from '../types';
export declare class GitHubChangeLogSource extends ChangeLogSource {
    constructor();
    getAPIBaseUrl(config: BranchUpgradeConfig): string;
    getCompareURL(baseUrl: string, repository: string, prevHead: string, nextHead: string): string;
    protected shouldSkipPackage(config: BranchUpgradeConfig): boolean;
    protected hasValidToken(config: BranchUpgradeConfig): {
        isValid: boolean;
        error?: ChangeLogError;
    };
}
