"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GiteaChangeLogSource = void 0;
const source_1 = require("../source");
class GiteaChangeLogSource extends source_1.ChangeLogSource {
    constructor() {
        super('gitea', 'gitea-tags');
    }
    getAPIBaseUrl(config) {
        return this.getBaseUrl(config) + 'api/v1/';
    }
    getCompareURL(baseUrl, repository, prevHead, nextHead) {
        return `${baseUrl}${repository}/compare/${prevHead}...${nextHead}`;
    }
    hasValidRepository(repository) {
        return repository.split('/').length === 2;
    }
}
exports.GiteaChangeLogSource = GiteaChangeLogSource;
//# sourceMappingURL=source.js.map