export declare function slugifyUrl(url: string): string;
/**
 * A comparator function to sort changelog files by preference,
 * prioritizing markdown files and plain text files over other file types.
 *
 * Avoid selecting files like `CHANGELOG.json` when `CHANGELOG.md` is available.
 * @see https://github.com/renovatebot/renovate/issues/25830
 *
 * @example
 * ```
 * const changelogFiles = [
 * 'CHANGELOG.json',
 * 'CHANGELOG',
 * 'CHANGELOG.md',
 * ].sort(compareChangelogFilePath);
 *
 * console.log(changelogFiles); // =>
 * [
 *  'CHANGELOG.md',
 *  'CHANGELOG',
 *  'CHANGELOG.json',
 * ]
 * ```
 *
 * @param a path to changelog file
 * @param b path to changelog file
 */
export declare function compareChangelogFilePath(a: string, b: string): number;
