"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitbucketChangeLogSource = void 0;
const source_1 = require("../source");
class BitbucketChangeLogSource extends source_1.ChangeLogSource {
    constructor() {
        super('bitbucket', 'bitbucket-tags');
    }
    getAPIBaseUrl(_config) {
        return 'https://api.bitbucket.org/';
    }
    getCompareURL(baseUrl, repository, prevHead, nextHead) {
        return `${baseUrl}${repository}/branches/compare/${nextHead}%0D${prevHead}`;
    }
}
exports.BitbucketChangeLogSource = BitbucketChangeLogSource;
//# sourceMappingURL=source.js.map