"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitbucketServerChangeLogSource = void 0;
const regex_1 = require("../../../../../../util/regex");
const url_1 = require("../../../../../../util/url");
const source_1 = require("../source");
const subfolderRegex = (0, regex_1.regEx)('(?<subfolder>.+/)(?:projects|scm)/');
const gitUrlRegex = (0, regex_1.regEx)('/(?<project>[^/]+)/(?<repo>[^/]+)\\.git$');
const webUrlRegex = (0, regex_1.regEx)('/projects/(?<project>[^/]+)/repos/(?<repo>[^/]+)');
class BitbucketServerChangeLogSource extends source_1.ChangeLogSource {
    constructor() {
        super('bitbucket-server', 'bitbucket-server-tags');
    }
    getBaseUrl(config) {
        const parsedUrl = (0, url_1.parseUrl)(config.sourceUrl);
        if (parsedUrl?.host) {
            const protocol = parsedUrl.protocol.replace((0, regex_1.regEx)(/^git\+/), '');
            const match = subfolderRegex.exec(parsedUrl.pathname);
            const subfolder = match?.groups?.subfolder ?? '/';
            return `${protocol}//${parsedUrl.host}${subfolder}`;
        }
        return '';
    }
    getAPIBaseUrl(config) {
        return `${this.getBaseUrl(config)}rest/api/1.0/`;
    }
    getCompareURL(baseUrl, repository, prevHead, nextHead) {
        const [projectKey, repositorySlug] = repository.split('/');
        return `${baseUrl}projects/${projectKey}/repos/${repositorySlug}/compare/commits?sourceBranch=${nextHead}&targetBranch=${prevHead}`;
    }
    getRepositoryFromUrl(config) {
        const parsedUrl = (0, url_1.parseUrl)(config.sourceUrl);
        if (parsedUrl) {
            const repositoryRegex = parsedUrl.pathname.endsWith('.git')
                ? gitUrlRegex
                : webUrlRegex;
            const match = repositoryRegex.exec(parsedUrl.pathname);
            if (match?.groups) {
                return `${match.groups.project}/${match.groups.repo}`;
            }
        }
        return '';
    }
}
exports.BitbucketServerChangeLogSource = BitbucketServerChangeLogSource;
//# sourceMappingURL=source.js.map