"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.id = void 0;
exports.getReleaseNotesMd = getReleaseNotesMd;
const tslib_1 = require("tslib");
const node_path_1 = tslib_1.__importDefault(require("node:path"));
const changelog_filename_regex_1 = tslib_1.__importDefault(require("changelog-filename-regex"));
const logger_1 = require("../../../../../../logger");
const schema_1 = require("../../../../../../modules/platform/bitbucket-server/schema");
const bitbucket_server_1 = require("../../../../../../util/http/bitbucket-server");
const url_1 = require("../../../../../../util/url");
const common_1 = require("../common");
exports.id = 'bitbucket-server-changelog';
const http = new bitbucket_server_1.BitbucketServerHttp(exports.id);
async function getReleaseNotesMd(repository, apiBaseUrl, sourceDirectory) {
    logger_1.logger.info('bitbucketServer.getReleaseNotesMd()');
    const [projectKey, repositorySlug] = repository.split('/');
    const apiRepoBaseUrl = (0, url_1.joinUrlParts)(apiBaseUrl, `projects`, projectKey, 'repos', repositorySlug);
    const repositorySourceURl = (0, url_1.joinUrlParts)(apiRepoBaseUrl, 'files', sourceDirectory ?? '');
    const allFiles = (await http.getJson(repositorySourceURl, {
        paginate: true,
    }, schema_1.Files)).body;
    const changelogFiles = allFiles.filter((f) => changelog_filename_regex_1.default.test(node_path_1.default.basename(f)));
    let changelogFile = changelogFiles
        .sort((a, b) => (0, common_1.compareChangelogFilePath)(a, b))
        .shift();
    if (!changelogFile) {
        logger_1.logger.trace('no changelog file found');
        return null;
    }
    changelogFile = `${sourceDirectory ? (0, url_1.ensureTrailingSlash)(sourceDirectory) : ''}${changelogFile}`;
    if (changelogFiles.length !== 0) {
        logger_1.logger.debug(`Multiple candidates for changelog file, using ${changelogFile}`);
    }
    const fileRes = await http.getText((0, url_1.joinUrlParts)(apiRepoBaseUrl, 'raw', changelogFile));
    const changelogMd = `${fileRes.body}\n#\n##`;
    return { changelogFile, changelogMd };
}
//# sourceMappingURL=index.js.map