"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleClosedPr = handleClosedPr;
exports.handleModifiedPr = handleModifiedPr;
const tslib_1 = require("tslib");
const global_1 = require("../../../../config/global");
const logger_1 = require("../../../../logger");
const comment_1 = require("../../../../modules/platform/comment");
const scm_1 = require("../../../../modules/platform/scm");
const emoji_1 = require("../../../../util/emoji");
const template = tslib_1.__importStar(require("../../../../util/template"));
async function handleClosedPr(config, pr) {
    if (pr.state === 'closed') {
        let content;
        // TODO #22198
        const userStrings = config.userStrings;
        if (config.updateType === 'major') {
            content = template.compile(userStrings.ignoreMajor, config);
        }
        else if (config.updateType === 'digest') {
            content = template.compile(userStrings.ignoreDigest, config);
        }
        else {
            content = template.compile(userStrings.ignoreOther, config);
        }
        content +=
            '\n\nIf you accidentally closed this PR, or if you changed your mind: rename this PR to get a fresh replacement PR.';
        if (!config.suppressNotifications.includes('prIgnoreNotification')) {
            if (global_1.GlobalConfig.get('dryRun')) {
                logger_1.logger.info(`DRY-RUN: Would ensure closed PR comment in PR #${pr.number}`);
            }
            else {
                await (0, comment_1.ensureComment)({
                    number: pr.number,
                    topic: userStrings.ignoreTopic,
                    content,
                });
            }
        }
        if (await scm_1.scm.branchExists(config.branchName)) {
            if (global_1.GlobalConfig.get('dryRun')) {
                logger_1.logger.info('DRY-RUN: Would delete branch ' + config.branchName);
            }
            else {
                await scm_1.scm.deleteBranch(config.branchName);
            }
        }
    }
}
async function handleModifiedPr(config, pr) {
    if (config.suppressNotifications.includes('prEditedNotification')) {
        return;
    }
    const editedPrCommentTopic = 'Edited/Blocked Notification';
    const content = 'Renovate will not automatically rebase this PR, because it does not recognize the last commit author and assumes somebody else may have edited the PR.\n\n' +
        'You can manually request rebase by checking the rebase/retry box above.\n\n' +
        (0, emoji_1.emojify)(' :warning: **Warning**: custom changes will be lost.');
    const dependencyDashboardCheck = config.dependencyDashboardChecks?.[config.branchName];
    if (!!dependencyDashboardCheck || config.rebaseRequested) {
        logger_1.logger.debug('Manual rebase has been requested for PR');
        if (global_1.GlobalConfig.get('dryRun')) {
            logger_1.logger.info(`DRY-RUN: Would remove edited/blocked PR comment in PR #${pr.number}`);
            return;
        }
        logger_1.logger.debug(`Removing edited/blocked PR comment in PR #${pr.number}`);
        await (0, comment_1.ensureCommentRemoval)({
            type: 'by-topic',
            number: pr.number,
            topic: editedPrCommentTopic,
        });
    }
    else {
        if (global_1.GlobalConfig.get('dryRun')) {
            logger_1.logger.info(`DRY-RUN: Would ensure edited/blocked PR comment in PR #${pr.number}`);
            return;
        }
        logger_1.logger.debug('Ensuring comment to indicate that rebasing is not possible');
        await (0, comment_1.ensureComment)({
            number: pr.number,
            topic: editedPrCommentTopic,
            content,
        });
    }
}
//# sourceMappingURL=handle-existing.js.map