"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setReconfigureBranchCache = setReconfigureBranchCache;
exports.deleteReconfigureBranchCache = deleteReconfigureBranchCache;
const logger_1 = require("../../../logger");
const repository_1 = require("../../../util/cache/repository");
function setReconfigureBranchCache(reconfigureBranchSha, isConfigValid, extractResult) {
    const cache = (0, repository_1.getCache)();
    const reconfigureBranchCache = {
        reconfigureBranchSha,
        isConfigValid,
        ...(extractResult && { extractResult }),
    };
    if (cache.reconfigureBranchCache) {
        logger_1.logger.debug({ reconfigureBranchCache }, 'Update reconfigure branch cache');
    }
    else {
        logger_1.logger.debug({ reconfigureBranchCache }, 'Create reconfigure branch cache');
    }
    cache.reconfigureBranchCache = reconfigureBranchCache;
}
function deleteReconfigureBranchCache() {
    const cache = (0, repository_1.getCache)();
    if (cache?.reconfigureBranchCache) {
        logger_1.logger.debug('Delete reconfigure branch cache');
        delete cache.reconfigureBranchCache;
    }
}
//# sourceMappingURL=reconfigure-cache.js.map