"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureReconfigurePrComment = ensureReconfigurePrComment;
exports.getConfigDesc = getConfigDesc;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const global_1 = require("../../../config/global");
const logger_1 = require("../../../logger");
const platform_1 = require("../../../modules/platform");
const comment_1 = require("../../../modules/platform/comment");
const errors_warnings_1 = require("../errors-warnings");
const base_branch_1 = require("../onboarding/pr/base-branch");
const config_description_1 = require("../onboarding/pr/config-description");
const pr_list_1 = require("../onboarding/pr/pr-list");
async function ensureReconfigurePrComment(config, packageFiles, branches, branchName, pr) {
    logger_1.logger.debug('ensureReconfigurePrComment()');
    logger_1.logger.trace({ config });
    let prCommentTemplate = `This is an reconfigure PR comment to help you understand and re-configure your renovate bot settings. If this Reconfigure PR were to be merged, we'd expect to see the following outcome:\n\n`;
    // TODO #22198
    prCommentTemplate += `
---
{{PACKAGE FILES}}
{{CONFIG}}
{{BASEBRANCH}}
{{PRLIST}}
{{WARNINGS}}
{{ERRORS}}
`;
    let prBody = prCommentTemplate;
    if (packageFiles && Object.entries(packageFiles).length) {
        let files = [];
        for (const [manager, managerFiles] of Object.entries(packageFiles)) {
            files = files.concat(managerFiles.map((file) => ` * \`${file.packageFile}\` (${manager})`));
        }
        prBody =
            prBody.replace('{{PACKAGE FILES}}', '### Detected Package Files\n\n' + files.join('\n')) + '\n';
    }
    else {
        prBody = prBody.replace('{{PACKAGE FILES}}\n', '');
    }
    let configDesc = '';
    if (global_1.GlobalConfig.get('dryRun')) {
        logger_1.logger.info(`DRY-RUN: Would check branch ${branchName}`);
    }
    else {
        configDesc = getConfigDesc(config);
    }
    prBody = prBody.replace('{{CONFIG}}\n', configDesc);
    prBody = prBody.replace('{{WARNINGS}}\n', (0, errors_warnings_1.getWarnings)(config) + (0, errors_warnings_1.getDepWarningsOnboardingPR)(packageFiles, config));
    prBody = prBody.replace('{{ERRORS}}\n', (0, errors_warnings_1.getErrors)(config));
    prBody = prBody.replace('{{BASEBRANCH}}\n', (0, base_branch_1.getBaseBranchDesc)(config));
    prBody = prBody.replace('{{PRLIST}}\n', (0, pr_list_1.getExpectedPrList)(config, branches));
    logger_1.logger.trace('prBody:\n' + prBody);
    prBody = platform_1.platform.massageMarkdown(prBody);
    if (global_1.GlobalConfig.get('dryRun')) {
        logger_1.logger.info('DRY-RUN: Would ensure comment');
        return true;
    }
    return await (0, comment_1.ensureComment)({
        number: pr.number,
        topic: 'Reconfigure PR Results',
        content: prBody,
    });
}
function getDescriptionArray(config) {
    logger_1.logger.debug('getDescriptionArray()');
    logger_1.logger.trace({ config });
    const desc = is_1.default.array(config.description, is_1.default.string)
        ? config.description
        : [];
    return desc.concat((0, config_description_1.getScheduleDesc)(config));
}
function getConfigDesc(config) {
    logger_1.logger.debug('getConfigDesc()');
    logger_1.logger.trace({ config });
    const descriptionArr = getDescriptionArray(config);
    if (!descriptionArr.length) {
        logger_1.logger.debug('No config description found');
        return '';
    }
    logger_1.logger.debug(`Found description array with length:${descriptionArr.length}`);
    let desc = `\n### Configuration Summary\n\nBased on the default config's presets, Renovate will:\n\n`;
    descriptionArr.forEach((d) => {
        desc += `  - ${d}\n`;
    });
    desc += '\n\n---\n';
    return desc;
}
//# sourceMappingURL=comment.js.map