import type { ReleaseResult } from '../../../../modules/datasource/types';
import type { VersioningApi } from '../../../../modules/versioning/types';
/**
 * Calculates the `mostRecentTimestamp` value for a set of releases.
 *
 * This function determines the highest release (a release with the highest version)
 * and checks if its timestamp is also the highest among all releases.
 * If so, it assigns that timestamp as the `mostRecentTimestamp` value in the result.
 * This helps identify if the package was abandoned.
 *
 * The function skips setting `mostRecentTimestamp` if:
 * - No releases could be determined as the highest (e.g. for invalid versions)
 * - The highest release is deprecated
 * - A lower version has a more recent timestamp than the highest version
 *
 * @returns The `ReleaseResult` value, potentially updated with a `mostRecentTimestamp` timestamp
 */
export declare function calculateMostRecentTimestamp(versioningApi: VersioningApi, releaseResult: ReleaseResult): ReleaseResult;
