"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentVersion = getCurrentVersion;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const regex_1 = require("../../../../util/regex");
function getCurrentVersion(currentValue, lockedVersion, versioningApi, rangeStrategy, latestVersion, allVersions) {
    // istanbul ignore if
    if (!is_1.default.string(currentValue)) {
        return null;
    }
    let useVersions = allVersions.filter((v) => versioningApi.matches(v, currentValue));
    if (useVersions.length === 1) {
        return useVersions[0];
    }
    if (latestVersion && versioningApi.matches(latestVersion, currentValue)) {
        useVersions = useVersions.filter((v) => !versioningApi.isGreaterThan(v, latestVersion));
    }
    if (rangeStrategy === 'pin') {
        return (lockedVersion ||
            versioningApi.getSatisfyingVersion(useVersions, currentValue));
    }
    if (rangeStrategy === 'bump') {
        // Use the lowest version in the current range
        return versioningApi.minSatisfyingVersion(useVersions, currentValue);
    }
    // Use the highest version in the current range
    const satisfyingVersion = versioningApi.getSatisfyingVersion(useVersions, currentValue);
    if (satisfyingVersion) {
        return satisfyingVersion;
    }
    if (versioningApi.isVersion(currentValue)) {
        return currentValue;
    }
    if (versioningApi.isSingleVersion(currentValue)) {
        return currentValue.replace((0, regex_1.regEx)(/=/g), '').trim();
    }
    return null;
}
//# sourceMappingURL=current.js.map