"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OnboardingState = void 0;
exports.getSemanticCommitPrTitle = getSemanticCommitPrTitle;
exports.getDefaultConfigFileName = getDefaultConfigFileName;
const tslib_1 = require("tslib");
const app_strings_1 = require("../../../config/app-strings");
const logger_1 = require("../../../logger");
const memCache = tslib_1.__importStar(require("../../../util/cache/memory"));
function getSemanticCommitPrTitle(config) {
    return `${config.semanticCommitType ?? 'chore'}: ${config.onboardingPrTitle}`;
}
function getDefaultConfigFileName(config) {
    return app_strings_1.configFileNames.includes(config.onboardingConfigFileName)
        ? config.onboardingConfigFileName
        : app_strings_1.configFileNames[0];
}
class OnboardingState {
    static cacheKey = 'OnboardingState';
    static skipKey = 'OnboardingStateValid';
    static get prUpdateRequested() {
        const updateRequested = !!memCache.get(OnboardingState.cacheKey);
        logger_1.logger.trace({ value: updateRequested }, 'Get OnboardingState.prUpdateRequested');
        return updateRequested;
    }
    static set prUpdateRequested(value) {
        logger_1.logger.trace({ value }, 'Set OnboardingState.prUpdateRequested');
        memCache.set(OnboardingState.cacheKey, value);
    }
    static get onboardingCacheValid() {
        const cacheValid = !!memCache.get(OnboardingState.skipKey);
        logger_1.logger.trace({ value: cacheValid }, 'Get OnboardingState.onboardingCacheValid');
        return cacheValid;
    }
    static set onboardingCacheValid(value) {
        logger_1.logger.trace({ value }, 'Set OnboardingState.onboardingCacheValid');
        memCache.set(OnboardingState.skipKey, value);
    }
}
exports.OnboardingState = OnboardingState;
//# sourceMappingURL=common.js.map