"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.finalizeRepo = finalizeRepo;
const tslib_1 = require("tslib");
const logger_1 = require("../../../logger");
const platform_1 = require("../../../modules/platform");
const repositoryCache = tslib_1.__importStar(require("../../../util/cache/repository"));
const git_1 = require("../../../util/git");
const package_files_1 = require("../package-files");
const reconfigure_1 = require("../reconfigure");
const prune_1 = require("./prune");
const repository_statistics_1 = require("./repository-statistics");
// istanbul ignore next
async function finalizeRepo(config, branchList, repoConfig) {
    await (0, reconfigure_1.checkReconfigureBranch)(config, repoConfig);
    await repositoryCache.saveCache();
    await (0, prune_1.pruneStaleBranches)(config, branchList);
    await ensureIssuesClosing();
    await (0, git_1.clearRenovateRefs)();
    package_files_1.PackageFiles.clear();
    const prList = await platform_1.platform.getPrList();
    if (prList?.some((pr) => pr.state === 'merged' &&
        pr.title !== 'Configure Renovate' &&
        pr.title !== config.onboardingPrTitle &&
        pr.sourceBranch !== config.onboardingBranch)) {
        logger_1.logger.debug('Repo is activated');
        config.repoIsActivated = true;
    }
    (0, repository_statistics_1.runBranchSummary)(config);
    (0, repository_statistics_1.runRenovateRepoStats)(config, prList);
}
// istanbul ignore next
function ensureIssuesClosing() {
    return Promise.all([
        platform_1.platform.ensureIssueClosing(`Action Required: Fix Renovate Configuration`),
        platform_1.platform.ensureIssueClosing(`Action Required: Add missing credentials`),
    ]);
}
//# sourceMappingURL=index.js.map