"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractAllDependencies = extractAllDependencies;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const config_1 = require("../../../config");
const logger_1 = require("../../../logger");
const manager_1 = require("../../../modules/manager");
const custom_1 = require("../../../modules/manager/custom");
const scm_1 = require("../../../modules/platform/scm");
const file_match_1 = require("./file-match");
const manager_files_1 = require("./manager-files");
const supersedes_1 = require("./supersedes");
async function extractAllDependencies(config) {
    const managerList = (0, manager_1.getEnabledManagersList)(config.enabledManagers);
    const extractList = [];
    const fileList = await scm_1.scm.getFileList();
    const tryConfig = (managerConfig) => {
        const matchingFileList = (0, file_match_1.getMatchingFiles)(managerConfig, fileList);
        if (matchingFileList.length) {
            extractList.push({ ...managerConfig, fileList: matchingFileList });
        }
    };
    for (const manager of managerList) {
        const managerConfig = (0, config_1.getManagerConfig)(config, manager);
        managerConfig.manager = manager;
        if ((0, custom_1.isCustomManager)(manager)) {
            const filteredCustomManagers = (config.customManagers ?? []).filter((mgr) => mgr.customType === manager);
            for (const customManager of filteredCustomManagers) {
                tryConfig((0, config_1.mergeChildConfig)(managerConfig, customManager));
            }
        }
        else {
            tryConfig(managerConfig);
        }
    }
    const extractResult = {
        packageFiles: {},
        extractionFingerprints: {},
    };
    // Store the fingerprint of all managers which match any file (even if they do not find any dependencies)
    // The cached result needs to be invalidated if the fingerprint of any matching manager changes
    for (const { manager } of extractList) {
        extractResult.extractionFingerprints[manager] = manager_1.hashMap.get(manager);
    }
    const extractDurations = {};
    const extractResults = await Promise.all(extractList.map(async (managerConfig) => {
        const start = Date.now();
        const packageFiles = await (0, manager_files_1.getManagerPackageFiles)(managerConfig);
        const durationMs = Math.round(Date.now() - start);
        extractDurations[managerConfig.manager] = durationMs;
        return { manager: managerConfig.manager, packageFiles };
    }));
    // De-duplicate results using supersedesManagers
    (0, supersedes_1.processSupersedesManagers)(extractResults);
    logger_1.logger.debug({ managers: extractDurations }, 'manager extract durations (ms)');
    let fileCount = 0;
    for (const { manager, packageFiles } of extractResults) {
        if (packageFiles?.length) {
            fileCount += packageFiles.length;
            logger_1.logger.debug(`Found ${manager} package files`);
            extractResult.packageFiles[manager] = (extractResult.packageFiles[manager] || []).concat(packageFiles);
        }
    }
    logger_1.logger.debug(`Found ${fileCount} package file(s)`);
    // If enabledManagers is non-empty, check that each of them has at least one extraction.
    // If not, log a warning to indicate possible misconfiguration.
    if (is_1.default.nonEmptyArray(config.enabledManagers)) {
        for (const enabledManager of config.enabledManagers) {
            if (!(enabledManager.replace('custom.', '') in extractResult.packageFiles)) {
                logger_1.logger.debug({ manager: enabledManager }, `Manager explicitly enabled in "enabledManagers" config, but found no results. Possible config error?`);
            }
        }
    }
    return extractResult;
}
//# sourceMappingURL=index.js.map