"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getIncludedFiles = getIncludedFiles;
exports.filterIgnoredFiles = filterIgnoredFiles;
exports.getFilteredFileList = getFilteredFileList;
exports.getMatchingFiles = getMatchingFiles;
const logger_1 = require("../../../logger");
const minimatch_1 = require("../../../util/minimatch");
const string_match_1 = require("../../../util/string-match");
function getIncludedFiles(fileList, includePaths) {
    if (!includePaths?.length) {
        return [...fileList];
    }
    return fileList.filter((file) => includePaths.some((includePath) => file === includePath ||
        (0, minimatch_1.minimatch)(includePath, { dot: true }).match(file)));
}
function filterIgnoredFiles(fileList, ignorePaths) {
    if (!ignorePaths?.length) {
        return [...fileList];
    }
    return fileList.filter((file) => !ignorePaths.some((ignorePath) => file.includes(ignorePath) ||
        (0, minimatch_1.minimatch)(ignorePath, { dot: true }).match(file)));
}
function getFilteredFileList(config, fileList) {
    const { includePaths, ignorePaths } = config;
    // TODO #22198
    let filteredList = getIncludedFiles(fileList, includePaths);
    filteredList = filterIgnoredFiles(filteredList, ignorePaths);
    return filteredList;
}
function getMatchingFiles(config, allFiles) {
    const fileList = getFilteredFileList(config, allFiles);
    const { managerFilePatterns, manager } = config;
    let matchedFiles = [];
    // TODO: types (#22198)
    for (const pattern of managerFilePatterns) {
        logger_1.logger.debug(`Using file pattern: ${pattern} for manager ${manager}`);
        matchedFiles = matchedFiles.concat(fileList.filter((file) => (0, string_match_1.matchRegexOrGlob)(file, pattern)));
    }
    // filter out duplicates
    return [...new Set(matchedFiles)].sort();
}
//# sourceMappingURL=file-match.js.map