"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkIfConfigured = checkIfConfigured;
const error_messages_1 = require("../../constants/error-messages");
function checkIfConfigured(config) {
    if (config.enabled === false) {
        throw new Error(error_messages_1.REPOSITORY_DISABLED_BY_CONFIG);
    }
    if (config.isFork && config.forkProcessing !== 'enabled') {
        throw new Error(error_messages_1.REPOSITORY_FORKED);
    }
}
//# sourceMappingURL=configured.js.map