import type { BuiltInParserName } from 'prettier';
export interface MigratedData {
    content: string;
    filename: string;
    indent: Indent;
}
interface Indent {
    amount: number;
    indent: string;
    type?: string;
}
export type PrettierParser = BuiltInParserName;
export declare function applyPrettierFormatting(filename: string, content: string, parser: PrettierParser, indent?: Indent): Promise<string>;
export declare class MigratedDataFactory {
    private static data;
    static getAsync(): Promise<MigratedData | null>;
    static reset(): void;
    static applyPrettierFormatting({ content, filename, indent, }: MigratedData): Promise<string>;
    private static build;
}
export {};
