"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createConfigMigrationBranch = createConfigMigrationBranch;
const global_1 = require("../../../../config/global");
const logger_1 = require("../../../../logger");
const scm_1 = require("../../../../modules/platform/scm");
const common_1 = require("../../../../util/common");
const fs_1 = require("../../../../util/fs");
const common_2 = require("../common");
const commit_message_1 = require("./commit-message");
const migrated_data_1 = require("./migrated-data");
async function createConfigMigrationBranch(config, migratedConfigData) {
    logger_1.logger.debug('createConfigMigrationBranch()');
    const pJsonMigration = migratedConfigData.filename === 'package.json';
    const configFileName = pJsonMigration
        ? 'renovate.json'
        : migratedConfigData.filename;
    logger_1.logger.debug('Creating config migration branch');
    const commitMessageFactory = new commit_message_1.ConfigMigrationCommitMessageFactory(config, configFileName);
    const commitMessage = commitMessageFactory.getCommitMessage();
    // istanbul ignore if
    if (global_1.GlobalConfig.get('dryRun')) {
        logger_1.logger.info('DRY-RUN: Would commit files to config migration branch');
        return Promise.resolve(null);
    }
    await scm_1.scm.checkoutBranch(config.defaultBranch);
    const contents = await migrated_data_1.MigratedDataFactory.applyPrettierFormatting(migratedConfigData);
    const files = [
        {
            type: 'addition',
            path: configFileName,
            contents,
        },
    ];
    if (pJsonMigration) {
        const pJson = (0, common_1.parseJson)(await (0, fs_1.readLocalFile)('package.json', 'utf8'), 'package.json');
        if (pJson?.renovate) {
            delete pJson.renovate;
        }
        const pJsonContent = await (0, migrated_data_1.applyPrettierFormatting)('package.json', JSON.stringify(pJson, undefined, migratedConfigData.indent.indent), 'json', migratedConfigData.indent);
        files.push({
            type: 'addition',
            path: 'package.json',
            contents: pJsonContent,
        });
    }
    return scm_1.scm.commitAndPush({
        baseBranch: config.baseBranch,
        branchName: (0, common_2.getMigrationBranchName)(config),
        files,
        message: commitMessage.toString(),
        platformCommit: config.platformCommit,
        force: true,
    });
}
//# sourceMappingURL=create.js.map