import type { BranchConfig, BranchUpgradeConfig } from '../types';
export type Limit = 'Commits';
export declare function resetAllLimits(): void;
export declare function setMaxLimit(key: Limit, val: unknown): void;
export declare function incLimitedValue(key: Limit, incBy?: number): void;
export type CountName = 'ConcurrentPRs' | 'HourlyPRs' | 'Branches';
type BranchLimitName = 'branchConcurrentLimit' | 'prConcurrentLimit' | 'prHourlyLimit';
export declare const counts: Map<CountName, number>;
export declare function getCount(key: CountName): number;
export declare function setCount(key: CountName, val: number): void;
export declare function incCountValue(key: CountName, incBy?: number): void;
export declare function calcLimit(upgrades: BranchUpgradeConfig[], limitName: BranchLimitName): number;
export declare function hasMultipleLimits(upgrades: BranchUpgradeConfig[], limitName: BranchLimitName): boolean;
export declare function isLimitReached(limit: 'Commits'): boolean;
export declare function isLimitReached(limit: 'Branches' | 'ConcurrentPRs', config: BranchConfig): boolean;
export {};
