"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.migrateAndValidateConfig = migrateAndValidateConfig;
const dequal_1 = require("dequal");
const massage_1 = require("../../../../config/massage");
const migration_1 = require("../../../../config/migration");
const validation_1 = require("../../../../config/validation");
const logger_1 = require("../../../../logger");
async function migrateAndValidateConfig(config, configType) {
    const { isMigrated, migratedConfig } = (0, migration_1.migrateConfig)(config);
    if (isMigrated) {
        logger_1.logger.warn({ configType, originalConfig: config, migratedConfig }, 'Config needs migrating');
    }
    const massagedConfig = (0, massage_1.massageConfig)(migratedConfig);
    // log only if it's changed
    if (!(0, dequal_1.dequal)(migratedConfig, massagedConfig)) {
        logger_1.logger.trace({ config: massagedConfig }, 'Post-massage config');
    }
    const { warnings, errors } = await (0, validation_1.validateConfig)('global', massagedConfig);
    if (warnings.length) {
        logger_1.logger.warn({ configType, warnings }, 'Config validation warnings found');
    }
    if (errors.length) {
        logger_1.logger.warn({ configType, errors }, 'Config validation errors found');
    }
    return massagedConfig;
}
//# sourceMappingURL=util.js.map