"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.coersions = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const json5_1 = tslib_1.__importDefault(require("json5"));
exports.coersions = {
    boolean: (val) => {
        if (val === 'true' || val === '') {
            return true;
        }
        if (val === 'false') {
            return false;
        }
        throw new Error("Invalid boolean value: expected 'true' or 'false', but got '" +
            val +
            "'");
    },
    array: (val) => {
        if (val === '') {
            return [];
        }
        try {
            return json5_1.default.parse(val);
        }
        catch {
            return val
                .split(',')
                .map((el) => el.trim())
                .filter(is_1.default.nonEmptyString);
        }
    },
    object: (val) => {
        if (val === '') {
            return {};
        }
        try {
            return json5_1.default.parse(val);
        }
        catch {
            throw new Error("Invalid JSON value: '" + val + "'");
        }
    },
    string: (val) => val.replace(/\\n/g, '\n'),
    integer: parseInt,
};
//# sourceMappingURL=coersions.js.map